/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.util;

import com.rameses.rcp.util.ErrorDialog;
import java.util.Timer;
import java.util.TimerTask;

public class TimerManager {
    private static Object LOCKED = new Object();
    private static TimerManager instance;
    private Timer timer = new Timer();

    public static TimerManager getInstance() {
        if (instance == null) {
            instance = new TimerManager();
        }
        return instance;
    }

    private TimerManager() {
    }

    public void cancel() {
        try {
            this.timer.cancel();
        }
        catch (Throwable t) {
            System.out.println("[WARN] TimerManager.cancel error caused by " + t.getClass().getName() + ": " + t.getMessage());
        }
    }

    public void purge() {
        try {
            this.timer.purge();
        }
        catch (Throwable t) {
            System.out.println("[WARN] TimerManager.purge error caused by " + t.getClass().getName() + ": " + t.getMessage());
        }
    }

    public void schedule(Runnable runnable) {
        this.schedule(runnable, 100L);
    }

    public void schedule(Runnable runnable, long delay) {
        this.schedule(new TimerTaskImpl(runnable), delay);
    }

    public void schedule(TimerTask task, long delay) {
        this.timer.schedule(task, delay);
    }

    private class TimerTaskImpl
    extends TimerTask {
        private Runnable runnable;

        TimerTaskImpl(Runnable runnable) {
            this.runnable = runnable;
        }

        @Override
        public void run() {
            if (this.runnable == null) {
                return;
            }
            try {
                this.runnable.run();
            }
            catch (Throwable t) {
                ErrorDialog.show(t);
            }
        }
    }
}

