/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.util;

import com.rameses.rcp.framework.ClientContext;
import com.rameses.util.BusinessException;
import java.util.Locale;
import java.util.ResourceBundle;

public class MessageUtil {
    public static String getMessage(String key, String defaultMsg, String bundleName) {
        if (bundleName == null) {
            return defaultMsg;
        }
        try {
            Locale locale = ClientContext.getCurrentContext().getLocale();
            String message = null;
            message = locale == null ? ResourceBundle.getBundle(bundleName).getString(key) : ResourceBundle.getBundle(bundleName, locale).getString(key);
            if (message != null) {
                return message;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return defaultMsg;
    }

    public static Exception getErrorMessage(Exception e) {
        if (e instanceof BusinessException) {
            BusinessException be = (BusinessException)e;
            String errno = be.getErrno();
            String msg = MessageUtil.getMessage(errno, be.getMessage(), "errors");
            return new Exception(msg, (Throwable)be);
        }
        return e;
    }

    public static Throwable getErrorMessage(Throwable e) {
        if (e instanceof BusinessException) {
            BusinessException be = (BusinessException)e;
            String errno = be.getErrno();
            String msg = MessageUtil.getMessage(errno, be.getMessage(), "errors");
            return new Exception(msg, (Throwable)be);
        }
        return e;
    }
}

