/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.util;

import com.rameses.rcp.control.XLabel;
import com.rameses.rcp.ui.ActiveControl;
import com.rameses.rcp.ui.ControlProperty;
import com.rameses.rcp.util.FormPanel;
import com.rameses.util.ValueUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JViewport;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;

public class ItemPanel
extends JPanel {
    private Component editorWrapper;
    private Component editor;
    private XLabel label;
    private ControlProperty property;
    private FormPanel formPanel;
    private Insets padding;

    public ItemPanel(FormPanel parent, Component editor) {
        JScrollPane container = null;
        if (editor instanceof JTextArea || editor instanceof JEditorPane) {
            container = new JScrollPane();
            container.setViewportView(editor);
        }
        this.initComponents(parent, editor, container);
    }

    public ItemPanel(FormPanel parent, Component editor, Component container) {
        this.initComponents(parent, editor, container);
    }

    private void initComponents(FormPanel parent, Component editor, Component container) {
        this.formPanel = parent;
        this.editor = editor;
        this.editorWrapper = container;
        if (container instanceof JScrollPane && !container.isPreferredSizeSet()) {
            JScrollPane jsp = (JScrollPane)container;
            JViewport view = jsp.getViewport();
            Dimension d = view.getViewSize();
            Insets i = view.getInsets();
            d.width += i.left + i.right;
            d.height += i.top + i.bottom;
            i = jsp.getInsets();
            d.width += i.left + i.right;
            d.height += i.top + i.bottom;
            container.setPreferredSize(d);
        }
        ActiveControl con = (ActiveControl)((Object)editor);
        this.property = con.getControlProperty();
        this.setOpaque(false);
        this.setLayout(new ItemPanelLayout(this.property));
        if (this.property.getCellPadding() != null) {
            this.padding = this.property.getCellPadding();
        }
        this.label = new XLabel(true);
        this.label.setLabelFor(editor);
        this.label.setAddCaptionColon(parent.isAddCaptionColon());
        if (this.property.getCaptionFont() != null) {
            this.label.setFont(this.property.getCaptionFont());
        } else {
            this.label.setFont(parent.getCaptionFont());
        }
        this.label.setForeground(parent.getCaptionForeground());
        if (!ValueUtil.isEmpty((Object)this.label.getText())) {
            this.label.setBorder(parent.getCaptionBorder());
        }
        this.add((Component)this.label, "label");
        if (container != null) {
            this.add(container, "editor");
        } else {
            this.add(editor, "editor");
        }
        ActiveControlPropetyListener listener = new ActiveControlPropetyListener();
        this.property.addPropertyChangeListener(listener);
        editor.addComponentListener(new ComponentListener(){

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentResized(ComponentEvent e) {
            }

            @Override
            public void componentHidden(ComponentEvent e) {
                ItemPanel.this.setVisible(false);
            }

            @Override
            public void componentShown(ComponentEvent e) {
                ItemPanel.this.setVisible(true);
            }
        });
    }

    public boolean match(Component editor) {
        if (editor == null) {
            return false;
        }
        return this.editor == editor;
    }

    public Component getEditorComponent() {
        return this.editor;
    }

    public Component getEditorWrapper() {
        return this.editorWrapper;
    }

    public XLabel getLabelComponent() {
        return this.label;
    }

    public ControlProperty getControlProperty() {
        return this.property;
    }

    @Override
    public Insets getInsets() {
        Insets insets = new Insets(0, 0, 0, 0);
        Insets i = super.getInsets();
        if (i != null) {
            insets.top += i.top;
            insets.left += i.left;
            insets.bottom += i.bottom;
            insets.right += i.right;
        }
        if (this.padding != null) {
            insets.top += this.padding.top;
            insets.left += this.padding.left;
            insets.bottom += this.padding.bottom;
            insets.right += this.padding.right;
        }
        return insets;
    }

    @Override
    public Insets getInsets(Insets insets) {
        Insets i = this.getInsets();
        if (insets == null) {
            return i;
        }
        insets.top = i.top;
        insets.left = i.left;
        insets.bottom = i.bottom;
        insets.right = i.right;
        return insets;
    }

    private class ItemPanelLayout
    implements LayoutManager {
        private Component label;
        private Component editor;
        private ControlProperty property;

        ItemPanelLayout(ControlProperty property) {
            this.property = property;
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
            if ("label".equals(name)) {
                this.label = comp;
            } else if ("editor".equals(name)) {
                this.editor = comp;
            }
        }

        @Override
        public void removeLayoutComponent(Component comp) {
            if (comp != null) {
                if (this.label == comp) {
                    this.label = comp;
                } else if (this.editor == comp) {
                    this.editor = comp;
                }
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return this.getLayoutSize(parent);
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            Dimension dim = this.getLayoutSize(parent);
            return new Dimension(100, dim.height);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void layoutContainer(Container parent) {
            Object object = parent.getTreeLock();
            synchronized (object) {
                Insets margin = parent.getInsets();
                int x = margin.left;
                int y = margin.top;
                int w = parent.getWidth() - (margin.left + margin.right);
                int h = parent.getHeight() - (margin.top + margin.bottom);
                int captionWidth = this.getPreferredCaptionWidth();
                String orient = ItemPanel.this.formPanel.getCaptionOrientation();
                if ("LEFT".equals(orient) || "TOP".equals(orient)) {
                    Rectangle rec = this.layoutLabel(x, y, w, h, captionWidth);
                    this.layoutEditor(rec.x, rec.y, rec.width, rec.height);
                } else {
                    Rectangle rec = this.layoutEditor(x, y, w, h);
                    this.layoutLabel(rec.x, rec.y, rec.width, rec.height, captionWidth);
                }
            }
        }

        private Rectangle layoutLabel(int x, int y, int w, int h, int captionWidth) {
            if (this.label != null && this.isShowCaption()) {
                Dimension dim = this.label.getPreferredSize();
                String captionOrientation = ItemPanel.this.formPanel.getCaptionOrientation();
                int cw = captionWidth;
                int ch = h;
                if (("TOP".equals(captionOrientation) || "BOTTOM".equals(captionOrientation)) && this.editor != null) {
                    cw = this.editor.getPreferredSize().width;
                    ch = dim.height;
                } else if (cw <= 0) {
                    cw = dim.width;
                }
                this.label.setBounds(x, y, cw, ch);
                if ("TOP".equals(captionOrientation)) {
                    y += ch;
                    h -= ch;
                } else {
                    x += cw;
                    w -= cw;
                }
            }
            return new Rectangle(x, y, w, h);
        }

        private Rectangle layoutEditor(int x, int y, int w, int h) {
            if (this.editor != null) {
                Dimension dim = this.editor.getPreferredSize();
                String captionOrientation = ItemPanel.this.formPanel.getCaptionOrientation();
                int cw = dim.width;
                if (cw > w || cw <= 0) {
                    cw = w;
                }
                this.editor.setBounds(x, y, cw, dim.height);
                if ("BOTTOM".equals(captionOrientation)) {
                    y += dim.height;
                    h -= dim.height;
                } else {
                    x += cw;
                    w -= cw;
                }
            }
            return new Rectangle(x, y, w, h);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Dimension getLayoutSize(Container parent) {
            Object object = parent.getTreeLock();
            synchronized (object) {
                Dimension dim;
                int w = 0;
                int h = 0;
                int captionWidth = this.getPreferredCaptionWidth();
                String orient = ItemPanel.this.formPanel.getCaptionOrientation();
                if (this.label != null) {
                    if (this.isShowCaption()) {
                        this.applyCaptionStyles((JLabel)this.label);
                        dim = this.label.getPreferredSize();
                        if ("TOP".equals(orient) || "BOTTOM".equals(orient)) {
                            h += dim.height;
                            w = Math.max(w, dim.width);
                        } else {
                            int cw = captionWidth;
                            if (cw <= 0) {
                                cw = dim.width;
                            }
                            w += cw;
                            h = Math.max(h, dim.height);
                        }
                        this.label.setVisible(true);
                    } else {
                        this.label.setVisible(false);
                    }
                }
                if (this.editor != null) {
                    dim = this.editor.getPreferredSize();
                    if ("TOP".equals(orient) || "BOTTOM".equals(orient)) {
                        h += dim.height;
                        w = Math.max(w, dim.width);
                    } else {
                        w += dim.width;
                        h = Math.max(h, dim.height);
                    }
                }
                Insets margin = parent.getInsets();
                return new Dimension(w += margin.left + margin.right, h += margin.top + margin.bottom);
            }
        }

        private void applyCaptionStyles(JLabel label) {
            String valign = ItemPanel.this.formPanel.getCaptionVAlignment();
            if ("CENTER".equals(valign)) {
                label.setVerticalAlignment(0);
            } else if ("BOTTOM".equals(valign)) {
                label.setVerticalAlignment(3);
            } else {
                label.setVerticalAlignment(1);
            }
            String halign = ItemPanel.this.formPanel.getCaptionHAlignment();
            if ("CENTER".equals(halign)) {
                label.setHorizontalAlignment(0);
            } else if ("RIGHT".equals(halign)) {
                label.setHorizontalAlignment(4);
            } else {
                label.setHorizontalAlignment(2);
            }
            Insets captionPadding = ItemPanel.this.formPanel.getCaptionPadding();
            if (captionPadding != null) {
                ((XLabel)label).setPadding(captionPadding);
            }
        }

        private int getPreferredCaptionWidth() {
            return this.property.getCaptionWidth() <= 0 ? ItemPanel.this.formPanel.getCaptionWidth() : this.property.getCaptionWidth();
        }

        private boolean isShowCaption() {
            return this.property.isShowCaption();
        }
    }

    private class ActiveControlPropetyListener
    implements PropertyChangeListener {
        private ItemPanel panel;
        private JLabel template;

        ActiveControlPropetyListener() {
            this.panel = ItemPanel.this;
            this.template = new JLabel();
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            Insets i;
            String propName = evt.getPropertyName();
            Object value = evt.getNewValue();
            if ("captionWidth".equals(propName)) {
                this.panel.revalidate();
            } else if ("showCaption".equals(propName)) {
                this.panel.revalidate();
            } else if ("caption".equals(propName)) {
                Border b = this.panel.getLabelComponent().getBorder();
                if (ValueUtil.isEmpty((Object)value) && !(b instanceof EmptyBorder)) {
                    this.panel.getLabelComponent().setBorder(BorderFactory.createEmptyBorder());
                } else if (!ValueUtil.isEqual((Object)b, (Object)ItemPanel.this.formPanel.getCaptionBorder())) {
                    this.panel.getLabelComponent().setBorder(ItemPanel.this.formPanel.getCaptionBorder());
                }
            } else if ("captionFont".equals(propName)) {
                Font f = (Font)value;
                if (f != null) {
                    this.panel.getLabelComponent().setFont(f);
                } else {
                    this.panel.getLabelComponent().setFont(this.template.getFont());
                }
            } else if ("cellPadding".equals(propName) && (i = (Insets)value) != null) {
                this.panel.padding = i;
                this.panel.revalidate();
            }
        }
    }
}

