/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.util;

import com.rameses.common.PropertyResolver;
import com.rameses.rcp.common.FormControl;
import com.rameses.rcp.common.FormPanelModel;
import com.rameses.rcp.common.PropertySupport;
import com.rameses.rcp.common.ValidatorEvent;
import com.rameses.rcp.constant.UIConstants;
import com.rameses.rcp.control.XEditorPane;
import com.rameses.rcp.control.XLabel;
import com.rameses.rcp.control.border.XUnderlineBorder;
import com.rameses.rcp.framework.Binding;
import com.rameses.rcp.framework.BindingListener;
import com.rameses.rcp.ui.ActiveControl;
import com.rameses.rcp.ui.ControlContainer;
import com.rameses.rcp.ui.ControlProperty;
import com.rameses.rcp.ui.UIComposite;
import com.rameses.rcp.ui.UIControl;
import com.rameses.rcp.ui.UIFocusableContainer;
import com.rameses.rcp.ui.UIInput;
import com.rameses.rcp.ui.Validatable;
import com.rameses.rcp.util.ActionMessage;
import com.rameses.rcp.util.FormControlUtil;
import com.rameses.rcp.util.ItemPanel;
import com.rameses.rcp.util.UIControlUtil;
import com.rameses.util.ValueUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.beans.Beans;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;

public class FormPanel
extends JPanel
implements UIComposite,
ControlContainer,
Validatable,
ActiveControl,
UIConstants {
    private int cellspacing = 2;
    private Insets cellpadding = new Insets(0, 0, 0, 0);
    private String orientation = "VERTICAL";
    private Insets padding;
    private Border origBorder;
    private int captionWidth = 80;
    private String captionVAlignment = "TOP";
    private String captionHAlignment = "LEFT";
    private String captionOrientation = "LEFT";
    private Font captionFont;
    private Color captionForeground;
    private Border captionBorder = new XUnderlineBorder();
    private Insets captionPadding = new Insets(0, 1, 0, 5);
    private boolean addCaptionColon = true;
    private Binding binding;
    private String[] depends;
    private int index;
    private List<UIControl> controls = new ArrayList<UIControl>();
    private boolean dynamic;
    private ControlProperty property = new ControlProperty();
    private ActionMessage actionMessage = new ActionMessage();
    private List<UIControl> nonDynamicControls = new ArrayList<UIControl>();
    private boolean loaded;
    private boolean reloaded;
    private boolean dynamicControlsRemoved;
    private String viewType;
    private String oldViewType;
    private boolean viewTypeSet;
    private LayoutManager layout = new Layout();
    private JEditorPane htmlPane;
    private String emptyWhen;
    private String emptyText;
    private XLabel emptyLbl;
    private FormPanelModel model;
    private FormPanelModel.Listener defaultListener;
    private int stretchWidth;
    private int stretchHeight;
    private String visibleWhen;

    public FormPanel() {
        super.setLayout(this.layout);
        this.setPadding(new Insets(5, 5, 5, 5));
        this.setOpaque(false);
        Font font = super.getFont().deriveFont(0);
        this.setFont(font);
        this.setCaptionFont(font);
        this.setCaptionForeground(UIManager.getColor("Label.foreground"));
    }

    @Override
    public void setLayout(LayoutManager mgr) {
    }

    @Override
    protected void addImpl(Component comp, Object constraints, int index) {
        ItemPanel p = null;
        Component control = comp;
        if (comp instanceof ActiveControl) {
            p = new ItemPanel(this, comp);
        } else if (comp instanceof JScrollPane && (control = ((JScrollPane)comp).getViewport().getView()) instanceof ActiveControl) {
            p = new ItemPanel(this, control, comp);
        }
        if (p != null) {
            if (!this.loaded && control instanceof UIControl) {
                this.nonDynamicControls.add((UIControl)((Object)control));
            }
            super.addImpl(p, constraints, index);
        }
    }

    @Override
    public void remove(Component comp) {
        if (comp instanceof ItemPanel) {
            super.remove(comp);
        } else {
            Component c = this.resolveComponent(comp);
            if (c != null) {
                super.remove(c);
            }
        }
    }

    private int indexOf(Component comp) {
        for (int i = 0; i < this.getComponentCount(); ++i) {
            ItemPanel p;
            Component c = this.getComponent(i);
            if (c == comp) {
                return i;
            }
            if (!(c instanceof ItemPanel) || (p = (ItemPanel)c).getEditorComponent() != comp) continue;
            return i;
        }
        return -1;
    }

    private Component resolveComponent(Component comp) {
        for (int i = 0; i < this.getComponentCount(); ++i) {
            Component c = this.getComponent(i);
            if (c == comp) {
                return c;
            }
            if (!(c instanceof ItemPanel)) continue;
            ItemPanel p = (ItemPanel)c;
            if (p.getEditorComponent() == comp) {
                return p;
            }
            if (p.getEditorWrapper() != comp) continue;
            return p;
        }
        return null;
    }

    @Override
    public List<? extends UIControl> getControls() {
        return this.controls;
    }

    @Override
    public String[] getDepends() {
        return this.depends;
    }

    public void setDepends(String[] depends) {
        this.depends = depends;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    @Override
    public Binding getBinding() {
        return this.binding;
    }

    @Override
    public void setBinding(Binding binding) {
        this.binding = binding;
    }

    @Override
    public boolean isDynamic() {
        return this.dynamic;
    }

    public void setDynamic(boolean dynamic) {
        this.dynamic = dynamic;
    }

    public int compareTo(Object o) {
        return UIControlUtil.compare(this, o);
    }

    @Override
    public void validateInput() {
        this.actionMessage.clearMessages();
        if (ValueUtil.isEqual((Object)this.viewType, (Object)"html")) {
            return;
        }
        for (UIControl c : this.controls) {
            if (!(c instanceof Validatable)) continue;
            Validatable v = (Validatable)((Object)c);
            UIControlUtil.validate(v, this.actionMessage);
        }
    }

    @Override
    public ActionMessage getActionMessage() {
        return this.actionMessage;
    }

    @Override
    public void requestFocus() {
        this.focusFirstInput();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean focusFirstInput() {
        ArrayList<UIControl> allControls = new ArrayList<UIControl>();
        if (!this.nonDynamicControls.isEmpty()) {
            allControls.addAll(this.nonDynamicControls);
        }
        allControls.addAll(this.controls);
        try {
            for (UIControl c : allControls) {
                if (this.actionMessage.hasMessages()) {
                    if (!(c instanceof Validatable)) continue;
                    Validatable v = (Validatable)((Object)c);
                    v.validateInput();
                    if (!v.getActionMessage().hasMessages()) continue;
                    ((Component)((Object)v)).requestFocus();
                    boolean bl = true;
                    return bl;
                }
                if (c instanceof UIFocusableContainer) {
                    UIFocusableContainer uis = (UIFocusableContainer)c;
                    if (!uis.focusFirstInput()) continue;
                    boolean bl = true;
                    return bl;
                }
                if (!(c instanceof UIInput)) continue;
                UIInput u = (UIInput)c;
                JComponent jc = (JComponent)((Object)c);
                if (u.isReadonly() || !jc.isFocusable() || !jc.isEnabled() || !jc.isShowing()) continue;
                jc.requestFocus();
                boolean bl = true;
                return bl;
            }
        }
        catch (Exception exception) {
        }
        finally {
            allControls = null;
        }
        return false;
    }

    @Override
    public boolean isHasNonDynamicContents() {
        return !this.nonDynamicControls.isEmpty();
    }

    @Override
    public UIControl find(String name) {
        for (UIControl uic : this.controls) {
            if (!ValueUtil.isEqual((Object)name, (Object)uic.getName())) continue;
            return uic;
        }
        return null;
    }

    @Override
    public int getStretchWidth() {
        return this.stretchWidth;
    }

    @Override
    public void setStretchWidth(int stretchWidth) {
        this.stretchWidth = stretchWidth;
    }

    @Override
    public int getStretchHeight() {
        return this.stretchHeight;
    }

    @Override
    public void setStretchHeight(int stretchHeight) {
        this.stretchHeight = stretchHeight;
    }

    @Override
    public String getVisibleWhen() {
        return this.visibleWhen;
    }

    @Override
    public void setVisibleWhen(String visibleWhen) {
        this.visibleWhen = visibleWhen;
    }

    @Override
    public void refresh() {
        if (this.reloaded || this.viewTypeSet && !ValueUtil.isEqual((Object)this.oldViewType, (Object)this.viewType)) {
            this.refreshForm();
            this.oldViewType = this.viewType;
            this.reloaded = false;
        } else if (ValueUtil.isEqual((Object)this.viewType, (Object)"html")) {
            this.refreshHtml();
        }
        Object bean = this.getBinding() == null ? null : this.getBinding().getBean();
        String whenExpr = this.getVisibleWhen();
        if (whenExpr != null && whenExpr.length() > 0 && bean != null) {
            boolean result = false;
            try {
                result = UIControlUtil.evaluateExprBoolean(bean, whenExpr);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            this.setVisible(result);
        }
    }

    @Override
    public void load() {
        this.binding.addBindingListener(new FormPanelBindingListener());
        this.build();
        this.loaded = true;
        this.reloaded = true;
    }

    @Override
    public void reload() {
        this.build();
        this.reloaded = true;
    }

    public Map getInfo() {
        return null;
    }

    private void build() {
        if (ValueUtil.isEmpty((Object)this.getName())) {
            return;
        }
        for (UIControl u : this.controls) {
            this.remove((Component)((Object)u));
            u = null;
        }
        this.controls.clear();
        this.property.setRequired(false);
        boolean htmlView = "html".equals(this.viewType);
        List list = this.getFormControls();
        FormControlUtil fcUtil = FormControlUtil.getInstance();
        for (FormControl fc : list) {
            UIControl uic = fcUtil.getControl(fc);
            if (uic == null) continue;
            uic.setBinding(this.binding);
            uic.load();
            if (uic instanceof Validatable && ((Validatable)((Object)uic)).isRequired()) {
                this.property.setRequired(true);
            }
            this.controls.add(uic);
        }
    }

    private void refreshForm() {
        boolean htmlView = "html".equals(this.viewType);
        if (!htmlView && this.htmlPane != null) {
            this.remove(this.htmlPane);
            this.htmlPane = null;
        }
        if (htmlView) {
            for (UIControl u : this.nonDynamicControls) {
                u.refresh();
                this.remove((Component)((Object)u));
            }
            this.dynamicControlsRemoved = true;
            for (UIControl u : this.controls) {
                u.refresh();
                this.remove((Component)((Object)u));
            }
            if (this.htmlPane == null) {
                this.initHtmlPane();
            }
        } else {
            super.setLayout(this.layout);
        }
        boolean empty = false;
        if (this.controls.size() == 0 && this.nonDynamicControls.size() == 0 && !ValueUtil.isEmpty((Object)this.emptyText)) {
            empty = true;
        } else if (!ValueUtil.isEmpty((Object)this.emptyWhen)) {
            try {
                empty = UIControlUtil.evaluateExprBoolean(this.binding.getBean(), this.emptyWhen);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        if (!empty) {
            if (this.emptyLbl != null) {
                this.remove(this.emptyLbl);
                this.emptyLbl = null;
            }
            if (htmlView) {
                Iterator<UIControl> fcUtil = FormControlUtil.getInstance();
                this.htmlPane.setText(((FormControlUtil)((Object)fcUtil)).renderHtml(this.getAllControls(), this));
            } else {
                if (this.dynamicControlsRemoved) {
                    for (UIControl u : this.nonDynamicControls) {
                        this.add((Component)((Object)u));
                        u.refresh();
                    }
                    this.dynamicControlsRemoved = false;
                }
                for (UIControl u : this.controls) {
                    u.refresh();
                    if (htmlView) continue;
                    if (this.layout != super.getLayout()) {
                        super.setLayout(this.layout);
                    }
                    if (this.reloaded) {
                        this.add((Component)((Object)u));
                    }
                    u.refresh();
                }
            }
        } else if (htmlView) {
            Font f = this.getFont();
            StringBuffer sb = new StringBuffer().append("<html>").append("<head>").append("<style> body, td, div, span { ").append("  font-family: \"" + f.getFamily() + "\"; ").append("  font-size: " + f.getSize()).append("}</style>").append("</head>").append("<body>").append(this.emptyText == null ? "" : this.emptyText).append("</body>").append("</html>");
            this.htmlPane.setText(sb.toString());
            this.htmlPane.setCaretPosition(0);
        } else if (this.emptyText != null) {
            if (this.emptyLbl == null) {
                this.emptyLbl = new XLabel();
                this.emptyLbl.setShowCaption(false);
            }
            this.emptyLbl.setExpression(this.emptyText);
            this.add(this.emptyLbl);
        }
        SwingUtilities.updateComponentTreeUI(this);
    }

    private void refreshHtml() {
        boolean empty = false;
        if (this.controls.size() == 0 && this.nonDynamicControls.size() == 0 && !ValueUtil.isEmpty((Object)this.emptyText)) {
            empty = true;
        } else if (!ValueUtil.isEmpty((Object)this.emptyWhen)) {
            try {
                empty = UIControlUtil.evaluateExprBoolean(this.binding.getBean(), this.emptyWhen);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        if (!empty) {
            List<UIControl> allControls = this.getAllControls();
            for (UIControl c : allControls) {
                c.refresh();
            }
            FormControlUtil fcUtil = FormControlUtil.getInstance();
            this.htmlPane.setText(fcUtil.renderHtml(allControls, this));
            this.htmlPane.setCaretPosition(0);
        } else {
            Font f = this.getFont();
            String html = "<font face='" + f.getFamily() + "' size='" + f.getSize() + "pt'>" + (this.emptyText == null ? "" : this.emptyText) + "</font>";
            this.htmlPane.setText(html);
        }
    }

    private void initHtmlPane() {
        XEditorPane editorPane = new XEditorPane();
        editorPane.setBinding(this.binding);
        super.setLayout(new BorderLayout());
        super.addImpl(editorPane, null, 0);
        this.htmlPane = editorPane;
    }

    private List getFormControls() {
        ArrayList<FormControl> list = new ArrayList<FormControl>();
        Object value = null;
        try {
            value = UIControlUtil.getBeanValue(this);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (value instanceof FormPanelModel) {
            if (this.model != null) {
                this.model.setListener(null);
                this.model = null;
            }
            this.model = (FormPanelModel)value;
            if (this.defaultListener == null) {
                this.defaultListener = new ModelListener();
            }
            this.model.setListener(this.defaultListener);
            value = this.model.getFormControls();
        }
        if (value != null) {
            if (value.getClass().isArray()) {
                for (FormControl fc : (FormControl[])value) {
                    list.add(fc);
                }
            } else if (value instanceof Collection) {
                list.addAll((Collection)value);
            }
        }
        return list;
    }

    @Override
    public ControlProperty getControlProperty() {
        return this.property;
    }

    @Override
    public String getCaption() {
        return this.property.getCaption();
    }

    @Override
    public void setCaption(String caption) {
        this.property.setCaption(caption);
    }

    public char getCaptionMnemonic() {
        return this.property.getCaptionMnemonic();
    }

    public void setCaptionMnemonic(char c) {
        this.property.setCaptionMnemonic(c);
    }

    public boolean isShowCaption() {
        return this.property.isShowCaption();
    }

    public void setShowCaption(boolean show) {
        this.property.setShowCaption(show);
    }

    public int getCellspacing() {
        return this.cellspacing;
    }

    public void setCellspacing(int cellspacing) {
        this.cellspacing = cellspacing;
    }

    @Override
    public void setBorder(Border border) {
        this.origBorder = border;
        if (this.padding != null) {
            Border inner = BorderFactory.createEmptyBorder(this.padding.top, this.padding.left, this.padding.bottom, this.padding.right);
            super.setBorder(BorderFactory.createCompoundBorder(border, inner));
        } else {
            super.setBorder(border);
        }
    }

    public Insets getPadding() {
        return this.padding;
    }

    public void setPadding(Insets padding) {
        this.padding = padding;
        this.setBorder(this.origBorder);
    }

    public int getCaptionWidth() {
        return this.captionWidth;
    }

    public void setCaptionWidth(int captionWidth) {
        this.captionWidth = captionWidth;
    }

    public String getCaptionVAlignment() {
        return this.captionVAlignment;
    }

    public void setCaptionVAlignment(String captionVAlignment) {
        this.captionVAlignment = captionVAlignment != null ? captionVAlignment.toUpperCase() : "TOP";
    }

    public String getCaptionHAlignment() {
        return this.captionHAlignment;
    }

    public void setCaptionHAlignment(String captionHAlignment) {
        this.captionHAlignment = captionHAlignment != null ? captionHAlignment.toUpperCase() : "LEFT";
    }

    public String getCaptionOrientation() {
        return this.captionOrientation;
    }

    public void setCaptionOrientation(String captionOrientation) {
        this.captionOrientation = captionOrientation != null ? captionOrientation.toUpperCase() : "LEFT";
    }

    public String getOrientation() {
        return this.orientation;
    }

    public void setOrientation(String orientation) {
        this.orientation = orientation != null ? orientation.toUpperCase() : "VERTICAL";
    }

    public Insets getCaptionPadding() {
        return this.captionPadding;
    }

    public void setCaptionPadding(Insets captionPadding) {
        this.captionPadding = captionPadding;
    }

    public Insets getCellpadding() {
        return this.cellpadding;
    }

    public void setCellpadding(Insets cellpadding) {
        this.cellpadding = cellpadding != null ? cellpadding : new Insets(0, 0, 0, 0);
    }

    public boolean isAddCaptionColon() {
        return this.addCaptionColon;
    }

    public void setAddCaptionColon(boolean addCaptionColon) {
        this.addCaptionColon = addCaptionColon;
        this.updateLabelsCaption();
    }

    private void updateLabelsCaption() {
        for (Component c : this.getComponents()) {
            if (!(c instanceof ItemPanel)) continue;
            XLabel lbl = ((ItemPanel)c).getLabelComponent();
            lbl.setAddCaptionColon(this.addCaptionColon);
        }
    }

    public Font getCaptionFont() {
        return this.captionFont;
    }

    public void setCaptionFont(Font captionFont) {
        this.captionFont = captionFont;
        this.updateLabelsFont();
    }

    private void updateLabelsFont() {
        for (Component c : this.getComponents()) {
            if (!(c instanceof ItemPanel)) continue;
            XLabel lbl = ((ItemPanel)c).getLabelComponent();
            lbl.setFont(this.captionFont);
        }
    }

    public Color getCaptionForeground() {
        return this.captionForeground;
    }

    public void setCaptionForeground(Color captionForeground) {
        this.captionForeground = captionForeground;
        this.updateLabelsForeground();
    }

    private void updateLabelsForeground() {
        for (Component c : this.getComponents()) {
            if (!(c instanceof ItemPanel)) continue;
            XLabel lbl = ((ItemPanel)c).getLabelComponent();
            lbl.setForeground(this.captionForeground);
        }
    }

    public Border getCaptionBorder() {
        return this.captionBorder;
    }

    public void setCaptionBorder(Border captionBorder) {
        this.captionBorder = captionBorder;
        this.updateLabelsBorder();
    }

    private void updateLabelsBorder() {
        for (Component c : this.getComponents()) {
            if (!(c instanceof ItemPanel)) continue;
            XLabel lbl = ((ItemPanel)c).getLabelComponent();
            lbl.setBorder(this.captionBorder);
        }
    }

    @Override
    public void setRequired(boolean required) {
    }

    @Override
    public boolean isRequired() {
        return this.property.isRequired();
    }

    public String getViewType() {
        return this.viewType;
    }

    public void setViewType(String viewType) {
        this.oldViewType = !this.viewTypeSet ? viewType : this.viewType;
        this.viewType = viewType;
        this.viewTypeSet = true;
    }

    public boolean isChildrenAcceptStyles() {
        return false;
    }

    public String getEmptyText() {
        return this.emptyText;
    }

    public void setEmptyText(String emptyText) {
        this.emptyText = emptyText;
    }

    public List<UIControl> getAllControls() {
        ArrayList<UIControl> allControls = new ArrayList<UIControl>();
        allControls.addAll(this.nonDynamicControls);
        allControls.addAll(this.controls);
        return allControls;
    }

    public String getEmptyWhen() {
        return this.emptyWhen;
    }

    public void setEmptyWhen(String emptyWhen) {
        this.emptyWhen = emptyWhen;
    }

    @Override
    public void setPropertyInfo(PropertySupport.PropertyInfo info) {
    }

    private class ModelListener
    implements FormPanelModel.Listener {
        private ModelListener() {
        }

        @Override
        public void onPropertyUpdated(String name, Object value) {
            FormPanel handle = FormPanel.this;
            PropertyResolver res = PropertyResolver.getInstance();
            try {
                res.setProperty((Object)handle, name, value);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @Override
        public String getHtmlFormat(boolean partial) {
            FormControlUtil fcUtil = FormControlUtil.getInstance();
            return fcUtil.renderHtml(FormPanel.this.getAllControls(), FormPanel.this, partial);
        }

        @Override
        public void onReload() {
            FormPanel.this.reload();
            FormPanel.this.refresh();
        }
    }

    private class FormPanelBindingListener
    implements BindingListener {
        private FormPanelBindingListener() {
        }

        @Override
        public void notifyDepends(UIControl u, Binding parent) {
            this.notifyDepends(u, parent, u.getName());
        }

        @Override
        public void notifyDepends(UIControl u, Binding parent, String name) {
            if (ValueUtil.isEmpty((Object)name)) {
                return;
            }
            if (ValueUtil.isEqual((Object)FormPanel.this.viewType, (Object)"html")) {
                boolean shouldRefresh = false;
                for (UIControl control : FormPanel.this.controls) {
                    if (!this.isDependent(name, control)) continue;
                    shouldRefresh = true;
                }
                if (shouldRefresh) {
                    FormPanel.this.refreshHtml();
                }
            } else {
                HashSet refreshed = new HashSet();
                for (UIControl control : FormPanel.this.controls) {
                    if (!this.isDependent(name, control)) continue;
                    this._doRefresh(control, refreshed);
                }
                refreshed.clear();
                refreshed = null;
            }
        }

        private boolean isDependent(String parentName, UIControl child) {
            if (child.getDepends() != null) {
                for (String s : child.getDepends()) {
                    if (!parentName.matches(s)) continue;
                    return true;
                }
            }
            return false;
        }

        @Override
        public void refresh(String regEx) {
            if (ValueUtil.isEqual((Object)FormPanel.this.viewType, (Object)"html")) {
                return;
            }
            HashSet refreshed = new HashSet();
            for (UIControl uu : FormPanel.this.controls) {
                String name = uu.getName();
                if (regEx != null && name != null && !name.matches(regEx)) continue;
                this._doRefresh(uu, refreshed);
            }
            refreshed.clear();
            refreshed = null;
        }

        private void _doRefresh(UIControl u, Set refreshed) {
            if (refreshed.add(u)) {
                u.refresh();
            }
        }

        @Override
        public void validate(ActionMessage actionMessage, Binding parent) {
        }

        @Override
        public void validateBean(ValidatorEvent evt) {
        }

        @Override
        public void formCommit() {
        }

        @Override
        public void update() {
        }
    }

    private class Layout
    implements LayoutManager {
        private Layout() {
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return this.getLayoutSize(parent);
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            Dimension dim = this.getLayoutSize(parent);
            return new Dimension(100, dim.height);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void layoutContainer(Container parent) {
            Object object = parent.getTreeLock();
            synchronized (object) {
                Insets margin = parent.getInsets();
                int x = margin.left;
                int y = margin.top;
                int w = parent.getWidth() - (margin.left + margin.right);
                int h = parent.getHeight() - (margin.top + margin.bottom);
                Component[] comps = parent.getComponents();
                for (int i = 0; i < comps.length; ++i) {
                    Component c = comps[i];
                    if (!c.isVisible()) continue;
                    Dimension dim = c.getPreferredSize();
                    if ("HORIZONTAL".equals(FormPanel.this.orientation)) {
                        if (x > 0) {
                            x += FormPanel.this.getCellspacing();
                        }
                        c.setBounds(x += ((FormPanel)FormPanel.this).cellpadding.left, y, dim.width, dim.height);
                    } else {
                        if (y > 0) {
                            y += FormPanel.this.getCellspacing();
                        }
                        c.setBounds(x, y += ((FormPanel)FormPanel.this).cellpadding.top, w, dim.height);
                    }
                    if ("HORIZONTAL".equals(FormPanel.this.orientation)) {
                        x += dim.width + ((FormPanel)FormPanel.this).cellpadding.right;
                        continue;
                    }
                    y += dim.height + ((FormPanel)FormPanel.this).cellpadding.bottom;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Dimension getLayoutSize(Container parent) {
            Object object = parent.getTreeLock();
            synchronized (object) {
                int w = 0;
                int h = 0;
                Component[] comps = parent.getComponents();
                if (Beans.isDesignTime() && comps.length == 0) {
                    return new Dimension(100, 100);
                }
                for (int i = 0; i < comps.length; ++i) {
                    Component c = comps[i];
                    if (!c.isVisible() || !(c instanceof ItemPanel)) continue;
                    Dimension dim = c.getPreferredSize();
                    if ("HORIZONTAL".equals(FormPanel.this.orientation)) {
                        if (h == 0) {
                            h = dim.height;
                        }
                        h = Math.min(h, dim.height);
                        if (w > 0) {
                            w += FormPanel.this.getCellspacing();
                        }
                        w += dim.width + ((FormPanel)FormPanel.this).cellpadding.left + ((FormPanel)FormPanel.this).cellpadding.right;
                        continue;
                    }
                    if (w == 0) {
                        w = dim.width;
                    }
                    w = Math.min(w, dim.width);
                    if (h > 0) {
                        h += FormPanel.this.getCellspacing();
                    }
                    h += dim.height + ((FormPanel)FormPanel.this).cellpadding.top + ((FormPanel)FormPanel.this).cellpadding.bottom;
                }
                Insets margin = parent.getInsets();
                return new Dimension(w += margin.left + margin.right, h += margin.top + margin.bottom);
            }
        }
    }
}

