/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.util;

import com.rameses.common.PropertyResolver;
import com.rameses.rcp.common.FormControl;
import com.rameses.rcp.common.Opener;
import com.rameses.rcp.common.SubControlModel;
import com.rameses.rcp.constant.TextCase;
import com.rameses.rcp.constant.TrimSpaceOption;
import com.rameses.rcp.control.XLabel;
import com.rameses.rcp.framework.Binding;
import com.rameses.rcp.framework.ClientContext;
import com.rameses.rcp.ui.ActiveControl;
import com.rameses.rcp.ui.ControlProperty;
import com.rameses.rcp.ui.UIControl;
import com.rameses.rcp.ui.UISubControl;
import com.rameses.rcp.util.FormPanel;
import com.rameses.rcp.util.UIControlUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FormControlUtil {
    private static final String CONF = "META-INF/form-controls.properties";
    private static final String HTML_TAGS = "<\\/?html>|<\\/?body>";
    private static FormControlUtil instance;
    private Properties controlsIndex;
    private List<ValueResolver> resolvers = new ArrayList<ValueResolver>();

    public static final synchronized FormControlUtil getInstance() {
        if (instance == null) {
            instance = new FormControlUtil();
        }
        return instance;
    }

    FormControlUtil() {
        this.resolvers.add(new DefaultValueResolver());
        this.controlsIndex = new Properties();
        try {
            Enumeration<URL> en = ClientContext.getCurrentContext().getClassLoader().getResources(CONF);
            while (en.hasMoreElements()) {
                URL u = en.nextElement();
                try {
                    this.controlsIndex.load(u.openStream());
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public UIControl getControl(FormControl fc) {
        String className = (String)this.controlsIndex.get(fc.getType());
        if (className == null) {
            System.out.println("FormPanel Warning: " + fc.getType() + " is not supported.");
            return null;
        }
        try {
            ClientContext ctx = ClientContext.getCurrentContext();
            Class<?> clazz = ctx.getClassLoader().loadClass(className);
            UIControl uic = (UIControl)clazz.newInstance();
            this.setProperties(uic, fc.getProperties());
            return uic;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public void addValueResolver(ValueResolver res) {
        if (!this.resolvers.contains(res)) {
            this.resolvers.add(res);
        }
    }

    public boolean removeValueResolver(ValueResolver res) {
        return this.resolvers.remove(res);
    }

    public String renderHtml(List<UIControl> controls, FormPanel panel) {
        return this.renderHtml(controls, panel, false);
    }

    public String renderHtml(List<UIControl> controls, FormPanel panel, boolean partial) {
        StringBuffer sb = new StringBuffer();
        if (!partial) {
            sb.append("<html>").append("<head>").append("<style> body, td, div, span { ").append("  font-family: \"" + panel.getFont().getFamily() + "\"; ").append("  font-size: " + panel.getFont().getSize()).append("}</style>").append("</head>").append("<body>");
        }
        sb.append("<table>");
        boolean first = true;
        for (UIControl c : controls) {
            if (!(c instanceof ActiveControl)) continue;
            ControlProperty cp = ((ActiveControl)((Object)c)).getControlProperty();
            sb.append("<tr>");
            if (cp.isShowCaption()) {
                sb.append("<td valign='top'><b>" + cp.getCaption() + ":</b></td>").append("<td valign='top'>");
            } else {
                sb.append("<td valign='top' colspan='2'>");
            }
            Color fg = ((Component)((Object)c)).getForeground();
            String strColor = null;
            if (fg != null) {
                strColor = "rgb(" + fg.getRed() + "," + fg.getGreen() + "," + fg.getBlue() + ")";
            }
            if (strColor != null) {
                sb.append("<font color='" + strColor + "'>");
            }
            Object value = null;
            try {
                if (c instanceof UISubControl) {
                    Opener opener;
                    UISubControl sc = (UISubControl)c;
                    Object handler = sc.getHandlerObject();
                    if (handler instanceof Opener && (opener = (Opener)handler).getHandle() != null && opener.getHandle() instanceof SubControlModel) {
                        value = ((SubControlModel)opener.getHandle()).getHtmlFormat();
                    }
                } else if (c instanceof FormPanel) {
                    FormPanel fp = (FormPanel)c;
                    value = this.renderHtml(fp.getAllControls(), fp, true);
                } else {
                    value = c instanceof XLabel ? ((XLabel)c).getValue() : UIControlUtil.getBeanValue(c);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!first && "__category_label".equals(c.getName())) {
                sb.append("<br>");
            }
            sb.append(value == null ? "" : value.toString().replaceAll(HTML_TAGS, ""));
            if (strColor != null) {
                sb.append("</font>");
            }
            sb.append("</td>").append("</tr>");
            first = false;
        }
        sb.append("</table>");
        if (!partial) {
            sb.append("</body>").append("</html>");
        }
        return sb.toString();
    }

    public Map buildHtmlValueFormat(List<FormControl> controls, Object entity) {
        HashMap<String, Object> valueIndex = new HashMap<String, Object>();
        Binding b = new Binding();
        b.setBean(entity);
        for (FormControl fc : controls) {
            UIControl c = this.getControl(fc);
            c.setBinding(b);
            c.load();
            c.refresh();
            if (!(c instanceof ActiveControl)) continue;
            Object value = null;
            if (c instanceof UISubControl) {
                Opener opener;
                UISubControl sc = (UISubControl)c;
                Object handler = sc.getHandlerObject();
                if (handler instanceof Opener && (opener = (Opener)handler).getHandle() != null && opener.getHandle() instanceof SubControlModel) {
                    value = ((SubControlModel)opener.getHandle()).getHtmlFormat();
                }
            } else if (c instanceof FormPanel) {
                FormPanel fp = (FormPanel)c;
                value = this.renderHtml(fp.getAllControls(), fp, true);
            } else {
                value = c instanceof XLabel ? ((XLabel)c).getValue() : UIControlUtil.getBeanValue(c);
            }
            String name = (String)fc.getProperties().get("name");
            if (name != null) {
                valueIndex.put(name, value == null ? "" : value);
            }
            c = null;
        }
        b = null;
        return valueIndex;
    }

    public Map buildPrintValueFormat(List<FormControl> controls, Object entity) {
        HashMap<String, Object> valueIndex = new HashMap<String, Object>();
        Binding b = new Binding();
        b.setBean(entity);
        for (FormControl fc : controls) {
            UIControl c = this.getControl(fc);
            c.setBinding(b);
            c.load();
            c.refresh();
            if (!(c instanceof ActiveControl)) continue;
            Object value = null;
            if (c instanceof UISubControl) {
                Opener opener;
                UISubControl sc = (UISubControl)c;
                Object handler = sc.getHandlerObject();
                if (handler instanceof Opener && (opener = (Opener)handler).getHandle() != null && opener.getHandle() instanceof SubControlModel) {
                    value = ((SubControlModel)opener.getHandle()).getPrintFormat();
                }
            } else if (c instanceof FormPanel) {
                FormPanel fp = (FormPanel)c;
                value = this.renderHtml(fp.getAllControls(), fp, true);
            } else {
                value = c instanceof XLabel ? ((XLabel)c).getValue() : UIControlUtil.getBeanValue(c);
            }
            String name = (String)fc.getProperties().get("name");
            if (name != null) {
                valueIndex.put(name, value == null ? "" : value);
            }
            c = null;
        }
        b = null;
        return valueIndex;
    }

    private void setProperties(Object control, Map properties) {
        if (properties == null) {
            return;
        }
        ClientContext ctx = ClientContext.getCurrentContext();
        PropertyResolver resolver = PropertyResolver.getInstance();
        Iterator iterator = properties.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry oo;
            Map.Entry me = oo = iterator.next();
            try {
                String key = me.getKey() + "";
                Object value = this.resolveValue(key, me.getValue());
                resolver.setProperty(control, key, value);
            }
            catch (Exception exception) {}
        }
    }

    private Object resolveValue(String name, Object value) {
        if (value == null) {
            return null;
        }
        for (ValueResolver vr : this.resolvers) {
            Object vv = vr.resolve(name, value);
            if (vv == null) continue;
            return vv;
        }
        return value;
    }

    private static class DefaultValueResolver
    implements ValueResolver {
        private static final Pattern RGB_PATTERN = Pattern.compile("rgb\\((\\d+),(\\d+),(\\d+)\\)");
        private static final Pattern FONT_PATTERN = Pattern.compile("([\\s\\w]+)\\s+(\\w+)\\s+(\\d+)$");

        private DefaultValueResolver() {
        }

        @Override
        public Object resolve(String name, Object value) {
            if (name != null && value instanceof String) {
                Matcher m;
                String strValue = value.toString();
                if ("preferredSize".equals(name) || "size".equals(name)) {
                    String[] ss = strValue.split("\\s*,\\s*");
                    return new Dimension(Integer.parseInt(ss[0]), Integer.parseInt(ss[1]));
                }
                if (name.matches(".*([Bb]ackground|[Ff]oreground|[Cc]olor).*")) {
                    if (strValue.matches("#[a-f\\d]{3,6}")) {
                        return Color.decode(strValue);
                    }
                    if (strValue.startsWith("rgb") && (m = RGB_PATTERN.matcher(strValue.replace(" ", ""))).matches()) {
                        int r = Integer.parseInt(m.group(1));
                        int g = Integer.parseInt(m.group(2));
                        int b = Integer.parseInt(m.group(3));
                        return new Color(r, g, b);
                    }
                }
                if ("depends".equals(name)) {
                    return strValue.split("\\s*,\\s*");
                }
                if (name.matches(".*[Ff]ont.*")) {
                    m = FONT_PATTERN.matcher(strValue);
                    if (m.matches()) {
                        try {
                            String fName = m.group(1);
                            String style = m.group(2).toUpperCase();
                            int fStyle = "BOLD".equals(style) ? 1 : ("ITALIC".equals(style) ? 2 : 0);
                            int fSize = Integer.parseInt(m.group(3));
                            return new Font(fName, fStyle, fSize);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    return new Font(null);
                }
                if (name.equals("textCase")) {
                    return TextCase.valueOf(strValue);
                }
                if (name.equals("trimSpaceOption")) {
                    return TrimSpaceOption.valueOf(strValue);
                }
            }
            return null;
        }
    }

    public static interface ValueResolver {
        public Object resolve(String var1, Object var2);
    }
}

