/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.util;

import com.rameses.rcp.util.MessageUtil;
import com.rameses.util.ValueUtil;
import java.awt.Component;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;

public class ActionMessage {
    private List<String> messages = new ArrayList<String>();
    private Component source;

    public void addMessage(String code, String message, Object[] args) {
        message = MessageUtil.getMessage(code, message, "errors");
        if (args != null) {
            message = MessageFormat.format(message, args);
        }
        this.messages.add(message);
    }

    public void addMessage(ActionMessage message) {
        this.messages.addAll(message.messages);
        if (this.source == null && message.source != null) {
            this.source = message.source;
        }
    }

    public void addMessage(ActionMessage message, String parentCaption) {
        boolean hasParentCaption;
        boolean bl = hasParentCaption = !ValueUtil.isEmpty((Object)parentCaption);
        if (hasParentCaption) {
            this.messages.add(parentCaption + " (");
        }
        for (String msg : message.messages) {
            this.messages.add(msg);
        }
        if (hasParentCaption) {
            this.messages.add(")");
        }
        if (this.source == null && message.source != null) {
            this.source = message.source;
        }
    }

    public boolean hasMessages() {
        return !this.messages.isEmpty();
    }

    public void clearMessages() {
        this.messages.clear();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        boolean first = true;
        for (String msg : this.messages) {
            if (!first) {
                sb.append("\n");
            }
            sb.append(msg);
            first = false;
        }
        return sb.toString();
    }

    public Component getSource() {
        return this.source;
    }

    public void setSource(Component source) {
        this.source = source;
    }
}

