/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.ui;

import com.rameses.rcp.common.ValidatorEvent;
import com.rameses.rcp.framework.Binding;
import com.rameses.rcp.framework.BindingListener;
import com.rameses.rcp.ui.UIControl;
import com.rameses.rcp.ui.UISubControl;
import com.rameses.rcp.util.ActionMessage;
import java.awt.Component;
import java.util.HashSet;
import java.util.Set;

public class BindingConnector
implements BindingListener {
    private Set<Binding> subBindings = new HashSet<Binding>();
    private Binding parentBinding;
    private UISubControl parent;

    public BindingConnector(UISubControl parent) {
        this.parent = parent;
    }

    public Binding getParentBinding() {
        return this.parentBinding;
    }

    public void setParentBinding(Binding parentBinding) {
        if (parentBinding == this.parentBinding) {
            return;
        }
        if (this.parentBinding != null) {
            this.parentBinding.removeListener(this);
        }
        if (parentBinding != null) {
            parentBinding.addBindingListener(this);
        }
        this.parentBinding = parentBinding;
    }

    public Set<Binding> getSubBindings() {
        return this.subBindings;
    }

    @Override
    public void validate(ActionMessage actionMessage, Binding pbinding) {
        Component comp = (Component)((Object)this.parent);
        if (!comp.isShowing() || comp.getParent() == null) {
            return;
        }
        ActionMessage subMessages = new ActionMessage();
        for (Binding sb : this.subBindings) {
            sb.validate(subMessages);
        }
        if (subMessages.hasMessages()) {
            actionMessage.addMessage(subMessages, this.parent.getCaption());
        }
    }

    @Override
    public void validateBean(ValidatorEvent evt) {
        Component comp = (Component)((Object)this.parent);
        if (!comp.isShowing() || comp.getParent() == null) {
            return;
        }
        for (Binding sb : this.subBindings) {
            ValidatorEvent subEvt = new ValidatorEvent(sb);
            sb.validateBean(subEvt);
            evt.add(subEvt);
        }
    }

    @Override
    public void notifyDepends(UIControl control, Binding parent) {
        this.notifyDepends(control, parent, control.getName());
    }

    @Override
    public void notifyDepends(UIControl control, Binding parent, String name) {
        for (Binding sb : this.subBindings) {
            sb.notifyDepends(control, name);
        }
    }

    @Override
    public void refresh(String fieldRegEx) {
        for (Binding sb : this.subBindings) {
            sb.refresh(fieldRegEx);
        }
    }

    @Override
    public void formCommit() {
        for (Binding sb : this.subBindings) {
            sb.formCommit();
        }
    }

    @Override
    public void update() {
        for (Binding sb : this.subBindings) {
            sb.update();
        }
    }

    public UIControl getParent() {
        return this.parent;
    }

    public void setParent(UISubControl parent) {
        this.parent = parent;
    }
}

