/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.Beans;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class RadioListPanel
extends JPanel {
    private int itemGap;
    private int itemCount;
    private int orientation;
    private Insets padding;
    private String selectionMode;
    private ButtonGroup buttonGroup;
    private RadioComponent selectedButton;

    public RadioListPanel() {
        this.initComponent();
    }

    private void initComponent() {
        this.itemGap = 5;
        this.itemCount = 2;
        this.orientation = 0;
        this.selectionMode = "SINGLE";
        this.setPreferredSize(new Dimension(100, 50));
        super.setLayout(new ContainerLayout());
        this.setOpaque(false);
        this.buttonGroup = new ButtonGroup();
        if (Beans.isDesignTime()) {
            this.addItem("Option 1", "Option 1");
            this.addItem("Option 2", "Option 2");
        }
    }

    @Override
    public void setLayout(LayoutManager mgr) {
    }

    public String getSelectionMode() {
        return this.selectionMode;
    }

    public void setSelectionMode(String selectionMode) {
        this.selectionMode = selectionMode;
    }

    public int getItemGap() {
        return this.itemGap;
    }

    public void setItemGap(int itemGap) {
        this.itemGap = itemGap;
    }

    public int getItemCount() {
        return this.itemCount;
    }

    public void setItemCount(int itemCount) {
        this.itemCount = itemCount;
        if (Beans.isDesignTime()) {
            this.removeAll();
            for (int i = 0; i < itemCount; ++i) {
                this.addItem("Option " + (i + 1), "Option " + (i + 1));
            }
        }
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setOrientation(int orientation) {
        this.orientation = orientation;
    }

    public Insets getPadding() {
        return this.padding;
    }

    public void setPadding(Insets padding) {
        this.padding = padding;
    }

    public List getUserObjects() {
        ArrayList<Object> list = new ArrayList<Object>();
        Component[] comps = this.getComponents();
        for (int i = 0; i < comps.length; ++i) {
            if (!(comps[i] instanceof RadioComponent)) continue;
            RadioComponent rc = (RadioComponent)comps[i];
            list.add(rc.getUserObject());
        }
        return list;
    }

    public void setSelectedIndex(int index) {
        this.clearSelection();
        RadioComponent rc = null;
        try {
            rc = (RadioComponent)this.getComponent(index);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (rc != null) {
            rc.setSelected(true);
        }
        this.revalidate();
        this.repaint();
    }

    private Insets getPreferredPadding() {
        Insets pads = this.getPadding();
        return pads == null ? new Insets(0, 0, 0, 0) : pads;
    }

    private int getPreferredCellPadding() {
        return Math.max(this.getItemGap(), 0);
    }

    public void addItem(String caption, Object userObject) {
        this.addItem(new ItemImpl(caption, userObject));
    }

    public void addItem(Item item) {
        if (item == null) {
            return;
        }
        this.add(new RadioComponent(item));
    }

    @Override
    protected void addImpl(Component comp, Object constraints, int index) {
        if (comp instanceof RadioComponent) {
            super.addImpl(comp, constraints, index);
        }
    }

    public void clearSelection() {
        this.buttonGroup.clearSelection();
        this.selectedButton = null;
    }

    public Item getSelectedItem() {
        return this.selectedButton == null ? null : this.selectedButton.getItem();
    }

    protected void onselect(Object obj) {
    }

    @Override
    public void repaint(long tm, int x, int y, int width, int height) {
        this.enableComponents(this.isEnabled());
        super.repaint(tm, x, y, width, height);
    }

    public void enableComponents(boolean enabled) {
        Component[] comps = this.getComponents();
        for (int i = 0; i < comps.length; ++i) {
            if (!(comps[i] instanceof RadioComponent)) continue;
            comps[i].setEnabled(enabled);
            comps[i].repaint();
        }
    }

    @Override
    public boolean requestFocusInWindow() {
        if (!this.isEnabled()) {
            return false;
        }
        Component[] comps = this.getComponents();
        for (int i = 0; i < comps.length; ++i) {
            RadioComponent btn;
            if (!(comps[i] instanceof RadioComponent) || !(btn = (RadioComponent)comps[i]).isEnabled() || !btn.isFocusable()) continue;
            return btn.requestFocusInWindow();
        }
        return false;
    }

    private class ContainerLayout
    implements LayoutManager {
        RadioListPanel root;

        private ContainerLayout() {
            this.root = RadioListPanel.this;
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        private List<RadioComponent> getRadioItems(Container parent) {
            ArrayList<RadioComponent> items = new ArrayList<RadioComponent>();
            Component[] comps = parent.getComponents();
            for (int i = 0; i < comps.length; ++i) {
                RadioComponent c;
                if (!(comps[i] instanceof RadioComponent) || !(c = (RadioComponent)comps[i]).isVisible()) continue;
                items.add(c);
            }
            return items;
        }

        private Dimension computePageSize(List<RadioComponent> items, int pageindex) {
            Dimension dim = new Dimension(0, 0);
            int itemcount = items.size();
            if (itemcount == 0) {
                return dim;
            }
            int cellpad = this.root.getPreferredCellPadding();
            int cellcount = this.root.getItemCount();
            if (cellcount <= 0) {
                cellcount = itemcount;
            }
            int pagecount = itemcount / cellcount;
            if (itemcount % cellcount > 0) {
                ++pagecount;
            }
            boolean has_visible_components = false;
            if (this.root.getOrientation() == 1) {
                int index;
                for (int cellindex = 0; cellindex < cellcount && (index = pageindex * cellcount + cellindex) < itemcount; ++cellindex) {
                    RadioComponent ri = items.get(index);
                    int cwidth = ri.getPreferredSize().width;
                    int cheight = ri.getPreferredSize().height;
                    for (int ii = cellindex + cellcount; ii < itemcount; ii += cellcount) {
                        RadioComponent o = items.get(ii);
                        Dimension odim = o.getPreferredSize();
                        cheight = Math.max(cheight, odim.height);
                    }
                    dim.width = Math.max(dim.width, cwidth);
                    dim.height += cheight;
                    if (has_visible_components) {
                        dim.height += cellpad;
                    }
                    has_visible_components = true;
                }
            } else {
                int index;
                for (int cellindex = 0; cellindex < cellcount && (index = pageindex * cellcount + cellindex) < itemcount; ++cellindex) {
                    RadioComponent ri = items.get(index);
                    int cwidth = ri.getPreferredSize().width;
                    int cheight = ri.getPreferredSize().height;
                    for (int ii = cellindex + cellcount; ii < itemcount; ii += cellcount) {
                        RadioComponent o = items.get(ii);
                        Dimension odim = o.getPreferredSize();
                        cwidth = Math.max(cwidth, odim.width);
                    }
                    dim.width += cwidth;
                    dim.height = Math.max(dim.height, cheight);
                    if (has_visible_components) {
                        dim.width += cellpad;
                    }
                    has_visible_components = true;
                }
            }
            return dim;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Dimension getLayoutSize(Container parent) {
            Object object = parent.getTreeLock();
            synchronized (object) {
                Dimension newdim = new Dimension(0, 0);
                List<RadioComponent> items = this.getRadioItems(parent);
                int itemcount = items.size();
                if (itemcount > 0) {
                    int cellpad = this.root.getPreferredCellPadding();
                    int cellcount = this.root.getItemCount();
                    if (cellcount <= 0) {
                        cellcount = itemcount;
                    }
                    int pagecount = itemcount / cellcount;
                    if (itemcount % cellcount > 0) {
                        ++pagecount;
                    }
                    for (int pageindex = 0; pageindex < pagecount; ++pageindex) {
                        Dimension pagedim = this.computePageSize(items, pageindex);
                        newdim.width += pagedim.width;
                        newdim.height += pagedim.height;
                    }
                }
                Insets margin = parent.getInsets();
                Insets pads = this.root.getPreferredPadding();
                newdim.width += margin.left + margin.right + pads.left + pads.right;
                newdim.height += margin.top + margin.bottom + pads.top + pads.bottom;
                return newdim;
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return this.getLayoutSize(parent);
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return this.getLayoutSize(parent);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void layoutContainer(Container parent) {
            Object object = parent.getTreeLock();
            synchronized (object) {
                Insets pads = this.root.getPreferredPadding();
                Insets margin = parent.getInsets();
                int pw = parent.getWidth();
                int ph = parent.getHeight();
                int sx = margin.left + pads.left;
                int sy = margin.top + pads.top;
                int rb = pw - (margin.right + pads.right);
                int w = pw - (margin.left + margin.right + pads.left + pads.right);
                int h = ph - (margin.top + margin.bottom + pads.top + pads.bottom);
                int x = sx;
                int y = sy;
                List<RadioComponent> items = this.getRadioItems(parent);
                int itemcount = items.size();
                if (itemcount == 0) {
                    return;
                }
                int cellpad = this.root.getPreferredCellPadding();
                int cellcount = this.root.getItemCount();
                if (cellcount <= 0) {
                    cellcount = itemcount;
                }
                int pagecount = itemcount / cellcount;
                if (itemcount % cellcount > 0) {
                    ++pagecount;
                }
                for (int pageindex = 0; pageindex < pagecount; ++pageindex) {
                    Dimension odim;
                    RadioComponent o;
                    int idx;
                    int pgidx;
                    Dimension rdim;
                    RadioComponent ri;
                    int index;
                    int cellindex;
                    if (this.root.getOrientation() == 1) {
                        y = sy;
                        if (pageindex > 0) {
                            x += cellpad;
                        }
                        int maxwidth = 0;
                        for (cellindex = 0; cellindex < cellcount && (index = pageindex * cellcount + cellindex) < itemcount; ++cellindex) {
                            ri = items.get(index);
                            rdim = ri.getPreferredSize();
                            maxwidth = Math.max(maxwidth, rdim.width);
                        }
                        for (cellindex = 0; cellindex < cellcount && (index = pageindex * cellcount + cellindex) < itemcount; ++cellindex) {
                            ri = items.get(index);
                            rdim = ri.getPreferredSize();
                            int maxheight = rdim.height;
                            for (pgidx = 0; pgidx < pagecount && (idx = pgidx * cellcount + cellindex) < itemcount; ++pgidx) {
                                o = items.get(idx);
                                odim = o.getPreferredSize();
                                maxheight = Math.max(maxheight, odim.height);
                            }
                            ri.setBounds(x, y, maxwidth, rdim.height);
                            y += maxheight + cellpad;
                        }
                        x += maxwidth;
                        continue;
                    }
                    x = sx;
                    if (pageindex > 0) {
                        y += cellpad;
                    }
                    int maxheight = 0;
                    for (cellindex = 0; cellindex < cellcount && (index = pageindex * cellcount + cellindex) < itemcount; ++cellindex) {
                        ri = items.get(index);
                        rdim = ri.getPreferredSize();
                        maxheight = Math.max(maxheight, rdim.height);
                    }
                    for (cellindex = 0; cellindex < cellcount && (index = pageindex * cellcount + cellindex) < itemcount; ++cellindex) {
                        ri = items.get(index);
                        rdim = ri.getPreferredSize();
                        int maxwidth = rdim.width;
                        for (pgidx = 0; pgidx < pagecount && (idx = pgidx * cellcount + cellindex) < itemcount; ++pgidx) {
                            o = items.get(idx);
                            odim = o.getPreferredSize();
                            maxwidth = Math.max(maxwidth, odim.width);
                        }
                        ri.setBounds(x, y, maxwidth, rdim.height);
                        x += maxwidth + cellpad;
                    }
                    y += maxheight;
                }
            }
        }
    }

    private class ToggleSelectionProcess
    implements Runnable {
        private RadioComponent comp;

        ToggleSelectionProcess(RadioComponent comp) {
            this.comp = comp;
        }

        @Override
        public void run() {
        }
    }

    class RadioComponent
    extends JRadioButton
    implements ActionListener {
        RadioListPanel root;
        private Item item;

        public RadioComponent(Item item) {
            this.root = RadioListPanel.this;
            this.item = item;
            this.setMargin(new Insets(0, 0, 0, 0));
            this.setOpaque(false);
            this.addActionListener(this);
        }

        public Item getItem() {
            return this.item;
        }

        public Object getUserObject() {
            return this.item == null ? null : this.item.getUserObject();
        }

        @Override
        public String getText() {
            return this.item == null ? "null" : this.item.getCaption();
        }

        @Override
        public void addNotify() {
            super.addNotify();
            this.root.buttonGroup.add(this);
        }

        @Override
        public void removeNotify() {
            super.removeNotify();
            this.root.buttonGroup.remove(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (Beans.isDesignTime()) {
                return;
            }
            if (this.root.selectedButton != null && this.root.selectedButton.equals(this)) {
                boolean toggle = "TOGGLE".equals(this.root.getSelectionMode());
                if (toggle) {
                    this.root.buttonGroup.clearSelection();
                    this.repaint();
                    this.root.selectedButton = null;
                    this.root.onselect(null);
                }
            } else {
                this.root.selectedButton = this;
                this.root.onselect(this.getUserObject());
            }
        }
    }

    class ItemImpl
    implements Item {
        private String caption;
        private Object userObject;

        ItemImpl(String caption, Object userObject) {
            this.caption = caption;
            this.userObject = userObject;
        }

        @Override
        public Object getUserObject() {
            return this.userObject;
        }

        @Override
        public String getCaption() {
            return this.caption;
        }
    }

    public static interface Item {
        public Object getUserObject();

        public String getCaption();
    }
}

