/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.swing;

import com.rameses.rcp.common.AbstractListDataProvider;
import com.rameses.rcp.common.ListItem;
import com.rameses.rcp.common.PropertyChangeHandler;
import com.rameses.rcp.common.ScrollListModel;
import com.rameses.rcp.common.TableModelHandler;
import com.rameses.rcp.control.border.XLineBorder;
import com.rameses.rcp.support.ColorUtil;
import com.rameses.rcp.swing.ListScrollBar;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;

public class ListPane
extends JPanel {
    private JScrollPane scrollPane;
    private JListImpl jList;
    private AbstractListDataProvider model;
    private Object modelObject;
    private int fixedCellHeight;
    private List<Handler> handlers = new ArrayList<Handler>();

    public ListPane() {
        this.initComponent();
    }

    private void initComponent() {
        this.jList = new JListImpl();
        this.fixedCellHeight = this.jList.getFixedCellHeight();
        this.scrollPane = new JScrollPane(this.jList);
        this.scrollPane.setVerticalScrollBarPolicy(20);
        this.scrollPane.setHorizontalScrollBarPolicy(31);
        this.scrollPane.setBorder(BorderFactory.createEmptyBorder());
        this.scrollPane.setViewport(new ViewportImpl(this.jList));
        super.setLayout(new CustomLayout());
        this.add(this.jList);
        this.jList.setCellRenderer(new CellRendererImpl());
        this.jList.addMouseListener(new ListMouseHandler());
        this.jList.addMouseWheelListener(new ListMouseHandler());
        this.jList.addKeyListener(new TableKeyAdapter());
    }

    @Override
    public void setLayout(LayoutManager mgr) {
    }

    public AbstractListDataProvider getModel() {
        return this.model;
    }

    public void setModel(AbstractListDataProvider model) {
        this.model = model;
        this.modelObject = model;
        this.fireModelChanged();
    }

    public void setModel(Object modelObject) {
        this.model = (AbstractListDataProvider)modelObject;
        this.modelObject = modelObject;
        this.fireModelChanged();
    }

    public void setCellHeight(int cellHeight) {
        if (this.jList == null) {
            return;
        }
        if (cellHeight > 0) {
            this.jList.setFixedCellHeight(cellHeight);
        } else {
            this.jList.setFixedCellHeight(this.fixedCellHeight);
        }
    }

    private void fireModelChanged() {
        this.getModel().load();
        this.jList.setModel(new ListModelImpl());
    }

    protected String getItemText(Object item) {
        return item == null ? null : item.toString();
    }

    @Override
    public void requestFocus() {
        this.jList.requestFocus();
    }

    public void removeHandler(Handler handler) {
        if (handler != null) {
            this.handlers.remove(handler);
        }
    }

    public void addHandler(Handler handler) {
        if (handler == null) {
            return;
        }
        if (!this.handlers.contains(handler)) {
            this.handlers.add(handler);
        }
    }

    private void notifyOnSelect(ListItem li) {
        Object item;
        Object object = item = li == null ? null : li.getItem();
        if (item == null) {
            return;
        }
        for (Handler handler : this.handlers) {
            handler.onselect(item);
        }
    }

    private class CustomLayout
    implements LayoutManager {
        ListPane root;

        private CustomLayout() {
            this.root = ListPane.this;
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return this.getLayoutSize(parent);
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return this.getLayoutSize(parent);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Dimension getLayoutSize(Container parent) {
            Object object = parent.getTreeLock();
            synchronized (object) {
                Dimension dim = ListPane.this.jList.getPreferredSize();
                Insets margin = parent.getInsets();
                int w = dim.width + margin.left + margin.right;
                int h = dim.height + margin.top + margin.bottom;
                return new Dimension(w, h);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void layoutContainer(Container parent) {
            Object object = parent.getTreeLock();
            synchronized (object) {
                Insets margin = parent.getInsets();
                int pw = parent.getWidth();
                int ph = parent.getHeight();
                int x = margin.left;
                int y = margin.top;
                int w = pw - (margin.left + margin.right);
                int h = ph - (margin.top + margin.bottom);
                ListPane.this.jList.setBounds(x, y, w, h);
            }
        }
    }

    private class ListModelImpl
    extends AbstractListModel {
        ListPane root;

        private ListModelImpl() {
            this.root = ListPane.this;
        }

        private List<ListItem> getListItems() {
            if (this.root.model == null) {
                return null;
            }
            return this.root.model.getListItems();
        }

        @Override
        public int getSize() {
            List<ListItem> items = this.getListItems();
            return Math.max(items == null ? 0 : items.size() - 1, 0);
        }

        @Override
        public Object getElementAt(int index) {
            List<ListItem> items = this.getListItems();
            if (items == null) {
                return null;
            }
            if (index >= 0 && index < items.size()) {
                return this.root.model.getListItemData(index);
            }
            return null;
        }
    }

    private class OnselectNotifier
    implements Runnable {
        ListPane root;
        private ListItem item;

        OnselectNotifier(ListItem item) {
            this.root = ListPane.this;
            this.item = item;
        }

        @Override
        public void run() {
            if (this.item == null) {
                return;
            }
            this.root.notifyOnSelect(this.item);
        }
    }

    public static interface Handler {
        public void onselect(Object var1);
    }

    private class TableKeyAdapter
    extends KeyAdapter {
        ListPane root;

        private TableKeyAdapter() {
            this.root = ListPane.this;
        }

        private void scroll() {
            JListImpl jList = this.root.jList;
            try {
                int selIndex = jList.getSelectedIndex();
                Rectangle rect = jList.getCellBounds(selIndex, selIndex);
                jList.scrollRectToVisible(rect);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (this.root.model == null) {
                return;
            }
            int index = this.root.jList.getSelectedIndex();
            if (index < 0) {
                return;
            }
            switch (e.getKeyCode()) {
                case 10: {
                    ListPane.this.notifyOnSelect(ListPane.this.model.getListItem(index));
                }
            }
        }
    }

    private class TableModelHandlerImpl
    implements TableModelHandler {
        ListPane root;

        private TableModelHandlerImpl() {
            this.root = ListPane.this;
        }

        @Override
        public void fireTableCellUpdated(int row, int column) {
        }

        @Override
        public void fireTableRowsDeleted(int firstRow, int lastRow) {
        }

        @Override
        public void fireTableRowsInserted(int firstRow, int lastRow) {
        }

        @Override
        public void fireTableRowsUpdated(int firstRow, int lastRow) {
        }

        @Override
        public void fireTableDataProviderChanged() {
        }

        @Override
        public void fireTableStructureChanged() {
            this.root.jList.repaint();
        }

        @Override
        public void fireTableDataChanged() {
            this.root.jList.repaint();
        }

        @Override
        public void fireTableRowSelected(int row, boolean focusOnItemDataOnly) {
        }
    }

    private class PropertyChangeHandlerImpl
    implements PropertyChangeHandler {
        ListPane root;

        private PropertyChangeHandlerImpl() {
            this.root = ListPane.this;
        }

        @Override
        public void firePropertyChange(String name, int value) {
        }

        @Override
        public void firePropertyChange(String name, boolean value) {
        }

        @Override
        public void firePropertyChange(String name, String value) {
        }

        @Override
        public void firePropertyChange(String name, Object value) {
            if ("selectedItemChanged".equals(name)) {
                ListItem li = this.root.model.getSelectedItem();
                if (li == null) {
                    return;
                }
                int index = li.getIndex();
                this.root.jList.setSelectedIndex(index);
                this.root.jList.ensureIndexIsVisible(index);
            }
        }
    }

    private class ListMouseHandler
    implements MouseWheelListener,
    MouseListener {
        ListPane root;

        private ListMouseHandler() {
            this.root = ListPane.this;
        }

        private void scroll() {
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent e) {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (this.root.model == null) {
                return;
            }
            if (!SwingUtilities.isLeftMouseButton(e)) {
                return;
            }
            if (e.getClickCount() == 2) {
                return;
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (this.root.model == null) {
                return;
            }
            if (!SwingUtilities.isLeftMouseButton(e)) {
                return;
            }
            int index = this.root.jList.getSelectedIndex();
            if (index < 0) {
                return;
            }
            this.root.model.setSelectedItem(index);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (this.root.model == null) {
                return;
            }
            if (!SwingUtilities.isLeftMouseButton(e)) {
                return;
            }
            if (e.getClickCount() == 2) {
                return;
            }
            int index = this.root.jList.getSelectedIndex();
            ListItem li = this.root.model.getListItem(index);
            EventQueue.invokeLater(new OnselectNotifier(li));
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }
    }

    private class CellRendererImpl
    implements ListCellRenderer {
        ListPane root;
        private JLabel label;
        private JLabel emptyLabel;

        CellRendererImpl() {
            this.root = ListPane.this;
            this.emptyLabel = new JLabel();
            this.label = new JLabel();
            this.label.setOpaque(true);
            this.label.setVerticalAlignment(1);
            Border bin = BorderFactory.createEmptyBorder(3, 5, 3, 5);
            XLineBorder bout = new XLineBorder();
            bout.setHideLeft(true);
            bout.setHideRight(true);
            bout.setHideTop(true);
            bout.setLineColor(SystemColor.controlShadow);
            this.label.setBorder(BorderFactory.createCompoundBorder(bout, bin));
        }

        public Component getListCellRendererComponent(JList jlist, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value == null) {
                return this.emptyLabel;
            }
            if (isSelected) {
                this.label.setOpaque(true);
                this.label.setBackground(jlist.getSelectionBackground());
                this.label.setForeground(jlist.getSelectionForeground());
            } else {
                this.label.setOpaque(false);
                this.label.setForeground(jlist.getForeground());
            }
            String text = this.root.getItemText(value);
            this.label.setText(text == null ? " " : "<html>" + text + "</html>");
            return this.label;
        }
    }

    private class ScrollListModelImpl
    extends ScrollListModel {
        ListPane root;

        private ScrollListModelImpl() {
            this.root = ListPane.this;
        }

        @Override
        public List fetchList(Map params) {
            AbstractListDataProvider model = this.root.getModel();
            if (model == null) {
                return null;
            }
            return model.fetchList(params);
        }
    }

    private class ScrollBarPanel
    extends JPanel {
        ListPane root;
        private Rectangle oldBounds;

        ScrollBarPanel(ListScrollBar scrollBar) {
            this.root = ListPane.this;
            this.oldBounds = new Rectangle();
            Dimension ps = scrollBar.getPreferredSize();
            this.setPreferredSize(ps);
            this.setLayout(new BorderLayout());
            scrollBar.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    String propName = evt.getPropertyName();
                    if ("visible".equals(propName)) {
                        Boolean visible = (Boolean)evt.getNewValue();
                        ScrollBarPanel.this.setVisible(visible);
                    }
                }
            });
            this.setVisible(scrollBar.isVisible());
            this.add((Component)scrollBar, "Center");
        }
    }

    private class ViewportImpl
    extends JViewport {
        ListPane root;
        private Color defaultBgcolor;
        private Color bgcolor;
        private Rectangle oldBounds;

        ViewportImpl(Component view) {
            this.root = ListPane.this;
            this.defaultBgcolor = SystemColor.control;
            this.bgcolor = Color.WHITE;
            this.oldBounds = new Rectangle();
            super.setBackground(this.bgcolor);
            super.setOpaque(true);
            super.setView(view);
        }

        @Override
        public void setBackground(Color bg) {
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            Color newColor = ColorUtil.brighter(this.defaultBgcolor.darker(), 20);
            Graphics2D g2 = (Graphics2D)g.create();
            g2.setColor(newColor);
            g2.drawLine(0, 0, 0, this.getHeight());
            g2.dispose();
        }
    }

    private class JListImpl
    extends JList {
        ListPane root;

        JListImpl() {
            this.root = ListPane.this;
        }

        @Override
        public void setSelectedIndex(int index) {
            super.setSelectedIndex(index);
        }

        @Override
        protected void fireSelectionValueChanged(int firstIndex, int lastIndex, boolean isAdjusting) {
            super.fireSelectionValueChanged(firstIndex, lastIndex, isAdjusting);
        }

        @Override
        public void addSelectionInterval(int anchor, int lead) {
            super.addSelectionInterval(anchor, lead);
        }
    }
}

