/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.LayoutManager2;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.Beans;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JPanel;

public class CheckListPanel
extends JPanel {
    private int itemGap;
    private int itemCount;
    private int orientation;
    private Insets padding;
    private String selectionMode;
    private ButtonGroup buttonGroup;
    private CheckButton selectedButton;

    public CheckListPanel() {
        this.initComponent();
    }

    private void initComponent() {
        this.itemGap = 5;
        this.itemCount = 2;
        this.orientation = 0;
        this.selectionMode = "SINGLE";
        super.setLayout(new ContainerLayout());
        this.setOpaque(false);
        this.buttonGroup = new ButtonGroup();
        if (Beans.isDesignTime()) {
            this.addItem("Option 1", "Option 1");
            this.addItem("Option 2", "Option 2");
        }
    }

    @Override
    public void setLayout(LayoutManager mgr) {
    }

    public String getSelectionMode() {
        return this.selectionMode;
    }

    public void setSelectionMode(String selectionMode) {
        this.selectionMode = selectionMode;
    }

    public int getItemGap() {
        return this.itemGap;
    }

    public void setItemGap(int itemGap) {
        this.itemGap = itemGap;
    }

    public int getItemCount() {
        return this.itemCount;
    }

    public void setItemCount(int itemCount) {
        this.itemCount = itemCount;
        if (Beans.isDesignTime()) {
            this.removeAll();
            for (int i = 0; i < itemCount; ++i) {
                this.addItem("Option " + (i + 1), "Option " + (i + 1));
            }
        }
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setOrientation(int orientation) {
        this.orientation = orientation;
    }

    public Insets getPadding() {
        return this.padding;
    }

    public void setPadding(Insets padding) {
        this.padding = padding;
    }

    public List getUserObjects() {
        ArrayList<Object> list = new ArrayList<Object>();
        Component[] comps = this.getComponents();
        for (int i = 0; i < comps.length; ++i) {
            if (!(comps[i] instanceof CheckButton)) continue;
            CheckButton rc = (CheckButton)comps[i];
            list.add(rc.getUserObject());
        }
        return list;
    }

    public void setSelectedIndex(int index) {
        this.setSelectedIndex(index, true, true);
    }

    public void setSelectedIndex(int index, boolean allowClearSelection, boolean allowRepaint) {
        if (allowClearSelection) {
            this.clearSelection();
        }
        CheckButton rc = null;
        try {
            rc = (CheckButton)this.getComponent(index);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (rc != null) {
            rc.setSelected(true);
        }
        if (allowRepaint) {
            this.revalidate();
            this.repaint();
        }
    }

    private Insets getPreferredPadding() {
        Insets pads = this.getPadding();
        return pads == null ? new Insets(0, 0, 0, 0) : pads;
    }

    private int getPreferredCellPadding() {
        return Math.max(this.getItemGap(), 0);
    }

    public void addItem(String caption, Object userObject) {
        this.addItem(new ItemImpl(caption, userObject));
    }

    public void addItem(Item item) {
        if (item == null) {
            return;
        }
        this.add(new CheckButton(item));
    }

    @Override
    protected void addImpl(Component comp, Object constraints, int index) {
        if (comp instanceof CheckButton) {
            super.addImpl(comp, constraints, index);
        }
    }

    public void clearSelection() {
        this.buttonGroup.clearSelection();
        this.selectedButton = null;
    }

    public Item getSelectedItem() {
        return this.selectedButton == null ? null : this.selectedButton.getItem();
    }

    protected void onselect(Object obj) {
    }

    @Override
    public void repaint(long tm, int x, int y, int width, int height) {
        this.enableComponents(this.isEnabled());
        super.repaint(tm, x, y, width, height);
    }

    public void enableComponents(boolean enabled) {
        Component[] comps = this.getComponents();
        for (int i = 0; i < comps.length; ++i) {
            if (!(comps[i] instanceof CheckButton)) continue;
            comps[i].setEnabled(enabled);
            comps[i].repaint();
        }
    }

    @Override
    public boolean requestFocusInWindow() {
        if (!this.isEnabled()) {
            return false;
        }
        Component[] comps = this.getComponents();
        for (int i = 0; i < comps.length; ++i) {
            CheckButton btn;
            if (!(comps[i] instanceof CheckButton) || !(btn = (CheckButton)comps[i]).isEnabled() || !btn.isFocusable()) continue;
            return btn.requestFocusInWindow();
        }
        return false;
    }

    public final boolean isSingleSelection() {
        return "SINGLE".equals(this.getSelectionMode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object getSelectedValue() {
        ArrayList<Object> results = new ArrayList<Object>();
        Component[] comps = this.getComponents();
        for (int i = 0; i < comps.length; ++i) {
            CheckButton btn;
            if (!(comps[i] instanceof CheckButton) || !(btn = (CheckButton)comps[i]).isSelected()) continue;
            results.add(btn.getUserObject());
        }
        if (results.isEmpty()) {
            return null;
        }
        try {
            if (this.isSingleSelection()) {
                Object e = results.get(0);
                return e;
            }
            Object[] objectArray = results.toArray();
            return objectArray;
        }
        finally {
            results.clear();
        }
    }

    private class CellInfo {
        int index;
        int width;
        int height;

        private CellInfo() {
        }
    }

    private class ContainerLayout
    implements LayoutManager,
    LayoutManager2 {
        CheckListPanel root;

        private ContainerLayout() {
            this.root = CheckListPanel.this;
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        private List<CheckButton> getItems(Container parent) {
            ArrayList<CheckButton> items = new ArrayList<CheckButton>();
            Component[] comps = parent.getComponents();
            for (int i = 0; i < comps.length; ++i) {
                CheckButton c;
                if (!(comps[i] instanceof CheckButton) || !(c = (CheckButton)comps[i]).isVisible()) continue;
                items.add(c);
            }
            return items;
        }

        private Dimension getLayoutSizeV(Container parent, List<CheckButton> items) {
            int itemcount = items.size();
            if (itemcount > 0) {
                int rows = 0;
                int cols = 0;
                int cellpad = this.root.getPreferredCellPadding();
                int itemVisibleCount = this.root.getItemCount();
                if (itemVisibleCount <= 0) {
                    rows = itemcount;
                    cols = 1;
                } else {
                    rows = itemVisibleCount;
                    cols = itemcount / itemVisibleCount;
                    if (itemcount % itemVisibleCount > 0) {
                        ++cols;
                    }
                }
                int itemindex = 0;
                CellInfo[][] cells = new CellInfo[rows][cols];
                for (int c = 0; c < cols; ++c) {
                    for (int r = 0; r < rows && itemindex < items.size(); ++r) {
                        Dimension cdim = items.get(itemindex).getPreferredSize();
                        CellInfo ci = new CellInfo();
                        ci.index = itemindex++;
                        ci.width = cdim.width;
                        ci.height = cdim.height;
                        cells[r][c] = ci;
                    }
                }
                Dimension newdim = new Dimension(0, 0);
                for (int c = 0; c < cols; ++c) {
                    Dimension coldim = this.computeColSize(cells, c);
                    newdim.width += coldim.width;
                    newdim.height = Math.max(newdim.height, coldim.height);
                }
                if (cols > 1) {
                    newdim.width += (cols - 1) * cellpad;
                }
                if (rows > 1) {
                    newdim.height += (rows - 1) * cellpad;
                }
                return newdim;
            }
            return new Dimension(0, 0);
        }

        private Dimension getLayoutSizeH(Container parent, List<CheckButton> items) {
            int itemcount = items.size();
            if (itemcount > 0) {
                int c;
                int cellpad = this.root.getPreferredCellPadding();
                int cellcount = this.root.getItemCount();
                if (cellcount <= 0) {
                    cellcount = itemcount;
                }
                int rows = itemcount / cellcount;
                if (itemcount % cellcount > 0) {
                    ++rows;
                }
                int itemindex = 0;
                CellInfo[][] cells = new CellInfo[rows][cellcount];
                for (int r = 0; r < cells.length; ++r) {
                    for (c = 0; c < cells[r].length && itemindex < items.size(); ++c) {
                        Dimension cdim = items.get(itemindex).getPreferredSize();
                        CellInfo ci = new CellInfo();
                        ci.index = itemindex++;
                        ci.width = cdim.width;
                        ci.height = cdim.height;
                        cells[r][c] = ci;
                    }
                }
                Dimension newdim = new Dimension(0, 0);
                for (c = 0; c < cellcount; ++c) {
                    Dimension coldim = this.computeColSize(cells, c);
                    newdim.width += coldim.width;
                    newdim.height = Math.max(newdim.height, coldim.height);
                }
                if (cellcount > 1) {
                    newdim.width += (cellcount - 1) * cellpad;
                }
                if (rows > 1) {
                    newdim.height += (rows - 1) * cellpad;
                }
                return newdim;
            }
            return new Dimension(0, 0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Dimension getLayoutSize(Container parent) {
            Object object = parent.getTreeLock();
            synchronized (object) {
                Dimension newdim = new Dimension(0, 0);
                List<CheckButton> items = this.getItems(parent);
                newdim = this.root.getOrientation() == 1 ? this.getLayoutSizeV(parent, items) : this.getLayoutSizeH(parent, items);
                Insets margin = parent.getInsets();
                Insets pads = this.root.getPreferredPadding();
                newdim.width += margin.left + margin.right + pads.left + pads.right;
                newdim.height += margin.top + margin.bottom + pads.top + pads.bottom;
                return newdim;
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return this.getLayoutSize(parent);
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return this.getLayoutSize(parent);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void layoutContainer(Container parent) {
            Object object = parent.getTreeLock();
            synchronized (object) {
                List<CheckButton> items = this.getItems(parent);
                int itemcount = items.size();
                if (itemcount == 0) {
                    return;
                }
                if (this.root.getOrientation() == 1) {
                    this.layoutContainerV(parent, items);
                } else {
                    this.layoutContainerH(parent, items);
                }
            }
        }

        private void layoutContainerH(Container parent, List<CheckButton> items) {
            Insets pads = this.root.getPreferredPadding();
            Insets margin = parent.getInsets();
            int pw = parent.getWidth();
            int ph = parent.getHeight();
            int px = margin.left + pads.left;
            int py = margin.top + pads.top;
            int itemcount = items.size();
            if (itemcount > 0) {
                int cellpad = this.root.getPreferredCellPadding();
                int cellcount = this.root.getItemCount();
                if (cellcount <= 0) {
                    cellcount = itemcount;
                }
                int rows = itemcount / cellcount;
                if (itemcount % cellcount > 0) {
                    ++rows;
                }
                int itemindex = 0;
                CellInfo[][] cells = new CellInfo[rows][cellcount];
                for (int r = 0; r < cells.length; ++r) {
                    for (int c = 0; c < cellcount && itemindex < items.size(); ++c) {
                        Dimension cdim = items.get(itemindex).getPreferredSize();
                        CellInfo ci = new CellInfo();
                        ci.index = itemindex++;
                        ci.width = cdim.width;
                        ci.height = cdim.height;
                        cells[r][c] = ci;
                    }
                }
                int x = px;
                int y = py;
                for (int r = 0; r < cells.length; ++r) {
                    CellInfo ci;
                    if (r > 0) {
                        y += cellpad;
                    }
                    Dimension rowdim = this.computeRowSize(cells[r]);
                    for (int c = 0; c < cellcount && (ci = cells[r][c]) != null; ++c) {
                        if (c > 0) {
                            x += cellpad;
                        }
                        Dimension coldim = this.computeColSize(cells, c);
                        Component comp = items.get(ci.index);
                        comp.setBounds(x, y, coldim.width, rowdim.height);
                        x += coldim.width;
                    }
                    x = px;
                    y += rowdim.height;
                }
            }
        }

        private void layoutContainerV(Container parent, List<CheckButton> items) {
            Insets pads = this.root.getPreferredPadding();
            Insets margin = parent.getInsets();
            int pw = parent.getWidth();
            int ph = parent.getHeight();
            int px = margin.left + pads.left;
            int py = margin.top + pads.top;
            int itemcount = items.size();
            if (itemcount <= 0) {
                return;
            }
            int rows = 0;
            int cols = 0;
            int cellpad = this.root.getPreferredCellPadding();
            int itemVisibleCount = this.root.getItemCount();
            if (itemVisibleCount <= 0) {
                rows = itemcount;
                cols = 1;
            } else {
                rows = itemVisibleCount;
                cols = itemcount / itemVisibleCount;
                if (itemcount % itemVisibleCount > 0) {
                    ++cols;
                }
            }
            int itemindex = 0;
            CellInfo[][] cells = new CellInfo[rows][cols];
            for (int c = 0; c < cols; ++c) {
                for (int r = 0; r < rows && itemindex < items.size(); ++r) {
                    Dimension cdim = items.get(itemindex).getPreferredSize();
                    CellInfo ci = new CellInfo();
                    ci.index = itemindex++;
                    ci.width = cdim.width;
                    ci.height = cdim.height;
                    cells[r][c] = ci;
                }
            }
            int x = px;
            int y = py;
            for (int r = 0; r < rows; ++r) {
                CellInfo ci;
                if (r > 0) {
                    y += cellpad;
                }
                Dimension rowdim = this.computeRowSize(cells[r]);
                for (int c = 0; c < cols && (ci = cells[r][c]) != null; ++c) {
                    if (c > 0) {
                        x += cellpad;
                    }
                    Dimension coldim = this.computeColSize(cells, c);
                    Component comp = items.get(ci.index);
                    comp.setBounds(x, y, coldim.width, rowdim.height);
                    x += coldim.width;
                }
                x = px;
                y += rowdim.height;
            }
        }

        private Dimension computeRowSize(CellInfo[] cells) {
            CellInfo ci;
            int cellpad = this.root.getPreferredCellPadding();
            Dimension dim = new Dimension(0, 0);
            for (int i = 0; i < cells.length && (ci = cells[i]) != null; ++i) {
                dim.width = dim.width + (ci.width + (i > 0 ? cellpad : 0));
                dim.height = Math.max(dim.height, ci.height);
            }
            return dim;
        }

        private Dimension computeColSize(CellInfo[][] cells, int index) {
            int cellpad = this.root.getPreferredCellPadding();
            Dimension dim = new Dimension(0, 0);
            for (int r = 0; r < cells.length; ++r) {
                CellInfo ci;
                CellInfo[] cols = cells[r];
                if (index < 0 || index >= cols.length || (ci = cols[index]) == null) continue;
                dim.width = Math.max(dim.width, ci.width);
                dim.height = dim.height + (ci.height + (r > 0 ? cellpad : 0));
            }
            return dim;
        }

        @Override
        public void addLayoutComponent(Component comp, Object constraints) {
        }

        @Override
        public Dimension maximumLayoutSize(Container target) {
            return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
        }

        @Override
        public float getLayoutAlignmentX(Container target) {
            return 0.5f;
        }

        @Override
        public float getLayoutAlignmentY(Container target) {
            return 0.5f;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void invalidateLayout(Container target) {
            Object object = target.getTreeLock();
            synchronized (object) {
            }
        }
    }

    class CheckButton
    extends JCheckBox
    implements ActionListener {
        CheckListPanel root;
        private Item item;

        public CheckButton(Item item) {
            this.root = CheckListPanel.this;
            this.item = item;
            this.setOpaque(false);
            this.setMargin(new Insets(0, 0, 0, 0));
            this.addActionListener(this);
        }

        public Item getItem() {
            return this.item;
        }

        public Object getUserObject() {
            return this.item == null ? null : this.item.getUserObject();
        }

        @Override
        public String getText() {
            return this.item == null ? "null" : this.item.getCaption();
        }

        @Override
        public void addNotify() {
            super.addNotify();
            if (CheckListPanel.this.isSingleSelection()) {
                this.root.buttonGroup.add(this);
            }
        }

        @Override
        public void removeNotify() {
            super.removeNotify();
            if (CheckListPanel.this.isSingleSelection()) {
                this.root.buttonGroup.remove(this);
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (Beans.isDesignTime()) {
                return;
            }
            Object value = this.root.getSelectedValue();
            if (this.root.selectedButton != null && this.root.selectedButton.equals(this)) {
                this.root.selectedButton = null;
                this.root.onselect(value);
            } else {
                this.root.selectedButton = this;
                this.root.onselect(value);
            }
        }
    }

    class ItemImpl
    implements Item {
        private String caption;
        private Object userObject;

        ItemImpl(String caption, Object userObject) {
            this.caption = caption;
            this.userObject = userObject;
        }

        @Override
        public Object getUserObject() {
            return this.userObject;
        }

        @Override
        public String getCaption() {
            return this.caption;
        }
    }

    public static interface Item {
        public Object getUserObject();

        public String getCaption();
    }
}

