/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.support;

import com.rameses.rcp.constant.TextCase;
import java.beans.Beans;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class TextDocument
extends PlainDocument {
    private List<DocumentListener> listeners = new ArrayList<DocumentListener>();
    private TextCase textCase = TextCase.NONE;
    private int maxlength = -1;
    private boolean dirty;
    private Filter filter;
    private boolean _replacing_;

    public void remove(DocumentListener listener) {
        if (listener != null) {
            this.listeners.remove(listener);
        }
    }

    public void add(DocumentListener listener) {
        if (listener != null && !this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public TextCase getTextCase() {
        return this.textCase;
    }

    public void setTextCase(TextCase textCase) {
        this.textCase = textCase;
        this.update();
    }

    public int getMaxlength() {
        return this.maxlength;
    }

    public void setMaxlength(int length) {
        this.maxlength = length;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void reset() {
        this.dirty = false;
    }

    public void loadValue(Object value) {
        this.loadValue(value, false);
    }

    public void loadValue(Object value, boolean dirty) {
        try {
            super.remove(0, this.getLength());
            this.insertString(0, value == null ? "" : value.toString(), null, false);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.dirty = dirty;
    }

    @Override
    public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
        Filter ff;
        if (str != null && str.length() > 0 && (ff = this.getFilter()) != null && !ff.accept(str)) {
            return;
        }
        this.insertString(offs, str, a, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertString(int offs, String str, AttributeSet a, boolean dirty) throws BadLocationException {
        if (Beans.isDesignTime()) {
            super.insertString(offs, str, a);
            return;
        }
        if (this.maxlength > 0) {
            if (this.getLength() >= this.maxlength) {
                return;
            }
            if (this.getLength() + str.length() > this.maxlength) {
                str = str.substring(0, this.maxlength - this.getLength());
            }
        }
        String newstr = null;
        try {
            newstr = this.parse(str);
        }
        catch (Throwable throwable) {
        }
        finally {
            newstr = str;
        }
        if (this.textCase != null) {
            newstr = this.textCase.convert(newstr);
        }
        super.insertString(offs, newstr, a);
        this.dirty = dirty;
        if (dirty) {
            this.fireOnupdate();
        }
    }

    @Override
    public void remove(int offs, int len) throws BadLocationException {
        super.remove(offs, len);
        this.dirty = true;
        this.fireOnupdate();
    }

    private void update() {
        try {
            String text = this.getText(0, this.getLength());
            super.remove(0, this.getLength());
            this.insertString(0, text, null);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void fireOnupdate() {
        for (DocumentListener listener : this.listeners) {
            listener.onupdate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String parse(String text) {
        StringBuffer sb = new StringBuffer();
        if (text == null) {
            return sb.toString();
        }
        int start = 0;
        while (true) {
            int idx0;
            if ((idx0 = text.indexOf("\\u", start)) < 0) {
                idx0 = text.indexOf("\\U", start);
            }
            if (idx0 < 0) {
                if (start >= text.length()) return sb.toString();
                break;
            }
            sb.append(text.substring(start, idx0));
            try {
                try {
                    String str = text.substring(idx0 + 2, idx0 + 6);
                    int num = Integer.parseInt(str, 16);
                    sb.append((char)num);
                    start = idx0 + 6;
                }
                catch (IndexOutOfBoundsException iobe) {
                    sb.append(text.substring(idx0));
                    start = idx0 + 6;
                }
                catch (NumberFormatException nfe) {
                    sb.append(text.substring(idx0));
                    start = idx0 + 6;
                }
                catch (Throwable t) {
                    sb.append(text.substring(idx0, idx0 + 6));
                    start = idx0 + 6;
                }
            }
            catch (Throwable throwable) {
                start = idx0 + 6;
                throw throwable;
            }
        }
        sb.append(text.substring(start));
        return sb.toString();
    }

    public Filter getFilter() {
        return this.filter;
    }

    public void setFilter(Filter filter) {
        this.filter = filter;
    }

    public static class DecimalFilter
    implements Filter {
        @Override
        public boolean accept(String value) {
            try {
                new BigDecimal(value);
                return true;
            }
            catch (Throwable t) {
                return false;
            }
        }
    }

    public static class NumberFilter
    implements Filter {
        @Override
        public boolean accept(String value) {
            try {
                new Integer(value);
                return true;
            }
            catch (Throwable t) {
                return false;
            }
        }
    }

    public static class DefaultFilter
    implements Filter {
        @Override
        public boolean accept(String value) {
            return true;
        }
    }

    public static interface Filter {
        public boolean accept(String var1);
    }

    public static interface DocumentListener {
        public void onupdate();
    }
}

