/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.support;

import com.rameses.rcp.support.ThemeUI;
import com.rameses.util.ValueUtil;
import java.awt.Color;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JComboBox;

public class ComboBoxEditorSupport {
    private JComboBox component;
    private Color origBackground;
    private Color focusBackground;
    private FocusListener focusListener;

    public static ComboBoxEditorSupport install(JComboBox component) {
        ComboBoxEditorSupport s = new ComboBoxEditorSupport(component);
        component.putClientProperty(ComboBoxEditorSupport.class, s);
        return s;
    }

    private ComboBoxEditorSupport(JComboBox component) {
        this.component = component;
        this.focusListener = new SupportFocusListener();
        component.addFocusListener(this.focusListener);
        this.focusBackground = ThemeUI.getColor("XTextField.focusBackground");
    }

    private class SupportFocusListener
    implements FocusListener {
        private SupportFocusListener() {
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            try {
                ComboBoxEditorSupport.this.origBackground = ComboBoxEditorSupport.this.component.getBackground();
                ComboBoxEditorSupport.this.component.setBackground(ComboBoxEditorSupport.this.focusBackground);
                if (ComboBoxEditorSupport.this.component.isEditable() && ComboBoxEditorSupport.this.component.getEditor() != null) {
                    ComboBoxEditorSupport.this.component.getEditor().selectAll();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            try {
                if (!ValueUtil.isEqual((Object)ComboBoxEditorSupport.this.component.getBackground(), (Object)ComboBoxEditorSupport.this.origBackground)) {
                    ComboBoxEditorSupport.this.component.setBackground(ComboBoxEditorSupport.this.origBackground);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

