/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.support;

import java.awt.Color;
import java.util.Properties;

public final class ColorUtil {
    private static Properties COLOR_NAMES = new Properties();

    public static Color brighter(Color c, int value) {
        if (value < 0) {
            return c;
        }
        float[] hsb = Color.RGBtoHSB(c.getRed(), c.getGreen(), c.getBlue(), new float[3]);
        int h = (int)(hsb[0] * 360.0f);
        int s = (int)(hsb[1] * 100.0f);
        int b = (int)(hsb[2] * 100.0f);
        int rm = 0;
        if ((b += value) > 100) {
            rm = b - 100;
            b = 100;
        }
        if ((s -= rm) < 0) {
            s = 0;
        }
        int rgb = Color.HSBtoRGB((float)h / 360.0f, (float)s / 100.0f, (float)b / 100.0f);
        return new Color(rgb);
    }

    public static Color darker(Color c, int value) {
        if (value < 0) {
            return c;
        }
        float[] hsb = Color.RGBtoHSB(c.getRed(), c.getGreen(), c.getBlue(), new float[3]);
        int h = (int)(hsb[0] * 360.0f);
        int s = (int)(hsb[1] * 100.0f);
        int b = (int)(hsb[2] * 100.0f);
        int rm = 0;
        if ((b -= value) < 0) {
            rm = b * -1;
            b = 0;
        }
        if ((s += rm) > 100) {
            s = 100;
        }
        int rgb = Color.HSBtoRGB((float)h / 360.0f, (float)s / 100.0f, (float)b / 100.0f);
        return new Color(rgb);
    }

    public static Color decode(String text) {
        String s;
        block16: {
            if (text == null || text.trim().length() == 0) {
                return null;
            }
            s = text.trim().toLowerCase();
            if (s.startsWith("#")) {
                if (s.length() <= 1) {
                    return null;
                }
                if (s.length() == 7) {
                    return Color.decode(s);
                }
                if (s.length() == 4) {
                    return Color.decode("#" + s.substring(1) + s.substring(1));
                }
                int rem = 7 - s.substring(1).length();
                StringBuffer sb = new StringBuffer(s);
                for (int i = 0; i < rem; ++i) {
                    sb.append("0");
                }
                return Color.decode(sb.toString());
            }
            try {
                if (!s.startsWith("rgb(") || !s.endsWith(")")) break block16;
                String[] values = s.substring(s.indexOf(40) + 1, s.lastIndexOf(41)).split(",");
                int r = 0;
                int g = 0;
                int b = 0;
                try {
                    r = Integer.parseInt(values[0].trim());
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                try {
                    g = Integer.parseInt(values[1].trim());
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                try {
                    b = Integer.parseInt(values[2].trim());
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                return new Color(r, g, b);
            }
            catch (Throwable t) {
                System.out.println("[WARN] invalid rgb value: " + s);
                return null;
            }
        }
        try {
            return Color.decode(COLOR_NAMES.getProperty(s));
        }
        catch (Throwable x) {
            return null;
        }
    }

    static {
        try {
            COLOR_NAMES.load(ColorUtil.class.getResourceAsStream("color_names.properties"));
        }
        catch (Exception ex) {
            System.out.println("Unable to load 'color_names.properties' file");
        }
    }
}

