/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.impl;

import com.rameses.platform.interfaces.Notifier;
import com.rameses.rcp.common.MsgBox;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class NotifierImpl
implements Notifier {
    private Map<Object, ProxyHandler> registry = new HashMap<Object, ProxyHandler>();

    @Override
    public void add(Object key, PropertyChangeListener listener) {
        if (key == null || listener == null) {
            return;
        }
        ProxyHandler handler = this.registry.get(key);
        if (handler == null) {
            handler = new ProxyHandler();
            this.registry.put(key, handler);
        }
        handler.add(listener);
    }

    @Override
    public void remove(Object key) {
        if (key == null) {
            return;
        }
        ProxyHandler handler = this.registry.remove(key);
        if (handler != null) {
            handler.clear();
        }
    }

    @Override
    public void notify(Object key, String name, Object value) {
        if (key == null) {
            return;
        }
        ProxyHandler handler = this.registry.get(key);
        handler.notify(key, name, value);
    }

    private class ProxyHandler {
        NotifierImpl root;
        private List<PropertyChangeListener> listeners;

        ProxyHandler() {
            this.root = NotifierImpl.this;
            this.listeners = new ArrayList<PropertyChangeListener>();
        }

        void add(PropertyChangeListener listener) {
            if (listener != null && !this.listeners.contains(listener)) {
                this.listeners.add(listener);
            }
        }

        void remove(PropertyChangeListener listener) {
            if (listener != null) {
                this.listeners.remove(listener);
            }
        }

        void clear() {
            this.listeners.clear();
        }

        void notify(Object key, String name, Object value) {
            PropertyChangeEvent pce = new PropertyChangeEvent(this.root, name, null, value);
            for (PropertyChangeListener pcl : this.listeners) {
                try {
                    pcl.propertyChange(pce);
                }
                catch (Throwable t) {
                    MsgBox.err(t);
                }
            }
        }
    }
}

