/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.impl;

import com.rameses.platform.interfaces.Platform;
import com.rameses.platform.interfaces.SubWindow;
import com.rameses.rcp.common.FloatingOpener;
import com.rameses.rcp.common.MsgBox;
import com.rameses.rcp.common.Opener;
import com.rameses.rcp.common.PopupMenuOpener;
import com.rameses.rcp.common.WindowUtil;
import com.rameses.rcp.framework.ClientContext;
import com.rameses.rcp.framework.ContentLayer;
import com.rameses.rcp.framework.NavigatablePanel;
import com.rameses.rcp.framework.NavigationHandler;
import com.rameses.rcp.framework.UIController;
import com.rameses.rcp.framework.UIControllerContext;
import com.rameses.rcp.framework.UIControllerPanel;
import com.rameses.rcp.framework.WindowMenu;
import com.rameses.rcp.ui.UICommand;
import com.rameses.rcp.ui.UIControl;
import com.rameses.rcp.util.ControlSupport;
import com.rameses.util.ValueUtil;
import java.awt.Container;
import java.util.HashMap;
import java.util.Stack;
import javax.swing.JComponent;

public class NavigationHandlerImpl
implements NavigationHandler {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void navigate(NavigatablePanel panel, UIControl source, Object outcome) {
        boolean allow_render_view;
        Stack<UIControllerContext> conStack;
        Platform platform;
        block43: {
            UIControllerContext curController;
            if (panel == null) {
                return;
            }
            JComponent sourceComp = (JComponent)((Object)source);
            ClientContext ctx = ClientContext.getCurrentContext();
            platform = ctx.getPlatform();
            conStack = panel.getControllers();
            UIControllerContext uIControllerContext = curController = conStack.isEmpty() ? null : conStack.peek();
            if (ValueUtil.isEmpty((Object)outcome)) {
                boolean autorefresh = true;
                if (source instanceof UICommand) {
                    autorefresh = ((UICommand)source).isAutoRefresh();
                }
                if (!autorefresh) return;
                if (curController == null) return;
                curController.getCurrentView().refresh();
                return;
            }
            if (outcome instanceof Opener) {
                Opener opener = (Opener)outcome;
                if ((opener = ControlSupport.initOpener(opener, curController == null ? null : curController.getController())) instanceof PopupMenuOpener) {
                    source.putClientProperty(PopupMenuOpener.class, opener);
                    return;
                }
                String opTarget = opener.getTarget() + "";
                if (opTarget.matches("process|_process")) {
                    return;
                }
                if (opTarget.startsWith("_")) {
                    opTarget = opTarget.substring(1);
                }
                boolean self = !opTarget.matches("topwindow|window|popup|floating|popuppanel|popupmenu");
                String windowId = opener.getController().getId();
                if (!self && platform.isWindowExists(windowId)) {
                    platform.activateWindow(windowId);
                    return;
                }
                UIController opCon = opener.getController();
                String permission = opener.getPermission();
                String role = opener.getRole();
                String domain = opener.getDomain();
                if (!ValueUtil.isEmpty((Object)permission) && !ControlSupport.isPermitted(domain, role, permission = opCon.getName() + "." + permission)) {
                    MsgBox.err("You don't have permission to perform this transaction.");
                    return;
                }
                UIControllerContext controller = new UIControllerContext(opCon);
                if (!ValueUtil.isEmpty((Object)opener.getOutcome())) {
                    if ("_close".equals(opener.getOutcome())) {
                        if (curController == null) return;
                        curController.getCurrentView().refresh();
                        return;
                    }
                    controller.setCurrentView(opener.getOutcome());
                }
                if (self) {
                    conStack.push(controller);
                    break block43;
                } else {
                    UIControllerPanel uic = new UIControllerPanel(controller);
                    HashMap<String, Object> props = new HashMap<String, Object>();
                    if (opener.getProperties().size() > 0) {
                        props.putAll(opener.getProperties());
                    }
                    props.put("id", windowId);
                    props.put("title", controller.getTitle());
                    props.put("modal", opener.isModal());
                    uic.putClientProperty("Opener.properties", props);
                    if ("popuppanel".equals(opTarget)) {
                        ContentLayer cpl = this.findTopContentLayer(sourceComp);
                        if (cpl == null) {
                            System.out.println("Cannot preview opener popuppanel. No available ContentPane.Layer");
                            return;
                        }
                        cpl.show(uic, props);
                        return;
                    }
                    if ("popupmenu".equals(opTarget)) {
                        WindowMenu.show(sourceComp, uic);
                        return;
                    }
                    if ("popup".equals(opTarget)) {
                        uic.buildFormAttrs(props);
                        props.putAll(WindowUtil.extractWindowAttrs(props));
                        platform.showPopup(sourceComp, uic, props);
                        return;
                    }
                    if (!(opener instanceof FloatingOpener)) {
                        uic.buildFormAttrs(props);
                        props.putAll(WindowUtil.extractWindowAttrs(props));
                        platform.showWindow(sourceComp, uic, props);
                        return;
                    }
                    FloatingOpener fo = (FloatingOpener)opener;
                    JComponent owner = (JComponent)((Object)source.getBinding().find(fo.getOwner()));
                    if (!ValueUtil.isEmpty((Object)fo.getOrientation())) {
                        props.put("orientation", fo.getOrientation());
                    }
                    platform.showFloatingWindow(owner, uic, props);
                    return;
                }
            }
            String out = outcome + "";
            if (out.startsWith("_close")) {
                if (conStack.size() > 1) {
                    conStack.pop();
                    if (out.contains(":")) {
                        out = out.substring(out.indexOf(":") + 1);
                        this.navigate(panel, source, out);
                        return;
                    }
                } else {
                    String conId;
                    Object h = panel.getClientProperty(SubWindow.class);
                    if (h instanceof SubWindow) {
                        ((SubWindow)h).closeWindow();
                        conStack.pop();
                        return;
                    }
                    String string = conId = curController == null ? null : curController.getId();
                    if (conId != null) {
                        platform.closeWindow(conId);
                    }
                    if ((conId = (String)panel.getClientProperty("navigatable-panel-id")) != null) {
                        platform.closeWindow(conId);
                    }
                    conStack.pop();
                }
            } else if (out.startsWith("_exit")) {
                while (conStack.size() > 1) {
                    conStack.pop();
                }
                String conId = conStack.peek().getId();
                platform.closeWindow(conId);
            } else if (out.startsWith("_root")) {
                while (conStack.size() > 1) {
                    conStack.pop();
                }
                if (out.contains(":")) {
                    out = out.substring(out.indexOf(":") + 1);
                    this.navigate(panel, source, out);
                    return;
                }
            } else {
                if (out.startsWith("_")) {
                    out = out.substring(1);
                }
                if (curController != null) {
                    curController.setCurrentView(out);
                    curController.getCurrentView().getBinding().reinjectAnnotations();
                }
            }
        }
        boolean bl = allow_render_view = !(outcome + "").matches("_close|_exit");
        if (!conStack.isEmpty()) {
            allow_render_view = true;
        }
        JComponent jpanel = null;
        if (panel instanceof JComponent) {
            jpanel = (JComponent)((Object)panel);
            jpanel.putClientProperty("navigatable-panel-render-view", allow_render_view);
        }
        try {
            panel.renderView();
        }
        finally {
            if (jpanel != null) {
                jpanel.putClientProperty("navigatable-panel-render-view", null);
            }
        }
        if (panel.getControllers().size() > 0) return;
        String pid = (String)panel.getClientProperty("navigatable-panel-id");
        if (pid == null) return;
        platform.closeWindow(pid);
    }

    private ContentLayer findTopContentLayer(JComponent comp) {
        ContentLayer cpl = null;
        if (comp == null) {
            return cpl;
        }
        for (Container parent = comp; parent != null; parent = parent.getParent()) {
            if (!(parent instanceof ContentLayer)) continue;
            cpl = (ContentLayer)((Object)parent);
        }
        return cpl;
    }
}

