/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.impl;

import com.rameses.platform.interfaces.SubWindow;
import com.rameses.platform.interfaces.SubWindowListener;
import com.rameses.rcp.impl.MainDialog;
import com.rameses.rcp.impl.PlatformImpl;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JPanel;
import javax.swing.border.AbstractBorder;
import javax.swing.plaf.basic.BasicInternalFrameUI;

class GlassPaneImpl
extends JPanel
implements SubWindow {
    private PlatformImpl platform;
    private MainDialog mainWindow;
    private String title;
    private SubWindowListener subWindowListener;

    public GlassPaneImpl(PlatformImpl platform, MainDialog mainWindow) {
        this.platform = platform;
        this.mainWindow = mainWindow;
        this.initComponent();
    }

    private void initComponent() {
        this.setOpaque(false);
        this.setLayout(new Layout());
        this.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                e.consume();
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                e.consume();
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                e.consume();
            }
        });
        this.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
            }

            @Override
            public void mouseMoved(MouseEvent e) {
            }
        });
        this.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
                e.consume();
            }

            @Override
            public void keyReleased(KeyEvent e) {
                e.consume();
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }
        });
    }

    @Override
    protected void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Rectangle clip = g.getClipBounds();
        Composite oldComposite = g2.getComposite();
        AlphaComposite alpha = AlphaComposite.getInstance(3, 0.75f);
        g2.setComposite(alpha);
        g2.setColor(this.getBackground());
        g2.fillRect(clip.x, clip.y, clip.width, clip.height);
        g2.setComposite(oldComposite);
    }

    @Override
    public void setVisible(boolean visible) {
        this.setFocusable(visible);
        super.setVisible(visible);
        if (visible) {
            this.requestFocus();
            Component comp = this.getContent();
            if (comp != null && comp.isFocusable()) {
                comp.requestFocus();
            }
            if (comp instanceof Container) {
                Container con = (Container)comp;
                con.setFocusCycleRoot(true);
                con.transferFocusDownCycle();
            } else {
                this.setFocusCycleRoot(true);
            }
        } else {
            Component comp = this.getContent();
            if (comp instanceof Container) {
                Container con = (Container)comp;
                con.setFocusCycleRoot(false);
            }
        }
    }

    public Component getContent() {
        Component[] comps = this.getComponents();
        if (comps.length > 0) {
            return comps[0];
        }
        return null;
    }

    @Override
    protected void addImpl(Component comp, Object constraints, int index) {
        if (comp instanceof InnerWindow) {
            super.addImpl(comp, constraints, index);
        } else {
            JComponent jcomp = (JComponent)comp;
            HashMap props = (HashMap)jcomp.getClientProperty("Window.properties");
            if (props == null) {
                props = new HashMap();
            }
            Object title = props.get("title");
            Object target = props.get("target");
            JComponent iw = null;
            iw = "popup".equals(target + "") ? new InnerWindow() : new InnerPanel();
            iw.setTitle(title == null ? "" : title.toString());
            iw.setContentPane(jcomp);
            iw.setVisible(true);
            super.addImpl(iw, constraints, index);
        }
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public void setListener(SubWindowListener listener) {
        this.subWindowListener = listener;
    }

    @Override
    public void update(Map attrs) {
    }

    @Override
    public void closeWindow() {
        this.setVisible(false);
        this.removeAll();
        this.platform.windows.remove(this.getName());
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                KeyboardFocusManager kfm = KeyboardFocusManager.getCurrentKeyboardFocusManager();
                kfm.clearGlobalFocusOwner();
                GlassPaneImpl.this.mainWindow.requestFocus();
            }
        });
    }

    private class Layout
    implements LayoutManager {
        private Layout() {
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return this.getLayoutSize(parent);
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return this.getLayoutSize(parent);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Dimension getLayoutSize(Container parent) {
            Object object = parent.getTreeLock();
            synchronized (object) {
                int w = 0;
                int h = 0;
                Component comp = this.getFirstVisible(parent);
                if (comp != null) {
                    Dimension dim = comp.getPreferredSize();
                    w = dim.width;
                    h = dim.height;
                }
                Insets margin = parent.getInsets();
                return new Dimension(w += margin.left + margin.right, h += margin.top + margin.bottom);
            }
        }

        private Component getFirstVisible(Container parent) {
            Component[] comps = parent.getComponents();
            for (int i = 0; i < comps.length; ++i) {
                if (!comps[i].isVisible()) continue;
                return comps[i];
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void layoutContainer(Container parent) {
            Object object = parent.getTreeLock();
            synchronized (object) {
                Insets margin = parent.getInsets();
                int pw = parent.getWidth();
                int ph = parent.getHeight();
                int x = margin.left;
                int y = margin.top;
                int w = pw - (margin.left + margin.right);
                int h = ph - (margin.top + margin.bottom);
                Component comp = this.getFirstVisible(parent);
                if (comp != null) {
                    Dimension dim = comp.getPreferredSize();
                    if (dim.width < pw) {
                        x = (w - dim.width) / 2 + margin.left;
                    }
                    if (dim.height < ph) {
                        y = (h - dim.height) / 2 + margin.top;
                    }
                    x = Math.max(x, margin.left);
                    y = Math.max(y, margin.top);
                    comp.setBounds(x, y, dim.width, dim.height);
                }
            }
        }
    }

    private class InnerPanelLayout
    implements LayoutManager {
        private InnerPanelLayout() {
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return this.getLayoutSize(parent);
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return this.getLayoutSize(parent);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Dimension getLayoutSize(Container parent) {
            Object object = parent.getTreeLock();
            synchronized (object) {
                int w = 0;
                int h = 0;
                Component comp = this.getFirstVisible(parent);
                if (comp != null) {
                    Dimension dim = comp.getPreferredSize();
                    w = dim.width;
                    h = dim.height;
                }
                Insets margin = parent.getInsets();
                return new Dimension(w += margin.left + margin.right, h += margin.top + margin.bottom);
            }
        }

        private Component getFirstVisible(Container parent) {
            Component[] comps = parent.getComponents();
            for (int i = 0; i < comps.length; ++i) {
                if (!comps[i].isVisible()) continue;
                return comps[i];
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void layoutContainer(Container parent) {
            Object object = parent.getTreeLock();
            synchronized (object) {
                Insets margin = parent.getInsets();
                int pw = parent.getWidth();
                int ph = parent.getHeight();
                int x = margin.left;
                int y = margin.top;
                int w = pw - (margin.left + margin.right);
                int h = ph - (margin.top + margin.bottom);
                Component comp = this.getFirstVisible(parent);
                if (comp == null) {
                    return;
                }
                Dimension dim = comp.getPreferredSize();
                comp.setBounds(x, y, w, h);
            }
        }
    }

    private class InnerPanelBorder
    extends AbstractBorder {
        private InnerPanelBorder() {
        }

        @Override
        public boolean isBorderOpaque() {
            return true;
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return new Insets(2, 2, 2, 2);
        }

        @Override
        public Insets getBorderInsets(Component c, Insets insets) {
            insets.bottom = 2;
            insets.right = 2;
            insets.top = 2;
            insets.left = 2;
            return insets;
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            Color oldColor = g.getColor();
            g.setColor(this.getShadowOuterColor(c));
            g.drawRect(0, 0, w - 1, h - 1);
            g.setColor(this.getHightlightInnerColor(c));
            g.drawLine(1, 1, 1, h - 2);
            g.drawLine(1, 1, w - 2, 1);
            g.setColor(this.getShadowInnerColor(c));
            g.drawLine(w - 2, 1, w - 2, h - 2);
            g.drawLine(1, h - 2, w - 2, h - 2);
            g.setColor(oldColor);
        }

        private Color getShadowOuterColor(Component c) {
            return c.getBackground().darker().darker();
        }

        private Color getShadowInnerColor(Component c) {
            return c.getBackground().darker();
        }

        private Color getHightlightInnerColor(Component c) {
            return c.getBackground().brighter();
        }
    }

    private class InnerPanel
    extends JPanel
    implements InnerView {
        InnerPanel() {
            this.setLayout(new InnerPanelLayout());
            this.setBorder(new InnerPanelBorder());
        }

        @Override
        public void setTitle(String title) {
        }

        @Override
        public void setContentPane(Container con) {
            if (con != null) {
                this.add(con);
            }
        }

        @Override
        protected void addImpl(Component comp, Object constraints, int index) {
            this.removeAll();
            super.addImpl(comp, constraints, -1);
        }
    }

    private class InnerWindow
    extends JInternalFrame
    implements InnerView {
        InnerWindow() {
            this.setFrameIcon(this.createDefaultIcon());
            try {
                MouseMotionListener[] listeners;
                JComponent northpane = ((BasicInternalFrameUI)this.getUI()).getNorthPane();
                for (MouseMotionListener mml : listeners = northpane.getMouseMotionListeners()) {
                    northpane.removeMouseMotionListener(mml);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        private ImageIcon createDefaultIcon() {
            BufferedImage bi = new BufferedImage(1, 1, 2);
            Graphics2D g2 = bi.createGraphics();
            g2.setComposite(AlphaComposite.getInstance(1));
            g2.fillRect(0, 0, 1, 1);
            g2.dispose();
            return new ImageIcon(bi);
        }
    }

    private static interface InnerView {
        public void setTitle(String var1);

        public void setContentPane(Container var1);

        public void setVisible(boolean var1);

        public Object getClientProperty(Object var1);
    }
}

