/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.impl;

import com.rameses.platform.interfaces.ContentPane;
import com.rameses.platform.interfaces.SubWindow;
import com.rameses.platform.interfaces.SubWindowContainer;
import com.rameses.platform.interfaces.SubWindowListener;
import com.rameses.rcp.impl.PlatformTabWindow;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.rmi.server.UID;
import java.util.Hashtable;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ExtTabbedPane
extends JTabbedPane
implements SubWindowContainer {
    private Map<String, Component> tabIndex;
    private Rectangle closeIconBounds;
    private boolean closeIconHover;

    public ExtTabbedPane() {
        this.initComponent();
    }

    private void initComponent() {
        this.tabIndex = new Hashtable<String, Component>();
        this.closeIconBounds = new Rectangle(0, 0, 10, 10);
        this.setFocusable(false);
        TabSupport support = new TabSupport();
        this.addChangeListener(support);
        this.addMouseListener(support);
        this.addMouseMotionListener(support);
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Component comp = this.getSelectedComponent();
        if (comp instanceof PlatformTabWindow && !((PlatformTabWindow)comp).isCanClose()) {
            return;
        }
        int idx = this.getSelectedIndex();
        if (idx < 0) {
            return;
        }
        Rectangle rec = this.getBoundsAt(idx);
        Graphics2D g2 = (Graphics2D)g.create();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int w = this.closeIconBounds.width;
        int h = this.closeIconBounds.height;
        int x = rec.x + rec.width - w - 8;
        int y = rec.y + rec.height / 2 - h / 2;
        g2.setColor(this.closeIconHover ? Color.RED : Color.BLACK);
        g2.drawLine(x + 2, y + 2, x + w - 3, y + h - 3);
        g2.drawLine(x + w - 3, y + 2, x + 2, y + h - 3);
        this.closeIconBounds.x = x;
        this.closeIconBounds.y = y;
        g2.setColor(this.closeIconHover ? UIManager.getColor("Separator.shadow") : UIManager.getColor("control"));
        Rectangle cib = this.closeIconBounds;
        g2.drawRoundRect(cib.x, cib.y, cib.width - 1, cib.height - 1, 3, 3);
        g2.dispose();
    }

    @Override
    public void insertTab(String title, Icon icon, Component component, String tip, int index) {
        final String _title = title + "          ";
        final Icon _icon = icon;
        final Component _component = component;
        final String _tip = tip;
        final int _index = index;
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                Component old;
                String tabid = _component.getName();
                if (tabid == null) {
                    tabid = "WIN" + new UID();
                    _component.setName(tabid);
                }
                if ((old = (Component)ExtTabbedPane.this.tabIndex.get(tabid)) != null && ExtTabbedPane.this.indexOfComponent(old) >= 0) {
                    ExtTabbedPane.this.setSelectedComponent(old);
                    return;
                }
                ExtTabbedPane.super.insertTab(_title, _icon, _component, _tip, _index);
                ExtTabbedPane.this.setSelectedIndex(_index);
                ExtTabbedPane.this.tabIndex.put(tabid, _component);
            }
        });
    }

    @Override
    public void remove(Component component) {
        int idx = this.indexOfComponent(component);
        if (idx >= 0) {
            String title = this.getTitleAt(idx);
            this.tabIndex.remove(title);
            String cname = component.getName();
            if (cname != null) {
                this.tabIndex.remove(cname);
            }
        }
        super.remove(component);
    }

    public void showInfo() {
        Component comp = this.getSelectedComponent();
        if (!(comp instanceof ContentPane)) {
            return;
        }
        ContentPane cp = (ContentPane)((Object)comp);
        ContentPane.View vw = cp.getView();
        if (vw != null) {
            vw.showInfo();
        }
    }

    @Override
    public void add(SubWindow window) {
        if (!(window instanceof JComponent)) {
            throw new IllegalStateException("window parameter must be an instance of SubWindow and JComponent");
        }
        JComponent jc = (JComponent)((Object)window);
        jc.putClientProperty("SubWindow.id", window.getName());
        window.setListener(new SubWindowHandler());
        this.addTab(window.getTitle(), jc);
    }

    private class TabSupport
    implements MouseListener,
    MouseMotionListener,
    ChangeListener {
        private TabSupport() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            Component comp;
            if (ExtTabbedPane.this.closeIconBounds.contains(e.getPoint()) && (comp = ExtTabbedPane.this.getSelectedComponent()) instanceof PlatformTabWindow) {
                ((PlatformTabWindow)comp).close();
                ExtTabbedPane.this.closeIconHover = false;
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            ExtTabbedPane.this.closeIconHover = false;
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            if (ExtTabbedPane.this.closeIconBounds.contains(e.getPoint())) {
                ExtTabbedPane.this.closeIconHover = true;
            } else {
                ExtTabbedPane.this.closeIconHover = false;
            }
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            Component comp = ExtTabbedPane.this.getSelectedComponent();
            if (comp instanceof PlatformTabWindow) {
                ((PlatformTabWindow)comp).activate();
            }
        }
    }

    private class SubWindowHandler
    implements SubWindowListener {
        private SubWindowHandler() {
        }

        @Override
        public void fireUpdate(SubWindow window) {
            if (window == null) {
                return;
            }
            if (!(window instanceof Component)) {
                throw new IllegalStateException("window parameter must be an instance of SubWindow and Component");
            }
            JComponent jc = (JComponent)((Object)window);
            int index = ExtTabbedPane.this.indexOfComponent(jc);
            if (index < 0) {
                return;
            }
            ExtTabbedPane.this.setTitleAt(index, window.getTitle() + "          ");
            String newId = window.getName();
            String oldId = jc.getClientProperty("SubWindow.id") + "";
            if (oldId != null && newId != null && !oldId.equals(newId)) {
                ExtTabbedPane.this.tabIndex.remove(oldId);
                ExtTabbedPane.this.tabIndex.put(newId, jc);
            }
            jc.putClientProperty("SubWindow.id", newId);
        }
    }
}

