/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.framework;

import com.rameses.platform.interfaces.SubWindow;
import com.rameses.platform.interfaces.SubWindowListener;
import com.rameses.platform.interfaces.ViewContext;
import com.rameses.rcp.common.MenuRootElement;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;

public final class WindowMenu
extends JWindow
implements MenuRootElement,
SubWindow {
    private JPanel contentpane;
    private AWTEventHandler eventHandler;
    private String title;
    private ViewContext viewContext;
    private JComponent jview;

    public static synchronized void show(Component invoker, Component view) {
        if (view == null) {
            return;
        }
        WindowMenu wm = null;
        Component root = SwingUtilities.getRoot(invoker);
        wm = root instanceof Window ? new WindowMenu((Window)root) : new WindowMenu(null);
        wm.setView(view);
        wm.pack();
        Insets margin = Toolkit.getDefaultToolkit().getScreenInsets(wm.getGraphicsConfiguration());
        Dimension scrdim = Toolkit.getDefaultToolkit().getScreenSize();
        Rectangle scrRect = new Rectangle(0, 0, scrdim.width, scrdim.height);
        int x = 0;
        int y = 0;
        if (invoker != null) {
            Point p = invoker.getLocationOnScreen();
            Rectangle rect = invoker.getBounds();
            y = p.y + rect.height;
            x = p.x;
            Rectangle r = wm.getExtendedScreenBounds(p);
            if (r != null) {
                margin = new Insets(0, 0, 0, 0);
                scrdim = new Dimension(r.width, r.height);
                scrRect = r;
            }
        }
        Dimension windim = wm.getPreferredSize();
        int scrMaxX = scrRect.x + scrdim.width - margin.right;
        int scrMaxY = scrRect.y + scrdim.height - margin.bottom;
        int lx = x + windim.width;
        int ly = y + windim.height;
        if (lx > scrMaxX) {
            x = Math.max(x - (lx - scrMaxX), margin.left);
        }
        if (ly > scrMaxY) {
            y = Math.max(y - (ly - scrMaxY), margin.top);
        }
        x = Math.max(x, margin.left);
        wm.setLocation(x, y);
        wm.setVisible(true);
    }

    private WindowMenu(Window win) {
        super(win);
        this.initComponent();
    }

    private void initComponent() {
        this.contentpane = new JPanel();
        this.contentpane.setLayout(new BorderLayout());
        this.contentpane.setBorder(BorderFactory.createLineBorder(new Color(180, 180, 180), 1));
        this.setContentPane(this.contentpane);
        this.eventHandler = new AWTEventHandler();
        this.addWindowListener(new WindowEventHandler());
    }

    void setView(Component view) {
        this.contentpane.removeAll();
        this.contentpane.add(view, "North");
        this.viewContext = null;
        if (view instanceof ViewContext) {
            this.viewContext = (ViewContext)((Object)view);
        }
        if (view instanceof JComponent) {
            this.jview = (JComponent)view;
            this.jview.putClientProperty(SubWindow.class, this);
        }
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public void closeWindow() {
        this.dispose();
    }

    @Override
    public void setListener(SubWindowListener listener) {
    }

    @Override
    public void update(Map map) {
    }

    private Rectangle getExtendedScreenBounds(Point p) {
        GraphicsDevice[] gds;
        if (p == null) {
            return null;
        }
        Rectangle screenRect = null;
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice gdmain = ge.getDefaultScreenDevice();
        block0: for (GraphicsDevice gd : gds = ge.getScreenDevices()) {
            GraphicsConfiguration[] gcs;
            if (screenRect != null) break;
            if (gdmain.equals(gd)) continue;
            for (GraphicsConfiguration gc : gcs = gd.getConfigurations()) {
                Rectangle rect = gc.getBounds();
                if (!rect.contains(p)) continue;
                screenRect = rect;
                continue block0;
            }
        }
        return screenRect;
    }

    private class WindowEventHandler
    extends WindowAdapter {
        WindowMenu root;

        private WindowEventHandler() {
            this.root = WindowMenu.this;
        }

        @Override
        public void windowOpened(WindowEvent e) {
            try {
                if (WindowMenu.this.viewContext != null) {
                    WindowMenu.this.viewContext.display();
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            long mask = 21L;
            Toolkit.getDefaultToolkit().addAWTEventListener(this.root.eventHandler, mask);
        }

        @Override
        public void windowClosed(WindowEvent e) {
            Toolkit.getDefaultToolkit().removeAWTEventListener(this.root.eventHandler);
            try {
                if (WindowMenu.this.viewContext != null) {
                    WindowMenu.this.viewContext.close();
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            finally {
                WindowMenu.this.viewContext = null;
            }
            if (this.root.jview != null) {
                this.root.jview.putClientProperty(SubWindow.class, null);
            }
        }
    }

    private class AWTEventHandler
    implements AWTEventListener {
        WindowMenu root;

        private AWTEventHandler() {
            this.root = WindowMenu.this;
        }

        @Override
        public void eventDispatched(AWTEvent e) {
            if (e instanceof MouseEvent) {
                this.processMouseEvent((MouseEvent)e);
            } else if (e instanceof FocusEvent) {
                this.processFocusEvent((FocusEvent)e);
            } else if (e instanceof ComponentEvent) {
                this.processCompEvent((ComponentEvent)e);
            }
        }

        private void processMouseEvent(MouseEvent me) {
            WindowMenu wm;
            Object source;
            if (me.getID() == 501 && (source = me.getSource()) instanceof Component && ((wm = this.findTop((Component)source)) == null || !wm.equals(this.root))) {
                this.root.dispose();
            }
        }

        private void processFocusEvent(FocusEvent e) {
            if (e.getID() == 1005 && e.isTemporary()) {
                this.root.dispose();
            }
        }

        private void processCompEvent(ComponentEvent e) {
            if (e.getID() == 100) {
                Object source = e.getSource();
                if (source instanceof Frame) {
                    this.root.dispose();
                } else if (source instanceof Dialog) {
                    this.root.dispose();
                }
            }
        }

        private WindowMenu findTop(Component comp) {
            if (comp == null) {
                return null;
            }
            if (comp instanceof WindowMenu) {
                return (WindowMenu)comp;
            }
            return this.findTop(comp.getParent());
        }
    }
}

