/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.framework;

import com.rameses.rcp.common.CallbackHandlerProxy;
import com.rameses.rcp.framework.ClientContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ValueChangeSupport {
    private Map<String, List> handlers = new HashMap<String, List>();
    private List<Map> extendedHandlers = new ArrayList<Map>();
    private List<Handler> vhandlers = new ArrayList<Handler>();

    ValueChangeSupport() {
    }

    public void add(Handler handler) {
        if (handler != null && !this.vhandlers.contains(handler)) {
            this.vhandlers.add(handler);
        }
    }

    public void remove(Handler handler) {
        if (handler != null) {
            this.vhandlers.remove(handler);
        }
    }

    public void addExtendedHandler(Map extended) {
        if (extended != null) {
            this.extendedHandlers.add(extended);
        }
    }

    public void add(String property, Object callbackListener) {
        if (property == null || callbackListener == null) {
            return;
        }
        ArrayList<Object> list = this.handlers.get(property);
        if (list == null) {
            list = new ArrayList<Object>();
            this.handlers.put(property, list);
        }
        list.add(callbackListener);
    }

    public void remove(String property, Object callbackListener) {
        if (property == null || callbackListener == null) {
            return;
        }
        List list = this.handlers.get(property);
        if (list != null) {
            list.remove(callbackListener);
            if (list.isEmpty()) {
                this.handlers.remove(property);
            }
        }
    }

    public void removeAll() {
        for (List list : this.handlers.values()) {
            list.clear();
        }
        this.handlers.clear();
        this.extendedHandlers.clear();
    }

    public void notify(String property, Object value) {
        if (property == null) {
            return;
        }
        for (Handler vh : this.vhandlers) {
            vh.valueChange(property, value);
        }
        Set<Map.Entry<String, List>> entries = this.handlers.entrySet();
        for (Map.Entry<String, List> entry : entries) {
            List list;
            String regex = entry.getKey();
            if (!this.match(property, regex) || (list = entry.getValue()) == null) continue;
            for (Object callback : list) {
                this.invokeCallback(callback, value);
            }
        }
        if (this.extendedHandlers.isEmpty()) {
            return;
        }
        for (Map map : this.extendedHandlers) {
            if (map.isEmpty()) continue;
            Set sets = map.entrySet();
            for (Map.Entry entry : sets) {
                String regex;
                String string = regex = entry.getKey() == null ? null : entry.getKey().toString();
                if (!this.match(property, regex)) continue;
                this.invokeCallback(entry.getValue(), value);
            }
        }
    }

    private boolean match(String name, String regex) {
        if (name == null || regex == null) {
            return false;
        }
        try {
            if ("*".equals(regex)) {
                regex = ".*";
            }
            return name.matches(regex);
        }
        catch (Exception ex) {
            return false;
        }
    }

    private void invokeCallback(Object callback, Object value) {
        block3: {
            try {
                if (callback == null) {
                    return;
                }
                new CallbackHandlerProxy(callback).call(value);
            }
            catch (Exception ex) {
                System.out.println("[ValueChangeSupport_notify] failed caused by " + ex.getMessage());
                if (!ClientContext.getCurrentContext().isDebugMode()) break block3;
                ex.printStackTrace();
            }
        }
    }

    public static interface Handler {
        public void valueChange(String var1, Object var2);
    }
}

