/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.framework;

import com.rameses.common.PropertyResolver;
import com.rameses.rcp.framework.Binding;

public class UIEvent {
    private Binding binding;
    private String name;
    private Object source;
    private Object value;

    public UIEvent(Object source, Binding binding) {
        this(source, binding, null);
    }

    public UIEvent(Object source, Binding binding, String name) {
        this.source = source;
        this.binding = binding;
        this.name = name;
    }

    public UIEvent(Object source, Binding binding, String name, Object value) {
        this.source = source;
        this.binding = binding;
        this.name = name;
        this.value = value;
    }

    public Binding getBinding() {
        return this.binding;
    }

    public String getName() {
        return this.name;
    }

    public Object getSource() {
        return this.source;
    }

    public Object getValue() {
        return this.value;
    }

    public Object getBindingBean() {
        return this.binding == null ? null : this.binding.getBean();
    }

    public Object getValue(String name) {
        Object bean = this.getBindingBean();
        if (bean == null || name == null || name.length() == 0) {
            return null;
        }
        try {
            PropertyResolver resolver = PropertyResolver.getInstance();
            return resolver.getProperty(bean, name);
        }
        catch (Throwable t) {
            return null;
        }
    }

    public void setValue(String name, Object value) {
        Object bean = this.getBindingBean();
        if (bean == null || name == null || name.length() == 0) {
            return;
        }
        try {
            PropertyResolver resolver = PropertyResolver.getInstance();
            resolver.setProperty(bean, name, value);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

