/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.framework;

import com.rameses.rcp.common.StyleRule;
import com.rameses.rcp.framework.Binding;
import com.rameses.rcp.framework.ClientContext;
import com.rameses.rcp.framework.UIContentPanel;
import com.rameses.rcp.framework.UIController;
import com.rameses.rcp.framework.UIViewHandler;
import com.rameses.rcp.framework.UIViewPanel;
import com.rameses.rcp.support.StyleRuleParser;
import com.rameses.rcp.ui.annotations.StyleSheet;
import com.rameses.rcp.ui.annotations.Template;
import com.rameses.util.ValueUtil;
import java.awt.Component;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class UIControllerContext {
    private UIController controller;
    private Map<String, UIViewPanel> viewCache = new Hashtable<String, UIViewPanel>();
    private Map<String, UIController.View> viewSource = new Hashtable<String, UIController.View>();
    private UIViewPanel currentView;
    private String id;
    private String title;
    private String name;

    public UIControllerContext(UIController controller) {
        this.setController(controller);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getTitle() {
        return this.controller.getTitle();
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public UIViewPanel getDefaultView() {
        return this.getView(this.controller.getDefaultView());
    }

    public void setCurrentView(String name) {
        if (!ValueUtil.isEmpty((Object)name)) {
            this.currentView = this.getView(name);
        }
    }

    public UIViewPanel getCurrentView() {
        if (this.currentView == null) {
            this.currentView = this.getDefaultView();
        }
        return this.currentView;
    }

    public UIViewPanel getView(String name) {
        if (!this.viewCache.containsKey(name)) {
            UIController.View view = this.viewSource.get(name);
            if (view == null) {
                throw new NullPointerException("'" + name + "' page view not found");
            }
            this.viewCache.put(name, this.buildViewPanel(view));
        }
        return this.viewCache.get(name);
    }

    public UIController getController() {
        return this.controller;
    }

    public void setController(UIController controller) {
        this.controller = controller;
        if (this.id == null) {
            this.id = controller.getId();
        }
        if (this.name == null) {
            this.name = controller.getName();
        }
        if (this.title == null) {
            this.title = controller.getTitle();
        }
        this.indexViews();
    }

    private void indexViews() {
        for (UIController.View v : this.controller.getViews()) {
            this.viewSource.put(v.getName(), v);
        }
    }

    private UIViewPanel buildViewPanel(UIController.View view) {
        ClassLoader loader = ClientContext.getCurrentContext().getClassLoader();
        UIViewPanel viewPanel = null;
        try {
            JComponent panel = (JComponent)loader.loadClass(view.getTemplate()).newInstance();
            if (panel instanceof UIViewPanel) {
                throw new Exception("Template " + view.getTemplate() + " should not be an instance of UIViewPanel.");
            }
            viewPanel = new UIViewPanel();
            viewPanel.putClientProperty(UIControllerContext.class, this);
            Binding binding = viewPanel.getBinding();
            binding.setController(this.controller);
            JComponent pagePanel = this.initPagePanel(panel, binding);
            if (pagePanel != null) {
                viewPanel.add(pagePanel);
            }
            binding.init();
            binding.setBean(this.controller.getCodeBean());
            viewPanel.putClientProperty("View.name", view.getName());
            viewPanel.putClientProperty("View.template", view.getTemplate());
            if (binding.getBean() instanceof UIViewHandler) {
                ((UIViewHandler)binding.getBean()).afterInit(view.getName(), viewPanel);
            }
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
        return viewPanel;
    }

    private JComponent initPagePanel(JComponent panel, Binding binding) throws Exception {
        Class<?> pageClass = panel.getClass();
        JComponent master = null;
        if (pageClass.isAnnotationPresent(Template.class)) {
            Template t = pageClass.getAnnotation(Template.class);
            Class mClass = t.value()[0];
            master = (JPanel)mClass.newInstance();
            if (master instanceof UIViewPanel) {
                throw new Exception("Master template " + mClass.getName() + " must not extend a UIViewPanel");
            }
            JComponent smaster = this.initPagePanel(master, binding);
            JComponent targetPanel = this.findTargetPanel(master, t.target());
            if (targetPanel != null) {
                targetPanel.add(panel);
            } else if (master instanceof UIContentPanel) {
                ((UIContentPanel)((Object)master)).setContent(panel, t.target());
            } else {
                master.add(panel);
            }
            if (smaster != master) {
                if (smaster instanceof UIContentPanel) {
                    ((UIContentPanel)((Object)smaster)).setContent(master, t.target());
                } else {
                    smaster.add(master);
                }
                master = smaster;
            }
        }
        this.loadStyleRules(pageClass, binding);
        return master != null ? master : panel;
    }

    private JComponent findTargetPanel(JComponent panel, String name) {
        if (name == null || name.length() == 0) {
            return null;
        }
        for (Component comp : panel.getComponents()) {
            boolean pass;
            boolean bl = pass = comp instanceof JPanel || comp instanceof JTabbedPane;
            if (!pass) continue;
            JComponent jc = (JComponent)comp;
            if (name.equals(jc.getName() + "")) {
                return jc;
            }
            JComponent jcr = this.findTargetPanel(jc, name);
            if (jcr == null) continue;
            return jcr;
        }
        return null;
    }

    private void loadStyleRules(Class pageClass, Binding binding) {
        Object sr;
        if (!pageClass.isAnnotationPresent(StyleSheet.class)) {
            return;
        }
        ArrayList<Object> sources = new ArrayList<Object>();
        StyleSheet ss = pageClass.getAnnotation(StyleSheet.class);
        String source = ss.value();
        if (source.trim().length() > 0) {
            if (source.indexOf(",") > -1) {
                for (String s : source.split("\\s*,\\s*")) {
                    sources.add(s);
                }
            } else {
                sources.add(source);
            }
        }
        ArrayList<StyleRule> newRules = new ArrayList<StyleRule>();
        ClassLoader loader = ClientContext.getCurrentContext().getClassLoader();
        InputStream is = null;
        if (sources.size() > 0) {
            for (String string : sources) {
                is = loader.getResourceAsStream(string);
                sr = this.getStyles(is);
                if (sr.size() <= 0) continue;
                newRules.addAll((Collection<StyleRule>)sr);
            }
        } else {
            is = pageClass.getResourceAsStream(pageClass.getSimpleName() + ".style");
            List<StyleRule> sr2 = this.getStyles(is);
            if (sr2.size() > 0) {
                newRules.addAll(sr2);
            }
        }
        StyleRule[] oldRules = binding.getStyleRules();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (oldRules != null) {
            for (StyleRule s : oldRules) {
                arrayList.add(s);
            }
        }
        for (Object e : newRules) {
            arrayList.add((StyleRule)e);
        }
        sr = arrayList.toArray(new StyleRule[0]);
        binding.setStyleRules((StyleRule[])sr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<StyleRule> getStyles(InputStream is) {
        if (is != null) {
            try {
                StyleRuleParser parser = new StyleRuleParser();
                StyleRuleParser.DefaultParseHandler handler = new StyleRuleParser.DefaultParseHandler();
                parser.parse(is, handler);
                List<StyleRule> list = handler.getList();
                return list;
            }
            catch (Exception exception) {
            }
            finally {
                try {
                    is.close();
                }
                catch (Exception exception) {}
            }
        }
        return new ArrayList<StyleRule>();
    }
}

