/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.framework;

import com.rameses.rcp.common.ScheduledTask;
import com.rameses.rcp.common.Task;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class TaskManager {
    private static final Object CACHE_LOCKED = new Object();
    private Map<Object, RunProc> cache = new HashMap<Object, RunProc>();
    private ScheduledExecutorService scheduler;

    public boolean isStarted() {
        return this.scheduler != null;
    }

    public void start() {
        if (this.scheduler == null) {
            this.scheduler = Executors.newScheduledThreadPool(100);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = CACHE_LOCKED;
        synchronized (object) {
            try {
                this.scheduler.shutdown();
            }
            catch (Throwable throwable) {
            }
            finally {
                this.scheduler = null;
            }
            Object[] values = this.cache.values().toArray();
            if (values == null) {
                values = new Object[]{};
            }
            for (Object o : values) {
                RunProc proc = (RunProc)o;
                try {
                    proc.cancel();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            this.cache.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTask(Runnable o) {
        Object object = CACHE_LOCKED;
        synchronized (object) {
            if (o == null) {
                return;
            }
            RunProc proc = new RunProc(o);
            proc.future = this.scheduler.schedule(proc, 100L, TimeUnit.MILLISECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTask(Callable o) {
        Object object = CACHE_LOCKED;
        synchronized (object) {
            if (o == null) {
                return;
            }
            CallProc proc = new CallProc(o);
            proc.future = this.scheduler.schedule(proc, 100L, TimeUnit.MILLISECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTask(Task task) {
        Object object = CACHE_LOCKED;
        synchronized (object) {
            if (task == null) {
                return;
            }
            long delay = 0L;
            long interval = 0L;
            TaskProc proc = new TaskProc(task);
            if (task instanceof ScheduledTask) {
                ScheduledTask st = (ScheduledTask)task;
                interval = st.getInterval();
                long l = delay = st.isImmediate() ? 0L : interval;
            }
            if (interval > 0L) {
                delay = delay > 0L ? delay : 100L;
                interval = interval > 0L ? interval : 100L;
                proc.future = this.scheduler.scheduleAtFixedRate(proc, delay, interval, TimeUnit.MILLISECONDS);
                this.cache.put(task, proc);
            } else {
                proc.future = this.scheduler.schedule(proc, 100L, TimeUnit.MILLISECONDS);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTask(Object task) {
        Object object = CACHE_LOCKED;
        synchronized (object) {
            if (task == null) {
                return;
            }
            RunProc proc = this.cache.remove(task);
            if (proc != null) {
                proc.cancel();
            }
        }
    }

    private class TaskProc
    extends RunProc {
        private Task task;
        private Future future;

        TaskProc(Task task) {
            this.task = task;
        }

        @Override
        public void cancel() {
            super.cancel();
            if (this.task != null) {
                try {
                    this.task.setCancelled(this.isCancelled());
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }

        @Override
        public void run() {
            block12: {
                try {
                    if (this.task.isCancelled()) {
                        try {
                            this.future.cancel(true);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        this.task = null;
                        this.remove();
                        break block12;
                    }
                    if (this.isCancelled()) {
                        try {
                            this.future.cancel(true);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        try {
                            this.task.setCancelled(true);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        this.task = null;
                        this.remove();
                        break block12;
                    }
                    this.task.start();
                    if (this.task.accept()) {
                        this.task.execute();
                    }
                    if (this.task.isEnded()) {
                        this.task.end();
                    }
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        }
    }

    private class CallProc
    extends RunProc {
        private Callable task;

        CallProc(Callable task) {
            this.task = task;
        }

        @Override
        public void run() {
            try {
                if (this.task != null && !this.isCancelled()) {
                    this.task.call();
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            finally {
                this.remove();
            }
        }
    }

    private class RunProc
    implements Runnable {
        TaskManager root;
        Future future;
        private Runnable task;
        private boolean cancelled;

        RunProc() {
            this.root = TaskManager.this;
        }

        RunProc(Runnable task) {
            this.root = TaskManager.this;
            this.task = task;
        }

        public boolean isCancelled() {
            return this.cancelled;
        }

        public void cancel() {
            this.cancelled = true;
        }

        @Override
        public void run() {
            try {
                if (this.task != null && !this.isCancelled()) {
                    this.task.run();
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            finally {
                this.remove();
            }
        }

        void remove() {
            try {
                this.root.removeTask(this.task);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

