/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.framework;

import com.rameses.rcp.framework.ClientContext;
import com.rameses.rcp.framework.EmptyNotificationProvider;
import com.rameses.rcp.framework.NotificationHandler;
import com.rameses.rcp.framework.NotificationProvider;
import com.rameses.rcp.framework.NotificationRenderer;
import com.rameses.util.Service;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public final class NotificationManager {
    private static final ExecutorService THREAD_POOL = Executors.newFixedThreadPool(100);
    private static final NotificationManager instance = new NotificationManager();
    private static final Object HANDLER_LOCKED = new Object();
    private static final Object RENDERER_LOCKED = new Object();
    private final List<NotificationProvider> providers = new ArrayList<NotificationProvider>();
    private final List<NotificationRenderer> renderers = new ArrayList<NotificationRenderer>();
    private final List<NotificationHandler> handlers = new ArrayList<NotificationHandler>();
    private NotificationProvider emptyProvider;
    private boolean allow_fetch_providers = true;

    static synchronized void reset() {
        try {
            instance.resetImpl();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public static NotificationProvider getDefaultProvider() {
        try {
            return instance.getProviders().get(0);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return instance.getEmptyProvider();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addHandler(NotificationHandler handler) {
        Object object = HANDLER_LOCKED;
        synchronized (object) {
            if (handler == null) {
                return;
            }
            NotificationManager.instance.handlers.remove(handler);
            NotificationManager.instance.handlers.add(handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeHandler(NotificationHandler handler) {
        Object object = HANDLER_LOCKED;
        synchronized (object) {
            if (handler != null) {
                NotificationManager.instance.handlers.remove(handler);
            }
        }
    }

    public static List<NotificationHandler> getHandlers() {
        return NotificationManager.instance.handlers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addRenderer(NotificationRenderer renderer) {
        Object object = RENDERER_LOCKED;
        synchronized (object) {
            if (renderer == null) {
                return;
            }
            NotificationManager.instance.renderers.remove(renderer);
            NotificationManager.instance.renderers.add(renderer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeHandler(NotificationRenderer renderer) {
        Object object = RENDERER_LOCKED;
        synchronized (object) {
            if (renderer != null) {
                NotificationManager.instance.renderers.remove(renderer);
            }
        }
    }

    public static void updateRenderers() {
        for (int i = 0; i < NotificationManager.instance.renderers.size(); ++i) {
            try {
                THREAD_POOL.submit(new RendererRefreshProc(NotificationManager.instance.renderers.get(i)));
                continue;
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
    }

    private void resetImpl() {
        this.allow_fetch_providers = true;
        this.renderers.clear();
        this.handlers.clear();
    }

    private synchronized List<NotificationProvider> getProviders() {
        if (this.allow_fetch_providers) {
            Iterator itr = Service.providers(NotificationProvider.class, (ClassLoader)ClientContext.getCurrentContext().getClassLoader());
            this.allow_fetch_providers = false;
            this.providers.clear();
            while (itr.hasNext()) {
                Object o = itr.next();
                if (!(o instanceof NotificationProvider)) continue;
                this.providers.add((NotificationProvider)o);
            }
        }
        return this.providers;
    }

    private NotificationProvider getEmptyProvider() {
        if (this.emptyProvider == null) {
            this.emptyProvider = new EmptyNotificationProvider();
        }
        return this.emptyProvider;
    }

    private static class RendererRefreshProc
    implements Runnable {
        private NotificationRenderer handler;

        RendererRefreshProc(NotificationRenderer handler) {
            this.handler = handler;
        }

        @Override
        public void run() {
            if (this.handler != null) {
                this.handler.refresh();
            }
        }
    }
}

