/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.framework;

import java.lang.reflect.Field;
import java.text.DecimalFormat;
import java.util.HashMap;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;

public final class LookAndFeelCustomizer {
    private final String SPECIAL_KEYS = "ColorChooser|InternalFrame|Menu|MenuBar|MenuItem|OptionPane|RadioButtonMenuItem|TextArea|ToolTip";

    public static void install() {
        LookAndFeelCustomizer laf = new LookAndFeelCustomizer();
        try {
            laf.install0();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        try {
            if (laf.isMac()) {
                laf.initSettingsForMac();
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private void install0() {
        int fontsize = 0;
        try {
            fontsize = Integer.parseInt(System.getProperty("fontsize"));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        double fontscale = 1.0;
        DecimalFormat numformat = new DecimalFormat("0.00");
        try {
            Integer num = Math.max(100, Integer.parseInt(System.getProperty("fontscale", "100")));
            fontscale = numformat.parse(numformat.format(((Number)num).doubleValue() / 100.0)).doubleValue();
        }
        catch (Throwable num) {
            // empty catch block
        }
        System.getProperties().put("laf.fontscale", (Object)fontscale);
        String fontname = System.getProperty("fontname", "").trim();
        if (fontname.trim().length() == 0) {
            fontname = null;
        }
        boolean debug = "true".equals(System.getProperty("laf.debug", ""));
        numformat = new DecimalFormat("0");
        UIDefaults uidefs = UIManager.getLookAndFeelDefaults();
        for (Object key : uidefs.keySet()) {
            Object val = uidefs.get(key);
            if (!(val instanceof FontUIResource)) continue;
            FontUIResource old = (FontUIResource)val;
            int fsize = old.getSize();
            if (fontsize > 0) {
                fsize = fontsize;
                String kname = key.toString().split("\\.")[0];
                if (kname.matches("ColorChooser|InternalFrame|Menu|MenuBar|MenuItem|OptionPane|RadioButtonMenuItem|TextArea|ToolTip")) {
                    ++fsize;
                }
            }
            try {
                Double num = ((Number)fsize).doubleValue() * fontscale;
                fsize = numformat.parse(numformat.format(num)).intValue();
            }
            catch (Throwable num) {
                // empty catch block
            }
            String fname = fontname == null ? old.getFontName() : fontname;
            uidefs.put(key, new FontUIResource(fname, old.getStyle(), fsize));
            if (!debug) continue;
            System.out.println(key + " = " + uidefs.get(key));
        }
    }

    private boolean isMac() {
        String osname = System.getProperty("os.name");
        if (osname == null) {
            return false;
        }
        return osname.toLowerCase().startsWith("mac");
    }

    private void initSettingsForMac() throws Exception {
        Class<?> macFontFinderClass = Class.forName("com.sun.t2k.MacFontFinder");
        Field psNameToPathMap = macFontFinderClass.getDeclaredField("psNameToPathMap");
        psNameToPathMap.setAccessible(true);
        if (psNameToPathMap.get(null) == null) {
            psNameToPathMap.set(null, new HashMap());
        }
        Field allAvailableFontFamilies = macFontFinderClass.getDeclaredField("allAvailableFontFamilies");
        allAvailableFontFamilies.setAccessible(true);
        if (allAvailableFontFamilies.get(null) == null) {
            allAvailableFontFamilies.set(null, new String[0]);
        }
    }
}

