/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.framework;

import com.rameses.rcp.annotations.Controller;
import com.rameses.rcp.framework.UIController;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.Map;

public abstract class ControllerProvider {
    private Map<Class, Field> classIndex = new Hashtable<Class, Field>();

    public UIController getController(String name, UIController caller) {
        UIController controller = this.provide(name, caller);
        Object bean = controller.getCodeBean();
        this.injectController(bean, bean.getClass(), controller);
        return controller;
    }

    protected abstract UIController provide(String var1, UIController var2);

    private void injectController(Object o, Class clazz, UIController u) {
        if (o == null) {
            return;
        }
        if (this.classIndex.containsKey(clazz)) {
            Field f = this.classIndex.get(clazz);
            if (f == null) {
                return;
            }
            boolean success = this.setValue(f, o, u);
            if (success) {
                Controller a = f.getAnnotation(Controller.class);
                this.fireOnreadyCallback(a, o);
            }
        } else {
            for (Field f : clazz.getDeclaredFields()) {
                if (!f.isAnnotationPresent(Controller.class)) continue;
                boolean success = this.setValue(f, o, u);
                if (success) {
                    Controller a = f.getAnnotation(Controller.class);
                    this.classIndex.put(clazz, f);
                    this.fireOnreadyCallback(a, o);
                }
                return;
            }
            if (clazz.getSuperclass() != null) {
                this.injectController(o, clazz.getSuperclass(), u);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean setValue(Field f, Object owner, Object value) {
        boolean accessible = f.isAccessible();
        try {
            f.setAccessible(true);
            f.set(owner, value);
            boolean bl = true;
            return bl;
        }
        catch (Throwable ex) {
            System.out.println("ERROR injecting @Controller " + ex.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            f.setAccessible(accessible);
        }
    }

    private void fireOnreadyCallback(Controller a, Object bean) {
        String onready;
        if (a == null || bean == null) {
            return;
        }
        String string = onready = a == null ? null : a.onready();
        if (onready == null || onready.length() == 0) {
            return;
        }
        Class<?> clazz = bean.getClass();
        Method method = null;
        try {
            method = clazz.getMethod(onready, new Class[0]);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            if (method == null) {
                return;
            }
            method.invoke(bean, new Object[0]);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }
}

