/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.framework;

import com.rameses.rcp.common.CallbackHandlerProxy;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class BindingValidatorSupport {
    private List<IFieldValidator> fields = new ArrayList<IFieldValidator>();
    private List<IBeanValidator> beans = new ArrayList<IBeanValidator>();

    public void addFieldValidator(Object obj) {
        if (obj == null) {
            return;
        }
        if (obj instanceof Map) {
            this.fields.add(new MapFieldValidator(obj));
        } else {
            this.fields.add(new CallableFieldValidator(obj));
        }
    }

    public void addBeanValidator(Object obj) {
        if (obj == null) {
            return;
        }
        this.beans.add(new CallableBeanValidator(obj));
    }

    public void removeValidators() {
        this.fields.clear();
        this.beans.clear();
    }

    public void fireBeanValidators(Object bean) {
        for (IBeanValidator bv : this.beans) {
            bv.validate(bean);
        }
    }

    public void fireFieldValidators(String key, Object value) {
        for (IFieldValidator fv : this.fields) {
            fv.validate(key, value);
        }
    }

    private class CallableBeanValidator
    implements IBeanValidator {
        private Object source;
        private CallbackHandlerProxy callback;

        CallableBeanValidator(Object source) {
            this.source = source;
            this.callback = new CallbackHandlerProxy(source);
        }

        @Override
        public void validate(Object bean) {
            this.callback.setHandleBreakException(false);
            this.callback.call(bean);
        }
    }

    private static interface IBeanValidator {
        public void validate(Object var1);
    }

    private class MapFieldValidator
    implements IFieldValidator {
        private Map source;

        MapFieldValidator(Object source) {
            this.source = (Map)source;
        }

        @Override
        public void validate(String name, Object value) {
            if (this.source == null) {
                return;
            }
            for (Object okey : this.source.keySet()) {
                Object oval = null;
                if (okey == null && name == null) {
                    oval = this.source.get(okey);
                } else {
                    String sfind = okey + "";
                    String sname = name + "";
                    if (sname.matches(sfind)) {
                        oval = this.source.get(okey);
                    }
                }
                if (oval == null) continue;
                CallbackHandlerProxy callback = new CallbackHandlerProxy(oval);
                callback.setHandleBreakException(false);
                callback.call(value);
            }
        }
    }

    private class CallableFieldValidator
    implements IFieldValidator {
        private Object source;
        private CallbackHandlerProxy callback;

        CallableFieldValidator(Object source) {
            this.source = source;
            this.callback = new CallbackHandlerProxy(source);
        }

        @Override
        public void validate(String key, Object value) {
            String keyobj = key;
            this.callback.setHandleBreakException(false);
            this.callback.call(new Object[]{keyobj, value});
        }
    }

    private static interface IFieldValidator {
        public void validate(String var1, Object var2);
    }
}

