/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.framework;

import com.rameses.common.ExpressionResolver;
import com.rameses.common.MethodResolver;
import com.rameses.common.PropertyResolver;
import com.rameses.platform.interfaces.SubWindow;
import com.rameses.platform.interfaces.SubWindowListener;
import com.rameses.platform.interfaces.ViewContext;
import com.rameses.rcp.annotations.Activate;
import com.rameses.rcp.annotations.BeanValidator;
import com.rameses.rcp.annotations.Close;
import com.rameses.rcp.annotations.FieldValidator;
import com.rameses.rcp.annotations.FormId;
import com.rameses.rcp.annotations.FormTitle;
import com.rameses.rcp.annotations.PropertyChangeListener;
import com.rameses.rcp.common.Opener;
import com.rameses.rcp.common.StyleRule;
import com.rameses.rcp.common.Validator;
import com.rameses.rcp.common.ValidatorEvent;
import com.rameses.rcp.common.ViewHandler;
import com.rameses.rcp.control.XButton;
import com.rameses.rcp.framework.ActionHandler;
import com.rameses.rcp.framework.BindingListener;
import com.rameses.rcp.framework.BindingValidatorSupport;
import com.rameses.rcp.framework.ChangeLog;
import com.rameses.rcp.framework.ClientContext;
import com.rameses.rcp.framework.ControlEvent;
import com.rameses.rcp.framework.DependencyInjector;
import com.rameses.rcp.framework.EventManager;
import com.rameses.rcp.framework.NavigatablePanel;
import com.rameses.rcp.framework.NavigationHandler;
import com.rameses.rcp.framework.UIController;
import com.rameses.rcp.framework.UIControllerContext;
import com.rameses.rcp.framework.UIControllerPanel;
import com.rameses.rcp.framework.UIEvent;
import com.rameses.rcp.framework.UIHandler;
import com.rameses.rcp.framework.UIViewPanel;
import com.rameses.rcp.framework.ValueChangeSupport;
import com.rameses.rcp.ui.ControlContainer;
import com.rameses.rcp.ui.NonStylable;
import com.rameses.rcp.ui.UIComposite;
import com.rameses.rcp.ui.UIControl;
import com.rameses.rcp.ui.UIFocusableContainer;
import com.rameses.rcp.ui.UIInput;
import com.rameses.rcp.ui.Validatable;
import com.rameses.rcp.util.ActionMessage;
import com.rameses.rcp.util.ControlSupport;
import com.rameses.rcp.util.UIControlUtil;
import com.rameses.rcp.util.UIInputUtil;
import com.rameses.util.BreakException;
import com.rameses.util.BusinessException;
import com.rameses.util.ValueUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.text.JTextComponent;

public class Binding {
    private static final String CHANGE_LOG_PREFIX_KEY = "CHANGE_LOG_PREFIX_KEY";
    public final Helper Utils = new Helper();
    private Object bean;
    private UIViewPanel owner;
    private UIController controller;
    private Map<String, UIControl> controlsIndex = new Hashtable<String, UIControl>();
    private Map<String, List> controlsListIndex = new Hashtable<String, List>();
    private List<UIControl> focusableControls = new ArrayList<UIControl>();
    private List<UIControl> controls = new ArrayList<UIControl>();
    private Map<String, Set<UIControl>> depends = new Hashtable<String, Set<UIControl>>();
    private List<Validatable> validatables = new ArrayList<Validatable>();
    private List<BindingListener> listeners = new ArrayList<BindingListener>();
    private ChangeLog changeLog = new ChangeLog();
    private XButton defaultButton;
    private StyleRule[] styleRules;
    private List<UIControl> _depends = new ArrayList<UIControl>();
    private boolean _initialized = false;
    private KeyListener changeLogKeySupport = new ChangeLogKeySupport();
    private boolean annotationScanIsDone;
    private Field bindingField;
    private Field changeLogField;
    private String closeMethod;
    private String activateMethod;
    private List<Validator> validators = new ArrayList<Validator>();
    private Map properties = new HashMap();
    private EventManager eventManager = new EventManager();
    private ViewContext viewContext;
    private String focusComponentName;
    private ActionHandlerSupport actionSupport;
    private ControlEventSupport support = new ControlEventSupport();
    private DependencyInjector injector;
    private List<ViewHandler> viewHandlers = new ArrayList<ViewHandler>();
    private ValueChangeSupport valueChangeSupport;
    private BindingValidatorSupport validatorSupport;

    public Binding() {
        this(null);
    }

    public Binding(UIViewPanel owner) {
        this.setOwner(owner);
    }

    public UIViewPanel getOwner() {
        return this.owner;
    }

    public void setOwner(UIViewPanel owner) {
        this.owner = owner;
    }

    public void addValidator(Validator validator) {
        if (this.validators.contains(validator)) {
            this.validators.add(validator);
        }
    }

    public boolean removeValidator(Validator validator) {
        return this.validators.remove(validator);
    }

    public EventManager getEventManager() {
        return this.eventManager;
    }

    public ActionHandlerSupport getActionHandlerSupport() {
        if (this.actionSupport == null) {
            this.actionSupport = new ActionHandlerSupport();
        }
        return this.actionSupport;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.controlsIndex != null) {
            this.controlsIndex.clear();
        }
        if (this.controlsListIndex != null) {
            this.controlsListIndex.clear();
        }
        if (this._depends != null) {
            this._depends.clear();
        }
        if (this.depends != null) {
            this.depends.clear();
        }
        if (this.focusableControls != null) {
            this.focusableControls.clear();
        }
        if (this.listeners != null) {
            this.listeners.clear();
        }
        if (this.viewHandlers != null) {
            this.viewHandlers.clear();
        }
    }

    public void register(UIControl control) {
        XButton btn;
        Validatable vd;
        this.controls.add(control);
        if (control.getDepends() != null) {
            this._depends.add(control);
        }
        if ((vd = (Validatable)control.getClientProperty(Validatable.class)) != null) {
            this.validatables.add(vd);
        } else if (control instanceof Validatable) {
            this.validatables.add((Validatable)((Object)control));
        }
        if (control instanceof XButton && this.defaultButton == null && (btn = (XButton)control).isDefaultCommand()) {
            this.defaultButton = btn;
        }
        if (!ValueUtil.isEmpty((Object)control.getName())) {
            String cname = control.getName();
            if (this.controlsIndex.containsKey(cname)) {
                ArrayList<UIControl> list = this.controlsListIndex.get(cname);
                if (list == null) {
                    list = new ArrayList<UIControl>();
                    list.add(this.controlsIndex.get(cname));
                    this.controlsListIndex.put(cname, list);
                }
                list.add(control);
            }
            this.controlsIndex.put(cname, control);
        }
        if (control instanceof Component) {
            Component c = (Component)((Object)control);
            c.addMouseListener(this.support);
            c.addKeyListener(this.support);
        }
    }

    public void unregister(UIControl control) {
        this.controls.remove(control);
        if (control instanceof Validatable) {
            this.validatables.remove((Validatable)((Object)control));
        }
        if (!ValueUtil.isEmpty((Object)control.getName())) {
            String cname = control.getName();
            this.controlsIndex.remove(cname);
            if (this.controlsListIndex.containsKey(cname)) {
                List list = this.controlsListIndex.get(cname);
                list.remove(control);
                if (list.size() == 0) {
                    this.controlsListIndex.remove(cname);
                }
            }
        }
        if (control instanceof Component) {
            Component c = (Component)((Object)control);
            c.removeMouseListener(this.support);
            c.removeKeyListener(this.support);
        }
    }

    public void updateDepends(UIControl uic, String[] vals) {
        if (this.controls.contains(uic)) {
            Iterator<Set<UIControl>> itr = this.depends.values().iterator();
            while (itr.hasNext()) {
                itr.next().remove(uic);
            }
            if (vals == null) {
                return;
            }
            for (String skey : vals) {
                Set<UIControl> sets = this.depends.get(skey);
                if (sets == null) {
                    sets = new HashSet<UIControl>();
                    this.depends.put(skey, sets);
                }
                sets.add(uic);
            }
        }
    }

    public void init() {
        String cname;
        if (this._initialized) {
            return;
        }
        this._initialized = true;
        Collections.sort(this.controls);
        Collections.sort(this.validatables);
        for (UIControl u : this.controls) {
            if (u instanceof UIInput || u instanceof UIFocusableContainer) {
                this.focusableControls.add(u);
            }
            if ((cname = u.getName()) == null || cname.trim().length() == 0) continue;
            for (UIControl c : this._depends) {
                if (u == c) continue;
                for (String s : c.getDepends()) {
                    if (!cname.matches(s)) continue;
                    if (!this.depends.containsKey(cname)) {
                        this.depends.put(cname, new HashSet());
                    }
                    this.depends.get(cname).add(c);
                }
            }
        }
        for (UIControl c : this._depends) {
            cname = c.getName();
            for (String s : c.getDepends()) {
                Set<UIControl> sets;
                if (s.equals(cname)) continue;
                if (!this.depends.containsKey(s)) {
                    this.depends.put(s, new HashSet());
                }
                if ((sets = this.depends.get(s)).contains(c)) continue;
                sets.add(c);
            }
        }
    }

    public void notifyDepends(UIControl u) {
        this.notifyDepends(u, u.getName());
    }

    public void notifyDepends(UIControl u, String name) {
        this.notifyDepends(u, name, true);
    }

    public void notifyDepends(final UIControl u, final String name, boolean invokeLater) {
        Runnable process = new Runnable(){

            @Override
            public void run() {
                block2: {
                    try {
                        Binding.this.doNotifyDepends(u, name);
                    }
                    catch (Exception e) {
                        if (!ClientContext.getCurrentContext().isDebugMode()) break block2;
                        e.printStackTrace();
                    }
                }
            }
        };
        if (invokeLater) {
            EventQueue.invokeLater(process);
        } else {
            process.run();
        }
    }

    public void notifyDepends(String name) {
        if (name == null || name.length() == 0) {
            return;
        }
        HashSet refreshed = new HashSet();
        if (this.depends.containsKey(name)) {
            for (UIControl uic : this.depends.get(name)) {
                this._doRefresh(uic, refreshed);
            }
        }
        refreshed.clear();
        refreshed = null;
        UIControl selUI = null;
        for (UIControl uic : this.controls) {
            if (!name.equals(uic.getName())) continue;
            selUI = uic;
            break;
        }
        if (selUI != null) {
            for (BindingListener bl : this.listeners) {
                bl.notifyDepends(selUI, this);
            }
        }
    }

    private void doNotifyDepends(UIControl u, String name) {
        UIViewPanel jcomp;
        HashSet refreshed = new HashSet();
        if (!ValueUtil.isEmpty((Object)name) && this.depends.containsKey(name)) {
            UIControl[] arrs;
            for (UIControl uu : arrs = this.depends.get(name).toArray(new UIControl[0])) {
                if (uu == null) continue;
                this._doRefresh(uu, refreshed);
            }
        }
        refreshed.clear();
        refreshed = null;
        for (BindingListener bl : this.listeners) {
            bl.notifyDepends(u, this);
        }
        if (this.focusComponentName != null) {
            Component comp;
            UIControl c = this.controlsIndex.get(this.focusComponentName);
            if (c != null && (comp = (Component)((Object)c)).isEnabled() && comp.isFocusable()) {
                comp.requestFocusInWindow();
            }
            this.focusComponentName = null;
        }
        if ((jcomp = this.getOwner()) != null) {
            jcomp.revalidate();
            jcomp.repaint();
        }
    }

    public void refresh() {
        this.refresh(null);
    }

    public void refresh(String regEx) {
        this.refresh(regEx, false);
    }

    public void refresh(String regEx, boolean async) {
        if (async) {
            new AsyncRefreshWorker(regEx).run();
        } else {
            this.refreshImpl(regEx);
        }
    }

    private void refreshImpl(String regEx) {
        HashSet refreshed = new HashSet();
        int len = this.controls.size();
        for (int i = 0; i < len; ++i) {
            UIControl uu = this.getUIControl(i);
            if (uu == null) continue;
            String name = uu.getName();
            if (regEx != null && name != null && !name.matches(regEx)) continue;
            this._doRefresh(uu, refreshed);
        }
        refreshed.clear();
        refreshed = null;
        for (BindingListener bl : this.listeners) {
            bl.refresh(regEx);
        }
        if (this.viewContext instanceof UIControllerPanel) {
            ((UIControllerPanel)this.viewContext).attachDefaultButton();
        }
        if (this.focusComponentName != null) {
            UIControl c = this.controlsIndex.get(this.focusComponentName);
            if (c != null) {
                Component comp = (Component)((Object)c);
                comp.requestFocusInWindow();
            }
            this.focusComponentName = null;
        }
    }

    private UIControl getUIControl(int index) {
        try {
            return this.controls.get(index);
        }
        catch (Throwable t) {
            return null;
        }
    }

    private void _doRefresh(UIControl u, Set refreshed) {
        this._doRefresh(u, refreshed, u.getName());
    }

    private void _doRefresh(UIControl u, Set refreshed, String name) {
        if (refreshed.add(u)) {
            block12: {
                if (u instanceof UIComposite) {
                    UIComposite comp = (UIComposite)u;
                    if (comp.isDynamic()) {
                        JComponent jc = (JComponent)((Object)comp);
                        if (jc.getClientProperty(this.getClass() + "REFRESHED") != null) {
                            comp.reload();
                        } else {
                            jc.putClientProperty(this.getClass() + "REFRESHED", true);
                        }
                    }
                    for (UIControl uIControl : comp.getControls()) {
                        this.applyStyle(uIControl);
                    }
                    this.applyStyle(u);
                } else {
                    this.applyStyle(u);
                }
                u.refresh();
                try {
                    Object o = u.getClientProperty(UIHandler.class);
                    if (o instanceof UIHandler) {
                        ((UIHandler)o).refresh(new UIEvent(u, u.getBinding(), u.getName()));
                    }
                }
                catch (Throwable t) {
                    System.out.println("[ERROR] " + t.getMessage());
                    if (!ClientContext.getCurrentContext().isDebugMode()) break block12;
                    t.printStackTrace();
                }
            }
            if (!ValueUtil.isEmpty((Object)name) && this.depends.containsKey(name)) {
                UIControl[] arrs;
                for (UIControl uu : arrs = this.depends.get(name).toArray(new UIControl[0])) {
                    if (uu == null) continue;
                    this._doRefresh(uu, refreshed);
                }
            }
        }
    }

    public final void applyStyle(UIControl u) {
        if (this.styleRules == null) {
            return;
        }
        if (u instanceof NonStylable) {
            return;
        }
        String name = u.getName();
        if (name == null) {
            name = "_any_name";
        }
        for (StyleRule r : this.styleRules) {
            String pattern = r.getPattern();
            String rule = r.getExpression();
            boolean applyStyles = false;
            if (rule != null && name.matches(pattern)) {
                try {
                    applyStyles = ExpressionResolver.getInstance().evalBoolean(rule, this.getBean());
                }
                catch (Exception ign) {
                    System.out.println("STYLE RULE ERROR: " + ign.getMessage());
                }
            }
            if (!applyStyles) continue;
            ControlSupport.setStyles(r.getProperties(), (Component)((Object)u));
        }
    }

    public void validate() {
        ActionMessage am = new ActionMessage();
        this.validate(am);
        if (am.hasMessages()) {
            if (am.getSource() != null) {
                am.getSource().requestFocusInWindow();
            }
            throw new BusinessException(am.toString());
        }
        this.getValidatorSupport().fireBeanValidators(this.getBean());
        ValidatorEvent evt = new ValidatorEvent(this);
        this.validateBean(evt);
        if (evt.hasMessages()) {
            if (evt.getSource() != null) {
                evt.getSource().requestFocusInWindow();
            }
            throw new BusinessException(evt.toString());
        }
    }

    public void validate(ActionMessage actionMessage) {
        UIControlUtil.validate(this.validatables, actionMessage);
        for (BindingListener bl : this.listeners) {
            bl.validate(actionMessage, this);
        }
    }

    public void validateBean(ValidatorEvent evt) {
        for (Validator v : this.validators) {
            v.validate(evt);
        }
        for (BindingListener bl : this.listeners) {
            bl.validateBean(evt);
        }
    }

    public void formCommit() {
        for (UIControl u : this.focusableControls) {
            Component comp = (Component)((Object)u);
            if (!comp.isEnabled() || !comp.isShowing() || u instanceof UIInput && ((UIInput)u).isReadonly() || u instanceof JTextComponent && !((JTextComponent)((Object)u)).isEditable()) continue;
            if (u instanceof UIComposite) {
                UIComposite uc = (UIComposite)u;
                for (UIControl uIControl : uc.getControls()) {
                    this.doCommit(uIControl);
                }
                continue;
            }
            this.doCommit(u);
        }
        for (BindingListener bl : this.listeners) {
            bl.formCommit();
        }
    }

    private void doCommit(UIControl u) {
        Object beanValue;
        if (!(u instanceof UIInput) || ValueUtil.isEmpty((Object)u.getName())) {
            return;
        }
        UIInput ui = (UIInput)u;
        if (ui.isImmediate() || ui.isReadonly()) {
            return;
        }
        Component c = (Component)((Object)ui);
        if (!(c.isEnabled() && c.isFocusable() && c.isShowing())) {
            return;
        }
        if (c.getParent() == null) {
            return;
        }
        Object compValue = ui.getValue();
        if (!ValueUtil.isEqual((Object)compValue, (Object)(beanValue = UIControlUtil.getBeanValue(ui)))) {
            UIInputUtil.updateBeanValue(ui);
        }
    }

    public void update() {
        if (this.changeLog != null) {
            this.changeLog.clear();
        }
        for (BindingListener bl : this.listeners) {
            bl.update();
        }
    }

    public void addBindingListener(BindingListener listener) {
        if (listener != null && !this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeListener(BindingListener listener) {
        if (listener != null) {
            this.listeners.remove(listener);
        }
    }

    public void activate() {
        try {
            if (this.activateMethod == null) {
                return;
            }
            MethodResolver mr = MethodResolver.getInstance();
            mr.invoke(this.bean, this.activateMethod, new Class[0], new Object[0]);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public boolean close() {
        if (this.closeMethod == null) {
            return true;
        }
        try {
            MethodResolver mr = MethodResolver.getInstance();
            Object o = mr.invoke(this.bean, this.closeMethod, new Class[0], new Object[0]);
            if ("false".equals(o + "")) {
                return false;
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return true;
    }

    public boolean focusFirstInput() {
        for (UIControl u : this.focusableControls) {
            UIInput ui;
            Component comp;
            if (u instanceof UIFocusableContainer) {
                UIFocusableContainer uis = (UIFocusableContainer)u;
                if (!uis.focusFirstInput()) continue;
                return true;
            }
            if (!(u instanceof UIInput) || !(comp = (Component)((Object)(ui = (UIInput)u))).isEnabled() || !comp.isFocusable()) continue;
            return comp.requestFocusInWindow();
        }
        return false;
    }

    public void fireNavigation(Object outcome) {
        this.fireNavigation(outcome, "parent");
    }

    public void fireNavigation(Object outcome, String target) {
        this.fireNavigation(outcome, target, true);
    }

    public void fireNavigation(final Object outcome, final String target, boolean invokeLater) {
        Runnable process = new Runnable(){

            @Override
            public void run() {
                Binding.this.doFireNavigation(outcome, target);
            }
        };
        if (invokeLater) {
            EventQueue.invokeLater(process);
        } else {
            process.run();
        }
    }

    private void doFireNavigation(Object outcome, String target) {
        UIViewPanel jcomp = null;
        try {
            if (outcome == null) {
                return;
            }
            jcomp = this.getOwner();
            if (!(outcome instanceof String) && !(outcome instanceof Opener)) {
                throw new Exception("outcome must be a String or Opener");
            }
            ClientContext ctx = ClientContext.getCurrentContext();
            NavigationHandler handler = ctx.getNavigationHandler();
            if (handler != null) {
                ViewContext viewctx;
                NavigatablePanel navPanel = UIControlUtil.getParentPanel(jcomp, target);
                if (navPanel == null && (viewctx = this.getViewContext()) instanceof NavigatablePanel) {
                    navPanel = (NavigatablePanel)((Object)viewctx);
                }
                handler.navigate(navPanel, null, outcome);
            }
        }
        catch (BreakException ctx) {
        }
        catch (Exception e) {
            ClientContext.getCurrentContext().getPlatform().showError(jcomp, e);
        }
    }

    public void focus(String name) {
        this.focusComponentName = name;
    }

    public void requestFocus(String name) {
        if (name == null) {
            return;
        }
        UIControl c = this.controlsIndex.get(name);
        if (c == null) {
            return;
        }
        Component comp = (Component)((Object)c);
        if (comp.isEnabled() && comp.isFocusable()) {
            comp.requestFocusInWindow();
        }
    }

    public UIControl find(String name) {
        if (name == null) {
            return null;
        }
        return this.controlsIndex.get(name);
    }

    public List<UIControl> findList(String name) {
        ArrayList<UIControl> list = this.controlsListIndex.get(name);
        if (list != null) {
            return list;
        }
        list = new ArrayList<UIControl>();
        UIControl u = this.controlsIndex.get(name);
        if (u != null) {
            list.add(u);
        }
        return list;
    }

    public void setTitle(String title) {
        if (this.viewContext != null && this.viewContext.getSubWindow() != null) {
            this.viewContext.getSubWindow().setTitle(title);
        }
    }

    public void bind(UIControl uic) {
        block4: {
            if (uic != null) {
                uic.setBinding(this);
                try {
                    Object o = uic.getClientProperty(UIHandler.class);
                    if (o instanceof UIHandler) {
                        ((UIHandler)o).bind(new UIEvent(uic, uic.getBinding(), uic.getName()));
                    }
                }
                catch (Throwable t) {
                    System.out.println("[ERROR] " + t.getMessage());
                    if (!ClientContext.getCurrentContext().isDebugMode()) break block4;
                    t.printStackTrace();
                }
            }
        }
    }

    public void unbind(UIControl uic) {
        block6: {
            if (uic != null) {
                try {
                    uic.setBinding(null);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                try {
                    Object o = uic.getClientProperty(UIHandler.class);
                    if (o instanceof UIHandler) {
                        ((UIHandler)o).unbind(new UIEvent(uic, uic.getBinding(), uic.getName()));
                    }
                }
                catch (Throwable t) {
                    System.out.println("[ERROR] " + t.getMessage());
                    if (!ClientContext.getCurrentContext().isDebugMode()) break block6;
                    t.printStackTrace();
                }
            }
        }
    }

    public boolean isInitialized() {
        return this._initialized;
    }

    public UIController getController() {
        return this.controller;
    }

    public void setController(UIController controller) {
        this.controller = controller;
    }

    public Object getBean() {
        return this.bean;
    }

    public void setBean(Object bean) {
        this.bean = bean;
        this.initAnnotatedFields(bean, bean.getClass());
        Method m = this.findAnnotatedMethod(bean.getClass(), Close.class);
        if (m != null) {
            this.closeMethod = m.getName();
        }
        if ((m = this.findAnnotatedMethod(bean.getClass(), Activate.class)) != null) {
            this.activateMethod = m.getName();
        }
        this._load();
    }

    public void reinjectAnnotations() {
        this.initAnnotatedFields(this.bean, this.bean.getClass());
    }

    private void _load() {
        for (UIControl c : this.controls) {
            c.load();
        }
    }

    public ChangeLog getChangeLog() {
        return this.changeLog;
    }

    public void setChangeLog(ChangeLog changeLog) {
        this.changeLog = changeLog;
    }

    public XButton getDefaultButton() {
        return this.defaultButton;
    }

    public void setDefaultButton(XButton defaultButton) {
        this.defaultButton = defaultButton;
    }

    public StyleRule[] getStyleRules() {
        return this.styleRules;
    }

    public void setStyleRules(StyleRule[] styleRules) {
        this.styleRules = styleRules;
    }

    public Map getProperties() {
        return this.properties;
    }

    public void setProperties(Map properties) {
        this.properties = properties;
    }

    public ViewContext getViewContext() {
        return this.viewContext;
    }

    public void setViewContext(ViewContext viewContext) {
        this.viewContext = viewContext;
    }

    private DependencyInjector getInjector() {
        if (this.injector == null) {
            this.injector = new DependencyInjector();
        }
        return this.injector;
    }

    private void initAnnotatedFields(Object o, Class clazz) {
        if (o == null) {
            return;
        }
        if (this.annotationScanIsDone) {
            boolean accessible;
            if (this.bindingField != null) {
                accessible = this.bindingField.isAccessible();
                this.bindingField.setAccessible(true);
                try {
                    this.bindingField.set(o, this);
                }
                catch (Exception ex) {
                    System.out.println("ERROR injecting @Binding " + ex.getMessage());
                }
                this.bindingField.setAccessible(accessible);
            }
            if (this.changeLogField != null) {
                accessible = this.changeLogField.isAccessible();
                this.changeLogField.setAccessible(true);
                try {
                    ChangeLog cl = this.getChangeLog();
                    String[] prefixes = (String[])this.getProperties().get(CHANGE_LOG_PREFIX_KEY);
                    if (prefixes != null) {
                        for (String s : prefixes) {
                            cl.getPrefix().add(s);
                        }
                    }
                }
                catch (Throwable ex) {
                    System.out.println("ERROR injecting @Binding " + ex.getMessage());
                }
                this.changeLogField.setAccessible(accessible);
            }
            return;
        }
        for (Field f : clazz.getDeclaredFields()) {
            Object obj;
            Object onactivate;
            String s;
            int n;
            boolean accessible = f.isAccessible();
            if (f.isAnnotationPresent(com.rameses.rcp.annotations.Binding.class)) {
                com.rameses.rcp.annotations.Binding b = f.getAnnotation(com.rameses.rcp.annotations.Binding.class);
                String[] values = b.validators();
                PropertyResolver res = PropertyResolver.getInstance();
                String[] stringArray = values;
                int n2 = stringArray.length;
                for (n = 0; n < n2; ++n) {
                    s = stringArray[n];
                    try {
                        Object v = res.getProperty(this.getBean(), s);
                        if (!(v instanceof Validator)) continue;
                        this.validators.add((Validator)v);
                        continue;
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                }
                f.setAccessible(true);
                try {
                    f.set(o, this);
                }
                catch (Throwable t) {
                    System.out.println("ERROR injecting @Binding caused by " + t.getClass().getName() + ": " + t.getMessage());
                }
                f.setAccessible(accessible);
                this.bindingField = f;
                onactivate = b.onactivate();
                if (onactivate == null || ((String)onactivate).length() <= 0) continue;
                try {
                    MethodResolver.getInstance().invoke(this.getBean(), (String)onactivate, new Object[0]);
                    continue;
                }
                catch (Throwable t) {
                    System.out.println("ERROR invoking '" + (String)onactivate + "' method caused by " + t.getMessage());
                    if (t instanceof RuntimeException) {
                        throw (RuntimeException)t;
                    }
                    throw new RuntimeException(t.getMessage(), t);
                }
            }
            if (f.isAnnotationPresent(com.rameses.rcp.annotations.ChangeLog.class)) {
                f.setAccessible(true);
                try {
                    com.rameses.rcp.annotations.ChangeLog annot = f.getAnnotation(com.rameses.rcp.annotations.ChangeLog.class);
                    String[] prefixes = annot.prefix();
                    this.getProperties().put(CHANGE_LOG_PREFIX_KEY, prefixes);
                    ChangeLog cl = this.getChangeLog();
                    if (prefixes != null) {
                        onactivate = prefixes;
                        int t = ((String[])onactivate).length;
                        for (n = 0; n < t; ++n) {
                            s = onactivate[n];
                            cl.getPrefix().add(s);
                        }
                    }
                    f.set(o, cl);
                }
                catch (Throwable t) {
                    System.out.println("ERROR injecting @ChangeLog caused by " + t.getClass().getName() + ": " + t.getMessage());
                }
                f.setAccessible(accessible);
                this.changeLogField = f;
                continue;
            }
            if (f.isAnnotationPresent(PropertyChangeListener.class)) {
                f.setAccessible(true);
                try {
                    Map map = (Map)f.get(this.getBean());
                    this.getValueChangeSupport().addExtendedHandler(map);
                }
                catch (Throwable t) {
                    System.out.println("ERROR injecting @PropertyChangeListener caused by " + t.getClass().getName() + ": " + t.getMessage());
                }
                f.setAccessible(accessible);
                continue;
            }
            if (f.isAnnotationPresent(FieldValidator.class)) {
                f.setAccessible(true);
                try {
                    obj = f.get(this.getBean());
                    this.getValidatorSupport().addFieldValidator(obj);
                }
                catch (Throwable t) {
                    System.out.println("ERROR injecting @FieldValidator caused by " + t.getClass().getName() + ": " + t.getMessage());
                }
                f.setAccessible(accessible);
                continue;
            }
            if (f.isAnnotationPresent(BeanValidator.class)) {
                f.setAccessible(true);
                try {
                    obj = f.get(this.getBean());
                    this.getValidatorSupport().addBeanValidator(obj);
                }
                catch (Throwable t) {
                    System.out.println("ERROR injecting @BeanValidator caused by " + t.getClass().getName() + ": " + t.getMessage());
                }
                f.setAccessible(accessible);
                continue;
            }
            if (f.isAnnotationPresent(com.rameses.rcp.annotations.SubWindow.class)) {
                f.setAccessible(true);
                try {
                    f.set(o, new SubWindowAdapter());
                }
                catch (Throwable t) {
                    System.out.println("ERROR injecting @SubWindow caused by " + t.getClass().getName() + ": " + t.getMessage());
                }
                f.setAccessible(accessible);
                continue;
            }
            f.setAccessible(true);
            try {
                for (Annotation anno : f.getDeclaredAnnotations()) {
                    Object resource = this.getInjector().getResource(anno, this);
                    if (resource == null) continue;
                    f.set(o, resource);
                }
            }
            catch (Throwable t) {
                System.out.println("ERROR injecting caused by " + t.getClass().getName() + ": " + t.getMessage());
            }
            f.setAccessible(accessible);
        }
        Class superClass = clazz.getSuperclass();
        if (superClass != null) {
            this.initAnnotatedFields(o, superClass);
        }
        this.annotationScanIsDone = true;
    }

    private void initAnnotatedMethods(Object o, Class clazz) {
        for (Method m : clazz.getDeclaredMethods()) {
            if (!m.isAnnotationPresent(Close.class)) continue;
            this.closeMethod = m.getName();
            return;
        }
        Class superClazz = clazz.getSuperclass();
        if (superClazz != null) {
            this.initAnnotatedMethods(o, superClazz);
        }
    }

    private Method findAnnotatedMethod(Class beanClass, Class annoClass) {
        for (Method m : beanClass.getDeclaredMethods()) {
            if (!m.isAnnotationPresent(annoClass)) continue;
            return m;
        }
        Class superClazz = beanClass.getSuperclass();
        if (superClazz == null) {
            return null;
        }
        return this.findAnnotatedMethod(superClazz, annoClass);
    }

    public void addViewHandler(ViewHandler handler) {
        if (handler == null) {
            return;
        }
        this.viewHandlers.remove(handler);
        this.viewHandlers.add(handler);
    }

    public void removeViewHandler(ViewHandler handler) {
        if (handler != null) {
            this.viewHandlers.remove(handler);
        }
    }

    void fireActivatePage(Object name) {
        Object bean = this.getBean();
        if (bean instanceof ViewHandler) {
            this.addViewHandler((ViewHandler)bean);
        }
        for (ViewHandler handler : this.viewHandlers) {
            handler.activatePage(this, name);
        }
    }

    void fireAfterRefresh(Object name) {
        for (ViewHandler handler : this.viewHandlers) {
            handler.afterRefresh(this, name);
        }
    }

    public ValueChangeSupport getValueChangeSupport() {
        if (this.valueChangeSupport == null) {
            this.valueChangeSupport = new ValueChangeSupport();
        }
        return this.valueChangeSupport;
    }

    public void addValueListener(String property, Object callbackListener) {
        this.getValueChangeSupport().add(property, callbackListener);
    }

    public void removeValueListener(String property, Object callbackListener) {
        this.getValueChangeSupport().remove(property, callbackListener);
    }

    public BindingValidatorSupport getValidatorSupport() {
        if (this.validatorSupport == null) {
            this.validatorSupport = new BindingValidatorSupport();
        }
        return this.validatorSupport;
    }

    private class AsyncRefreshWorker {
        private String regex;

        AsyncRefreshWorker(String regex) {
            this.regex = regex;
        }

        void run() {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            AsyncRefreshWorker.this.runImpl();
                        }
                    });
                }
            }).start();
        }

        private void runImpl() {
            Binding.this.refreshImpl(this.regex);
        }
    }

    public class SubWindowAdapter
    implements SubWindow {
        Binding root;

        public SubWindowAdapter() {
            this.root = Binding.this;
        }

        private SubWindow getCurrentWindow() {
            ViewContext ctx = this.root.getViewContext();
            return ctx == null ? null : ctx.getSubWindow();
        }

        public void close() {
            this.closeWindow();
        }

        @Override
        public void closeWindow() {
            SubWindow win = this.getCurrentWindow();
            if (win != null) {
                win.closeWindow();
            }
        }

        @Override
        public String getName() {
            SubWindow win = this.getCurrentWindow();
            return win == null ? null : win.getName();
        }

        @Override
        public String getTitle() {
            SubWindow win = this.getCurrentWindow();
            return win == null ? null : win.getTitle();
        }

        @Override
        public void setTitle(String title) {
            SubWindow win = this.getCurrentWindow();
            if (win != null) {
                win.setTitle(title);
            }
        }

        @Override
        public void setListener(SubWindowListener listener) {
        }

        public void update() {
            SubWindow win = this.getCurrentWindow();
            if (win == null) {
                return;
            }
            HashMap props = new HashMap();
            Object bean = Binding.this.getBean();
            this.loadFormPropertiesFromAnnotation(props, bean, bean.getClass());
            this.update(props);
        }

        @Override
        public void update(Map attrs) {
            SubWindow win = this.getCurrentWindow();
            if (win == null || attrs == null || attrs.isEmpty()) {
                return;
            }
            Object oid = attrs.get("id");
            if (oid != null) {
                Object oval;
                UIViewPanel uiv = this.root.getOwner();
                Object object = oval = uiv == null ? null : uiv.getClientProperty(UIControllerContext.class);
                if (oval instanceof UIControllerContext) {
                    ((UIControllerContext)oval).setId(oid.toString());
                }
            }
            win.update(attrs);
        }

        private void loadFormPropertiesFromAnnotation(Map props, Object bean, Class beanClass) {
            boolean accessible;
            for (Field field : beanClass.getDeclaredFields()) {
                accessible = field.isAccessible();
                try {
                    if (field.isAnnotationPresent(FormId.class)) {
                        field.setAccessible(true);
                        props.put("id", field.get(bean));
                    } else if (field.isAnnotationPresent(FormTitle.class)) {
                        field.setAccessible(true);
                        props.put("title", field.get(bean));
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                field.setAccessible(accessible);
            }
            for (AccessibleObject accessibleObject : beanClass.getDeclaredMethods()) {
                accessible = accessibleObject.isAccessible();
                try {
                    if (accessibleObject.isAnnotationPresent(FormId.class)) {
                        ((Method)accessibleObject).setAccessible(true);
                        props.put("id", ((Method)accessibleObject).invoke(bean, new Object[0]));
                    } else if (accessibleObject.isAnnotationPresent(FormTitle.class)) {
                        ((Method)accessibleObject).setAccessible(true);
                        props.put("title", ((Method)accessibleObject).invoke(bean, new Object[0]));
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                ((Method)accessibleObject).setAccessible(accessible);
            }
            Class superClass = beanClass.getSuperclass();
            if (superClass != null) {
                this.loadFormPropertiesFromAnnotation(props, bean, superClass);
            }
        }
    }

    public class ActionHandlerSupport {
        private List<ActionHandler> handlers = new ArrayList<ActionHandler>();

        public void add(ActionHandler handler) {
            if (handler == null) {
                return;
            }
            this.handlers.remove(handler);
            this.handlers.add(handler);
        }

        public void remove(ActionHandler handler) {
            if (handler != null) {
                this.handlers.remove(handler);
            }
        }

        public void fireBeforeExecute() {
            for (ActionHandler handler : this.handlers) {
                handler.onBeforeExecute();
            }
        }

        public void fireAfterExecute() {
            for (ActionHandler handler : this.handlers) {
                handler.onAfterExecute();
            }
        }
    }

    private class ControlEventSupport
    implements MouseListener,
    KeyListener {
        private ControlEventSupport() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (e.getButton() == 1) {
                ControlEvent evt = this.createControlEvent(e);
                evt.setEventName("LEFT_CLICK");
            } else if (e.getButton() == 3) {
                ControlEvent evt = this.createControlEvent(e);
                evt.setEventName("RIGHT_CLICK");
            }
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void keyPressed(KeyEvent e) {
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }

        private ControlEvent createControlEvent(ComponentEvent e) {
            Component c = (Component)e.getSource();
            ControlEvent evt = new ControlEvent();
            evt.setSource(c.getName());
            evt.setSourceEvent(e);
            return evt;
        }
    }

    private class ChangeLogKeySupport
    implements KeyListener {
        private ChangeLogKeySupport() {
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void keyPressed(KeyEvent e) {
        }

        @Override
        public void keyReleased(KeyEvent e) {
            if (e.isControlDown() && e.getKeyCode() == 90 && Binding.this.changeLog.hasChanges()) {
                ChangeLog.ChangeEntry ce = Binding.this.changeLog.undo();
                if (ce != null) {
                    Binding.this.focus(ce.getFieldName());
                }
                Binding.this.refresh();
            }
        }
    }

    public class Helper {
        Binding root;

        public Helper() {
            this.root = Binding.this;
        }

        public void bindControls(Container cont, Binding binding) {
            if (cont == null) {
                return;
            }
            for (Component c : cont.getComponents()) {
                if (c instanceof UIControl) {
                    UIControl uic = (UIControl)((Object)c);
                    if (binding == null) {
                        uic.setBinding(null);
                        binding.unregister(uic);
                    } else {
                        binding.bind(uic);
                        binding.register(uic);
                    }
                    if (!(c instanceof ControlContainer) || !((ControlContainer)((Object)c)).isHasNonDynamicContents() || !(c instanceof Container)) continue;
                    this.bindControls((Container)c, binding);
                    continue;
                }
                if (!(c instanceof Container)) continue;
                this.bindControls((Container)c, binding);
            }
        }

        public void focusComponent(Component comp) {
            EventQueue.invokeLater(new RequestFocusTask(comp));
        }

        public boolean isChild(Container cont, Component child) {
            if (cont == null || child == null) {
                return false;
            }
            boolean found = false;
            for (Container parent = child.getParent(); parent != null; parent = parent.getParent()) {
                if (!cont.equals(parent)) continue;
                found = true;
                break;
            }
            return found;
        }

        public void validateInput(ActionMessage am) {
            UIControlUtil.validate(Binding.this.validatables, am);
            for (BindingListener bl : Binding.this.listeners) {
                bl.validate(am, this.root);
            }
        }
    }

    private class RequestFocusTask
    implements Runnable {
        Component comp;

        RequestFocusTask(Component comp) {
            this.comp = comp;
        }

        @Override
        public void run() {
            if (this.comp != null && this.comp.isEnabled() && this.comp.isFocusable()) {
                this.comp.requestFocusInWindow();
            }
        }
    }
}

