/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.control.text;

import java.beans.Beans;
import java.util.HashMap;
import java.util.Map;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;

public class MaskDocument
extends PlainDocument {
    private JTextComponent jtext;
    private MaskChar[] masks;
    private char placeHolder;
    private boolean includeLiteralChars;
    private MaskCharManager maskCharManager;

    public MaskDocument(JTextComponent jtext) {
        this.jtext = jtext;
        this.placeHolder = (char)95;
        this.includeLiteralChars = true;
    }

    public char getPlaceHolder() {
        return this.placeHolder;
    }

    public void setPlaceHolder(char placeHolder) {
        this.placeHolder = placeHolder;
    }

    public boolean isIncludeLiteral() {
        return this.includeLiteralChars;
    }

    public void setIncludeLiteral(boolean includeLiteralChars) {
        this.includeLiteralChars = includeLiteralChars;
    }

    public void updateMask(String maskFormat) {
        this.masks = this.getMaskCharManager().createMasks(maskFormat);
        char[] chars = this.getMaskValues();
        try {
            super.remove(0, this.getLength());
            super.insertString(0, new String(chars), null);
        }
        catch (BadLocationException ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    public Object getValue() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.masks.length; ++i) {
            char ch = this.masks[i].getValue();
            if (this.masks[i] instanceof FixedMaskChar) {
                if (!this.isIncludeLiteral()) continue;
                sb.append(ch);
                continue;
            }
            if (ch == '\u0000') {
                return null;
            }
            sb.append(ch);
        }
        return sb.toString();
    }

    public void setValue(Object value) {
        char[] chars = value == null ? new char[]{} : value.toString().toCharArray();
        for (MaskChar mc : this.masks) {
            mc.reset();
        }
        int mi = 0;
        for (int i = 0; i < chars.length && i < this.masks.length; ++i) {
            if (this.masks[mi] instanceof FixedMaskChar) {
                if (!this.isIncludeLiteral()) {
                    --i;
                }
                ++mi;
                continue;
            }
            if (!this.masks[mi].accept(chars[i])) break;
            this.masks[mi].setValue(chars[i]);
            ++mi;
        }
        chars = this.getMaskValues();
        try {
            super.remove(0, this.getLength());
            super.insertString(0, new String(chars), null);
        }
        catch (BadLocationException ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    private String getText() {
        try {
            return new StringBuffer(this.getText(0, this.getLength())).toString();
        }
        catch (BadLocationException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    private char[] getMaskValues() {
        char[] chars = new char[this.masks.length];
        for (int i = 0; i < chars.length; ++i) {
            chars[i] = this.masks[i].getValue();
            if (chars[i] != '\u0000') continue;
            chars[i] = this.getPlaceHolder();
        }
        return chars;
    }

    @Override
    public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
        if (Beans.isDesignTime()) {
            super.insertString(offs, str, a);
            return;
        }
        if (offs >= this.masks.length) {
            return;
        }
        boolean hasChanges = false;
        int index = 0;
        int updatedIndex = 0;
        char[] chars = str.toCharArray();
        for (int i = offs; i < this.masks.length && index < chars.length; ++i) {
            if (!this.masks[i].isAllowInput()) continue;
            char ch = chars[index];
            if (!this.masks[i].accept(ch)) break;
            this.masks[i].setValue(ch);
            ch = this.masks[i].getValue();
            updatedIndex = i;
            hasChanges = true;
            super.remove(i, 1);
            super.insertString(i, ch + "", a);
            ++index;
        }
        if (!hasChanges) {
            return;
        }
        int caretPos = this.getNextUpdatableIndex(updatedIndex + 1);
        if (caretPos < 0) {
            caretPos = updatedIndex + 1 == this.masks.length ? this.masks.length : offs;
        }
        try {
            this.jtext.setCaretPosition(caretPos);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void remove(int offs, int len) throws BadLocationException {
        if (Beans.isDesignTime()) {
            super.remove(offs, len);
            return;
        }
        super.remove(offs, len);
        StringBuffer sb = new StringBuffer();
        int limit = offs + len;
        for (int i = offs; i < limit && i < this.masks.length; ++i) {
            this.masks[i].reset();
            char ch = this.masks[i].getValue();
            sb.append(ch == '\u0000' ? this.getPlaceHolder() : ch);
        }
        super.insertString(offs, sb.toString(), null);
        try {
            this.jtext.setCaretPosition(offs);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private int getNextUpdatableIndex(int start) {
        for (int i = start; i < this.masks.length; ++i) {
            if (!this.masks[i].isAllowInput()) continue;
            return i;
        }
        return -1;
    }

    private MaskCharManager getMaskCharManager() {
        if (this.maskCharManager == null) {
            this.maskCharManager = new MaskCharManager();
        }
        return this.maskCharManager;
    }

    private class AnyHexMaskChar
    implements MaskChar {
        private char pattern = (char)72;
        private char value;
        private char[] HEX_LETTERS = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'A', 'B', 'C', 'D', 'E', 'F'};

        private AnyHexMaskChar() {
        }

        @Override
        public MaskChar createInstance() {
            return new AnyHexMaskChar();
        }

        @Override
        public boolean isAllowInput() {
            return true;
        }

        @Override
        public boolean accept(char value) {
            if (Character.isDigit(value)) {
                return true;
            }
            for (int i = 0; i < this.HEX_LETTERS.length; ++i) {
                if (this.HEX_LETTERS[i] != value) continue;
                return true;
            }
            return false;
        }

        @Override
        public char getValue() {
            return this.value;
        }

        @Override
        public void setValue(char value) {
            this.value = this.accept(value) ? value : (char)'\u0000';
        }

        @Override
        public void reset() {
            this.value = '\u0000';
        }
    }

    private class AnyCharMaskChar
    implements MaskChar {
        private char pattern = (char)42;
        private char value;

        private AnyCharMaskChar() {
        }

        @Override
        public MaskChar createInstance() {
            return new AnyCharMaskChar();
        }

        @Override
        public boolean isAllowInput() {
            return true;
        }

        @Override
        public boolean accept(char value) {
            return true;
        }

        @Override
        public char getValue() {
            return this.value;
        }

        @Override
        public void setValue(char value) {
            this.value = value;
        }

        @Override
        public void reset() {
            this.value = '\u0000';
        }
    }

    private class AnyLetterMaskChar
    implements MaskChar {
        private char pattern = (char)63;
        private char value;

        private AnyLetterMaskChar() {
        }

        @Override
        public MaskChar createInstance() {
            return new AnyLetterMaskChar();
        }

        @Override
        public boolean isAllowInput() {
            return true;
        }

        @Override
        public boolean accept(char value) {
            return Character.isLetter(value);
        }

        @Override
        public char getValue() {
            return this.value;
        }

        @Override
        public void setValue(char value) {
            this.value = this.accept(value) ? value : (char)'\u0000';
        }

        @Override
        public void reset() {
            this.value = '\u0000';
        }
    }

    private class AlphaNumericMaskChar
    implements MaskChar {
        private char pattern = (char)65;
        private char value;

        private AlphaNumericMaskChar() {
        }

        @Override
        public MaskChar createInstance() {
            return new AlphaNumericMaskChar();
        }

        @Override
        public boolean isAllowInput() {
            return true;
        }

        @Override
        public boolean accept(char value) {
            return Character.isLetter(value) || Character.isDigit(value);
        }

        @Override
        public char getValue() {
            return this.value;
        }

        @Override
        public void setValue(char value) {
            this.value = this.accept(value) ? value : (char)'\u0000';
        }

        @Override
        public void reset() {
            this.value = '\u0000';
        }
    }

    private class LowerCaseMaskChar
    implements MaskChar {
        private char pattern = (char)76;
        private char value;

        private LowerCaseMaskChar() {
        }

        @Override
        public MaskChar createInstance() {
            return new LowerCaseMaskChar();
        }

        @Override
        public boolean isAllowInput() {
            return true;
        }

        @Override
        public boolean accept(char value) {
            return Character.isLetter(value);
        }

        @Override
        public char getValue() {
            if (this.value == '\u0000') {
                return this.value;
            }
            return Character.toLowerCase(this.value);
        }

        @Override
        public void setValue(char value) {
            this.value = this.accept(value) ? value : (char)'\u0000';
        }

        @Override
        public void reset() {
            this.value = '\u0000';
        }
    }

    private class UpperCaseMaskChar
    implements MaskChar {
        private char pattern = (char)85;
        private char value;

        private UpperCaseMaskChar() {
        }

        @Override
        public MaskChar createInstance() {
            return new UpperCaseMaskChar();
        }

        @Override
        public boolean isAllowInput() {
            return true;
        }

        @Override
        public boolean accept(char value) {
            return Character.isLetter(value);
        }

        @Override
        public char getValue() {
            if (this.value == '\u0000') {
                return this.value;
            }
            return Character.toUpperCase(this.value);
        }

        @Override
        public void setValue(char value) {
            this.value = this.accept(value) ? value : (char)'\u0000';
        }

        @Override
        public void reset() {
            this.value = '\u0000';
        }
    }

    private class DigitMaskChar
    implements MaskChar {
        private char pattern = (char)35;
        private char value;

        private DigitMaskChar() {
        }

        @Override
        public MaskChar createInstance() {
            return new DigitMaskChar();
        }

        @Override
        public boolean isAllowInput() {
            return true;
        }

        @Override
        public boolean accept(char value) {
            return Character.isDigit(value);
        }

        @Override
        public char getValue() {
            return this.value;
        }

        @Override
        public void setValue(char value) {
            this.value = this.accept(value) ? value : (char)'\u0000';
        }

        @Override
        public void reset() {
            this.value = '\u0000';
        }
    }

    private class FixedMaskChar
    implements MaskChar {
        private char value;

        FixedMaskChar(char value) {
            this.value = value;
        }

        @Override
        public MaskChar createInstance() {
            return null;
        }

        @Override
        public boolean accept(char value) {
            return true;
        }

        @Override
        public boolean isAllowInput() {
            return false;
        }

        @Override
        public char getValue() {
            return this.value;
        }

        @Override
        public void setValue(char value) {
        }

        @Override
        public void reset() {
        }
    }

    private static interface MaskChar {
        public boolean accept(char var1);

        public MaskChar createInstance();

        public boolean isAllowInput();

        public char getValue();

        public void setValue(char var1);

        public void reset();
    }

    private class MaskCharManager {
        private Map<String, MaskChar> patterns = new HashMap<String, MaskChar>();

        MaskCharManager() {
            this.patterns.put("#", new DigitMaskChar());
            this.patterns.put("U", new UpperCaseMaskChar());
            this.patterns.put("L", new LowerCaseMaskChar());
            this.patterns.put("A", new AlphaNumericMaskChar());
            this.patterns.put("?", new AnyLetterMaskChar());
            this.patterns.put("*", new AnyCharMaskChar());
            this.patterns.put("H", new AnyHexMaskChar());
        }

        MaskChar[] createMasks(String format) {
            if (format == null || format.length() == 0) {
                return new MaskChar[0];
            }
            char[] chars = format.toCharArray();
            MaskChar[] masks = new MaskChar[chars.length];
            for (int i = 0; i < chars.length; ++i) {
                char ch = chars[i];
                MaskChar mc = this.patterns.get(ch + "");
                masks[i] = mc != null ? mc.createInstance() : new FixedMaskChar(ch);
            }
            return masks;
        }
    }
}

