/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.control.text;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

final class HtmlLinkDialog {
    public static final int APPROVE_OPTION = 1;
    public static final int CANCEL_OPTION = 2;
    private JTextField editor;
    private String caption;
    private String value;

    public String getCaption() {
        return this.caption;
    }

    public void setCaption(String caption) {
        this.caption = caption;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void setValue(Object value) {
        this.value = value == null ? null : value.toString();
    }

    public int open(Component invoker) {
        Component root = invoker == null ? null : SwingUtilities.getRoot(invoker);
        JDialog d = null;
        d = root instanceof Frame ? new JDialog((Frame)root) : (root instanceof Dialog ? new JDialog((Dialog)root) : new JDialog());
        d.setModal(true);
        d.setDefaultCloseOperation(2);
        d.setTitle("Hyperlink");
        d.setContentPane(this.getContent(d));
        d.pack();
        d.setResizable(false);
        d.addWindowListener(new WindowListener(){

            @Override
            public void windowActivated(WindowEvent e) {
            }

            @Override
            public void windowClosed(WindowEvent e) {
            }

            @Override
            public void windowClosing(WindowEvent e) {
            }

            @Override
            public void windowDeactivated(WindowEvent e) {
            }

            @Override
            public void windowDeiconified(WindowEvent e) {
            }

            @Override
            public void windowIconified(WindowEvent e) {
            }

            @Override
            public void windowOpened(WindowEvent e) {
                HtmlLinkDialog.this.editor.selectAll();
            }
        });
        d.setLocationRelativeTo(invoker);
        d.setVisible(true);
        Integer opt = (Integer)this.editor.getClientProperty("ACTION_RESULT");
        return opt == null ? 0 : opt;
    }

    private JPanel getContent(JDialog dialog) {
        JLabel lbltitle = new JLabel();
        lbltitle.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
        lbltitle.setText(this.caption == null ? "" : this.caption);
        this.editor = new JTextField();
        this.editor.setText(this.value == null ? "" : this.value);
        this.editor.putClientProperty("ACTION_RESULT", 2);
        this.editor.setPreferredSize(new Dimension(200, 20));
        JPanel toppanel = new JPanel(new BorderLayout());
        toppanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        toppanel.add((Component)lbltitle, "North");
        toppanel.add((Component)this.editor, "South");
        Dimension dim = toppanel.getPreferredSize();
        toppanel.setPreferredSize(new Dimension(300, dim.height));
        JButton approveButton = this.getApproveButton(dialog);
        JPanel toolbar = new JPanel();
        toolbar.setLayout(new BoxLayout(toolbar, 0));
        toolbar.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
        toolbar.add(Box.createHorizontalGlue());
        toolbar.add((Component)approveButton, "West");
        toolbar.add(Box.createHorizontalStrut(5));
        toolbar.add((Component)this.getCancelButton(dialog), "East");
        toolbar.add(Box.createHorizontalGlue());
        JPanel bottompanel = new JPanel(new BorderLayout());
        bottompanel.add((Component)toolbar, "East");
        JPanel body = new JPanel(new BorderLayout());
        body.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        body.add((Component)toppanel, "North");
        body.add((Component)toolbar, "South");
        dialog.getRootPane().setDefaultButton(approveButton);
        return body;
    }

    private JButton getApproveButton(final JDialog dialog) {
        JButton btn = new JButton("  OK  ");
        btn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HtmlLinkDialog.this.editor.putClientProperty("ACTION_RESULT", 1);
                HtmlLinkDialog.this.setValue(HtmlLinkDialog.this.editor.getText());
                dialog.dispose();
            }
        });
        return btn;
    }

    private JButton getCancelButton(final JDialog dialog) {
        JButton btn = new JButton("Cancel");
        btn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HtmlLinkDialog.this.editor.putClientProperty("ACTION_RESULT", 2);
                HtmlLinkDialog.this.setValue(null);
                dialog.dispose();
            }
        });
        return btn;
    }
}

