/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.control.text;

import com.rameses.rcp.common.MsgBox;
import com.rameses.rcp.control.text.InputVerifierProxy;
import com.rameses.rcp.control.text.TextComponentSupport;
import com.rameses.rcp.support.FontSupport;
import com.rameses.rcp.support.ThemeUI;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.beans.Beans;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.InputVerifier;
import javax.swing.JButton;
import javax.swing.JRootPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.UIManager;

public class DefaultTextField
extends JTextField {
    public final String ACTION_MAPPING_KEY_ESCAPE = "ACTION_MAPPING_KEY_ESCAPE";
    public final String ACTION_MAPPING_KEY_ENTER = "ACTION_MAPPING_KEY_ENTER";
    private InputVerifierProxy inputVerifierProxy;
    private Color focusBackground;
    private Color disabledBackground;
    private Color enabledBackground;
    private boolean readonly;
    private String focusKeyStroke;
    private KeyStroke focusKeyStrokeObject;
    private String actionCommand;
    private String hint;
    private boolean inFocus;
    private Map<String, List<ActionListener>> actionMap;
    private String disableWhen;
    private String visibleWhen;
    private FontSupport fontSupport;
    private Font preferredFont;
    private Font sourceFont;
    private String fontStyle;

    public DefaultTextField() {
        this.initComponent();
    }

    private void initComponent() {
        TextComponentSupport.getInstance().installUIDefaults(this);
        this.setPreferredSize(new Dimension(100, 20));
        this.actionMap = new HashMap<String, List<ActionListener>>();
        this.initDefaults();
        InputMap inputMap = this.getInputMap(0);
        this.initActionKeys(inputMap, this.getActionMap());
        KeyStroke escKey = KeyStroke.getKeyStroke(27, 0);
        inputMap.put(escKey, "ACTION_MAPPING_KEY_ESCAPE");
        this.getActionMap().put("ACTION_MAPPING_KEY_ESCAPE", new EscapeActionSupport());
        if (this.isEnabledEnterActionSupport()) {
            KeyStroke enterKey = KeyStroke.getKeyStroke(10, 0);
            inputMap.put(enterKey, "ACTION_MAPPING_KEY_ENTER");
            this.getActionMap().put("ACTION_MAPPING_KEY_ENTER", new EnterActionSupport());
        }
        this.resetInputVerifierProxy();
        this.focusBackground = ThemeUI.getColor("XTextField.focusBackground");
        this.setActionCommand("");
        this.setDisabledTextColor(Color.decode("#303030"));
    }

    protected Map getFontAttributes() {
        return null;
    }

    protected void initDefaults() {
    }

    protected void initActionKeys(InputMap inputMap, ActionMap actionMap) {
    }

    protected boolean isEnabledEnterActionSupport() {
        return true;
    }

    protected InputVerifier getMainInputVerifier() {
        return null;
    }

    protected InputVerifier getChildInputVerifier() {
        return null;
    }

    public Color getFocusBackground() {
        return this.focusBackground;
    }

    public Color getDisabledBackground() {
        return this.disabledBackground;
    }

    public Color getEnabledBackground() {
        return this.enabledBackground;
    }

    @Override
    public Color getBackground() {
        Color newColor;
        if (Beans.isDesignTime()) {
            return super.getBackground();
        }
        Color bgcolor = null;
        boolean enabled = this.isEnabled();
        bgcolor = enabled ? (this.hasFocus() ? ((newColor = this.getFocusBackground()) == null ? this.enabledBackground : newColor) : this.enabledBackground) : this.disabledBackground;
        return bgcolor == null ? new Color(255, 255, 255) : bgcolor;
    }

    public boolean isReadonly() {
        return this.readonly;
    }

    public void setReadonly(boolean readonly) {
        if (!this.isEnabled()) {
            return;
        }
        this.readonly = readonly;
        this.setEditable(!readonly);
        super.firePropertyChange("editable", readonly, !readonly);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.setEditable(enabled ? !this.isReadonly() : enabled);
    }

    public String getFocusKeyStroke() {
        return this.focusKeyStroke;
    }

    public void setFocusKeyStroke(String focusKeyStroke) {
        this.focusKeyStroke = focusKeyStroke;
        KeyStroke oldKeyStroke = this.focusKeyStrokeObject;
        if (oldKeyStroke != null) {
            this.unregisterKeyboardAction(oldKeyStroke);
        }
        try {
            this.focusKeyStrokeObject = KeyStroke.getKeyStroke(focusKeyStroke);
        }
        catch (Throwable t) {
            this.focusKeyStrokeObject = null;
        }
        if (this.focusKeyStrokeObject != null) {
            ActionListener actionL = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DefaultTextField.this.invokeFocusAction(e);
                }
            };
            this.registerKeyboardAction(actionL, this.focusKeyStrokeObject, 2);
        }
    }

    public String getHint() {
        return this.hint;
    }

    public void setHint(String hint) {
        this.hint = hint;
    }

    public String getActionCommand() {
        return this.actionCommand;
    }

    @Override
    public void setActionCommand(String actionCommand) {
        this.actionCommand = actionCommand;
    }

    protected void resetInputVerifierProxy() {
        this.inputVerifierProxy = new InputVerifierProxy(this.getMainInputVerifier());
        this.inputVerifierProxy.setChild(this.getChildInputVerifier());
        super.setInputVerifier(this.inputVerifierProxy);
        super.putClientProperty(InputVerifierProxy.class, this.inputVerifierProxy);
    }

    @Override
    public final InputVerifier getInputVerifier() {
        return this.inputVerifierProxy;
    }

    @Override
    public final void setInputVerifier(InputVerifier verifier) {
        this.inputVerifierProxy.setEnabled(verifier != null);
    }

    public final InputVerifierProxy getInputVerifierProxy() {
        return this.inputVerifierProxy;
    }

    @Override
    protected final void processFocusEvent(FocusEvent e) {
        if (e.getID() == 1004) {
            this.inFocus = true;
            this.updateBackground();
            this.resetInputVerifierProxy();
            this.inputVerifierProxy.setEnabled(true);
            super.setInputVerifier(this.inputVerifierProxy);
            try {
                this.onfocusGained(e);
            }
            catch (Exception exception) {}
        } else if (e.getID() == 1005) {
            if (!e.isTemporary()) {
                this.inFocus = false;
                this.updateBackground();
            }
            try {
                this.onfocusLost(e);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.inputVerifierProxy.setEnabled(false);
        }
        super.processFocusEvent(e);
    }

    protected void updateBackground() {
        if (this.enabledBackground == null) {
            this.enabledBackground = UIManager.getLookAndFeelDefaults().getColor("TextField.background");
        }
        if (this.disabledBackground == null) {
            this.disabledBackground = UIManager.getLookAndFeelDefaults().getColor("TextField.disabledBackground");
        }
        Color newColor = this.getBackground();
        this.setBackground(newColor);
        this.repaint();
    }

    protected void onfocusGained(FocusEvent e) {
    }

    protected void onfocusLost(FocusEvent e) {
    }

    @Override
    public final void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
        if ("enableInputVerifier".equals(propertyName)) {
            this.inputVerifierProxy.setEnabled(newValue);
        } else if ("detachInputVerifier".equals(propertyName)) {
            super.setInputVerifier(newValue ? null : this.inputVerifierProxy);
        }
        this.onpropertyChange(propertyName, oldValue, newValue);
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    protected void onpropertyChange(String propertyName, boolean oldValue, boolean newValue) {
    }

    @Override
    protected void processKeyEvent(KeyEvent e) {
        this.onprocessKeyEvent(e);
        super.processKeyEvent(e);
    }

    protected void onprocessKeyEvent(KeyEvent e) {
    }

    private void invokeFocusAction(ActionEvent e) {
        if (this.isEnabled() && this.isFocusable()) {
            this.requestFocus();
        }
    }

    protected final boolean isInFocus() {
        return this.inFocus;
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        String hint = this.getHint();
        if (hint == null || hint.length() == 0) {
            return;
        }
        String text = this.getText();
        if (text == null || text.length() == 0) {
            if (this.inFocus) {
                return;
            }
            Color oldColor = g.getColor();
            Color newColor = new Color(150, 150, 150);
            g.setColor(newColor);
            g.drawString(hint, 0, 0);
            g.setColor(oldColor);
        }
    }

    public String getVisibleWhen() {
        return this.visibleWhen;
    }

    public void setVisibleWhen(String visibleWhen) {
        this.visibleWhen = visibleWhen;
    }

    public String getDisableWhen() {
        return this.disableWhen;
    }

    public void setDisableWhen(String disableWhen) {
        this.disableWhen = disableWhen;
    }

    private FontSupport getFontSupport() {
        if (this.fontSupport == null) {
            this.fontSupport = new FontSupport();
        }
        return this.fontSupport;
    }

    @Override
    public Font getFont() {
        return this.preferredFont;
    }

    @Override
    public void setFont(Font font) {
        this.sourceFont = font;
        this.preferredFont = this.getPreferredFont();
        super.setFont(this.preferredFont);
    }

    public String getFontStyle() {
        return this.fontStyle;
    }

    public void setFontStyle(String fontStyle) {
        this.fontStyle = fontStyle;
        this.preferredFont = this.getPreferredFont();
        super.setFont(this.preferredFont);
    }

    public Font getPreferredFont() {
        Font baseFont;
        Font font = baseFont = this.sourceFont == null ? super.getFont() : this.sourceFont;
        if (baseFont != null) {
            Map attrs = this.getFontSupport().createFontAttributes(this.getFontStyle());
            baseFont = this.getFontSupport().applyStyles(baseFont, attrs);
        }
        return baseFont;
    }

    public void addActionMapping(String actionMappingKey, ActionListener actionListener) {
        if (actionListener == null) {
            return;
        }
        List<ActionListener> listeners = this.actionMap.get(actionMappingKey);
        if (listeners == null) {
            listeners = new ArrayList<ActionListener>();
            this.actionMap.put(actionMappingKey, listeners);
        }
        if (!listeners.contains(actionListener)) {
            listeners.add(actionListener);
        }
    }

    public void removeActionMapping(String actionMappingKey, ActionListener actionListener) {
        if (actionListener == null) {
            return;
        }
        List<ActionListener> listeners = this.actionMap.get(actionMappingKey);
        if (listeners != null) {
            listeners.remove(actionListener);
        }
    }

    public void removeActionMapping(ActionListener actionListener) {
        if (actionListener == null) {
            return;
        }
        Collection<List<ActionListener>> values = this.actionMap.values();
        for (List<ActionListener> val : values) {
            val.remove(actionListener);
        }
    }

    public void removeActionMappings() {
        Collection<List<ActionListener>> values = this.actionMap.values();
        for (List<ActionListener> val : values) {
            val.clear();
        }
        this.actionMap.clear();
    }

    private class EnterActionSupport
    extends AbstractAction {
        DefaultTextField root;

        private EnterActionSupport() {
            this.root = DefaultTextField.this;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            List listeners = (List)this.root.actionMap.get(this.root.ACTION_MAPPING_KEY_ENTER);
            if (listeners != null) {
                for (ActionListener al : listeners) {
                    try {
                        al.actionPerformed(e);
                    }
                    catch (Throwable x) {
                        MsgBox.err(x);
                        return;
                    }
                }
            }
            if (listeners == null || listeners.isEmpty()) {
                JRootPane rootPane = this.root.getRootPane();
                if (rootPane == null) {
                    return;
                }
                JButton btn = rootPane.getDefaultButton();
                if (btn != null) {
                    btn.doClick();
                }
            }
        }
    }

    private class EscapeActionSupport
    extends AbstractAction {
        DefaultTextField root;

        private EscapeActionSupport() {
            this.root = DefaultTextField.this;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            List listeners = (List)this.root.actionMap.get(this.root.ACTION_MAPPING_KEY_ESCAPE);
            if (listeners != null) {
                for (ActionListener al : listeners) {
                    al.actionPerformed(e);
                }
            }
        }
    }
}

