/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.control.text;

import com.rameses.rcp.control.text.AbstractNumberDocument;
import com.rameses.rcp.control.text.DefaultTextField;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.text.Document;

public abstract class AbstractNumberField
extends DefaultTextField {
    private AbstractNumberDocument document;
    private boolean usePrimitiveValue;
    private boolean defaultFocus;

    protected abstract AbstractNumberDocument createDocument();

    @Override
    protected final void initDefaults() {
        this.document = this.createDocument();
        if (this.document == null) {
            throw new NullPointerException(this.getClass().getSimpleName() + " requires an AbstractNumberDocument");
        }
        super.setDocument(this.document);
        this.putClientProperty("TextField.font", this.getFont());
        this.setHorizontalAlignment(4);
        this.setPreferredSize(new Dimension(100, this.getPreferredSize().height));
        this.setFont(Font.decode("Monospaced--"));
        new ESCKeyAction().register(this);
        this.setMargin(new Insets(1, 2, 1, 4));
    }

    @Override
    protected InputVerifier getMainInputVerifier() {
        return this.document.getInputVerifier();
    }

    @Override
    public final void setDocument(Document doc) {
    }

    protected final AbstractNumberDocument getModel() {
        return this.document;
    }

    public boolean isUsePrimitiveValue() {
        return this.usePrimitiveValue;
    }

    public void setUsePrimitiveValue(boolean usePrimitiveValue) {
        this.usePrimitiveValue = usePrimitiveValue;
    }

    public boolean isDefaultFocus() {
        return this.defaultFocus;
    }

    public void setDefaultFocus(boolean defaultFocus) {
        this.defaultFocus = defaultFocus;
    }

    public double getMinValue() {
        return this.document.getMinValue();
    }

    public void setMinValue(double value) {
        this.document.setMinValue(value);
    }

    public double getMaxValue() {
        return this.document.getMaxValue();
    }

    public void setMaxValue(double value) {
        this.document.setMaxValue(value);
    }

    public String getFormat() {
        return this.document.getFormat();
    }

    public void setFormat(String format) {
        this.document.setFormat(format);
    }

    public Object getValue() {
        return this.getNumberValue();
    }

    public void setValue(Object value) {
        Number number = null;
        try {
            number = this.getModel().decode(value.toString());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setNumberValue((Number)value);
    }

    public Number getNumberValue() {
        return this.document.getValue();
    }

    public void setNumberValue(Number value) {
        this.document.setValue(value);
    }

    @Override
    protected void onfocusGained(FocusEvent e) {
        this.getModel().showFormattedText(false);
    }

    @Override
    protected void onfocusLost(FocusEvent e) {
        if (e.isTemporary()) {
            return;
        }
        this.getModel().showFormattedText(true);
    }

    protected void oncancelEditing() {
    }

    private class ESCKeyAction
    implements ActionListener {
        KeyStroke keyStroke = KeyStroke.getKeyStroke(27, 0, false);
        private JComponent component;
        private ActionListener origAction;

        ESCKeyAction() {
        }

        void register(JComponent component) {
            this.component = component;
            this.origAction = component.getActionForKeyStroke(this.keyStroke);
            component.registerKeyboardAction(this, this.keyStroke, 0);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AbstractNumberField.this.oncancelEditing();
        }
    }
}

