/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.control.text;

import java.beans.Beans;
import java.text.DecimalFormat;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;

public abstract class AbstractNumberDocument
extends PlainDocument {
    private AbstractNumberDocument self = this;
    private boolean validateEntry = true;
    private double minValue = -1.0;
    private double maxValue = -1.0;
    private DecimalFormat formatter;
    private String format;
    private CustomInputVerifier inputVerifier = new CustomInputVerifier(this);
    private Number value;
    private String stringValue;

    public AbstractNumberDocument() {
        this.setFormat("#,##0.00");
    }

    public abstract void refresh();

    public abstract Number decode(String var1);

    public abstract Number convertValue(Number var1);

    protected abstract Number getPrimitiveValue(Number var1);

    public InputVerifier getInputVerifier() {
        return this.inputVerifier;
    }

    public double getMinValue() {
        return this.minValue;
    }

    public void setMinValue(double minValue) {
        this.minValue = minValue;
    }

    public double getMaxValue() {
        return this.maxValue;
    }

    public void setMaxValue(double maxValue) {
        this.maxValue = maxValue;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
        this.formatter = this.format == null ? null : new DecimalFormat(this.format);
    }

    public final String getValueAsString() {
        return this.stringValue;
    }

    public Number getValue() {
        return this.value;
    }

    public void setValue(Number value) {
        this.value = value;
        String string = this.stringValue = value != null ? value.toString() : null;
        if (value != null) {
            try {
                Number num = this.convertValue(value);
                String text = num == null ? "" : num.toString();
                super.remove(0, this.getLength());
                super.insertString(0, text, null);
                this.stringValue = num == null ? null : num.toString();
                this.value = num;
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception ex) {
                throw new RuntimeException(ex.getMessage(), ex);
            }
        }
        try {
            super.remove(0, this.getLength());
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public void setValue(String text) {
        try {
            super.remove(0, this.getLength());
            this.insertString(0, text, null);
        }
        catch (BadLocationException ex) {
            this.stringValue = null;
            this.value = null;
        }
    }

    @Override
    public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
        if (Beans.isDesignTime()) {
            super.insertString(offs, str, a);
            return;
        }
        if (!this.validateEntry) {
            super.insertString(offs, str, a);
            this.validateEntry = true;
            return;
        }
        StringBuffer sb = new StringBuffer(this.getText(0, this.getLength()));
        sb.insert(offs, str);
        if (sb.toString().equals("-")) {
            super.insertString(offs, str, a);
            this.stringValue = null;
            this.value = null;
        } else {
            String text = sb.toString();
            if (text.equals("-.")) {
                sb.insert(1, "0");
            } else if (text.equals(".")) {
                sb.insert(0, "0");
            }
            Number num = this.decode(sb.toString());
            if (num != null) {
                super.insertString(offs, str, a);
                if (text.equals("-.") || text.equals(".")) {
                    super.insertString(offs, "0", a);
                }
                this.stringValue = sb.toString();
                this.value = num;
            }
        }
    }

    @Override
    public void remove(int offs, int len) throws BadLocationException {
        StringBuffer sb = new StringBuffer(this.getText(0, this.getLength()));
        sb.delete(offs, offs + len);
        if (sb.length() == 0) {
            super.remove(offs, len);
            this.stringValue = null;
            this.value = null;
        } else {
            Number num = this.decode(sb.toString());
            super.remove(offs, len);
            this.stringValue = sb.toString();
            this.value = num;
        }
    }

    protected boolean isInRange(Number value) {
        try {
            this.inputVerifier.checkRange(value);
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    protected String formatValue(Number value) {
        if (value == null) {
            return null;
        }
        if (this.formatter == null) {
            return value.toString();
        }
        String pattern = this.getFormat();
        if (pattern == null || pattern.trim().length() == 0) {
            return value.toString();
        }
        DecimalFormat formatter = new DecimalFormat(pattern);
        return formatter.format(value);
    }

    public final void showFormattedText(boolean show) {
        try {
            super.remove(0, this.getLength());
            Number num = this.getValue();
            if (num == null) {
                return;
            }
            if (show) {
                String snum = this.formatValue(num);
                super.insertString(0, snum, null);
            } else {
                super.insertString(0, num.toString(), null);
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    private void finalizeValue() {
        try {
            if (this.value == null) {
                return;
            }
            Number num = this.convertValue(this.value);
            String snum = this.formatValue(num);
            super.remove(0, this.getLength());
            super.insertString(0, snum, null);
            this.stringValue = snum;
            this.value = num;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private class CustomInputVerifier
    extends InputVerifier {
        public CustomInputVerifier(AbstractNumberDocument document) {
        }

        @Override
        public boolean verify(JComponent input) {
            JTextComponent jtc = (JTextComponent)input;
            if (!jtc.isEnabled()) {
                return true;
            }
            if (!jtc.isEditable()) {
                return true;
            }
            Number num = AbstractNumberDocument.this.self.value;
            if (num != null) {
                try {
                    this.checkRange(num);
                }
                catch (Exception ex) {
                    input.putClientProperty("Verification-Error", ex.getMessage());
                    return false;
                }
            } else if (jtc.getText() != null && jtc.getText().length() > 0) {
                jtc.setText("");
            }
            input.putClientProperty("Verification-Error", null);
            AbstractNumberDocument.this.self.finalizeValue();
            return true;
        }

        public void checkRange(Number num) throws Exception {
            if (num == null) {
                return;
            }
            double dv = num.doubleValue();
            if (AbstractNumberDocument.this.self.minValue >= 0.0 && AbstractNumberDocument.this.self.maxValue >= 0.0) {
                if (!(dv >= AbstractNumberDocument.this.self.minValue) || !(dv <= AbstractNumberDocument.this.self.maxValue)) {
                    throw new Exception("The value entered must be between " + AbstractNumberDocument.this.self.minValue + " and " + AbstractNumberDocument.this.self.maxValue);
                }
            } else {
                if (AbstractNumberDocument.this.self.minValue >= 0.0 && dv < AbstractNumberDocument.this.self.minValue) {
                    throw new Exception("The value entered must be greater than or equal to " + AbstractNumberDocument.this.self.minValue);
                }
                if (AbstractNumberDocument.this.self.maxValue >= 0.0 && dv > AbstractNumberDocument.this.self.maxValue) {
                    throw new Exception("The value entered must be less than or equal to " + AbstractNumberDocument.this.self.maxValue);
                }
            }
        }
    }
}

