/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.control.table;

import com.rameses.rcp.common.AbstractListDataProvider;
import com.rameses.rcp.common.MsgBox;
import com.rameses.rcp.common.PropertySupport;
import com.rameses.rcp.control.table.DataTableBinding;
import com.rameses.rcp.control.table.DataTableModel;
import com.rameses.rcp.control.table.ImmediateCellEditor;
import com.rameses.rcp.control.table.SelectionCellUtil;
import com.rameses.rcp.framework.Binding;
import com.rameses.rcp.framework.ClientContext;
import com.rameses.rcp.ui.UIInput;
import com.rameses.rcp.util.UIControlUtil;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.util.Map;
import javax.swing.JCheckBox;

public class SelectionCellEditor
extends JCheckBox
implements UIInput,
ImmediateCellEditor {
    private ItemHandler itemHandler;
    private Binding binding;
    private int stretchWidth;
    private int stretchHeight;
    private String visibleWhen;

    public SelectionCellEditor() {
        this.setHorizontalAlignment(0);
        this.setBorderPainted(true);
        this.itemHandler = new ItemHandler();
        this.addItemListener(this.itemHandler);
    }

    @Override
    public Object getValue() {
        return null;
    }

    @Override
    public void setValue(Object value) {
        KeyEvent ke;
        if (value instanceof KeyEvent && (ke = (KeyEvent)value).getKeyCode() != 32) {
            return;
        }
        this.refresh();
        this.setSelected(!this.isSelected());
    }

    @Override
    public boolean isNullWhenEmpty() {
        return false;
    }

    @Override
    public boolean isImmediate() {
        return true;
    }

    @Override
    public boolean isReadonly() {
        return false;
    }

    @Override
    public void setReadonly(boolean readonly) {
    }

    @Override
    public void setRequestFocus(boolean focus) {
    }

    @Override
    public String[] getDepends() {
        return null;
    }

    @Override
    public int getIndex() {
        return 0;
    }

    @Override
    public Binding getBinding() {
        return this.binding;
    }

    @Override
    public void setBinding(Binding binding) {
        this.binding = binding;
    }

    public int compareTo(Object o) {
        return UIControlUtil.compare(this, o);
    }

    @Override
    public void setPropertyInfo(PropertySupport.PropertyInfo info) {
    }

    @Override
    public void load() {
    }

    @Override
    public void refresh() {
        try {
            this.itemHandler.enabled = false;
            this.setSelected(this.itemHandler.isItemMatches());
        }
        catch (Exception e) {
            if (ClientContext.getCurrentContext().isDebugMode()) {
                e.printStackTrace();
            }
        }
        finally {
            this.itemHandler.enabled = true;
        }
    }

    public Map getInfo() {
        return null;
    }

    @Override
    public int getStretchWidth() {
        return this.stretchWidth;
    }

    @Override
    public void setStretchWidth(int stretchWidth) {
        this.stretchWidth = stretchWidth;
    }

    @Override
    public int getStretchHeight() {
        return this.stretchHeight;
    }

    @Override
    public void setStretchHeight(int stretchHeight) {
        this.stretchHeight = stretchHeight;
    }

    @Override
    public String getVisibleWhen() {
        return this.visibleWhen;
    }

    @Override
    public void setVisibleWhen(String visibleWhen) {
        this.visibleWhen = visibleWhen;
    }

    DataTableBinding getTableBinding() {
        return (DataTableBinding)this.getBinding();
    }

    DataTableModel getTableModel() {
        return this.getTableBinding().getTableModel();
    }

    AbstractListDataProvider.ListSelectionSupport getSelectionSupport() {
        return this.getTableModel().getDataProvider().getSelectionSupport();
    }

    private class ItemHandler
    implements ItemListener {
        private SelectionCellUtil cellUtil = SelectionCellUtil.newInstance();
        private boolean enabled = true;

        private ItemHandler() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (!this.enabled) {
                return;
            }
            try {
                boolean value = e.getStateChange() == 1;
                DataTableBinding tableBinding = (DataTableBinding)SelectionCellEditor.this.binding;
                tableBinding.getTableModel().setValueAt(value, tableBinding.getRowIndex(), tableBinding.getColumnIndex());
            }
            catch (Exception ex) {
                MsgBox.err(ex);
            }
        }

        boolean isItemMatches() {
            DataTableBinding tableBinding = SelectionCellEditor.this.getTableBinding();
            Object itemData = SelectionCellEditor.this.getTableModel().getDataProvider().getListItemData(tableBinding.getRowIndex());
            return SelectionCellEditor.this.getSelectionSupport().isItemChecked(itemData);
        }
    }
}

