/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.control.table;

import com.rameses.rcp.control.table.CellRenderers;
import com.rameses.rcp.control.table.TableBorders;
import com.rameses.rcp.support.ColorUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.SystemColor;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.border.AbstractBorder;
import javax.swing.table.JTableHeader;

public class DataTableHeader
extends JTableHeader {
    private JTable table;
    private AbstractBorder border;
    private Color control = SystemColor.control;

    public DataTableHeader(JTable table) {
        super(table.getColumnModel());
        this.table = table;
        this.border = new CellRenderers.HeaderBorder();
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g.create();
        this.border.paintBorder(this, g2, 0, 0, this.getWidth(), this.getHeight());
        g2.dispose();
    }

    public static class CornerBorder
    extends AbstractBorder {
        private JTable table;
        private String cornerType;
        private Color color;

        public CornerBorder(JTable table, String cornerType) {
            this.table = table;
            this.cornerType = cornerType;
        }

        public CornerBorder(Color color, String cornerType) {
            this.color = color;
            this.cornerType = cornerType;
        }

        public JComponent createComponent() {
            JLabel lbl = new JLabel("");
            lbl.setBorder(new TableBorders.HeaderBorder(true, true, false, true));
            return lbl;
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return this.getBorderInsets(c, new Insets(0, 0, 0, 0));
        }

        @Override
        public Insets getBorderInsets(Component c, Insets insets) {
            return new Insets(0, 0, 0, 0);
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            Color preferredColor = this.color;
            if (preferredColor == null && this.table != null) {
                preferredColor = this.table.getGridColor();
            }
            if (preferredColor == null) {
                return;
            }
            Color oldColor = g.getColor();
            g.setColor(preferredColor);
            if ("UPPER_LEFT_CORNER".equals(this.cornerType)) {
                g.drawRect(-1, -1, w, h);
            } else if ("UPPER_RIGHT_CORNER".equals(this.cornerType)) {
                g.drawRect(-1, 0, w, h - 1);
            } else {
                g.drawRect(-1, -1, w + 1, h + 1);
            }
            g.setColor(oldColor);
        }
    }

    public static class CustomBorder
    extends AbstractBorder {
        private JTable table;
        private Insets margin;

        public CustomBorder(JTable table) {
            this(table, null);
        }

        public CustomBorder(JTable table, Insets margin) {
            this.table = table;
            this.margin = margin == null ? new Insets(0, 0, 0, 0) : margin;
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return this.getBorderInsets(c, this.margin);
        }

        @Override
        public Insets getBorderInsets(Component c, Insets insets) {
            return this.margin;
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            Color color = this.table.getGridColor();
            if (color == null) {
                return;
            }
            Color oldColor = g.getColor();
            g.setColor(color);
            g.drawRect(-1, -1, w, h);
            g.setColor(oldColor);
        }
    }

    public static class Painter {
        public void paint(JComponent comp, Graphics g, int x, int y, int w, int h) {
            Graphics2D g2 = (Graphics2D)g.create();
            Color bg = Color.LIGHT_GRAY;
            GradientPaint gp = new GradientPaint(0.0f, 0.0f, ColorUtil.brighter(bg, 30), 0.0f, (h - 1) / 2, ColorUtil.brighter(bg, 15));
            g2.setPaint(gp);
            g2.fillRect(x, y, w, h - 1);
            g2.dispose();
        }
    }
}

