/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.control.table;

import com.rameses.common.ExpressionResolver;
import com.rameses.common.MethodResolver;
import com.rameses.rcp.common.AbstractListDataProvider;
import com.rameses.rcp.common.AbstractListModel;
import com.rameses.rcp.common.Action;
import com.rameses.rcp.common.ButtonColumnHandler;
import com.rameses.rcp.common.CheckBoxColumnHandler;
import com.rameses.rcp.common.Column;
import com.rameses.rcp.common.EditorListSupport;
import com.rameses.rcp.common.ListItem;
import com.rameses.rcp.common.ListPageModel;
import com.rameses.rcp.common.MsgBox;
import com.rameses.rcp.common.Opener;
import com.rameses.rcp.common.PropertyChangeHandler;
import com.rameses.rcp.common.StyleRule;
import com.rameses.rcp.common.TableModelHandler;
import com.rameses.rcp.control.XCheckBox;
import com.rameses.rcp.control.table.CellRenderers;
import com.rameses.rcp.control.table.ColumnHandlerUtil;
import com.rameses.rcp.control.table.DataTableBinding;
import com.rameses.rcp.control.table.DataTableHeader;
import com.rameses.rcp.control.table.DataTableModel;
import com.rameses.rcp.control.table.DataTableModelDesignTime;
import com.rameses.rcp.control.table.ExprBeanSupport;
import com.rameses.rcp.control.table.ImmediateCellEditor;
import com.rameses.rcp.control.table.SelectionCellEditor;
import com.rameses.rcp.control.table.SelectionCellRenderer;
import com.rameses.rcp.control.table.SelectionColumnHandler;
import com.rameses.rcp.control.table.TableColumnValidator;
import com.rameses.rcp.control.table.TableControl;
import com.rameses.rcp.control.table.TableListener;
import com.rameses.rcp.control.table.TableUtil;
import com.rameses.rcp.framework.Binding;
import com.rameses.rcp.framework.ChangeLog;
import com.rameses.rcp.framework.ClientContext;
import com.rameses.rcp.ui.UIControl;
import com.rameses.rcp.ui.UIInput;
import com.rameses.rcp.ui.UILookup;
import com.rameses.rcp.ui.Validatable;
import com.rameses.rcp.util.ActionMessage;
import com.rameses.rcp.util.UICommandUtil;
import com.rameses.rcp.util.UIControlUtil;
import com.rameses.rcp.util.UIInputUtil;
import com.rameses.util.ValueUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.beans.Beans;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.InputVerifier;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TableModelEvent;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.swing.text.JTextComponent;

public class DataTableComponent
extends JTable
implements TableControl {
    private static final String COLUMN_POINT = "COLUMN_POINT";
    private Map<Integer, JComponent> editors = new HashMap<Integer, JComponent>();
    private DataTableBinding itemBinding = new DataTableBinding();
    private DataTableModel tableModel;
    private TableListener tableListener;
    private ListPageModel pageModel;
    private EditorListSupport editorSupport;
    private AbstractListDataProvider dataProvider;
    private PropertyChangeHandlerImpl propertyHandler;
    private TableModelHandlerImpl tableModelHandler;
    private String multiSelectName;
    private String varName = "item";
    private String varStatus;
    private String id;
    private int editingRow = -1;
    private boolean readonly;
    private boolean required;
    private boolean editingMode;
    private boolean editorBeanLoaded;
    private boolean rowCommited = true;
    private boolean processingRequest;
    private JComponent currentEditor;
    private KeyEvent currentKeyEvent;
    private ListItem previousItem;
    private Color evenBackground;
    private Color oddBackground;
    private Color errorBackground = Color.PINK;
    private Color evenForeground;
    private Color oddForeground;
    private Color errorForeground = Color.BLACK;
    private Binding binding;
    private JLabel lblProcessing;
    private boolean fetching;
    private int rowHeaderHeight = -1;
    private CellContext cellContext;

    public DataTableComponent() {
        this.initComponents();
    }

    private void initComponents() {
        super.setSelectionMode(0);
        this.propertyHandler = new PropertyChangeHandlerImpl();
        this.tableModelHandler = new TableModelHandlerImpl();
        this.tableModel = new DataTableModel();
        this.attachTableHeader();
        this.addKeyListener(new TableKeyAdapter());
        int cond = 1;
        KeyStroke enter = KeyStroke.getKeyStroke(10, 0);
        this.getInputMap(cond).put(enter, "selectNextColumnCell");
        KeyStroke shiftEnter = KeyStroke.getKeyStroke(10, 1);
        this.getInputMap(cond).put(shiftEnter, "selectPreviousColumnCell");
        new TableEnterAction().install(this);
        new TableEscapeAction().install(this);
        KeyStroke ctrlZ = KeyStroke.getKeyStroke("ctrl Z");
        this.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!DataTableComponent.this.rowCommited) {
                    ChangeLog log = DataTableComponent.this.itemBinding.getChangeLog();
                    if (log.hasChanges()) {
                        DataTableComponent.this.undo();
                    }
                    if (!log.hasChanges()) {
                        DataTableComponent.this.rowCommited = true;
                        DataTableComponent.this.oncancelRowEdit();
                    }
                }
            }
        }, ctrlZ, 0);
        this.addComponentListener(new ComponentListener(){

            @Override
            public void componentHidden(ComponentEvent e) {
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentShown(ComponentEvent e) {
            }

            @Override
            public void componentResized(ComponentEvent e) {
                if (DataTableComponent.this.currentEditor == null) {
                    return;
                }
                Point colPoint = (Point)DataTableComponent.this.currentEditor.getClientProperty(DataTableComponent.COLUMN_POINT);
                Rectangle bounds = DataTableComponent.this.getCellRect(colPoint.y, colPoint.x, false);
                DataTableComponent.this.currentEditor.setBounds(bounds);
                DataTableComponent.this.currentEditor.requestFocus();
                DataTableComponent.this.currentEditor.grabFocus();
            }
        });
        this.addMouseListener(new PopupMenuAdapter());
    }

    public void attachTableHeader() {
        DataTableHeader header = new DataTableHeader(this);
        this.setTableHeader(header);
        header.setReorderingAllowed(false);
        header.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Point point = e.getPoint();
                if (point == null) {
                    return;
                }
                int colIndex = DataTableComponent.this.columnAtPoint(point);
            }
        });
    }

    protected void uninstall(AbstractListDataProvider dataProvider) {
    }

    protected void install(AbstractListDataProvider dataProvider) {
    }

    @Override
    public AbstractListDataProvider getDataProvider() {
        return this.dataProvider;
    }

    public void setDataProvider(AbstractListDataProvider dataProvider) {
        EditorListSupport oldEditorSupport;
        if (Beans.isDesignTime()) {
            Column[] columns = dataProvider == null ? null : dataProvider.getColumns();
            DataTableModelDesignTime dtm = new DataTableModelDesignTime(columns);
            this.setModel(dtm);
            dtm.applyColumnAttributes(this);
            return;
        }
        AbstractListDataProvider oldDataProvider = this.dataProvider;
        if (oldDataProvider != null) {
            oldDataProvider.removeHandler(this.propertyHandler);
            oldDataProvider.removeHandler(this.tableModelHandler);
            oldDataProvider.setUIProvider(null);
            this.uninstall(oldDataProvider);
        }
        if ((oldEditorSupport = this.editorSupport) != null) {
            oldEditorSupport.setTableEditorProvider(null);
        }
        this.cellContext = new CellContext();
        this.dataProvider = dataProvider;
        this.editorSupport = null;
        this.pageModel = null;
        if (this.dataProvider != null) {
            this.dataProvider.addHandler(this.propertyHandler);
        }
        if (dataProvider instanceof ListPageModel) {
            this.pageModel = (ListPageModel)((Object)dataProvider);
        }
        if (dataProvider instanceof EditorListSupport.TableEditor) {
            this.editorSupport = EditorListSupport.create(dataProvider);
        }
        if (this.tableModel != null) {
            this.tableModel.dispose();
        }
        Object bindingBean = this.getBinding() == null ? null : this.getBinding().getBean();
        this.tableModel = new DataTableModel();
        this.tableModel.setBindingBean(bindingBean);
        this.tableModel.setDataProvider(dataProvider);
        this.tableModel.setEditorListSupport(this.editorSupport);
        if (dataProvider != null) {
            dataProvider.addHandler(this.tableModelHandler);
            dataProvider.setUIProvider(new DefaultUIProvider());
            if (this.editorSupport != null) {
                this.editorSupport.setTableEditorProvider(new TableEditorProviderImpl());
            }
            this.install(dataProvider);
            if (this.isAutoResize() && dataProvider.isAutoResize()) {
                this.setAutoResizeMode(2);
            } else {
                this.setAutoResizeMode(0);
            }
        }
        this.itemBinding.setRoot(this.getBinding());
        this.tableModel.setBinding(this.itemBinding);
        this.initDataTableModel();
        this.setModel(this.tableModel);
        this.buildColumns();
        this.onTableModelChanged(this.tableModel);
    }

    public DataTableModel getDataTableModel() {
        return this.tableModel;
    }

    public boolean isProcessingRequest() {
        return this.processingRequest || this.fetching;
    }

    private void initDataTableModel() {
        if (this.tableModel == null) {
            return;
        }
        this.tableModel.setId(this.getId());
        this.tableModel.setVarName(this.getVarName());
        this.tableModel.setVarStatus(this.getVarStatus());
        this.tableModel.setMultiSelectName(this.getMultiSelectName());
    }

    @Override
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
        DataTableModel dtm = this.getDataTableModel();
        if (dtm != null) {
            dtm.setId(id);
        }
    }

    @Override
    public String getVarName() {
        return this.varName;
    }

    public void setVarName(String varName) {
        this.varName = varName;
        this.getDataTableModel().setVarName(varName);
    }

    public String getVarStatus() {
        return this.varStatus;
    }

    public void setVarStatus(String varStatus) {
        this.varStatus = varStatus;
        this.getDataTableModel().setVarStatus(varStatus);
    }

    public String getMultiSelectName() {
        return this.multiSelectName;
    }

    public void setMultiSelectName(String multiSelectName) {
        this.multiSelectName = multiSelectName;
        this.getDataTableModel().setMultiSelectName(multiSelectName);
    }

    public void setBinding(Binding binding) {
        this.binding = binding;
    }

    @Override
    public Binding getBinding() {
        return this.binding;
    }

    @Override
    public Binding getItemBinding() {
        return this.itemBinding;
    }

    public void setListener(TableListener listener) {
        this.tableListener = listener;
    }

    public boolean isRequired() {
        return this.required;
    }

    public boolean isEditingMode() {
        return this.editingMode;
    }

    public boolean isAutoResize() {
        return this.getAutoResizeMode() != 0;
    }

    public void setAutoResize(boolean autoResize) {
        if (autoResize) {
            this.setAutoResizeMode(2);
        } else {
            this.setAutoResizeMode(0);
        }
    }

    public boolean isReadonly() {
        return this.readonly;
    }

    public void setReadonly(boolean readonly) {
        this.readonly = readonly;
    }

    @Override
    public Color getEvenBackground() {
        return this.evenBackground;
    }

    public void setEvenBackground(Color evenBackground) {
        this.evenBackground = evenBackground;
    }

    @Override
    public Color getOddBackground() {
        return this.oddBackground;
    }

    public void setOddBackground(Color oddBackground) {
        this.oddBackground = oddBackground;
    }

    @Override
    public Color getErrorBackground() {
        return this.errorBackground;
    }

    public void setErrorBackground(Color errorBackground) {
        this.errorBackground = errorBackground;
    }

    @Override
    public Color getEvenForeground() {
        return this.evenForeground;
    }

    public void setEvenForeground(Color evenForeground) {
        this.evenForeground = evenForeground;
    }

    @Override
    public Color getOddForeground() {
        return this.oddForeground;
    }

    public void setOddForeground(Color oddForeground) {
        this.oddForeground = oddForeground;
    }

    @Override
    public Color getErrorForeground() {
        return this.errorForeground;
    }

    public void setErrorForeground(Color errorForeground) {
        this.errorForeground = errorForeground;
    }

    @Override
    public void setRowHeight(int rowHeight) {
        super.setRowHeight(rowHeight);
        this.setRowHeaderHeight(rowHeight);
    }

    public int getRowHeaderHeight() {
        return this.rowHeaderHeight;
    }

    public void setRowHeaderHeight(int rowHeaderHeight) {
        this.rowHeaderHeight = rowHeaderHeight;
    }

    public boolean hasRowHeader() {
        return false;
    }

    private void buildColumns() {
        this.removeAll();
        this.editors.clear();
        this.required = false;
        ColumnHandlerUtil handlerUtil = ColumnHandlerUtil.newInstance();
        int length = this.tableModel.getColumnCount();
        for (int i = 0; i < length; ++i) {
            JComponent editor;
            Column col = this.tableModel.getColumn(i);
            TableCellRenderer cellRenderer = TableUtil.getCellRenderer(col);
            handlerUtil.prepare(col);
            TableColumn tableCol = this.getColumnModel().getColumn(i);
            tableCol.setCellRenderer(cellRenderer);
            this.applyColumnProperties(tableCol, col);
            if (!ValueUtil.isEmpty((Object)col.getEditableWhen())) {
                col.setEditable(true);
            }
            if (!col.isEditable() || this.editors.containsKey(i) || (editor = TableUtil.createCellEditor(col)) == null) continue;
            if (!(editor instanceof UIControl)) {
                System.out.println("Column editor must be an instance of UIControl ");
                continue;
            }
            editor.setVisible(false);
            editor.setName(col.getName());
            editor.setBounds(-10, -10, 10, 10);
            editor.putClientProperty(JTable.class, true);
            editor.putClientProperty(Binding.class, this.getBinding());
            editor.putClientProperty(UIInputUtil.Support.class, new EditorInputSupport());
            editor.putClientProperty(Validatable.class, new TableColumnValidator(this.itemBinding, col));
            editor.addFocusListener(new EditorFocusSupport());
            this.addKeyboardAction(editor, 10, true);
            this.addKeyboardAction(editor, 9, true);
            this.addKeyboardAction(editor, 27, false);
            UIControl uicomp = (UIControl)((Object)editor);
            uicomp.setBinding(this.itemBinding);
            this.itemBinding.register(uicomp);
            if (editor instanceof Validatable) {
                Validatable vi = (Validatable)((Object)editor);
                vi.setRequired(col.isRequired());
                vi.setCaption(col.getCaption());
                if (vi.isRequired()) {
                    this.required = true;
                }
            }
            this.editors.put(i, editor);
            this.add(editor);
        }
        this.itemBinding.setOwner(this.binding.getOwner());
        this.itemBinding.setViewContext(this.binding.getViewContext());
        this.itemBinding.init();
    }

    public void rebuildColumns() {
        this.tableModel = new DataTableModel();
        this.tableModel.setDataProvider(this.dataProvider);
        this.tableModel.setEditorListSupport(this.editorSupport);
        this.tableModel.setVarName(this.getVarName());
        this.tableModel.setVarStatus(this.getVarStatus());
        this.tableModel.setMultiSelectName(this.getMultiSelectName());
        this.setModel(this.tableModel);
        this.buildColumns();
        this.onTableModelChanged(this.tableModel);
    }

    protected void onTableModelChanged(DataTableModel tableModel) {
    }

    private void addKeyboardAction(JComponent comp, int key, boolean commit) {
        EditorKeyBoardAction kba = new EditorKeyBoardAction(comp, key, commit);
        comp.registerKeyboardAction(kba, kba.keyStroke, 0);
    }

    private void applyColumnProperties(TableColumn tc, Column c) {
        if (c.getMaxWidth() > 0) {
            tc.setMaxWidth(c.getMaxWidth());
        }
        if (c.getMinWidth() > 0) {
            tc.setMinWidth(c.getMinWidth());
        }
        if (c.getWidth() > 0) {
            tc.setWidth(c.getWidth());
            tc.setPreferredWidth(c.getWidth());
        }
        tc.setResizable(c.isResizable());
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.dataProvider != null && this.fetching) {
            if (this.lblProcessing == null) {
                this.lblProcessing = new JLabel("<html><h1>Loading...</h1></html>");
                this.lblProcessing.setForeground(Color.GRAY);
                this.lblProcessing.setVerticalAlignment(1);
                this.lblProcessing.setBorder(new EmptyBorder(5, 10, 10, 10));
            }
            Rectangle rec = this.getVisibleRect();
            Graphics g2 = g.create();
            g2.translate(rec.x, rec.y);
            this.lblProcessing.setSize(rec.width, rec.height);
            this.lblProcessing.paint(g2);
            g2.dispose();
        }
    }

    @Override
    public void setTableHeader(JTableHeader tableHeader) {
        super.setTableHeader(tableHeader);
        tableHeader = this.getTableHeader();
        if (tableHeader == null) {
            return;
        }
        tableHeader.setDefaultRenderer(new CellRenderers.HeaderRenderer());
        tableHeader.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent me) {
                if (DataTableComponent.this.currentEditor == null) {
                    return;
                }
                Point p = new Point(me.getX(), me.getY());
                int colIndex = DataTableComponent.this.columnAtPoint(p);
                if (colIndex < 0) {
                    return;
                }
                Point colPoint = (Point)DataTableComponent.this.currentEditor.getClientProperty(DataTableComponent.COLUMN_POINT);
                if (colPoint.x - 1 == colIndex || colPoint.x == colIndex || colPoint.x + 1 == colIndex) {
                    Rectangle bounds = DataTableComponent.this.getCellRect(colPoint.y, colPoint.x, false);
                    DataTableComponent.this.currentEditor.setBounds(bounds);
                    DataTableComponent.this.currentEditor.requestFocus();
                    DataTableComponent.this.currentEditor.grabFocus();
                } else {
                    DataTableComponent.this.hideEditor(false);
                }
            }
        });
    }

    protected void onopenItem() {
    }

    private void openItem() {
        if (this.processingRequest) {
            return;
        }
        try {
            this.processingRequest = true;
            this.onopenItem();
        }
        catch (Exception ex) {
            MsgBox.err(ex);
        }
        finally {
            this.processingRequest = false;
        }
    }

    protected void onprocessMouseEvent(MouseEvent me) {
    }

    @Override
    protected void processMouseEvent(MouseEvent me) {
        if (this.processingRequest) {
            return;
        }
        if (me.getID() == 500) {
            if (me.getClickCount() == 1) {
                TableCellRenderer renderer;
                int colIndex = this.getSelectedColumn();
                if (colIndex >= 0 && colIndex < this.getColumnCount() && (renderer = this.getColumnModel().getColumn(colIndex).getCellRenderer()) instanceof CellRenderers.ActionColumnHandler) {
                    CellRenderers.ActionColumnHandler ach = (CellRenderers.ActionColumnHandler)((Object)renderer);
                    Column colObj = this.getDataTableModel().getColumn(colIndex);
                    Object rowObj = this.getDataTableModel().getItem(this.getSelectedRow());
                    ActionColumnInvoker aci = new ActionColumnInvoker(ach, colObj, rowObj);
                    EventQueue.invokeLater(aci);
                    me.consume();
                    return;
                }
            } else if (me.getClickCount() == 2) {
                boolean b;
                Point p = new Point(me.getX(), me.getY());
                int colIndex = this.columnAtPoint(p);
                Column dc = this.tableModel.getColumn(colIndex);
                int rowIndex = this.getSelectedRow();
                Object rowObj = this.getDataTableModel().getItem(rowIndex);
                boolean _editable = this.getDataProvider().isColumnEditable(rowObj, dc.getName());
                if (_editable) {
                    _editable = dc.isEditable();
                }
                if (b = "false".equals(dc.getProperties().get("_allowEdit"))) {
                    _editable = false;
                }
                if (dc != null && !_editable) {
                    me.consume();
                    this.openItem();
                    return;
                }
            }
        }
        this.onprocessMouseEvent(me);
        if (!me.isConsumed()) {
            super.processMouseEvent(me);
        }
    }

    @Override
    public boolean editCellAt(int rowIndex, int colIndex, EventObject e) {
        TableCellRenderer renderer = this.getColumnModel().getColumn(colIndex).getCellRenderer();
        if (renderer instanceof SelectionCellRenderer && this.isSpaceBarKey(e)) {
            if (!this.tableModel.getDataProvider().isMultiSelect()) {
                return false;
            }
            Object itemdata = this.tableModel.getItem(rowIndex);
            if (itemdata == null) {
                return false;
            }
            boolean o = !this.tableModel.getDataProvider().getSelectionSupport().isItemChecked(itemdata);
            this.tableModel.setValueAt(o, rowIndex, colIndex);
            return false;
        }
        if (renderer instanceof CellRenderers.ActionColumnHandler) {
            if (this.isSpaceBarKey(e)) {
                CellRenderers.ActionColumnHandler ach = (CellRenderers.ActionColumnHandler)((Object)renderer);
                Column colObj = this.getDataTableModel().getColumn(colIndex);
                Object rowObj = this.getDataTableModel().getItem(rowIndex);
                EventQueue.invokeLater(new ActionColumnInvoker(ach, colObj, rowObj));
            }
            return false;
        }
        if (this.isReadonly()) {
            return false;
        }
        Column oColumn = this.tableModel.getColumn(colIndex);
        if (oColumn == null) {
            return false;
        }
        if (oColumn.getTypeHandler() instanceof SelectionColumnHandler) {
            if (!this.dataProvider.isMultiSelect()) {
                return false;
            }
            if (this.dataProvider.getListItemData(rowIndex) == null) {
                return false;
            }
            JComponent editor = this.editors.get(colIndex);
            if (editor != null) {
                this.showEditor(editor, rowIndex, colIndex, e);
            }
            return false;
        }
        if (this.editorSupport == null) {
            return false;
        }
        if (e instanceof MouseEvent) {
            MouseEvent me = (MouseEvent)e;
            if (SwingUtilities.isLeftMouseButton(me)) {
                if (me.getClickCount() != 2 && !(oColumn.getTypeHandler() instanceof CheckBoxColumnHandler)) {
                    return false;
                }
            } else {
                return false;
            }
        }
        boolean columnEditable = true;
        StyleRule[] rules = this.getBinding().getStyleRules();
        if (rules != null && this.getId() != null) {
            String qname = this.getId() + ":" + this.getVarName() + "." + oColumn.getName();
            Object itemData = this.editorSupport.getSource().getListItemData(rowIndex);
            for (StyleRule r : rules) {
                String pattern = r.getPattern();
                String expr = r.getExpression();
                if (expr == null || !qname.matches(pattern)) continue;
                try {
                    Object oval;
                    boolean matched = UIControlUtil.evaluateExprBoolean(this.createExpressionBean(itemData), expr);
                    if (!matched || (oval = r.getProperties().get("editable")) == null) continue;
                    if ("true".equals(oval.toString())) {
                        columnEditable = true;
                        continue;
                    }
                    if (!"false".equals(oval.toString())) continue;
                    columnEditable = false;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        oColumn.getProperties().put("_allowEdit", columnEditable);
        if (columnEditable) {
            KeyEvent ke;
            if (e instanceof KeyEvent && ((ke = (KeyEvent)e).isControlDown() || ke.isAltDown())) {
                return false;
            }
            this.editItem(rowIndex, colIndex, e);
        }
        return false;
    }

    @Override
    public void changeSelection(int rowIndex, int columnIndex, boolean toggle, boolean extend) {
        if (this.processingRequest) {
            return;
        }
        int oldRowIndex = this.getSelectedRow();
        int oldColIndex = this.getSelectedColumn();
        if (this.editingMode && (rowIndex != oldRowIndex || columnIndex != oldColIndex)) {
            this.currentEditor.putClientProperty("Editor.hide", null);
            boolean success = this.hideEditor(this.currentEditor, oldRowIndex, oldColIndex, true, true);
            if (!success) {
                return;
            }
        }
        if (columnIndex != oldColIndex) {
            if (this.cellContext.hasError()) {
                this.cellContext.showError();
                this.grabFocus();
                return;
            }
            this.cellContext.reset();
        }
        if (rowIndex != oldRowIndex && this.editorSupport != null) {
            ListItem li;
            CellHelper cellhelper;
            ListItem li2;
            int editRowIndex = this.editingRow;
            if (editRowIndex < 0 && (li2 = this.editorSupport.getSource().getListItem(oldRowIndex)) != null && li2.isDirty()) {
                editRowIndex = oldRowIndex;
            }
            if ((cellhelper = new CellHelper(oldColIndex)).isType("checkbox") && this.cellContext.hasError()) {
                this.commitData(this.cellContext.value, this.cellContext.rowIndex, this.cellContext.colIndex);
                if (this.cellContext.hasError()) {
                    this.grabFocus();
                    return;
                }
            }
            if (editRowIndex >= 0 && (li = this.editorSupport.getSource().getListItem(editRowIndex)) != null && (this.editorSupport.isTemporaryItem(li) || li.getState() == 3)) {
                try {
                    if (!this.validateRow(editRowIndex)) {
                        String errmsg = this.editorSupport.getSource().getMessageSupport().getErrorMessage(editRowIndex);
                        if (errmsg != null) {
                            throw new Exception(errmsg);
                        }
                        return;
                    }
                    if (li.getState() == 2) {
                        this.editorSupport.flushTemporaryItem(li);
                    } else if (li.getState() == 3) {
                        this.editorSupport.fireUpdateItem(li);
                    }
                    this.editorSupport.fireCommitItem(li);
                    this.itemBinding.getChangeLog().clear();
                    this.editingRow = -1;
                }
                catch (Throwable ex) {
                    this.tableModel.fireTableRowsUpdated(editRowIndex, editRowIndex);
                    MsgBox.err(ex);
                    return;
                }
            }
        }
        super.changeSelection(rowIndex, columnIndex, toggle, extend);
        this.putClientProperty("selectionPoint", new Point(columnIndex, rowIndex));
        if (rowIndex != oldRowIndex) {
            this.editingRow = -1;
        }
        if (columnIndex != oldColIndex && this.dataProvider != null) {
            Column oColumn = this.tableModel.getColumn(columnIndex);
            this.dataProvider.setSelectedColumn(oColumn == null ? null : oColumn.getName());
        }
        if (rowIndex != oldRowIndex) {
            this.rowSelectionChanged(rowIndex);
        }
    }

    @Override
    protected void processKeyEvent(KeyEvent e) {
        if (this.processingRequest) {
            return;
        }
        if (this.currentEditor != null) {
            return;
        }
        this.currentKeyEvent = e;
        super.processKeyEvent(e);
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        if (this.getSelectedRow() >= this.getRowCount()) {
            try {
                this.setRowSelectionInterval(0, 0);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        super.tableChanged(e);
    }

    protected void onrowChanged() {
    }

    private void rowSelectionChanged(int index) {
        if (this.dataProvider != null) {
            this.dataProvider.setSelectedItem(index);
        }
        this.editorBeanLoaded = false;
        this.rowCommited = true;
        this.previousItem = null;
        this.onrowChanged();
    }

    protected void oncancelRowEdit() {
    }

    public final void cancelRowEdit() {
        if (!this.rowCommited) {
            ChangeLog log = this.itemBinding.getChangeLog();
            List<ChangeLog.ChangeEntry> ceList = log.undoAll();
            for (ChangeLog.ChangeEntry changeEntry : ceList) {
            }
            this.rowCommited = true;
            int row = this.getSelectedRow();
            this.tableModel.fireTableRowsUpdated(row, row);
            if (this.cellContext != null) {
                this.cellContext.reset();
            }
            this.oncancelRowEdit();
        }
    }

    public void undo() {
        int row = this.getSelectedRow();
        ChangeLog.ChangeEntry ce = this.itemBinding.getChangeLog().undo();
        this.tableModel.fireTableRowsUpdated(row, row);
    }

    private boolean canRemoveItem() {
        if (this.isReadonly()) {
            return false;
        }
        if (this.editorSupport == null) {
            return false;
        }
        int rowIndex = this.getSelectedRow();
        if (rowIndex < 0) {
            return false;
        }
        AbstractListDataProvider ldp = this.editorSupport.getSource();
        ListItem li = ldp.getSelectedItem();
        if (li == null) {
            return false;
        }
        return li.getState() != 0;
    }

    public final void removeItem() {
        if (this.isReadonly()) {
            return;
        }
        if (this.editorSupport == null) {
            return;
        }
        int rowIndex = this.getSelectedRow();
        if (rowIndex < 0) {
            return;
        }
        AbstractListDataProvider ldp = this.editorSupport.getSource();
        if (ldp.getMessageSupport().hasErrorMessages() && ldp.getMessageSupport().getErrorMessage(rowIndex) == null) {
            return;
        }
        try {
            ListItem li = ldp.getListItem(rowIndex);
            if (li.getState() == 0 && ldp.isLastItem(li)) {
                return;
            }
            ldp.setSelectedItem(rowIndex);
            this.editorSupport.fireRemoveItem(li);
        }
        catch (Exception ex) {
            MsgBox.err(ex);
        }
    }

    @Override
    public Object createExpressionBean(Object itemBean) {
        Object bean = this.binding == null ? null : this.binding.getBean();
        ExprBeanSupport beanSupport = new ExprBeanSupport(bean);
        beanSupport.setItem(this.getVarName(), itemBean);
        return beanSupport.createProxy();
    }

    protected void onchangedItem(ListItem item) {
    }

    public void editItem(int rowIndex, int colIndex, EventObject e) {
        if (this.editorSupport == null) {
            return;
        }
        if (this.dataProvider.getMessageSupport().hasErrorMessages() && this.dataProvider.getMessageSupport().getErrorMessage(this.getSelectedRow()) == null) {
            return;
        }
        ListItem oListItem = this.tableModel.getListItem(rowIndex);
        if (!this.editorSupport.isAllowedForEditing(oListItem)) {
            return;
        }
        Column col = this.tableModel.getColumn(colIndex);
        if (col == null || !col.isEditable()) {
            return;
        }
        boolean has_loaded_item = false;
        boolean fired_delete_key = false;
        try {
            if (e instanceof KeyEvent) {
                KeyEvent ke = (KeyEvent)e;
                boolean bl = fired_delete_key = ke.getKeyCode() == 127;
                if (fired_delete_key && this.dataProvider.isLastItem(oListItem)) {
                    return;
                }
                if (ke.isActionKey()) {
                    return;
                }
            }
            if (oListItem.getItem() == null || oListItem.getState() == 0) {
                this.editorSupport.loadTemporaryItem(oListItem, col.getName());
                oListItem.setRoot(this.binding.getBean());
                this.tableModel.fireTableRowsUpdated(rowIndex, rowIndex);
                has_loaded_item = true;
            }
        }
        catch (Exception ex) {
            MsgBox.err(ex);
            return;
        }
        if (!ValueUtil.isEmpty((Object)col.getEditableWhen())) {
            boolean passed = false;
            try {
                Object exprBean = this.createExpressionBean(oListItem.getItem());
                passed = UIControlUtil.evaluateExprBoolean(exprBean, col.getEditableWhen());
            }
            catch (Exception ex) {
                System.out.println("Failed to evaluate expression " + col.getEditableWhen() + " caused by " + ex.getMessage());
            }
            if (!passed) {
                if (has_loaded_item) {
                    oListItem.loadItem(null, 0);
                    this.tableModel.fireTableRowsUpdated(rowIndex, rowIndex);
                }
                if (this.dataProvider.getListItem(rowIndex + 1) == null) {
                    oListItem.loadItem(null, 0);
                    this.tableModel.fireTableRowsUpdated(rowIndex, rowIndex);
                }
                return;
            }
        }
        try {
            boolean editable = this.editorSupport.isColumnEditable(oListItem.getItem(), col.getName());
            if (!editable) {
                if (has_loaded_item) {
                    oListItem.loadItem(null, 0);
                    this.tableModel.fireTableRowsUpdated(rowIndex, rowIndex);
                }
                return;
            }
        }
        catch (Throwable t) {
            System.out.println("[WARN] error caused by " + t.getMessage());
            return;
        }
        JComponent editor = this.editors.get(colIndex);
        if (editor == null) {
            return;
        }
        if (this.editorSupport.isLastItem(oListItem)) {
            if (this.editorSupport.isAllowAdd()) {
                this.editorSupport.addEmptyItem();
            } else {
                oListItem.loadItem(null, 0);
                return;
            }
        }
        oListItem.setRoot(this.binding.getBean());
        this.tableModel.fireTableRowsUpdated(rowIndex, rowIndex);
        try {
            this.onchangedItem(oListItem);
        }
        catch (Exception ex) {
            MsgBox.err(ex);
        }
        if (!fired_delete_key) {
            this.showEditor(editor, rowIndex, colIndex, e);
        }
    }

    protected void onfocusGained(FocusEvent e) {
    }

    protected void onfocusLost(FocusEvent e) {
    }

    @Override
    protected final void processFocusEvent(FocusEvent e) {
        int selCol;
        if (e.getID() == 1004) {
            this.onfocusGained(e);
        } else if (e.getID() == 1005) {
            this.onfocusLost(e);
        }
        super.processFocusEvent(e);
        if (e.getID() == 1004 && (selCol = this.getSelectedColumn()) < 0 && this.getColumnCount() > 0) {
            try {
                this.changeSelection(this.getSelectedRow(), 0, false, false);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private void log(String msg) {
        String name = this.getClass().getSimpleName();
        System.out.println("[" + name + "] " + msg);
    }

    private boolean isPrintableKey(EventObject e) {
        KeyEvent ke = null;
        if (e instanceof KeyEvent) {
            ke = (KeyEvent)e;
        }
        if (ke == null) {
            ke = this.currentKeyEvent;
        }
        if (ke == null) {
            return false;
        }
        if (ke.isActionKey() || ke.isControlDown() || ke.isAltDown()) {
            return false;
        }
        switch (ke.getKeyCode()) {
            case 10: 
            case 27: 
            case 127: {
                return false;
            }
        }
        return true;
    }

    private boolean isEditKey(EventObject e) {
        if (!(e instanceof KeyEvent)) {
            return false;
        }
        KeyEvent ke = (KeyEvent)e;
        switch (ke.getKeyCode()) {
            case 8: 
            case 113: 
            case 155: {
                return true;
            }
        }
        return false;
    }

    private boolean isSpaceBarKey(EventObject e) {
        KeyEvent ke;
        return e instanceof KeyEvent && (ke = (KeyEvent)e).getKeyCode() == 32;
    }

    private boolean isMouseClicked(EventObject e) {
        MouseEvent me;
        if (e instanceof MouseEvent && SwingUtilities.isLeftMouseButton(me = (MouseEvent)e)) {
            return me.getID() == 500 && me.getClickCount() == 1;
        }
        return false;
    }

    private void selectAll(JComponent editor, EventObject evt) {
        if (editor instanceof JTextComponent) {
            ((JTextComponent)editor).selectAll();
        } else {
            if (editor instanceof UIInput) {
                ((UIInput)((Object)editor)).setRequestFocus(true);
            }
            if (editor instanceof JCheckBox) {
                ((UIInput)((Object)editor)).setValue(evt);
            }
        }
    }

    private void focusNextCellFrom(int rowIndex, int colIndex) {
        int nextCol = this.findNextEditableColFrom(colIndex);
        int firstEditable = this.findNextEditableColFrom(-1);
        if (nextCol >= 0) {
            this.changeSelection(rowIndex, nextCol, false, false);
        } else if (rowIndex + 1 < this.tableModel.getRowCount()) {
            this.changeSelection(rowIndex + 1, firstEditable, false, false);
        }
    }

    private int findNextEditableColFrom(int colIndex) {
        for (int i = colIndex + 1; i < this.tableModel.getColumnCount(); ++i) {
            if (this.editors.get(i) == null) continue;
            return i;
        }
        return -1;
    }

    private void hideEditor(boolean commit) {
        this.hideEditor(commit, true);
    }

    private void hideEditor(boolean commit, boolean grabFocus) {
        if (!this.editingMode || this.currentEditor == null) {
            return;
        }
        Point point = (Point)this.currentEditor.getClientProperty(COLUMN_POINT);
        this.hideEditor(this.currentEditor, point.y, point.x, commit, grabFocus);
    }

    private boolean hideEditor(JComponent editor, int rowIndex, int colIndex, boolean commit, boolean grabFocus) {
        UILookup lkp;
        Object lkpval;
        Object propval = editor.getClientProperty("Editor.hide");
        if (propval != null) {
            editor.putClientProperty("Editor.hide", null);
            if ("false".equals(propval + "")) {
                return false;
            }
        }
        if (editor instanceof SelectionCellEditor) {
            commit = false;
        }
        if (editor instanceof JCheckBox && editor instanceof UIInput) {
            UIInput uiinput = (UIInput)((Object)editor);
            uiinput.putClientProperty("cellEditorValue", uiinput.getValue());
        }
        InputVerifier inputVerifier = editor.getInputVerifier();
        editor.setVisible(false);
        editor.setInputVerifier(null);
        this.editingMode = false;
        this.currentEditor = null;
        Object value = editor.getClientProperty("cellEditorValue");
        if ("no_updates".equals(value)) {
            commit = false;
        }
        if (editor instanceof UILookup && this.editorSupport != null && (lkpval = (lkp = (UILookup)((Object)editor)).getClientProperty("UIControl.value")) instanceof Object[]) {
            ListItem oListItem = this.editorSupport.getSource().getListItem(this.editingRow);
            Object[] objs = (Object[])lkpval;
            if (objs.length > 0 && oListItem.getState() != 2) {
                oListItem.setState(3);
            }
        }
        if (commit) {
            this.tableModel.setBinding(this.itemBinding);
            try {
                this.cellContext.value = value;
                this.cellContext.rowIndex = rowIndex;
                this.cellContext.colIndex = colIndex;
                this.tableModel.setValueAt(value, rowIndex, colIndex);
                this.cellContext.reset();
            }
            catch (EditorListSupport.BeforeColumnUpdateException bcx) {
                if (bcx.getCause() != null) {
                    MsgBox.err(bcx.getCause());
                }
                if (!(editor instanceof JCheckBox)) {
                    this.refocusEditor(editor, inputVerifier);
                    editor.putClientProperty("Editor.hide", false);
                }
                this.cellContext.error = bcx.getCause() == null ? bcx : bcx.getCause();
                return false;
            }
            catch (EditorListSupport.AfterColumnUpdateException acx) {
                if (acx.getCause() != null) {
                    MsgBox.err(acx.getCause());
                }
                if (!(editor instanceof JCheckBox)) {
                    this.itemBinding.getChangeLog().undo();
                    this.refocusEditor(editor, inputVerifier);
                    editor.putClientProperty("Editor.hide", false);
                }
                this.cellContext.error = acx.getCause() == null ? acx : acx.getCause();
                return false;
            }
            catch (Exception ex) {
                MsgBox.err(ex);
                if (!(editor instanceof JCheckBox)) {
                    this.refocusEditor(editor, inputVerifier);
                    editor.putClientProperty("Editor.hide", false);
                }
                this.cellContext.error = ex;
                return false;
            }
        }
        this.tableModel.fireTableRowsUpdated(rowIndex, rowIndex);
        if (grabFocus && !editor.isVisible()) {
            this.grabFocus();
        }
        return true;
    }

    private void commitData(Object value, int rowIndex, int colIndex) {
        try {
            this.cellContext.value = value;
            this.cellContext.rowIndex = rowIndex;
            this.cellContext.colIndex = colIndex;
            this.tableModel.setValueAt(value, rowIndex, colIndex, true);
            this.cellContext.reset();
        }
        catch (EditorListSupport.BeforeColumnUpdateException bcx) {
            if (bcx.getCause() != null) {
                MsgBox.err(bcx.getCause());
            }
            this.cellContext.error = bcx.getCause() == null ? bcx : bcx.getCause();
        }
        catch (EditorListSupport.AfterColumnUpdateException acx) {
            if (acx.getCause() != null) {
                MsgBox.err(acx.getCause());
            }
            this.cellContext.error = acx.getCause() == null ? acx : acx.getCause();
        }
        catch (Exception ex) {
            MsgBox.err(ex);
            this.cellContext.error = ex;
        }
    }

    private void refocusEditor(JComponent editor, InputVerifier inputVerifier) {
        editor.setVisible(true);
        editor.setInputVerifier(inputVerifier);
        this.editingMode = true;
        this.currentEditor = editor;
        this.currentEditor.grabFocus();
    }

    public void clearEditors() {
        if (this.currentEditor != null) {
            this.currentEditor.setVisible(false);
            this.currentEditor.setInputVerifier(null);
        }
        this.editingMode = false;
        this.currentEditor = null;
    }

    private boolean validateRow(int rowIndex) {
        if (this.editorSupport == null) {
            return true;
        }
        ActionMessage ac = new ActionMessage();
        this.itemBinding.validate(ac);
        if (ac.hasMessages()) {
            this.dataProvider.getMessageSupport().addErrorMessage(rowIndex, ac.toString());
        } else {
            this.dataProvider.getMessageSupport().removeErrorMessage(rowIndex);
        }
        if (ac.hasMessages()) {
            return false;
        }
        try {
            this.editorSupport.fireValidateItem(this.dataProvider.getListItem(rowIndex));
            this.dataProvider.getMessageSupport().removeErrorMessage(rowIndex);
            return true;
        }
        catch (Exception e) {
            if (ClientContext.getCurrentContext().isDebugMode()) {
                e.printStackTrace();
            }
            String msg = this.getMessage(e) + "";
            this.dataProvider.getMessageSupport().addErrorMessage(rowIndex, msg);
            return false;
        }
    }

    private String getMessage(Throwable t) {
        if (t == null) {
            return null;
        }
        String msg = t.getMessage();
        for (Throwable cause = t.getCause(); cause != null; cause = cause.getCause()) {
            String s = cause.getMessage();
            if (s == null) continue;
            msg = s;
        }
        return msg;
    }

    private void showEditor(JComponent editor, int rowIndex, int colIndex, EventObject e) {
        final JComponent _editor = editor;
        final int _rowIndex = rowIndex;
        final int _colIndex = colIndex;
        final EventObject _eventObject = e;
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                DataTableComponent.this.showEditorImpl(_editor, _rowIndex, _colIndex, _eventObject);
            }
        });
    }

    private void showEditorImpl(JComponent editor, int rowIndex, int colIndex, EventObject e) {
        Rectangle bounds = this.getCellRect(rowIndex, colIndex, false);
        editor.putClientProperty(COLUMN_POINT, new Point(colIndex, rowIndex));
        editor.putClientProperty("cellEditorValue", null);
        editor.setFont(this.getFont());
        editor.setBounds(bounds);
        editor.validate();
        UIControl ui = (UIControl)((Object)editor);
        Object bean = this.dataProvider.getListItemData(rowIndex);
        this.itemBinding.setBean(bean);
        boolean refreshed = false;
        if (!this.editorBeanLoaded) {
            this.itemBinding.update();
            this.itemBinding.setRoot(this.binding);
            this.itemBinding.setTableModel(this.tableModel);
            this.itemBinding.setRowIndex(rowIndex);
            this.itemBinding.setColumnIndex(colIndex);
            this.itemBinding.refresh();
            refreshed = true;
            this.editorBeanLoaded = true;
        }
        if (e == null) {
            e = this.currentKeyEvent;
        }
        editor.putClientProperty("updateBeanValue", false);
        editor.putClientProperty("allowSelectAll", false);
        boolean editor_forcely_hidden = false;
        if (e instanceof MouseEvent || this.isEditKey(e)) {
            if (!refreshed) {
                ui.refresh();
            }
            this.selectAll(editor, e);
            if (editor instanceof XCheckBox) {
                this.hideEditor(editor, rowIndex, colIndex, true, true);
                editor_forcely_hidden = true;
            }
        } else if (this.isPrintableKey(e)) {
            if (editor instanceof UILookup) {
                UILookup lkp = (UILookup)((Object)editor);
                lkp.setValue(this.currentKeyEvent);
                lkp.putClientProperty("UIControl.value", null);
            } else if (editor instanceof UIInput) {
                ((UIInput)((Object)editor)).setValue(this.currentKeyEvent);
            }
            if (editor instanceof XCheckBox) {
                this.hideEditor(editor, rowIndex, colIndex, true, true);
                editor_forcely_hidden = true;
            }
        } else {
            return;
        }
        if (editor instanceof ImmediateCellEditor) {
            this.editorBeanLoaded = false;
            return;
        }
        this.oneditCellAt(rowIndex, colIndex);
        this.previousItem = this.dataProvider.getSelectedItem();
        if (editor_forcely_hidden) {
            return;
        }
        InputVerifier verifier = (InputVerifier)editor.getClientProperty(InputVerifier.class);
        if (verifier == null) {
            verifier = editor.getInputVerifier();
            editor.putClientProperty(InputVerifier.class, verifier);
        }
        editor.setInputVerifier(verifier);
        editor.setVisible(true);
        editor.requestFocus();
        this.editingRow = rowIndex;
        this.editingMode = true;
        this.rowCommited = false;
        this.currentEditor = editor;
    }

    private boolean isValidKeyCode(int keyCode) {
        return keyCode >= 32 && keyCode <= 126;
    }

    protected void oneditCellAt(int rowIndex, int colIndex) {
    }

    public AbstractListModel getListModel() {
        return null;
    }

    @Override
    public void invokeAction(String name, Object[] args) throws Exception {
        Binding binding = this.getBinding();
        Object bean = binding == null ? null : binding.getBean();
        Object result = MethodResolver.getInstance().invoke(bean, name, args);
        if (result instanceof Opener) {
            Opener o = (Opener)result;
            String target = o.getTarget();
            if (target == null || target.trim().length() == 0 || target.matches("self")) {
                o.setTarget("popup");
            }
            binding.fireNavigation(o);
        }
    }

    private class CellHelper {
        private int colIndex;
        private Column colObj;
        private Column.TypeHandler colTypeHandler;
        private DataTableModel model;

        CellHelper(int colIndex) {
            this.colIndex = colIndex;
            TableModel tm = DataTableComponent.this.getModel();
            if (tm instanceof DataTableModel) {
                this.model = (DataTableModel)tm;
                this.colObj = this.model.getColumn(colIndex);
            }
            if (this.colObj != null) {
                this.colTypeHandler = this.colObj.getTypeHandler();
            }
        }

        public DataTableModel getModel() {
            return this.model;
        }

        public Column getColumn() {
            return this.colObj;
        }

        public Column.TypeHandler getTypeHandler() {
            return this.colTypeHandler;
        }

        public TableCellRenderer getRenderer() {
            if (this.colObj == null) {
                return null;
            }
            return DataTableComponent.this.getColumnModel().getColumn(this.colIndex).getCellRenderer();
        }

        public boolean isType(String type) {
            Column.TypeHandler cth = this.getTypeHandler();
            String stype = (cth == null ? null : cth.getType()) + "";
            return stype.equalsIgnoreCase(type + "");
        }

        public Object getCheckBoxValue() {
            if (this.colObj == null) {
                return null;
            }
            JComponent editor = (JComponent)DataTableComponent.this.editors.get(this.colIndex);
            boolean selected = false;
            if (editor instanceof XCheckBox) {
                selected = ((XCheckBox)editor).isSelected();
            } else if (editor instanceof JCheckBox) {
                selected = ((JCheckBox)editor).isSelected();
            } else {
                return null;
            }
            Object objval = selected ? this.colObj.getCheckValue() : this.colObj.getUncheckValue();
            return objval == null ? Boolean.valueOf(selected) : objval;
        }
    }

    private class CellContext {
        int rowIndex;
        int colIndex;
        Throwable error;
        Object value;

        private CellContext() {
        }

        void reset() {
            this.colIndex = -1;
            this.rowIndex = -1;
            this.error = null;
        }

        boolean hasError() {
            return this.error != null;
        }

        void showError() {
            if (this.error != null) {
                MsgBox.err(this.error);
            }
        }
    }

    private class ActionColumnInvoker
    implements Runnable {
        DataTableComponent root;
        private CellRenderers.ActionColumnHandler handler;
        private Column colObj;
        private Object rowObj;

        ActionColumnInvoker(CellRenderers.ActionColumnHandler handler, Column colObj, Object rowObj) {
            this.root = DataTableComponent.this;
            this.handler = handler;
            this.colObj = colObj;
            this.rowObj = rowObj;
        }

        @Override
        public void run() {
            try {
                if (this.handler == null) {
                    return;
                }
                String name = this.colObj.getName();
                if (name != null && name.trim().length() > 0) {
                    this.root.invokeAction(name, new Object[0]);
                } else {
                    Column.TypeHandler typehandler = this.colObj.getTypeHandler();
                    if (typehandler instanceof ButtonColumnHandler) {
                        ButtonColumnHandler bch = (ButtonColumnHandler)typehandler;
                        HashMap<String, String> mm = new HashMap<String, String>();
                        mm.put("action", bch.getAction());
                        mm.put("tag", bch.getTag());
                        this.root.getDataProvider().onInvokeAction(this.rowObj, name, mm);
                    }
                }
            }
            catch (Exception e) {
                MsgBox.err(e);
            }
            catch (Throwable t) {
                MsgBox.err(new Exception(t.getMessage(), t), t.getMessage());
            }
        }
    }

    private class TableEditorProviderImpl
    implements EditorListSupport.TableEditorProvider {
        DataTableComponent root;

        private TableEditorProviderImpl() {
            this.root = DataTableComponent.this;
        }

        @Override
        public void refreshCurrentEditor(ListItem li) {
            if (DataTableComponent.this.currentEditor == null || !DataTableComponent.this.currentEditor.isVisible() || !DataTableComponent.this.currentEditor.isEnabled()) {
                return;
            }
            if (!(DataTableComponent.this.currentEditor instanceof UIInput)) {
                return;
            }
            UIInput uiinput = (UIInput)((Object)DataTableComponent.this.currentEditor);
            uiinput.refresh();
        }

        @Override
        public boolean hasUncommittedData() {
            if (this.root.editingMode) {
                return true;
            }
            int[] selRows = this.root.getSelectedRows();
            if (selRows == null) {
                selRows = new int[]{};
            }
            for (int rowIndex : selRows) {
                ListItem li;
                if (rowIndex < 0 || (li = this.root.getDataProvider().getListItem(rowIndex)) != null || li.getState() != 2) continue;
                return true;
            }
            return false;
        }
    }

    private class DefaultUIProvider
    implements AbstractListDataProvider.UIProvider {
        DataTableComponent root;

        private DefaultUIProvider() {
            this.root = DataTableComponent.this;
        }

        @Override
        public Object getBinding() {
            return this.root.getBinding();
        }

        @Override
        public Column getSelectedColumn() {
            int index = this.root.getSelectedColumn();
            if (index < 0) {
                return null;
            }
            if (this.root.tableModel == null) {
                return null;
            }
            return this.root.tableModel.getColumn(index);
        }
    }

    private class FocusGrabber
    implements Runnable {
        DataTableComponent root;
        private int rowIndex;
        private int colIndex;

        FocusGrabber(int rowIndex, int colIndex) {
            this.root = DataTableComponent.this;
            this.rowIndex = rowIndex;
            this.colIndex = colIndex;
        }

        void focus() {
            EventQueue.invokeLater(this);
        }

        @Override
        public void run() {
            Component pfo = KeyboardFocusManager.getCurrentKeyboardFocusManager().getPermanentFocusOwner();
            if (this.root.equals(pfo)) {
                return;
            }
            this.root.grabFocus();
            this.root.requestFocusInWindow();
            try {
                Thread.sleep(200L);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            EventQueue.invokeLater(this);
        }
    }

    private class ActionMenuItem
    extends JMenuItem {
        DataTableComponent root;
        private Map data;
        private ListItem listItem;

        ActionMenuItem(Map data, ListItem listItem) {
            this.root = DataTableComponent.this;
            this.data = data == null ? new HashMap() : data;
            this.listItem = listItem;
            this.setText(this.data.get("value") + "");
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ActionMenuItem.this.invokeAction(e);
                }
            });
            if (this.data.get("action") instanceof Action) {
                Action a = (Action)this.data.get("action");
                Map newData = a.toMap();
                newData.putAll(this.data);
                this.data = newData;
            }
        }

        Map getData() {
            return this.data;
        }

        void invokeAction(ActionEvent e) {
            try {
                Object item = this.listItem == null ? null : this.listItem.getItem();
                Object result = this.root.getDataProvider().callContextMenu(item, this.getData());
                if (result == null) {
                    return;
                }
                if (result instanceof Action) {
                    Action a = (Action)result;
                    UICommandUtil.processAction((JComponent)this.root, this.root.getBinding(), a);
                } else {
                    this.root.getBinding().fireNavigation(result);
                }
            }
            catch (Exception ex) {
                MsgBox.err(ex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void refresh() {
            try {
                ExpressionResolver resolver;
                Object item;
                boolean enabled = !"false".equals(this.data.get("enabled") + "");
                this.setEnabled(enabled);
                Object object = item = this.listItem == null ? null : this.listItem.getItem();
                if (item == null) {
                    return;
                }
                ExpressionResolver expressionResolver = resolver = ExpressionResolver.getInstance();
                synchronized (expressionResolver) {
                    String expr;
                    Object exprBean = this.root.createExpressionBean(item);
                    if (this.data.containsKey("disabledWhen")) {
                        expr = this.data.get("disabledWhen").toString();
                        this.setEnabled(!this.evalBoolean(resolver, exprBean, expr));
                    }
                    if (this.data.containsKey("visibleWhen")) {
                        expr = this.data.get("visibleWhen").toString();
                        this.setVisible(this.evalBoolean(resolver, exprBean, expr));
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        boolean evalBoolean(ExpressionResolver resolver, Object exprBean, String expr) {
            try {
                return resolver.evalBoolean(expr, exprBean);
            }
            catch (Throwable ex) {
                return false;
            }
        }
    }

    private class PopupMenuRunnable
    implements Runnable {
        DataTableComponent root;
        private JPopupMenu popup;
        private DataTableModel dtm;
        private ListItem li;
        private MouseEvent e;
        private int rowIndex;
        private int colIndex;
        private String colName;

        private PopupMenuRunnable() {
            this.root = DataTableComponent.this;
        }

        @Override
        public void run() {
            try {
                this.runImpl();
            }
            catch (Exception ex) {
                MsgBox.err(ex);
            }
        }

        private void runImpl() {
            if (this.li.getItem() == null) {
                return;
            }
            Column oColumn = this.dtm.getColumn(this.colIndex);
            this.colName = oColumn == null ? null : oColumn.getName();
            List<Map> menuItems = this.root.getDataProvider().getContextMenu(this.li.getItem(), this.colName);
            if (menuItems == null || menuItems.isEmpty()) {
                return;
            }
            this.popup.removeAll();
            for (Map data : menuItems) {
                String value = this.getString(data, "value");
                if ("-".equals(value + "")) {
                    this.popup.addSeparator();
                    continue;
                }
                ActionMenuItem jmi = new ActionMenuItem(data, this.li);
                Dimension dim = jmi.getPreferredSize();
                jmi.setPreferredSize(new Dimension(Math.max(dim.width, 100), dim.height));
                this.popup.add(jmi);
            }
            Component[] comps = this.popup.getComponents();
            for (int i = 0; i < comps.length; ++i) {
                if (!(comps[i] instanceof ActionMenuItem)) continue;
                ActionMenuItem ami = (ActionMenuItem)comps[i];
                ami.listItem = this.li;
                ami.refresh();
            }
            this.popup.pack();
            this.popup.show(this.e.getComponent(), this.e.getX(), this.e.getY());
        }

        private String getString(Map data, String name) {
            Object o = data.get(name);
            return o == null ? null : o.toString();
        }
    }

    private class PopupMenuAdapter
    extends MouseAdapter {
        DataTableComponent root;
        private JPopupMenu popup;

        private PopupMenuAdapter() {
            this.root = DataTableComponent.this;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (!SwingUtilities.isRightMouseButton(e)) {
                return;
            }
            if (this.root.getDataProvider() == null) {
                return;
            }
            int rowIndex = this.root.rowAtPoint(e.getPoint());
            DataTableModel dtm = this.root.getDataTableModel();
            ListItem li = dtm.getListItem(rowIndex);
            if (li == null) {
                return;
            }
            int colIndex = this.root.columnAtPoint(e.getPoint());
            if (colIndex < 0) {
                colIndex = this.root.getSelectedColumn();
            }
            this.root.changeSelection(rowIndex, colIndex, false, false);
            if (this.popup == null) {
                this.popup = new JPopupMenu();
            } else {
                this.popup.setVisible(false);
            }
            PopupMenuRunnable pmr = new PopupMenuRunnable();
            pmr.popup = this.popup;
            pmr.dtm = dtm;
            pmr.li = li;
            pmr.e = e;
            pmr.rowIndex = rowIndex;
            pmr.colIndex = colIndex;
            EventQueue.invokeLater(pmr);
        }
    }

    private class TableModelHandlerImpl
    implements TableModelHandler {
        DataTableComponent root;

        private TableModelHandlerImpl() {
            this.root = DataTableComponent.this;
        }

        @Override
        public void fireTableCellUpdated(int row, int column) {
        }

        @Override
        public void fireTableRowsDeleted(int firstRow, int lastRow) {
        }

        @Override
        public void fireTableRowsInserted(int firstRow, int lastRow) {
        }

        @Override
        public void fireTableRowsUpdated(int firstRow, int lastRow) {
        }

        @Override
        public void fireTableDataProviderChanged() {
        }

        @Override
        public void fireTableStructureChanged() {
            this.root.clearEditors();
        }

        @Override
        public void fireTableDataChanged() {
            this.root.clearEditors();
        }

        @Override
        public void fireTableRowSelected(int row, boolean focusOnItemDataOnly) {
            ListItem li;
            Point sel = (Point)this.root.getClientProperty("selectionPoint");
            if (sel == null) {
                sel = new Point();
            }
            if ((li = this.root.dataProvider.getListItem(row)) == null) {
                this.root.getSelectionModel().setSelectionInterval(0, 0);
            } else {
                int preferredRow = 0;
                int itemCount = this.root.dataProvider.getListItemCount();
                for (int i = row; i >= 0; --i) {
                    if (focusOnItemDataOnly) {
                        if (this.root.dataProvider.getListItemData(i) == null) continue;
                        preferredRow = i;
                        break;
                    }
                    if (i >= itemCount) continue;
                    preferredRow = i;
                    break;
                }
                this.root.getSelectionModel().setSelectionInterval(preferredRow, preferredRow);
                DataTableComponent.this.onrowChanged();
            }
        }
    }

    private class PropertyChangeHandlerImpl
    implements PropertyChangeHandler {
        DataTableComponent root;

        private PropertyChangeHandlerImpl() {
            this.root = DataTableComponent.this;
        }

        @Override
        public void firePropertyChange(String name, int value) {
        }

        @Override
        public void firePropertyChange(String name, boolean value) {
            if ("loading".equals(name)) {
                this.root.fetching = value;
                this.root.repaint();
            }
        }

        @Override
        public void firePropertyChange(String name, String value) {
        }

        @Override
        public void firePropertyChange(String name, Object value) {
            if ("focusSelectedItem".equals(name)) {
                this.focusSelectedItem();
            } else if ("refreshItem".equals(name)) {
                try {
                    this.refreshItem(value);
                }
                catch (Throwable t) {
                    System.out.println("failed to refreshItem caused by " + t.getMessage());
                }
            }
        }

        void focusSelectedItem() {
            ListItem li;
            int rowIndex;
            Point loc = (Point)DataTableComponent.this.getClientProperty("selectionPoint");
            if (loc == null) {
                loc = new Point();
            }
            int n = rowIndex = (li = this.root.dataProvider.getSelectedItem()) == null ? 0 : li.getIndex();
            if (!this.root.dataProvider.validRange(rowIndex)) {
                rowIndex = 0;
            }
            this.root.tableModel.fireTableRowsUpdated(rowIndex, rowIndex);
            this.root.setRowSelectionInterval(rowIndex, rowIndex);
        }

        void refreshItem(Object o) {
            if (o instanceof Integer[]) {
                Integer[] arr = (Integer[])o;
                int rowIndex = arr[0];
                int colIndex = arr[1];
                if (colIndex < 0) {
                    this.root.tableModel.fireTableRowsUpdated(rowIndex, rowIndex);
                } else {
                    this.root.tableModel.fireTableCellUpdated(rowIndex, colIndex);
                }
            }
        }
    }

    private class TableEscapeAction
    implements ActionListener {
        private ActionListener oldAction;

        private TableEscapeAction() {
        }

        void install(JComponent comp) {
            KeyStroke ks = KeyStroke.getKeyStroke(27, 0, false);
            this.oldAction = comp.getActionForKeyStroke(ks);
            comp.registerKeyboardAction(this, ks, 0);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (DataTableComponent.this.editorSupport != null) {
                this.fireAction();
                return;
            }
            ActionListener actionL = (ActionListener)DataTableComponent.this.getRootPane().getClientProperty("Window.closeAction");
            if (actionL != null) {
                actionL.actionPerformed(e);
            } else if (this.oldAction != null) {
                this.oldAction.actionPerformed(e);
            }
        }

        private void fireAction() {
            int rowIndex = DataTableComponent.this.getSelectedRow();
            ListItem li = DataTableComponent.this.dataProvider.getListItem(rowIndex);
            if (li == null) {
                return;
            }
            if (DataTableComponent.this.editorSupport.isTemporaryItem(li)) {
                DataTableComponent.this.dataProvider.getMessageSupport().removeErrorMessage(li.getIndex());
                DataTableComponent.this.editorSupport.removeTemporaryItem(li);
                Point sel = (Point)DataTableComponent.this.getClientProperty("selectionPoint");
                if (sel == null) {
                    sel = new Point(0, 0);
                }
                DataTableComponent.this.changeSelection(rowIndex, sel.x, false, false);
            } else if (li.getState() == 3 && DataTableComponent.this.dataProvider.getMessageSupport().hasErrorMessages()) {
                DataTableComponent.this.dataProvider.getMessageSupport().removeErrorMessage(li.getIndex());
                li.setState(1);
                DataTableComponent.this.tableModel.fireTableRowsUpdated(rowIndex, rowIndex);
            } else {
                DataTableComponent.this.tableModel.fireTableRowsUpdated(rowIndex, rowIndex);
            }
        }
    }

    private class TableEnterAction
    implements ActionListener {
        private JComponent component;
        private ActionListener oldAction;

        private TableEnterAction() {
        }

        void install(JComponent component) {
            this.component = component;
            KeyStroke ks = KeyStroke.getKeyStroke(10, 0, false);
            this.oldAction = component.getActionForKeyStroke(ks);
            component.registerKeyboardAction(this, ks, 0);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!DataTableComponent.this.isReadonly() && DataTableComponent.this.editors.size() > 0) {
                DataTableComponent tbl = DataTableComponent.this;
                int row = tbl.getSelectedRow();
                int col = tbl.getSelectedColumn();
                DataTableComponent.this.focusNextCellFrom(row, col);
            } else {
                JRootPane rp = this.component.getRootPane();
                if (rp != null && rp.getDefaultButton() != null) {
                    JButton btn = rp.getDefaultButton();
                    btn.doClick();
                } else if (this.oldAction != null) {
                    this.oldAction.actionPerformed(e);
                }
            }
        }
    }

    private class TableKeyAdapter
    extends KeyAdapter {
        private TableKeyAdapter() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (DataTableComponent.this.processingRequest) {
                return;
            }
            switch (e.getKeyCode()) {
                case 40: {
                    if (!DataTableComponent.this.dataProvider.isLastItem(DataTableComponent.this.getSelectedRow())) break;
                    e.consume();
                    DataTableComponent.this.dataProvider.moveNextRecord();
                    break;
                }
                case 38: {
                    if (!DataTableComponent.this.dataProvider.isFirstItem(DataTableComponent.this.getSelectedRow())) break;
                    e.consume();
                    DataTableComponent.this.dataProvider.moveBackRecord();
                    break;
                }
                case 36: {
                    if (DataTableComponent.this.pageModel == null || !e.isControlDown()) break;
                    e.consume();
                    DataTableComponent.this.pageModel.moveFirstPage();
                    break;
                }
                case 34: {
                    if (DataTableComponent.this.pageModel == null) break;
                    e.consume();
                    DataTableComponent.this.pageModel.moveNextPage();
                    break;
                }
                case 33: {
                    if (DataTableComponent.this.pageModel == null) break;
                    e.consume();
                    DataTableComponent.this.pageModel.moveBackPage();
                    break;
                }
                case 127: {
                    DataTableComponent.this.removeItem();
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            DataTableComponent.this.requestFocusInWindow();
                            DataTableComponent.this.grabFocus();
                        }
                    });
                    break;
                }
                case 10: {
                    if (!e.isControlDown()) break;
                    DataTableComponent.this.openItem();
                    break;
                }
                case 27: {
                    DataTableComponent.this.cancelRowEdit();
                }
            }
        }
    }

    private class EditorKeyBoardAction
    implements ActionListener {
        KeyStroke keyStroke;
        private boolean commit;
        private ActionListener[] listeners;

        EditorKeyBoardAction(JComponent comp, int key, boolean commit) {
            this.commit = commit;
            this.keyStroke = KeyStroke.getKeyStroke(key, 0);
            if (key == 10 && comp instanceof JTextField) {
                JTextField jtf = (JTextField)comp;
                this.listeners = jtf.getActionListeners();
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.listeners != null && this.listeners.length > 0) {
                for (ActionListener l : this.listeners) {
                    l.actionPerformed(e);
                }
            } else {
                JComponent comp = (JComponent)e.getSource();
                Point point = (Point)comp.getClientProperty(DataTableComponent.COLUMN_POINT);
                if (this.commit) {
                    DataTableComponent.this.focusNextCellFrom(point.y, point.x);
                } else {
                    comp.firePropertyChange("enableInputVerifier", true, false);
                    DataTableComponent.this.hideEditor(comp, point.y, point.x, false, true);
                }
            }
        }
    }

    private class EditorFocusSupport
    implements FocusListener {
        private boolean fromTempFocus;

        private EditorFocusSupport() {
        }

        @Override
        public void focusGained(FocusEvent e) {
            if (this.fromTempFocus) {
                if (DataTableComponent.this.editingMode) {
                    JComponent comp = (JComponent)e.getSource();
                    UIInput uiinput = (UIInput)comp.getClientProperty(UIInput.class);
                    String ubv = null;
                    ubv = uiinput != null ? uiinput.getClientProperty("updateBeanValue") + "" : comp.getClientProperty("updateBeanValue") + "";
                    if ("false".equals(ubv)) {
                        return;
                    }
                    DataTableComponent.this.hideEditor(true);
                    Point selPoint = null;
                    if (uiinput != null) {
                        selPoint = (Point)uiinput.getClientProperty(DataTableComponent.COLUMN_POINT);
                    }
                    if (selPoint == null) {
                        selPoint = (Point)comp.getClientProperty(DataTableComponent.COLUMN_POINT);
                    }
                    try {
                        DataTableComponent.this.focusNextCellFrom(selPoint.y, selPoint.x);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.fromTempFocus = false;
            }
        }

        @Override
        public void focusLost(FocusEvent e) {
            this.fromTempFocus = e.isTemporary();
        }
    }

    private class EditorInputSupport
    implements UIInputUtil.Support {
        private EditorInputSupport() {
        }

        @Override
        public Object setValue(String name, Object value) {
            return this.setValue(name, value, null);
        }

        @Override
        public Object setValue(String name, Object value, JComponent jcomp) {
            if (DataTableComponent.this.currentEditor != null) {
                DataTableComponent.this.currentEditor.putClientProperty("cellEditorValue", value);
            } else if (jcomp != null) {
                jcomp.putClientProperty("cellEditorValue", value);
            }
            return null;
        }
    }
}

