/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.control.popup;

import com.rameses.rcp.control.popup.PopupItem;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;

public class PopupList
extends JPopupMenu {
    private DefaultSelectionModel model;
    private JComponent invoker;
    private int rowHeight;
    private int rowSize;
    private Color selectionBackground;
    private Color selectionForeground;
    private List<SelectionListener> listeners;

    public PopupList(JComponent invoker) {
        this.invoker = invoker;
        this.listeners = new ArrayList<SelectionListener>();
        super.setLayout(new DefaultLayout());
        this.setLightWeightPopupEnabled(true);
        this.setFocusable(false);
        this.setRowHeight(20);
        this.setRowSize(10);
        this.setSelectionBackground(new Color(51, 153, 255));
        this.setSelectionForeground(Color.WHITE);
        this.getModel();
        Color shadow = this.getBackground().darker();
        this.setBorder(BorderFactory.createLineBorder(shadow));
    }

    private DefaultSelectionModel getModel() {
        if (this.model == null) {
            this.model = new DefaultSelectionModel(this);
        }
        return this.model;
    }

    public void remove(SelectionListener listener) {
        if (listener != null) {
            this.listeners.remove(listener);
        }
    }

    public void add(SelectionListener listener) {
        if (listener != null && !this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public int getRowHeight() {
        return this.rowHeight;
    }

    public void setRowHeight(int rowHeight) {
        this.rowHeight = rowHeight;
    }

    public int getRowSize() {
        return this.rowSize;
    }

    public void setRowSize(int rowSize) {
        this.rowSize = rowSize;
    }

    public Color getSelectionBackground() {
        return this.selectionBackground;
    }

    public void setSelectionBackground(Color selectionBackground) {
        this.selectionBackground = selectionBackground;
    }

    public Color getSelectionForeground() {
        return this.selectionForeground;
    }

    public void setSelectionForeground(Color selectionForeground) {
        this.selectionForeground = selectionForeground;
    }

    public PopupItem getPopupItem() {
        ItemLabel c = this.getModel().getSelectedItem();
        return c == null ? null : c.getPopupItem();
    }

    private int indexOf(ItemLabel item) {
        if (item == null) {
            return -1;
        }
        Component[] comps = this.getComponents();
        for (int i = 0; i < comps.length; ++i) {
            ItemLabel c = (ItemLabel)comps[i];
            if (!c.equals(item)) continue;
            return i;
        }
        return -1;
    }

    private ItemLabel getItem(int index) {
        try {
            return (ItemLabel)this.getComponent(index);
        }
        catch (Throwable t) {
            return null;
        }
    }

    public void moveDown() {
        ItemLabel selItem = this.getModel().getSelectedItem();
        int index = this.indexOf(selItem);
        ItemLabel c = this.getItem(index + 1);
        if (c == null) {
            return;
        }
        this.getModel().setSelectedItem(c);
        this.getModel().refresh();
    }

    public void moveUp() {
        ItemLabel c;
        ItemLabel selItem = this.getModel().getSelectedItem();
        int index = this.indexOf(selItem) - 1;
        if (index < 0) {
            index = 0;
        }
        if ((c = this.getItem(index)) == null) {
            return;
        }
        this.getModel().setSelectedItem(c);
        this.getModel().refresh();
    }

    public synchronized void setData(List<PopupItem> list) {
        this.removeAll();
        if (list != null) {
            for (int i = 0; i < this.getRowSize(); ++i) {
                try {
                    PopupItem si = list.get(i);
                    this.add(new ItemLabel(si));
                    continue;
                }
                catch (Throwable t) {
                    break;
                }
            }
        }
        this.getModel().setSelectedItem(null);
    }

    @Override
    protected void addImpl(Component comp, Object constraints, int index) {
        if (!(comp instanceof ItemLabel)) {
            return;
        }
        super.addImpl(comp, constraints, index);
    }

    public static interface SelectionListener {
        public void onselect(PopupItem var1);
    }

    private class DefaultSelectionModel {
        PopupList root;
        private JComponent container;
        private ItemLabel selectedItem;

        DefaultSelectionModel(JComponent container) {
            this.root = PopupList.this;
            this.container = container;
        }

        public ItemLabel getSelectedItem() {
            return this.selectedItem;
        }

        public void setSelectedItem(ItemLabel selectedItem) {
            this.selectedItem = selectedItem;
        }

        public void refresh() {
            Component[] comps = this.container.getComponents();
            for (int i = 0; i < comps.length; ++i) {
                Component c = comps[i];
                if (!(c instanceof ItemLabel)) continue;
                ItemLabel item = (ItemLabel)c;
                item.setBackground(Color.WHITE);
                item.setForeground(this.root.getForeground());
                item.repaint();
            }
            ItemLabel item = this.getSelectedItem();
            if (item != null) {
                item.setBackground(this.root.getSelectionBackground());
                item.setForeground(this.root.getSelectionForeground());
                item.repaint();
            }
        }
    }

    private class ItemLabel
    extends JLabel
    implements MouseListener {
        PopupList root;
        private PopupItem item;

        ItemLabel(PopupItem item) {
            this.root = PopupList.this;
            this.item = item;
            this.setOpaque(true);
            this.setBackground(Color.WHITE);
            this.setBorder(BorderFactory.createEmptyBorder(2, 5, 2, 5));
            this.addMouseListener(this);
            String caption = item == null ? null : item.getCaption();
            this.setText(caption == null ? "" : caption.toString());
        }

        public PopupItem getPopupItem() {
            return this.item;
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            if (this.root.model == null) {
                return;
            }
            this.root.model.setSelectedItem(this);
            this.root.model.refresh();
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 2) {
                return;
            }
            if (!SwingUtilities.isLeftMouseButton(e)) {
                return;
            }
            for (SelectionListener sl : this.root.listeners) {
                sl.onselect(this.item);
            }
        }
    }

    private class DefaultLayout
    implements LayoutManager {
        PopupList root;
        private int SPACING;

        private DefaultLayout() {
            this.root = PopupList.this;
            this.SPACING = 1;
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return this.getLayoutSize(parent);
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return this.getLayoutSize(parent);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Dimension getLayoutSize(Container parent) {
            Object object = parent.getTreeLock();
            synchronized (object) {
                int w = 0;
                int h = 0;
                boolean has_visibled_items = false;
                Component[] comps = parent.getComponents();
                for (int i = 0; i < comps.length; ++i) {
                    Component c = comps[i];
                    if (!c.isVisible()) continue;
                    if (has_visibled_items) {
                        h += this.SPACING;
                    }
                    Dimension dim = c.getPreferredSize();
                    w = Math.max(dim.width, w);
                    h += this.root.getRowHeight();
                    has_visibled_items = true;
                }
                if (this.root.invoker != null) {
                    Insets m = this.root.invoker.getInsets();
                    w = Math.max(w, this.root.invoker.getWidth() - m.left + 1);
                }
                Insets margin = parent.getInsets();
                return new Dimension(w += margin.left + margin.right, h += margin.top + margin.bottom);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void layoutContainer(Container parent) {
            Object object = parent.getTreeLock();
            synchronized (object) {
                Insets margin = parent.getInsets();
                int pw = parent.getWidth();
                int ph = parent.getHeight();
                int x = margin.left;
                int y = margin.top;
                int w = pw - (margin.left + margin.right);
                int rowHeight = this.root.getRowHeight();
                boolean has_visibled_items = false;
                Component[] comps = parent.getComponents();
                for (int i = 0; i < comps.length; ++i) {
                    Component c = comps[i];
                    if (!c.isVisible()) continue;
                    if (has_visibled_items) {
                        ++y;
                    }
                    Dimension dim = c.getPreferredSize();
                    c.setBounds(x, y, w, rowHeight);
                    y += rowHeight;
                    has_visibled_items = true;
                }
            }
        }
    }
}

