/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.control.panel;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.ArrayList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;

class WrapPanel
extends JPanel {
    private ViewportHandlerImpl viewHandler;
    private LayoutImpl layout;
    private Container viewPort;
    private JScrollPane scroller;
    private int cellSpacing;
    private Dimension cellSize;
    private Insets padding;

    public WrapPanel() {
        this.initComponent();
    }

    private void initComponent() {
        this.layout = new LayoutImpl();
        super.setLayout(this.layout);
        this.viewHandler = new ViewportHandlerImpl();
        this.padding = new Insets(5, 5, 5, 5);
        this.cellSize = new Dimension(80, 80);
        this.cellSpacing = 5;
    }

    @Override
    public void setLayout(LayoutManager mgr) {
    }

    public int getCellSpacing() {
        return this.cellSpacing;
    }

    public void setCellSpacing(int cellSpacing) {
        this.cellSpacing = cellSpacing;
    }

    public Dimension getCellSize() {
        return this.cellSize;
    }

    public void setCellSize(Dimension cellSize) {
        this.cellSize = cellSize;
    }

    public Insets getPadding() {
        return this.padding;
    }

    public void setPadding(Insets padding) {
        this.padding = padding;
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (this.viewPort != null) {
            this.viewPort.removeComponentListener(this.viewHandler);
        }
        this.viewPort = null;
        if (this.getParent() instanceof JViewport) {
            this.viewPort = this.getParent();
            this.viewPort.addComponentListener(this.viewHandler);
            if (this.viewPort.getParent() instanceof JScrollPane) {
                JScrollPane jsp = (JScrollPane)this.viewPort.getParent();
                jsp.setHorizontalScrollBarPolicy(31);
                jsp.setVerticalScrollBarPolicy(20);
                jsp.getVerticalScrollBar().setUnitIncrement(10);
                this.scroller = jsp;
            }
        } else {
            this.addComponentListener(this.viewHandler);
        }
    }

    @Override
    public void removeNotify() {
        this.removeComponentListener(this.viewHandler);
        if (this.viewPort != null) {
            this.viewPort.removeComponentListener(this.viewHandler);
        }
        this.viewPort = null;
        this.scroller = null;
        super.removeNotify();
    }

    private Dimension getPreferredCellSize() {
        Dimension dim = this.getCellSize();
        if (dim == null) {
            dim = new Dimension(80, 80);
        }
        return dim;
    }

    private class CellInfo {
        int rowIndex;
        int colIndex;
        int width;
        int height;
        Component comp;

        private CellInfo() {
        }
    }

    private class TableInfo {
        int rowIndex;
        int colIndex;
        int cellIndex;
        int maxColIndex;
        int spacing;
        CellInfo[] cells;
        Dimension cellSize;

        TableInfo(int size, int spacing, Dimension cellSize) {
            this.cells = new CellInfo[size];
            this.spacing = spacing > 0 ? spacing : 0;
            this.cellSize = cellSize;
        }

        CellInfo addCell(Component comp) {
            CellInfo c = new CellInfo();
            c.comp = comp;
            c.width = this.cellSize.width;
            c.height = this.cellSize.height;
            c.rowIndex = this.rowIndex;
            c.colIndex = this.colIndex++;
            this.cells[this.cellIndex] = c;
            ++this.cellIndex;
            this.maxColIndex = Math.max(this.maxColIndex, c.colIndex);
            return c;
        }

        void moveToNextRow(CellInfo ci) {
            if (ci == null) {
                return;
            }
            this.colIndex = 0;
            ci.rowIndex = this.rowIndex = ci.rowIndex + 1;
            ci.colIndex = this.colIndex;
        }

        void addRow() {
            this.colIndex = 0;
            ++this.rowIndex;
        }

        Dimension getCurrentRowSize() {
            return this.getRowSize(this.rowIndex);
        }

        Dimension getRowSize(int index) {
            int w = 0;
            int h = 0;
            CellInfo[] arr = this.getRowCells(index);
            for (int i = 0; i < arr.length; ++i) {
                w += arr[i].width;
                h = Math.max(h, arr[i].height);
            }
            if (arr.length > 1 && this.spacing > 0) {
                w += (arr.length - 1) * this.spacing;
            }
            return new Dimension(w, h);
        }

        int getCellMaxWidth(int index) {
            int maxw = 0;
            for (int i = 0; i < this.cells.length; ++i) {
                if (this.cells[i] == null || this.cells[i].colIndex != index) continue;
                maxw = Math.max(maxw, this.cells[i].width);
            }
            return maxw;
        }

        int getCellMaxHeight(int index) {
            int maxh = 0;
            for (int i = 0; i < this.cells.length; ++i) {
                if (this.cells[i] == null || this.cells[i].rowIndex != index) continue;
                maxh = Math.max(maxh, this.cells[i].height);
            }
            return maxh;
        }

        Dimension getSize() {
            int w = 0;
            int h = 0;
            for (int i = 0; i <= this.rowIndex; ++i) {
                Dimension dim = this.getRowSize(i);
                w = Math.max(w, dim.width);
                h += dim.height;
            }
            if (this.rowIndex > 1 && this.spacing > 0) {
                h += (this.rowIndex - 1) * this.spacing;
            }
            return new Dimension(w, h);
        }

        CellInfo[] getRowCells(int index) {
            ArrayList<CellInfo> list = new ArrayList<CellInfo>();
            for (int i = 0; i < this.cells.length; ++i) {
                if (this.cells[i] == null || this.cells[i].rowIndex != index) continue;
                list.add(this.cells[i]);
            }
            return list.toArray(new CellInfo[0]);
        }
    }

    private class LayoutImpl
    implements LayoutManager {
        WrapPanel root;
        int maxWidth;

        private LayoutImpl() {
            this.root = WrapPanel.this;
            this.maxWidth = Integer.MAX_VALUE;
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        private Component[] getVisibleComponents(Container parent) {
            ArrayList<Component> list = new ArrayList<Component>();
            Component[] comps = parent.getComponents();
            for (int i = 0; i < comps.length; ++i) {
                if (!comps[i].isVisible()) continue;
                list.add(comps[i]);
            }
            return list.toArray(new Component[0]);
        }

        private boolean isInViewport(Container parent) {
            return parent.getParent() instanceof JViewport;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Dimension getLayoutSize(Container parent) {
            Object object = parent.getTreeLock();
            synchronized (object) {
                Insets margin = parent.getInsets();
                int w = margin.left + margin.right;
                int h = margin.top + margin.bottom;
                Insets pad = this.root.getPadding();
                if (pad != null) {
                    w += pad.left + pad.right;
                    h += pad.top + pad.bottom;
                }
                Dimension dim = this.root.getPreferredCellSize();
                if (this.isInViewport(parent)) {
                    TableInfo table = this.buildTable(parent);
                    dim = table.getSize();
                }
                return new Dimension(w += dim.width, h += dim.height);
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return this.getLayoutSize(parent);
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return this.getLayoutSize(parent);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void layoutContainer(Container parent) {
            Object object = parent.getTreeLock();
            synchronized (object) {
                Insets pad = this.root.getPadding();
                if (pad == null) {
                    pad = new Insets(0, 0, 0, 0);
                }
                Insets margin = parent.getInsets();
                int x = margin.left + pad.left;
                int y = margin.top + pad.top;
                TableInfo table = this.buildTable(parent);
                for (int r = 0; r <= table.rowIndex; ++r) {
                    if (r > 0) {
                        y += table.spacing;
                    }
                    Dimension rowdim = table.getRowSize(r);
                    CellInfo[] cells = table.getRowCells(r);
                    for (int i = 0; i < cells.length; ++i) {
                        if (i > 0) {
                            x += table.spacing;
                        }
                        Component comp = cells[i].comp;
                        comp.setBounds(x, y, cells[i].width, cells[i].height);
                        x += cells[i].width;
                    }
                    y += rowdim.height;
                    x = margin.left + pad.left;
                }
            }
        }

        private TableInfo buildTable(Container parent) {
            Insets margin = parent.getInsets();
            Component[] comps = this.getVisibleComponents(parent);
            TableInfo table = new TableInfo(comps.length, this.root.getCellSpacing(), this.root.getPreferredCellSize());
            for (int i = 0; i < comps.length; ++i) {
                CellInfo ci = table.addCell(comps[i]);
                Dimension rowdim = table.getCurrentRowSize();
                int rwidth = rowdim.width + margin.left + margin.right;
                if (rwidth <= this.maxWidth) continue;
                table.moveToNextRow(ci);
            }
            return table;
        }
    }

    private class ViewportHandlerImpl
    extends ComponentAdapter {
        WrapPanel root;

        private ViewportHandlerImpl() {
            this.root = WrapPanel.this;
        }

        @Override
        public void componentResized(ComponentEvent e) {
            Component comp = e.getComponent();
            Dimension dim = comp.getSize();
            ((WrapPanel)this.root).layout.maxWidth = dim.width;
            if (comp instanceof JViewport) {
                ((WrapPanel)this.root).layout.maxWidth = dim.width - 30;
            }
            this.root.revalidate();
        }
    }
}

