/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.control.panel;

import com.rameses.rcp.control.panel.TileLabel;
import com.rameses.rcp.control.panel.WrapPanel;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;

public class TilePanel
extends WrapPanel {
    private boolean showCaptions = true;
    private String textAlignment;
    private String alignment;
    private Object selectedItem;

    public TilePanel() {
        this.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                try {
                    TilePanel.this.clearSelection();
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        });
    }

    @Override
    public void setLayout(LayoutManager mgr) {
    }

    public String getTextAlignment() {
        return this.textAlignment;
    }

    public void setTextAlignment(String textAlignment) {
        this.textAlignment = textAlignment;
    }

    public String getAlignment() {
        return this.alignment;
    }

    public void setAlignment(String alignment) {
        this.alignment = alignment;
    }

    public boolean isShowCaptions() {
        return this.showCaptions;
    }

    public void setShowCaptions(boolean showCaptions) {
        this.showCaptions = showCaptions;
    }

    public void addItem(String caption, Object userObject) {
        this.addItem(caption, userObject);
    }

    public void addItem(String caption, Object userObject, ImageIcon icon) {
        TileItem ti = new TileItem(caption, userObject, icon);
        super.add(ti);
    }

    public Object getSelectedItem() {
        return this.selectedItem;
    }

    public TileItem getItem(Object userObject) {
        int idx = this.indexOf(userObject);
        return this.getItem(idx);
    }

    public TileItem getItem(int index) {
        try {
            return (TileItem)this.getComponent(index);
        }
        catch (Throwable t) {
            return null;
        }
    }

    public void removeItem(Object userObject) {
        int idx = this.indexOf(userObject);
        this.removeItem(idx);
    }

    public void removeItem(int index) {
        if (index >= 0 && index < this.getComponentCount()) {
            this.remove(index);
        }
    }

    public int indexOf(Object userObject) {
        Component[] comps = this.getComponents();
        for (int i = 0; i < comps.length; ++i) {
            if (!(comps[i] instanceof TileItem)) continue;
            TileItem item = (TileItem)comps[i];
            Object itemobj = item.getUserObject();
            if (userObject == null && itemobj == null) {
                return i;
            }
            if (userObject != null && userObject.equals(itemobj)) {
                return i;
            }
            if (itemobj == null || !itemobj.equals(userObject)) continue;
            return i;
        }
        return -1;
    }

    @Override
    protected void addImpl(Component comp, Object constraints, int index) {
        if (!(comp instanceof TileItem)) {
            throw new IllegalStateException("This container only supports TileItem component. Please use addItem to correct this.");
        }
        TileItem ti = (TileItem)comp;
        ti.setAlignment(this.getAlignment());
        ti.setTextAlignment(this.getTextAlignment());
        super.addImpl(comp, constraints, index);
    }

    protected void onselect(Object item) {
    }

    private void clearSelection() {
        Component[] comps = this.getComponents();
        for (int i = 0; i < comps.length; ++i) {
            if (!(comps[i] instanceof TileItem)) continue;
            TileItem ti = (TileItem)comps[i];
            ti.setSelected(false);
            ti.repaint();
        }
    }

    private class ContainerLayout
    implements LayoutManager {
        private ContainerLayout() {
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        private TileItem[] getVisibleComponents(Container parent) {
            ArrayList<TileItem> list = new ArrayList<TileItem>();
            Component[] comps = parent.getComponents();
            for (int i = 0; i < comps.length; ++i) {
                if (!(comps[i] instanceof TileItem)) continue;
                list.add((TileItem)comps[i]);
            }
            return list.toArray(new TileItem[0]);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Dimension getLayoutSize(Container parent) {
            Object object = parent.getTreeLock();
            synchronized (object) {
                Dimension newdim = new Dimension(0, 0);
                Dimension celldim = TilePanel.this.getCellSize();
                Insets margin = parent.getInsets();
                TileItem[] items = this.getVisibleComponents(parent);
                for (int i = 0; i < items.length; ++i) {
                    if (i > 0) {
                        newdim.width += Math.max(TilePanel.this.getCellSpacing(), 0);
                    }
                    TileItem c = items[i];
                    newdim.width += celldim.width;
                    newdim.height = celldim.height;
                }
                Insets pads = TilePanel.this.getPadding();
                if (pads != null) {
                    newdim.width += margin.left + margin.right + pads.left + pads.right;
                    newdim.height += margin.top + margin.bottom + pads.top + pads.bottom;
                }
                return newdim;
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return this.getLayoutSize(parent);
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return this.getLayoutSize(parent);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void layoutContainer(Container parent) {
            Object object = parent.getTreeLock();
            synchronized (object) {
                Insets pads = TilePanel.this.getPadding();
                if (pads == null) {
                    pads = new Insets(0, 0, 0, 0);
                }
                Dimension celldim = TilePanel.this.getCellSize();
                Insets margin = parent.getInsets();
                int x = margin.left + pads.left;
                int y = margin.top + pads.top;
                int w = parent.getWidth() - (margin.left + margin.right + pads.left + pads.right);
                int h = parent.getHeight() - (margin.top + margin.bottom + pads.top + pads.bottom);
                int rb = parent.getWidth() - (margin.right + pads.right);
                boolean firstItemInRow = true;
                TileItem[] items = this.getVisibleComponents(parent);
                for (int i = 0; i < items.length; ++i) {
                    if (i > 0) {
                        x += Math.max(TilePanel.this.getCellSpacing(), 0);
                    }
                    TileItem c = items[i];
                    if (firstItemInRow) {
                        firstItemInRow = false;
                        c.setSize(celldim.width, celldim.height);
                        c.setLocation(x, y);
                    } else if (x + celldim.width > rb) {
                        x = margin.left + pads.left;
                        firstItemInRow = false;
                        c.setSize(celldim.width, celldim.height);
                        c.setLocation(x, y += celldim.height + Math.max(TilePanel.this.getCellSpacing(), 0));
                    } else {
                        c.setSize(celldim.width, celldim.height);
                        c.setLocation(x, y);
                    }
                    x += celldim.width;
                }
            }
        }
    }

    private class TileItemMouseAdapter
    implements MouseListener {
        private TileItem source;
        private boolean pressed;
        private boolean processing;

        TileItemMouseAdapter(TileItem source) {
            this.source = source;
            source.addMouseListener(this);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.pressed = true;
            TilePanel.this.clearSelection();
            this.source.setSelected(true);
            this.source.repaint();
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (this.pressed) {
                this.pressed = false;
                TilePanel.this.clearSelection();
                this.source.setSelected(true);
                this.source.repaint();
                try {
                    Thread.currentThread();
                    Thread.sleep(68L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (e.getClickCount() == 2) {
                    return;
                }
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        TileItemMouseAdapter.this.doClick();
                    }
                });
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            Component[] comps = TilePanel.this.getComponents();
            for (int i = 0; i < comps.length; ++i) {
                if (!(comps[i] instanceof TileItem)) continue;
                TileItem ti = (TileItem)comps[i];
                ti.setMouseEntered(false);
                ti.repaint();
            }
            this.source.setMouseEntered(true);
            this.source.repaint();
        }

        @Override
        public void mouseExited(MouseEvent e) {
            if (this.pressed) {
                this.pressed = false;
                this.source.setSelected(false);
            }
            this.source.setMouseEntered(false);
            this.source.repaint();
        }

        void doClick() {
            TilePanel.this.selectedItem = this.source.getUserObject();
            TilePanel.this.onselect(TilePanel.this.selectedItem);
        }
    }

    class XTileItem
    extends JLabel {
        private Color selBackground;
        private Color selBorderBackground;
        private String text;
        private Object userObject;
        private ImageIcon icon;
        private boolean mouse_entered;
        private boolean selected;

        public XTileItem(String text, Object userObject) {
            this(text, userObject, null);
        }

        public XTileItem(String text, Object userObject, ImageIcon icon) {
            this.text = text;
            this.icon = icon;
            this.userObject = userObject;
            if (TilePanel.this.isShowCaptions()) {
                this.setText("<html><center>" + text + "</center></html>");
            }
            this.selBackground = Color.decode("#c1dcfc");
            this.selBorderBackground = Color.decode("#7da2ce");
            this.setBorder(BorderFactory.createEmptyBorder(3, 3, 0, 3));
            this.setVerticalAlignment(1);
            this.setHorizontalAlignment(0);
            this.setVerticalTextPosition(1);
            this.setHorizontalTextPosition(0);
        }

        public Object getUserObject() {
            return this.userObject;
        }

        public void setUserObject(Object userObject) {
            this.userObject = userObject;
        }

        @Override
        public Icon getIcon() {
            return this.icon;
        }

        public void setIcon(ImageIcon icon) {
            this.icon = icon;
        }

        public void setTextAlignment(String alignment) {
            if (alignment == null) {
                return;
            }
            if (alignment.equalsIgnoreCase("TOP")) {
                this.setVerticalTextPosition(1);
                this.setHorizontalTextPosition(0);
            } else if (alignment.equalsIgnoreCase("BOTTOM")) {
                this.setVerticalTextPosition(3);
                this.setHorizontalTextPosition(0);
            } else if (alignment.equalsIgnoreCase("TOP_LEFT")) {
                this.setVerticalTextPosition(1);
                this.setHorizontalTextPosition(2);
            } else if (alignment.equalsIgnoreCase("TOP_CENTER")) {
                this.setVerticalTextPosition(1);
                this.setHorizontalTextPosition(0);
            } else if (alignment.equalsIgnoreCase("TOP_RIGHT")) {
                this.setVerticalTextPosition(1);
                this.setHorizontalTextPosition(4);
            } else if (alignment.equalsIgnoreCase("BOTTOM_LEFT")) {
                this.setVerticalTextPosition(3);
                this.setHorizontalTextPosition(2);
            } else if (alignment.equalsIgnoreCase("BOTTOM_CENTER")) {
                this.setVerticalTextPosition(3);
                this.setHorizontalTextPosition(0);
            } else if (alignment.equalsIgnoreCase("BOTTOM_RIGHT")) {
                this.setVerticalTextPosition(3);
                this.setHorizontalTextPosition(4);
            } else {
                this.setVerticalTextPosition(0);
                this.setHorizontalTextPosition(0);
            }
        }

        public void setAlignment(String alignment) {
            if (alignment == null) {
                return;
            }
            if (alignment.equalsIgnoreCase("TOP")) {
                this.setVerticalAlignment(1);
                this.setHorizontalAlignment(0);
            } else if (alignment.equalsIgnoreCase("BOTTOM")) {
                this.setVerticalAlignment(3);
                this.setHorizontalAlignment(0);
            } else if (alignment.equalsIgnoreCase("TOP_LEFT")) {
                this.setVerticalAlignment(1);
                this.setHorizontalAlignment(2);
            } else if (alignment.equalsIgnoreCase("TOP_CENTER")) {
                this.setVerticalAlignment(1);
                this.setHorizontalAlignment(0);
            } else if (alignment.equalsIgnoreCase("TOP_RIGHT")) {
                this.setVerticalAlignment(1);
                this.setHorizontalAlignment(4);
            } else if (alignment.equalsIgnoreCase("BOTTOM_LEFT")) {
                this.setVerticalAlignment(3);
                this.setHorizontalAlignment(2);
            } else if (alignment.equalsIgnoreCase("BOTTOM_CENTER")) {
                this.setVerticalAlignment(3);
                this.setHorizontalAlignment(0);
            } else if (alignment.equalsIgnoreCase("BOTTOM_RIGHT")) {
                this.setVerticalAlignment(3);
                this.setHorizontalAlignment(4);
            } else {
                this.setVerticalAlignment(0);
                this.setHorizontalAlignment(0);
            }
        }

        boolean isMouseEntered() {
            return this.mouse_entered;
        }

        void setMouseEntered(boolean mouse_entered) {
            this.mouse_entered = mouse_entered;
        }

        boolean isSelected() {
            return this.selected;
        }

        void setSelected(boolean selected) {
            this.selected = selected;
        }

        @Override
        protected void paintComponent(Graphics g) {
            int width = this.getWidth();
            int height = this.getHeight();
            Graphics2D g2 = (Graphics2D)g.create();
            if (this.isSelected()) {
                g2.setColor(this.selBackground);
                g2.fillRoundRect(0, 0, width - 1, height - 1, 3, 3);
            } else if (this.isMouseEntered()) {
                g2.setComposite(AlphaComposite.getInstance(10, 0.4f));
                g2.setColor(this.selBackground);
                g2.fillRoundRect(0, 0, width - 1, height - 1, 3, 3);
            }
            g2.dispose();
            super.paintComponent(g);
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            int width = this.getWidth();
            int height = this.getHeight();
            Graphics2D g2 = (Graphics2D)g.create();
            if (this.isSelected()) {
                g2.setColor(this.selBorderBackground);
                g2.drawRoundRect(0, 0, width - 1, height - 1, 3, 3);
            } else if (this.isMouseEntered()) {
                g2.setComposite(AlphaComposite.getInstance(10, 0.4f));
                g2.setColor(this.selBorderBackground);
                g2.drawRoundRect(0, 0, width - 1, height - 1, 3, 3);
            }
            g2.dispose();
        }
    }

    class TileItem
    extends TileLabel {
        private Color selBackground;
        private Color selBorderBackground;
        private Object userObject;
        private boolean mouse_entered;
        private boolean selected;

        public TileItem(String text, Object userObject) {
            this(text, userObject, null);
        }

        public TileItem(String text, Object userObject, ImageIcon icon) {
            this.userObject = userObject;
            this.setText(text);
            this.setImageIcon(icon);
            this.selBackground = Color.decode("#c1dcfc");
            this.selBorderBackground = Color.decode("#7da2ce");
            new TileItemMouseAdapter(this);
        }

        public Object getUserObject() {
            return this.userObject;
        }

        public void setUserObject(Object userObject) {
            this.userObject = userObject;
        }

        public void setTextAlignment(String alignment) {
            if (alignment == null) {
                return;
            }
            if (alignment.equalsIgnoreCase("TOP")) {
                this.setVerticalTextPosition(1);
                this.setHorizontalTextPosition(0);
            } else if (alignment.equalsIgnoreCase("BOTTOM")) {
                this.setVerticalTextPosition(3);
                this.setHorizontalTextPosition(0);
            } else if (alignment.equalsIgnoreCase("TOP_LEFT")) {
                this.setVerticalTextPosition(1);
                this.setHorizontalTextPosition(2);
            } else if (alignment.equalsIgnoreCase("TOP_CENTER")) {
                this.setVerticalTextPosition(1);
                this.setHorizontalTextPosition(0);
            } else if (alignment.equalsIgnoreCase("TOP_RIGHT")) {
                this.setVerticalTextPosition(1);
                this.setHorizontalTextPosition(4);
            } else if (alignment.equalsIgnoreCase("BOTTOM_LEFT")) {
                this.setVerticalTextPosition(3);
                this.setHorizontalTextPosition(2);
            } else if (alignment.equalsIgnoreCase("BOTTOM_CENTER")) {
                this.setVerticalTextPosition(3);
                this.setHorizontalTextPosition(0);
            } else if (alignment.equalsIgnoreCase("BOTTOM_RIGHT")) {
                this.setVerticalTextPosition(3);
                this.setHorizontalTextPosition(4);
            } else {
                this.setVerticalTextPosition(0);
                this.setHorizontalTextPosition(0);
            }
        }

        public void setAlignment(String alignment) {
            if (alignment == null) {
                return;
            }
            if (alignment.equalsIgnoreCase("TOP")) {
                this.setVerticalAlignment(1);
                this.setHorizontalAlignment(0);
            } else if (alignment.equalsIgnoreCase("BOTTOM")) {
                this.setVerticalAlignment(3);
                this.setHorizontalAlignment(0);
            } else if (alignment.equalsIgnoreCase("TOP_LEFT")) {
                this.setVerticalAlignment(1);
                this.setHorizontalAlignment(2);
            } else if (alignment.equalsIgnoreCase("TOP_CENTER")) {
                this.setVerticalAlignment(1);
                this.setHorizontalAlignment(0);
            } else if (alignment.equalsIgnoreCase("TOP_RIGHT")) {
                this.setVerticalAlignment(1);
                this.setHorizontalAlignment(4);
            } else if (alignment.equalsIgnoreCase("BOTTOM_LEFT")) {
                this.setVerticalAlignment(3);
                this.setHorizontalAlignment(2);
            } else if (alignment.equalsIgnoreCase("BOTTOM_CENTER")) {
                this.setVerticalAlignment(3);
                this.setHorizontalAlignment(0);
            } else if (alignment.equalsIgnoreCase("BOTTOM_RIGHT")) {
                this.setVerticalAlignment(3);
                this.setHorizontalAlignment(4);
            } else {
                this.setVerticalAlignment(0);
                this.setHorizontalAlignment(0);
            }
        }

        boolean isMouseEntered() {
            return this.mouse_entered;
        }

        void setMouseEntered(boolean mouse_entered) {
            this.mouse_entered = mouse_entered;
        }

        boolean isSelected() {
            return this.selected;
        }

        void setSelected(boolean selected) {
            this.selected = selected;
        }

        @Override
        protected void paintComponent(Graphics g) {
            int width = this.getWidth();
            int height = this.getHeight();
            Graphics2D g2 = (Graphics2D)g.create();
            if (this.isSelected()) {
                g2.setColor(this.selBackground);
                g2.fillRoundRect(0, 0, width - 1, height - 1, 3, 3);
            } else if (this.isMouseEntered()) {
                g2.setComposite(AlphaComposite.getInstance(10, 0.4f));
                g2.setColor(this.selBackground);
                g2.fillRoundRect(0, 0, width - 1, height - 1, 3, 3);
            }
            g2.dispose();
            super.paintComponent(g);
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            int width = this.getWidth();
            int height = this.getHeight();
            Graphics2D g2 = (Graphics2D)g.create();
            if (this.isSelected()) {
                g2.setColor(this.selBorderBackground);
                g2.drawRoundRect(0, 0, width - 1, height - 1, 3, 3);
            } else if (this.isMouseEntered()) {
                g2.setComposite(AlphaComposite.getInstance(10, 0.4f));
                g2.setColor(this.selBorderBackground);
                g2.drawRoundRect(0, 0, width - 1, height - 1, 3, 3);
            }
            g2.dispose();
        }
    }
}

