/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.control.panel;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;

public class TileLabel
extends JLabel {
    private JLabel iconLabel;
    private JLabel textLabel;
    private Dimension iconSize;
    private ImageIcon icon;
    private String text;

    public TileLabel() {
        this.setLayout(new ContainerLayout());
        this.iconSize = new Dimension(48, 48);
    }

    private JLabel getIconLabel() {
        if (this.iconLabel == null) {
            this.iconLabel = new JLabel();
            this.iconLabel.setHorizontalAlignment(0);
            this.iconLabel.setVerticalAlignment(0);
            this.iconLabel.setBorder(BorderFactory.createLineBorder(Color.BLUE));
            this.iconLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            this.iconLabel.setOpaque(false);
        }
        return this.iconLabel;
    }

    private JLabel getTextLabel() {
        if (this.textLabel == null) {
            this.textLabel = new JLabel();
            this.textLabel.setHorizontalAlignment(0);
            this.textLabel.setVerticalAlignment(1);
            this.textLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            this.textLabel.setOpaque(false);
        }
        return this.textLabel;
    }

    public Dimension getIconSize() {
        return this.iconSize;
    }

    public void setIconSize(Dimension iconSize) {
        this.iconSize = iconSize;
    }

    @Override
    public String getText() {
        return null;
    }

    @Override
    public void setText(String text) {
        this.text = text;
        if (text == null) {
            this.getTextLabel().setText(text);
        } else {
            this.getTextLabel().setText("<html><center>" + text + "</center></html>");
        }
    }

    @Override
    public void setIcon(Icon icon) {
    }

    public ImageIcon getImageIcon() {
        return this.icon;
    }

    public void setImageIcon(ImageIcon icon) {
        this.icon = icon;
        this.getIconLabel().setIcon(icon);
    }

    private class ContainerLayout
    implements LayoutManager {
        private ContainerLayout() {
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Dimension getLayoutSize(Container parent) {
            Object object = parent.getTreeLock();
            synchronized (object) {
                JLabel comp;
                Dimension newdim = new Dimension(0, 0);
                Dimension icondim = TileLabel.this.getIconSize();
                if (icondim != null) {
                    newdim.width = icondim.width;
                    newdim.height = icondim.height;
                }
                if ((comp = TileLabel.this.getTextLabel()) != null) {
                    Dimension dim = ((Component)comp).getPreferredSize();
                    newdim.width = Math.max(newdim.width, dim.width);
                    newdim.height += dim.height;
                }
                Insets margin = parent.getInsets();
                newdim.width += margin.left + margin.right;
                newdim.height += margin.top + margin.bottom;
                return newdim;
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return this.getLayoutSize(parent);
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return this.getLayoutSize(parent);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void layoutContainer(Container parent) {
            Object object = parent.getTreeLock();
            synchronized (object) {
                JLabel comp;
                Insets margin = parent.getInsets();
                int x = margin.left;
                int y = margin.top;
                int w = parent.getWidth() - (margin.left + margin.right);
                int h = parent.getHeight() - (margin.top + margin.bottom);
                Dimension icondim = TileLabel.this.getIconSize();
                if (icondim != null) {
                    JLabel iconLabel = TileLabel.this.getIconLabel();
                    if (iconLabel.getParent() == null) {
                        parent.add(iconLabel);
                    }
                    iconLabel.setBounds(x, y, w, icondim.height);
                    y += icondim.height;
                    h -= icondim.height;
                }
                if ((comp = TileLabel.this.getTextLabel()).getParent() == null) {
                    parent.add(comp);
                }
                comp.setBounds(x, y, w, h);
            }
        }
    }
}

