/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.control.menu;

import com.rameses.rcp.control.menu.VMenu;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.EventListener;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;

public class VMenuBar
extends JPanel {
    private final Object ItemSelectionLocked = new Object();
    private ItemSelectionModel ism = new ItemSelectionModel();

    public VMenuBar() {
        this.initComponent();
    }

    private void initComponent() {
        super.setLayout(new LayoutManagerImpl());
        this.addContainerListener(new ContainerListener(){

            @Override
            public void componentAdded(ContainerEvent e) {
                if (e.getChild() instanceof JMenuItem) {
                    VMenuBar.this.getRoot().componentAdded((JMenuItem)e.getChild());
                }
            }

            @Override
            public void componentRemoved(ContainerEvent e) {
                if (e.getChild() instanceof JMenuItem) {
                    VMenuBar.this.getRoot().componentRemoved((JMenuItem)e.getChild());
                }
            }
        });
        AWTEventHandler handler = new AWTEventHandler();
        Toolkit.getDefaultToolkit().addAWTEventListener(handler, 16L);
    }

    private VMenuBar getRoot() {
        return this;
    }

    @Override
    public void setLayout(LayoutManager mgr) {
    }

    private void componentAdded(JMenuItem mi) {
        EventListener h;
        if (mi == null) {
            return;
        }
        Object o = mi.getClientProperty(MenuItemMouseHandler.class);
        if (!(o instanceof MenuItemMouseHandler)) {
            h = new MenuItemMouseHandler();
            mi.addMouseListener((MouseListener)h);
            mi.putClientProperty(MenuItemMouseHandler.class, h);
        }
        if (!(mi instanceof JMenu) && !((o = mi.getClientProperty(VMenu.ActionHandler.class)) instanceof VMenu.ActionHandler)) {
            h = new VMenu.ActionHandler();
            mi.addActionListener((ActionListener)h);
            mi.putClientProperty(VMenu.ActionHandler.class, h);
        }
    }

    private void componentRemoved(JMenuItem mi) {
        EventListener h;
        if (mi == null) {
            return;
        }
        Object o = mi.getClientProperty(MenuItemMouseHandler.class);
        if (o instanceof MenuItemMouseHandler) {
            h = (MenuItemMouseHandler)o;
            mi.removeMouseListener((MouseListener)h);
        }
        if ((o = mi.getClientProperty(VMenu.ActionHandler.class)) instanceof VMenu.ActionHandler) {
            h = (VMenu.ActionHandler)o;
            mi.removeActionListener((ActionListener)h);
        }
    }

    public VMenu addMenu(String text) {
        VMenu m = new VMenu(text);
        this.add(m);
        return m;
    }

    public JMenuItem addMenuItem(String text) {
        JMenuItem mi = new JMenuItem(text);
        this.add(mi);
        return mi;
    }

    private class AWTEventHandler
    implements AWTEventListener {
        private AWTEventHandler() {
        }

        @Override
        public void eventDispatched(AWTEvent e) {
            if (e instanceof MouseEvent) {
                this.processMouseEvent((MouseEvent)e);
            }
        }

        private void processMouseEvent(MouseEvent e) {
            Component vm;
            Object source;
            if (e.getID() == 500 && (source = e.getSource()) instanceof Component && ((vm = this.findTopVMenuBar((Component)source)) == null || !vm.equals(VMenuBar.this.getRoot()))) {
                VMenuBar.this.getRoot().ism.deselectAll();
            }
        }

        private Component findTopVMenuBar(Component comp) {
            if (comp == null) {
                return null;
            }
            if (comp instanceof VMenuBar) {
                return comp;
            }
            if (comp instanceof JPopupMenu) {
                JPopupMenu pm = (JPopupMenu)comp;
                Component inv = pm.getInvoker();
                return inv == null ? null : this.findTopVMenuBar(inv);
            }
            return this.findTopVMenuBar(comp.getParent());
        }
    }

    private class MenuItemMouseHandler
    extends MouseAdapter {
        private MenuItemMouseHandler() {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            JMenuItem mi = (JMenuItem)e.getSource();
            VMenuBar.this.ism.select(mi);
        }
    }

    private class ItemSelectionModel {
        private JMenuItem selItem;

        private ItemSelectionModel() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void select(JMenuItem mi) {
            Object object = VMenuBar.this.getRoot().ItemSelectionLocked;
            synchronized (object) {
                this.selectImpl(mi);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void deselect(JMenuItem mi) {
            Object object = VMenuBar.this.getRoot().ItemSelectionLocked;
            synchronized (object) {
                this.deselectImpl(mi);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void deselectAll() {
            Object object = VMenuBar.this.getRoot().ItemSelectionLocked;
            synchronized (object) {
                this.deselectAllImpl();
            }
        }

        void selectImpl(JMenuItem mi) {
            if (this.selItem != null) {
                this.deselect(this.selItem);
                this.selItem = null;
            }
            mi.setArmed(true);
            mi.setSelected(true);
            mi.setRolloverEnabled(true);
            mi.setBorderPainted(true);
            mi.repaint();
            this.selItem = mi;
            if (mi instanceof JMenu) {
                JMenu jm = (JMenu)mi;
                jm.setPopupMenuVisible(true);
            }
        }

        void deselectImpl(JMenuItem mi) {
            mi.setArmed(false);
            mi.setSelected(false);
            mi.setRolloverEnabled(false);
            mi.setBorderPainted(false);
            mi.repaint();
            if (mi instanceof JMenu) {
                JMenu jm = (JMenu)mi;
                jm.setPopupMenuVisible(false);
            }
        }

        void deselectAllImpl() {
            Component[] comps = VMenuBar.this.getRoot().getComponents();
            for (int i = 0; i < comps.length; ++i) {
                if (!(comps[i] instanceof JMenuItem)) continue;
                this.deselectImpl((JMenuItem)comps[i]);
            }
        }
    }

    private class LayoutManagerImpl
    implements LayoutManager {
        final int MIN_HEIGHT = 24;

        private LayoutManagerImpl() {
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return this.getLayoutSize(parent);
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return this.getLayoutSize(parent);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Dimension getLayoutSize(Container parent) {
            Object object = parent.getTreeLock();
            synchronized (object) {
                int w = 0;
                int h = 0;
                Component[] comps = parent.getComponents();
                for (int i = 0; i < comps.length; ++i) {
                    if (!comps[i].isVisible()) continue;
                    Dimension dim = comps[i].getPreferredSize();
                    h += Math.max(dim.height, 24);
                    w = Math.max(dim.width, w);
                }
                Insets m = parent.getInsets();
                return new Dimension(w += m.left + m.right, h += m.top + m.bottom);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void layoutContainer(Container parent) {
            Object object = parent.getTreeLock();
            synchronized (object) {
                Insets pad = parent.getInsets();
                int pw = parent.getWidth();
                int ph = parent.getHeight();
                int x = pad.left;
                int y = pad.top;
                int w = pw - (pad.left + pad.right);
                int h = ph - (pad.top + pad.bottom);
                Component[] comps = parent.getComponents();
                for (int i = 0; i < comps.length; ++i) {
                    if (!comps[i].isVisible()) continue;
                    Dimension dim = comps[i].getPreferredSize();
                    int ch = Math.max(dim.height, 24);
                    comps[i].setBounds(x, y, w, ch);
                    comps[i].setSize(w, ch);
                    y += ch;
                }
            }
        }
    }
}

