/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.control.menu;

import com.rameses.rcp.common.Node;
import com.rameses.rcp.common.TreeNodeModel;
import com.rameses.rcp.control.menu.MenuItemProxy;
import com.rameses.rcp.ui.UIControl;
import com.rameses.rcp.util.ControlSupport;
import com.rameses.util.ValueUtil;
import javax.swing.JMenu;

public class MenuProxy
extends JMenu {
    private boolean init;
    private UIControl control;
    private TreeNodeModel nodeModel;
    private Node node;

    public MenuProxy(UIControl control, TreeNodeModel nodeModel, Node node) {
        this.control = control;
        this.node = node;
        this.nodeModel = nodeModel;
        super.setText(node.getCaption());
        if (!ValueUtil.isEmpty((Object)node.getIcon())) {
            super.setIcon(ControlSupport.getImageIcon(node.getIcon()));
        }
        if (!ValueUtil.isEmpty((Object)node.getMnemonic())) {
            super.setMnemonic(node.getMnemonic().trim().charAt(0));
        }
    }

    @Override
    public int getComponentCount() {
        if (!this.init) {
            for (Node n : this.nodeModel.fetchNodes(this.node)) {
                if (n.isLeaf()) {
                    this.add(new MenuItemProxy(this.control, this.nodeModel, n));
                    continue;
                }
                this.add(new MenuProxy(this.control, this.nodeModel, n));
            }
            this.init = true;
        }
        return super.getComponentCount();
    }
}

