/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.control.layout;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.HashMap;
import java.util.Map;

public class ToolbarLayout
implements LayoutManager {
    private Map<String, LayoutManager> layouts = new HashMap<String, LayoutManager>();
    private LayoutManager layout;
    private String orientation;
    private String alignment;
    private Insets padding;
    private int spacing;

    public ToolbarLayout() {
        this.layouts.put("HORIZONTAL", new HorizontalLayout());
        this.layouts.put("VERTICAL", new VerticalLayout());
        this.layouts.put("FLOW", new FlowLayout());
        this.layouts.put("XFLOW", new XFlowLayout());
        this.setOrientation("HORIZONTAL");
        this.setAlignment("LEFT");
        this.setPadding(null);
    }

    public String getOrientation() {
        return this.orientation;
    }

    public void setOrientation(String orientation) {
        this.orientation = orientation;
        this.layout = this.layouts.get(orientation);
        if (this.layout == null) {
            this.orientation = "HORIZONTAL";
            this.layout = this.layouts.get(orientation);
        }
    }

    public String getAlignment() {
        return this.alignment;
    }

    public void setAlignment(String alignment) {
        this.alignment = alignment;
    }

    public Insets getPadding() {
        return this.padding;
    }

    public void setPadding(Insets padding) {
        this.padding = padding == null ? new Insets(1, 1, 1, 1) : padding;
    }

    public int getSpacing() {
        return this.spacing;
    }

    public void setSpacing(int spacing) {
        this.spacing = spacing;
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
        if (this.layout != null) {
            this.layout.addLayoutComponent(name, comp);
        }
    }

    @Override
    public void removeLayoutComponent(Component comp) {
        if (this.layout != null) {
            this.layout.removeLayoutComponent(comp);
        }
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        if (this.layout != null) {
            return this.layout.preferredLayoutSize(parent);
        }
        return new Dimension(0, 0);
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        if (this.layout != null) {
            return this.layout.minimumLayoutSize(parent);
        }
        return new Dimension(0, 0);
    }

    @Override
    public void layoutContainer(Container parent) {
        if (this.layout != null) {
            this.layout.layoutContainer(parent);
        }
    }

    private class XFlowLayout
    implements LayoutManager {
        private int CELL_SIZE = 100;

        private XFlowLayout() {
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Dimension getLayoutSize(Container parent) {
            Object object = parent.getTreeLock();
            synchronized (object) {
                int w = this.CELL_SIZE + 20 + ((ToolbarLayout)ToolbarLayout.this).padding.left + ((ToolbarLayout)ToolbarLayout.this).padding.right;
                int h = this.CELL_SIZE - 20 + ((ToolbarLayout)ToolbarLayout.this).padding.top + ((ToolbarLayout)ToolbarLayout.this).padding.bottom;
                Insets margin = parent.getInsets();
                return new Dimension(w + margin.left + margin.right, w + margin.top + margin.bottom);
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return this.getLayoutSize(parent);
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return this.getLayoutSize(parent);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void layoutContainer(Container parent) {
            Object object = parent.getTreeLock();
            synchronized (object) {
                Insets margin = parent.getInsets();
                int x = margin.left;
                int y = margin.top;
                int pw = parent.getWidth();
                int ph = parent.getHeight();
                int w = pw - (margin.left + margin.right);
                int h = ph - (margin.top + margin.bottom);
                Component[] comps = parent.getComponents();
                if (comps.length == 0) {
                    return;
                }
                int colWidth = this.CELL_SIZE + 20 + ((ToolbarLayout)ToolbarLayout.this).padding.left + ((ToolbarLayout)ToolbarLayout.this).padding.right;
                int colHeight = this.CELL_SIZE - 20 + ((ToolbarLayout)ToolbarLayout.this).padding.top + ((ToolbarLayout)ToolbarLayout.this).padding.bottom;
                int colCount = w / colWidth;
                for (int i = 0; i < comps.length; ++i) {
                    int colIndex = 0;
                    boolean found = false;
                    for (int c = i; c < comps.length && colIndex < colCount; ++c) {
                        i = c;
                        if (!comps[c].isVisible()) continue;
                        Component comp = comps[c];
                        Dimension dim = comp.getPreferredSize();
                        if (found) {
                            x += ToolbarLayout.this.getSpacing();
                        }
                        comp.setBounds(x, y, colWidth, colHeight);
                        x += colWidth;
                        ++colIndex;
                        found = true;
                    }
                    x = margin.left;
                    y += colHeight;
                    if (!found) continue;
                    y += ToolbarLayout.this.getSpacing();
                }
            }
        }
    }

    private class FlowLayout
    implements LayoutManager {
        private int CELL_SIZE = 100;

        private FlowLayout() {
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Dimension getLayoutSize(Container parent) {
            Object object = parent.getTreeLock();
            synchronized (object) {
                int w = this.CELL_SIZE + ((ToolbarLayout)ToolbarLayout.this).padding.left + ((ToolbarLayout)ToolbarLayout.this).padding.right;
                int h = this.CELL_SIZE + ((ToolbarLayout)ToolbarLayout.this).padding.top + ((ToolbarLayout)ToolbarLayout.this).padding.bottom;
                Insets margin = parent.getInsets();
                return new Dimension(w + margin.left + margin.right, w + margin.top + margin.bottom);
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return this.getLayoutSize(parent);
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return this.getLayoutSize(parent);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void layoutContainer(Container parent) {
            Object object = parent.getTreeLock();
            synchronized (object) {
                Insets margin = parent.getInsets();
                int x = margin.left;
                int y = margin.top;
                int pw = parent.getWidth();
                int ph = parent.getHeight();
                int w = pw - (margin.left + margin.right);
                int h = ph - (margin.top + margin.bottom);
                Component[] comps = parent.getComponents();
                if (comps.length == 0) {
                    return;
                }
                int colWidth = this.CELL_SIZE + ((ToolbarLayout)ToolbarLayout.this).padding.left + ((ToolbarLayout)ToolbarLayout.this).padding.right;
                int colHeight = this.CELL_SIZE + ((ToolbarLayout)ToolbarLayout.this).padding.top + ((ToolbarLayout)ToolbarLayout.this).padding.bottom;
                int colCount = w / colWidth;
                for (int i = 0; i < comps.length; ++i) {
                    int colIndex = 0;
                    int rowHeight = 0;
                    boolean found = false;
                    for (int c = i; c < comps.length && colIndex < colCount; ++c) {
                        i = c;
                        if (!comps[c].isVisible()) continue;
                        Component comp = comps[c];
                        Dimension dim = comp.getPreferredSize();
                        if (found) {
                            x += ToolbarLayout.this.getSpacing();
                        }
                        colHeight = dim.width > colWidth ? colWidth / dim.width * dim.height / 3 + dim.height : dim.height;
                        comp.setBounds(x, y, colWidth, colHeight);
                        rowHeight = Math.max(rowHeight, colHeight);
                        x += colWidth;
                        ++colIndex;
                        found = true;
                    }
                    x = margin.left;
                    y += rowHeight;
                    if (!found) continue;
                    y += ToolbarLayout.this.getSpacing();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void layoutContainer2(Container parent) {
            Object object = parent.getTreeLock();
            synchronized (object) {
                Insets margin = parent.getInsets();
                int x = margin.left;
                int y = margin.top;
                int pw = parent.getWidth();
                int ph = parent.getHeight();
                int w = pw - (margin.left + margin.right);
                int h = ph - (margin.top + margin.bottom);
                Component[] comps = parent.getComponents();
                if (comps.length == 0) {
                    return;
                }
                int colWidth = this.CELL_SIZE + ((ToolbarLayout)ToolbarLayout.this).padding.left + ((ToolbarLayout)ToolbarLayout.this).padding.right;
                int colHeight = this.CELL_SIZE + ((ToolbarLayout)ToolbarLayout.this).padding.top + ((ToolbarLayout)ToolbarLayout.this).padding.bottom;
                int colCount = w / colWidth;
                for (int i = 0; i < comps.length; ++i) {
                    int colIndex = 0;
                    boolean found = false;
                    for (int c = i; c < comps.length && colIndex < colCount; ++c) {
                        i = c;
                        if (!comps[c].isVisible()) continue;
                        Component comp = comps[c];
                        Dimension dim = comp.getPreferredSize();
                        if (found) {
                            x += ToolbarLayout.this.getSpacing();
                        }
                        comp.setBounds(x, y, colWidth, colHeight);
                        x += colWidth;
                        ++colIndex;
                        found = true;
                    }
                    x = margin.left;
                    y += colHeight;
                    if (!found) continue;
                    y += ToolbarLayout.this.getSpacing();
                }
            }
        }
    }

    private class VerticalLayout
    implements LayoutManager {
        private VerticalLayout() {
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Dimension getLayoutSize(Container parent) {
            Object object = parent.getTreeLock();
            synchronized (object) {
                int w = 0;
                int h = 0;
                boolean found = false;
                Component[] comps = parent.getComponents();
                for (int i = 0; i < comps.length; ++i) {
                    if (!comps[i].isVisible()) continue;
                    if (found) {
                        h += ToolbarLayout.this.getSpacing();
                    }
                    Dimension dim = comps[i].getPreferredSize();
                    h += dim.height + ((ToolbarLayout)ToolbarLayout.this).padding.top + ((ToolbarLayout)ToolbarLayout.this).padding.bottom;
                    w = Math.max(w, dim.width + ((ToolbarLayout)ToolbarLayout.this).padding.left + ((ToolbarLayout)ToolbarLayout.this).padding.right);
                    found = true;
                }
                Insets margin = parent.getInsets();
                return new Dimension(w + margin.left + margin.right, h + margin.top + margin.bottom);
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return this.getLayoutSize(parent);
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return this.getLayoutSize(parent);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void layoutContainer(Container parent) {
            Object object = parent.getTreeLock();
            synchronized (object) {
                Dimension dim;
                Component comp;
                int i;
                Insets margin = parent.getInsets();
                int x = margin.left;
                int y = margin.top;
                int w = parent.getWidth() - (margin.left + margin.right);
                int h = parent.getHeight() - (margin.top + margin.bottom);
                int endPoint = parent.getHeight() - margin.bottom;
                boolean found = false;
                Component[] comps = parent.getComponents();
                if ("BOTTOM".equals(ToolbarLayout.this.getAlignment())) {
                    y = endPoint;
                    for (i = comps.length; i > 0; --i) {
                        if (!comps[i - 1].isVisible()) continue;
                        comp = comps[i - 1];
                        dim = comp.getPreferredSize();
                        if (found) {
                            y -= ToolbarLayout.this.getSpacing();
                        }
                        y -= dim.height + ((ToolbarLayout)ToolbarLayout.this).padding.top + ((ToolbarLayout)ToolbarLayout.this).padding.bottom;
                        found = true;
                    }
                    if (y < margin.top) {
                        y = margin.top;
                    }
                }
                found = false;
                for (i = 0; i < comps.length; ++i) {
                    if (!comps[i].isVisible()) continue;
                    comp = comps[i];
                    dim = comp.getPreferredSize();
                    int cheight = dim.height + ((ToolbarLayout)ToolbarLayout.this).padding.top + ((ToolbarLayout)ToolbarLayout.this).padding.bottom;
                    if (found) {
                        y += ToolbarLayout.this.getSpacing();
                    }
                    if (y + cheight > endPoint) {
                        int nh = h - y;
                        if (nh < 18) {
                            comp.setBounds(0, 0, 0, 0);
                        } else {
                            comp.setBounds(x, y, w, nh);
                        }
                    } else {
                        comp.setBounds(x, y, w, cheight);
                    }
                    y += cheight;
                    found = true;
                }
            }
        }
    }

    private class HorizontalLayout
    implements LayoutManager {
        private HorizontalLayout() {
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Dimension getLayoutSize(Container parent) {
            Object object = parent.getTreeLock();
            synchronized (object) {
                int w = 0;
                int h = 0;
                boolean found = false;
                Component[] comps = parent.getComponents();
                for (int i = 0; i < comps.length; ++i) {
                    Component c = comps[i];
                    if (!c.isVisible()) continue;
                    if (found) {
                        w += ToolbarLayout.this.getSpacing();
                    }
                    Dimension dim = c.getPreferredSize();
                    w += dim.width + ((ToolbarLayout)ToolbarLayout.this).padding.left + ((ToolbarLayout)ToolbarLayout.this).padding.right;
                    h = Math.max(h, dim.height + ((ToolbarLayout)ToolbarLayout.this).padding.top + ((ToolbarLayout)ToolbarLayout.this).padding.bottom);
                    found = true;
                }
                Insets margin = parent.getInsets();
                return new Dimension(w + margin.left + margin.right, h + margin.top + margin.bottom);
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return this.getLayoutSize(parent);
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return this.getLayoutSize(parent);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void layoutContainer(Container parent) {
            Object object = parent.getTreeLock();
            synchronized (object) {
                Dimension dim;
                Component comp;
                int i;
                Insets margin = parent.getInsets();
                int x = margin.left;
                int y = margin.top;
                int w = parent.getWidth() - (margin.left + margin.right);
                int h = parent.getHeight() - (margin.top + margin.bottom);
                int endPoint = parent.getWidth() - margin.right;
                boolean found = false;
                Component[] comps = parent.getComponents();
                if ("RIGHT".equals(ToolbarLayout.this.getAlignment())) {
                    x = parent.getWidth() - margin.right;
                    for (i = comps.length; i > 0; --i) {
                        if (!comps[i - 1].isVisible()) continue;
                        comp = comps[i - 1];
                        dim = comp.getPreferredSize();
                        if (found) {
                            x -= ToolbarLayout.this.getSpacing();
                        }
                        x -= dim.width + ((ToolbarLayout)ToolbarLayout.this).padding.left + ((ToolbarLayout)ToolbarLayout.this).padding.right;
                        found = true;
                    }
                    if (x < margin.left) {
                        x = margin.left;
                    }
                }
                found = false;
                for (i = 0; i < comps.length; ++i) {
                    if (!comps[i].isVisible()) continue;
                    comp = comps[i];
                    dim = comp.getPreferredSize();
                    int cwidth = dim.width + ((ToolbarLayout)ToolbarLayout.this).padding.left + ((ToolbarLayout)ToolbarLayout.this).padding.right;
                    if (found) {
                        x += ToolbarLayout.this.getSpacing();
                    }
                    if (x + cwidth > endPoint) {
                        int nw = w - x;
                        if (nw < 18) {
                            comp.setBounds(0, 0, 0, 0);
                        } else {
                            comp.setBounds(x, y, nw, h);
                        }
                    } else {
                        comp.setBounds(x, y, cwidth, h);
                    }
                    x += cwidth;
                    found = true;
                }
            }
        }
    }
}

