/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.control.layout;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JLabel;

public class SplitViewLayout
implements LayoutManager {
    private Map<String, LayoutManager> layouts = new HashMap<String, LayoutManager>();
    private LayoutManager layout;
    private String orientation;
    private int dividerSize;
    private int dividerLocation;
    private int dividerLocationPercentage;
    private int locationIndex;
    private Component divider;
    private Provider provider;
    private Component horizontalDivider;
    private Component verticalDivider;
    private Point sourcePoint;
    private Point targetPoint;
    private Rectangle viewRect;
    private boolean startedMoving;
    private boolean showDividerBorder;

    public SplitViewLayout(Provider provider) {
        this.provider = provider;
        this.layouts.put("HORIZONTAL", new HorizontalLayout());
        this.layouts.put("VERTICAL", new VerticalLayout());
        this.setOrientation("HORIZONTAL");
        this.setDividerLocation(100);
        this.setDividerSize(5);
    }

    public String getOrientation() {
        return this.orientation;
    }

    public void setOrientation(String orientation) {
        this.orientation = orientation;
        this.layout = this.layouts.get(orientation);
        if (this.layout == null) {
            this.orientation = "HORIZONTAL";
            this.layout = this.layouts.get(orientation);
        }
    }

    public int getDividerSize() {
        return this.dividerSize;
    }

    public void setDividerSize(int dividerSize) {
        this.dividerSize = dividerSize;
    }

    public int getDividerLocation() {
        return this.dividerLocation;
    }

    public void setDividerLocation(int dividerLocation) {
        this.dividerLocation = dividerLocation;
        this.locationIndex = dividerLocation;
    }

    public int getDividerLocationPercentage() {
        return this.dividerLocationPercentage;
    }

    public void setDividerLocationPercentage(int dividerLocationPercentage) {
        this.dividerLocationPercentage = dividerLocationPercentage;
    }

    public boolean isShowDividerBorder() {
        return this.showDividerBorder;
    }

    public void setShowDividerBorder(boolean showDividerBorder) {
        this.showDividerBorder = showDividerBorder;
    }

    void setLocationIndex(int x) {
        this.locationIndex = x;
    }

    private Component getDivider() {
        if ("vertical".equalsIgnoreCase(this.getOrientation() + "")) {
            if (this.verticalDivider == null) {
                JDivider lbl = new JDivider(1);
                lbl.setName("splitview.divider");
                lbl.setCursor(Cursor.getPredefinedCursor(8));
                new VerticalMouseSupport().setDivider(lbl);
                this.verticalDivider = lbl;
            }
            return this.verticalDivider;
        }
        if (this.horizontalDivider == null) {
            JDivider lbl = new JDivider(0);
            lbl.setName("splitview.divider");
            lbl.setCursor(Cursor.getPredefinedCursor(10));
            new HorizontalMouseSupport().setDivider(lbl);
            this.horizontalDivider = lbl;
        }
        return this.horizontalDivider;
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
    }

    @Override
    public void removeLayoutComponent(Component comp) {
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        if (this.layout == null) {
            return new Dimension(this.getDividerSize(), this.getDividerSize());
        }
        return this.layout.preferredLayoutSize(parent);
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        if (this.layout == null) {
            return new Dimension(this.getDividerSize(), this.getDividerSize());
        }
        return this.layout.minimumLayoutSize(parent);
    }

    @Override
    public void layoutContainer(Container parent) {
        this.layout.layoutContainer(parent);
    }

    private Component[] getLayoutComponents(Component[] comps) {
        if (comps == null) {
            return new Component[0];
        }
        ArrayList<Component> list = new ArrayList<Component>();
        for (int i = 0; i < comps.length; ++i) {
            Component c = comps[i];
            if (this.horizontalDivider != null && this.horizontalDivider.equals(c) || this.verticalDivider != null && this.verticalDivider.equals(c)) continue;
            if (list.size() >= 2) break;
            list.add(c);
        }
        return list.toArray(new Component[0]);
    }

    private Component getLayoutComponent(Component[] comps, String name) {
        if (comps == null || name == null) {
            return null;
        }
        for (int i = 0; i < comps.length; ++i) {
            String cname = comps[i].getName();
            if (!name.equals(cname)) continue;
            return comps[i];
        }
        return null;
    }

    private Component lookupComponent(Component[] comps) {
        if (comps == null || comps.length == 0) {
            return null;
        }
        for (int i = 0; i < comps.length; ++i) {
            Component c = comps[i];
            if (c.getName() != null) continue;
            return c;
        }
        return null;
    }

    private class VerticalLayout
    implements LayoutManager {
        SplitViewLayout root;

        private VerticalLayout() {
            this.root = SplitViewLayout.this;
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return this.getLayoutSize(parent);
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return this.getLayoutSize(parent);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Dimension getLayoutSize(Container parent) {
            Object object = parent.getTreeLock();
            synchronized (object) {
                int dsize;
                int w = dsize = this.root.getDividerSize();
                int h = dsize;
                Insets margin = parent.getInsets();
                return new Dimension(w += margin.left + margin.right, h += margin.top + margin.bottom);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void layoutContainer(Container parent) {
            Object object = parent.getTreeLock();
            synchronized (object) {
                Component[] comps;
                Component divider = SplitViewLayout.this.getDivider();
                parent.remove(divider);
                parent.add(divider);
                Insets margin = parent.getInsets();
                int pw = parent.getWidth();
                int ph = parent.getHeight();
                int tMax = margin.top;
                int bMax = ph - margin.bottom;
                int x = margin.left;
                int y = margin.top;
                int w = pw - (margin.left + margin.right);
                int h = ph - (margin.top + margin.bottom);
                SplitViewLayout.this.viewRect = new Rectangle(x, y, w, h);
                int divsize = this.root.getDividerSize();
                int locindex = 0;
                if (this.root.startedMoving) {
                    locindex = this.root.locationIndex;
                } else {
                    double locper = this.root.getDividerLocationPercentage();
                    if (locper > 0.0) {
                        locper = Math.min(locper, 100.0);
                        locindex = margin.top + (int)(locper / 100.0 * (double)h);
                    } else {
                        locindex = this.root.getDividerLocation();
                    }
                }
                if (locindex < tMax) {
                    locindex = tMax + divsize;
                }
                if (locindex > bMax) {
                    locindex = bMax - divsize;
                }
                if ((comps = SplitViewLayout.this.getLayoutComponents(parent.getComponents())).length >= 1) {
                    comps[0].setBounds(x, y, w, locindex);
                }
                divider.setBounds(x, y += locindex, w, divsize);
                int nh = ph - margin.bottom - (y += divsize);
                if (nh < 0) {
                    nh = 0;
                }
                if (comps.length >= 2) {
                    comps[1].setBounds(x, y, w, nh);
                }
            }
        }
    }

    private class HorizontalLayout
    implements LayoutManager {
        SplitViewLayout root;

        private HorizontalLayout() {
            this.root = SplitViewLayout.this;
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return this.getLayoutSize(parent);
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return this.getLayoutSize(parent);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Dimension getLayoutSize(Container parent) {
            Object object = parent.getTreeLock();
            synchronized (object) {
                int dsize;
                int w = dsize = this.root.getDividerSize();
                int h = dsize;
                Insets margin = parent.getInsets();
                return new Dimension(w += margin.left + margin.right, h += margin.top + margin.bottom);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void layoutContainer(Container parent) {
            Object object = parent.getTreeLock();
            synchronized (object) {
                Component[] comps;
                Component divider = SplitViewLayout.this.getDivider();
                parent.remove(divider);
                parent.add(divider);
                Insets margin = parent.getInsets();
                int pw = parent.getWidth();
                int ph = parent.getHeight();
                int lbound = margin.left;
                int rbound = pw - margin.right;
                int x = margin.left;
                int y = margin.top;
                int w = pw - (margin.left + margin.right);
                int h = ph - (margin.top + margin.bottom);
                SplitViewLayout.this.viewRect = new Rectangle(x, y, w, h);
                int divsize = this.root.getDividerSize();
                int locindex = 0;
                if (this.root.startedMoving) {
                    locindex = this.root.locationIndex;
                } else {
                    double locper = this.root.getDividerLocationPercentage();
                    if (locper > 0.0) {
                        locper = Math.min(locper, 100.0);
                        locindex = margin.left + (int)(locper / 100.0 * (double)w);
                    } else {
                        locindex = this.root.getDividerLocation();
                    }
                }
                if (locindex < lbound) {
                    locindex = lbound + divsize;
                }
                if (locindex > rbound) {
                    locindex = rbound - divsize;
                }
                if ((comps = SplitViewLayout.this.getLayoutComponents(parent.getComponents())).length >= 1) {
                    comps[0].setBounds(x, y, locindex, h);
                }
                divider.setBounds(x += locindex, y, divsize, h);
                int rw = pw - margin.right - (x += SplitViewLayout.this.getDividerSize());
                if (rw < 0) {
                    rw = 0;
                }
                if (comps.length >= 2) {
                    comps[1].setBounds(x, y, rw, h);
                }
            }
        }
    }

    private class JDivider
    extends JLabel {
        SplitViewLayout root;
        private Color hilite;
        private Color shadow;
        private int orientation;

        public JDivider(int orientation) {
            this.root = SplitViewLayout.this;
            this.orientation = orientation;
            this.hilite = SystemColor.controlLtHighlight;
            this.shadow = SystemColor.controlDkShadow;
        }

        @Override
        protected void paintBorder(Graphics g) {
            super.paintBorder(g);
            if (!this.root.isShowDividerBorder()) {
                return;
            }
            int dsize = this.root.getDividerSize();
            if (dsize < 3) {
                return;
            }
            Rectangle rect = this.getBounds();
            if (this.orientation == 1) {
                g.setColor(this.hilite);
                g.drawLine(0, 1, rect.width, 1);
                g.setColor(this.shadow);
                g.drawLine(0, rect.height - 2, rect.width, rect.height - 2);
            } else {
                g.setColor(this.hilite);
                g.drawLine(1, 0, 1, rect.height);
                g.setColor(this.shadow);
                g.drawLine(rect.width - 2, 0, rect.width - 2, rect.height);
            }
        }
    }

    private class VerticalMouseSupport
    implements MouseListener,
    MouseMotionListener {
        SplitViewLayout root;
        Component divider;

        private VerticalMouseSupport() {
            this.root = SplitViewLayout.this;
        }

        void setDivider(Component divider) {
            this.divider = divider;
            divider.addMouseListener(this);
            divider.addMouseMotionListener(this);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            SplitViewLayout.this.sourcePoint = e.getPoint();
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (SplitViewLayout.this.targetPoint != null) {
                Rectangle rect = this.divider.getBounds();
                int ny = rect.y + ((SplitViewLayout)SplitViewLayout.this).targetPoint.y;
                if (ny < 0) {
                    ((SplitViewLayout)SplitViewLayout.this).targetPoint.y = SplitViewLayout.this.locationIndex * -1;
                }
                SplitViewLayout.this.locationIndex = ny;
            }
            SplitViewLayout.this.sourcePoint = null;
            SplitViewLayout.this.targetPoint = null;
            SplitViewLayout.this.provider.revalidate();
            SplitViewLayout.this.provider.repaint();
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            this.root.startedMoving = true;
            SplitViewLayout.this.targetPoint = e.getPoint();
            Rectangle divRect = this.divider.getBounds();
            int ny = divRect.y + ((SplitViewLayout)SplitViewLayout.this).targetPoint.y;
            if (ny < 10) {
                ((SplitViewLayout)SplitViewLayout.this).targetPoint.y = divRect.y * -1 + 10;
            } else {
                int h = ((SplitViewLayout)SplitViewLayout.this).viewRect.height - divRect.y;
                int limit = h - SplitViewLayout.this.getDividerSize() - 10;
                if (((SplitViewLayout)SplitViewLayout.this).targetPoint.y > limit) {
                    ((SplitViewLayout)SplitViewLayout.this).targetPoint.y = limit;
                }
            }
            SplitViewLayout.this.provider.paintDividerHandle(SplitViewLayout.this.viewRect, divRect, SplitViewLayout.this.targetPoint);
        }
    }

    private class HorizontalMouseSupport
    implements MouseListener,
    MouseMotionListener {
        SplitViewLayout root;
        Component divider;

        private HorizontalMouseSupport() {
            this.root = SplitViewLayout.this;
        }

        void setDivider(Component divider) {
            this.divider = divider;
            divider.addMouseListener(this);
            divider.addMouseMotionListener(this);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            SplitViewLayout.this.sourcePoint = e.getPoint();
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (SplitViewLayout.this.targetPoint != null) {
                Rectangle rect = this.divider.getBounds();
                int nx = rect.x + ((SplitViewLayout)SplitViewLayout.this).targetPoint.x;
                if (nx < 0) {
                    ((SplitViewLayout)SplitViewLayout.this).targetPoint.x = SplitViewLayout.this.locationIndex * -1;
                }
                SplitViewLayout.this.locationIndex = nx;
            }
            SplitViewLayout.this.sourcePoint = null;
            SplitViewLayout.this.targetPoint = null;
            SplitViewLayout.this.provider.revalidate();
            SplitViewLayout.this.provider.repaint();
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            SplitViewLayout.this.startedMoving = true;
            SplitViewLayout.this.targetPoint = e.getPoint();
            Rectangle divRect = this.divider.getBounds();
            int nx = divRect.x + ((SplitViewLayout)SplitViewLayout.this).targetPoint.x;
            if (nx < 10) {
                ((SplitViewLayout)SplitViewLayout.this).targetPoint.x = divRect.x * -1 + 10;
            } else {
                int w = ((SplitViewLayout)SplitViewLayout.this).viewRect.width - divRect.x;
                int limit = w - SplitViewLayout.this.getDividerSize() - 10;
                if (((SplitViewLayout)SplitViewLayout.this).targetPoint.x > limit) {
                    ((SplitViewLayout)SplitViewLayout.this).targetPoint.x = limit;
                }
            }
            SplitViewLayout.this.provider.paintDividerHandle(SplitViewLayout.this.viewRect, divRect, SplitViewLayout.this.targetPoint);
        }
    }

    public static interface Provider {
        public void revalidate();

        public void repaint();

        public void paintDividerHandle(Rectangle var1, Rectangle var2, Point var3);
    }
}

