/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.control.layout;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;

public class HorizontalLayout
implements LayoutManager {
    private Border separator;
    private boolean showLeftSeparator;

    public HorizontalLayout() {
        this.setSeparator(new SeparatorBorder());
    }

    public Border getSeparator() {
        return this.separator;
    }

    public void setSeparator(Border separator) {
        this.separator = separator;
    }

    public void setShowLeftSeparator(boolean showLeftSeparator) {
        this.showLeftSeparator = showLeftSeparator;
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
    }

    @Override
    public void removeLayoutComponent(Component comp) {
    }

    private List<Component> getVisibleComponents(Container parent) {
        ArrayList<Component> list = new ArrayList<Component>();
        Component[] comps = parent.getComponents();
        block0: for (int i = 0; i < comps.length; ++i) {
            if (!comps[i].isVisible()) continue;
            if (comps[i] instanceof SeparatorComponent) {
                parent.remove(comps[i]);
                continue;
            }
            if (comps[i] instanceof Container) {
                Component[] innerComps = ((Container)comps[i]).getComponents();
                if (innerComps.length == 0) {
                    list.add(comps[i]);
                    continue;
                }
                for (int ii = 0; ii < innerComps.length; ++ii) {
                    if (!innerComps[ii].isVisible()) continue;
                    list.add(comps[i]);
                    continue block0;
                }
                continue;
            }
            list.add(comps[i]);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Dimension getLayoutSize(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            int w = 0;
            int h = 0;
            Component sep = this.createSeparatorComponent();
            Dimension sepdim = sep == null ? new Dimension(0, 0) : sep.getPreferredSize();
            List<Component> list = this.getVisibleComponents(parent);
            if (this.showLeftSeparator && !list.isEmpty()) {
                w += sepdim.width;
                h = Math.max(h, sepdim.height);
            }
            boolean found = false;
            while (!list.isEmpty()) {
                Component comp = list.remove(0);
                Dimension dim = comp.getPreferredSize();
                if (found) {
                    w += sepdim.width;
                    h = Math.max(h, sepdim.height);
                }
                w += dim.width;
                h = Math.max(h, dim.height);
                found = true;
            }
            Insets margin = parent.getInsets();
            return new Dimension(w + margin.left + margin.right, h + margin.top + margin.bottom);
        }
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        return this.getLayoutSize(parent);
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        return this.getLayoutSize(parent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void layoutContainer(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            Component sep;
            Insets margin = parent.getInsets();
            int x = margin.left;
            int y = margin.top;
            int w = parent.getWidth() - (margin.left + margin.right);
            int h = parent.getHeight() - (margin.top + margin.bottom);
            boolean found = false;
            List<Component> list = this.getVisibleComponents(parent);
            if (this.showLeftSeparator && !list.isEmpty() && (sep = this.createSeparatorComponent()) != null) {
                Dimension sepDim = sep.getPreferredSize();
                parent.add(sep);
                sep.setBounds(x, y, sepDim.width, h);
                x += sepDim.width;
            }
            while (!list.isEmpty()) {
                Component sep2;
                Component comp = list.remove(0);
                Dimension dim = comp.getPreferredSize();
                int pwidth = dim.width;
                if (list.isEmpty()) {
                    pwidth = Math.max(dim.width, w - x);
                }
                if (found && (sep2 = this.createSeparatorComponent()) != null) {
                    Dimension sepDim = sep2.getPreferredSize();
                    parent.add(sep2);
                    sep2.setBounds(x, y, sepDim.width, h);
                    x += sepDim.width;
                }
                comp.setBounds(x, y, pwidth, h);
                x += dim.width;
                found = true;
            }
        }
    }

    private Component createSeparatorComponent() {
        Border border = this.getSeparator();
        if (border == null) {
            return null;
        }
        SeparatorComponent c = new SeparatorComponent();
        c.setBorder(border);
        return c;
    }

    private class SeparatorComponent
    extends JLabel {
        private SeparatorComponent() {
        }
    }

    private class SeparatorBorder
    extends AbstractBorder {
        private SeparatorBorder() {
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return this.getBorderInsets(c, new Insets(0, 0, 0, 0));
        }

        @Override
        public Insets getBorderInsets(Component c, Insets insets) {
            insets.top = 5;
            insets.bottom = 5;
            insets.left = 2;
            insets.right = 2;
            return insets;
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            Color shadow = c.getBackground().darker();
            Color hilite = c.getBackground().brighter();
            Color oldColor = g.getColor();
            g.setColor(shadow);
            g.drawLine(x, y + 5, x, h - 6);
            g.setColor(hilite);
            g.drawLine(x + 1, y + 5, x + 1, h - 6);
            g.setColor(oldColor);
        }
    }
}

