/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.control.layout;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;

public class DividerLayout
implements LayoutManager {
    private int orientation = 1;
    private int spacing = 4;
    private int minWidth = 100;
    private int minHeight = 60;
    private double weightFill = 0.5;

    public int getOrientation() {
        return this.orientation;
    }

    public void setOrientation(int orientation) {
        this.orientation = orientation;
    }

    public int getSpacing() {
        return this.spacing;
    }

    public void setSpacing(int spacing) {
        this.spacing = spacing;
    }

    public int getMinWidth() {
        return this.minWidth;
    }

    public void setMinWidth(int minWidth) {
        this.minWidth = minWidth;
    }

    public int getMinHeight() {
        return this.minHeight;
    }

    public void setMinHeight(int minHeight) {
        this.minHeight = minHeight;
    }

    public double getWeightFill() {
        return this.weightFill;
    }

    public void setWeightFill(double weightFill) {
        this.weightFill = weightFill;
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
    }

    @Override
    public void removeLayoutComponent(Component comp) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension preferredLayoutSize(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            Dimension dim = this.getMinLayoutSize(parent);
            Insets margin = parent.getInsets();
            int w = margin.left + margin.right + dim.width;
            int h = margin.top + margin.bottom + dim.height;
            return new Dimension(w, h);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension minimumLayoutSize(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            Dimension dim = this.getMinLayoutSize(parent);
            Insets margin = parent.getInsets();
            int w = margin.left + margin.right + dim.width;
            int h = margin.top + margin.bottom + dim.height;
            return new Dimension(w, h);
        }
    }

    private Dimension getMinLayoutSize(Container parent) {
        Component[] comps = this.getVisibleComponents(parent);
        Component comp1 = comps.length > 0 ? comps[0] : null;
        Component comp2 = comps.length > 1 ? comps[1] : null;
        int w1 = comp1 == null ? 0 : comp1.getMinimumSize().width;
        int h1 = comp1 == null ? 0 : comp1.getMinimumSize().height;
        int w2 = comp2 == null ? 0 : comp2.getMinimumSize().width;
        int h2 = comp2 == null ? 0 : comp2.getMinimumSize().height;
        int minW = Math.max(this.getMinWidth(), 0);
        int minH = Math.max(this.getMinHeight(), 0);
        int w = Math.max(Math.max(w1, w2), minW);
        int h = Math.max(Math.max(h1, h2), minH);
        return new Dimension(w, h);
    }

    private Component[] getVisibleComponents(Container parent) {
        ArrayList<Component> list = new ArrayList<Component>();
        Component[] comps = parent.getComponents();
        for (int i = 0; i < comps.length; ++i) {
            if (!comps[i].isVisible()) continue;
            list.add(comps[i]);
        }
        return list.toArray(new Component[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void layoutContainer(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            Component comp2;
            Component[] comps = this.getVisibleComponents(parent);
            Component comp1 = comps.length > 0 ? comps[0] : null;
            Component component = comp2 = comps.length > 1 ? comps[1] : null;
            if (this.getOrientation() == 1) {
                this.layoutVertical(parent, comp1, comp2);
            } else if (this.getOrientation() == 0) {
                this.layoutHorizontal(parent, comp1, comp2);
            } else {
                this.layoutVertical(parent, comp1, comp2);
            }
        }
    }

    private void layoutVertical(Container parent, Component comp1, Component comp2) {
        Insets margin = parent.getInsets();
        int minW = Math.max(this.getMinWidth(), 0);
        int minH = Math.max(this.getMinHeight(), 0);
        int pw = Math.max(parent.getWidth(), minW);
        int ph = Math.max(parent.getHeight(), minH);
        int x = margin.left;
        int y = margin.top;
        int w = pw - (margin.left + margin.right);
        int h = ph - (margin.top + margin.bottom);
        double full_ratio = 1.0;
        double weight_fill = Math.max(this.getWeightFill(), 0.0);
        if (weight_fill <= 0.0) {
            weight_fill = 0.5;
        } else if (weight_fill > 1.0) {
            weight_fill = full_ratio;
        }
        double ratio_1 = weight_fill;
        double ratio_2 = full_ratio - ratio_1;
        if (comp2 != null) {
            int spacing = Math.max(this.getSpacing(), 0);
            int c_h = (int)((double)h * ratio_2);
            c_h = Math.max(c_h - spacing, 0);
            y = Math.max(ph - margin.bottom - c_h, 0);
            comp2.setBounds(x, y, w, c_h);
            y = margin.top;
        } else {
            ratio_1 = full_ratio;
        }
        if (comp1 != null) {
            int c_h = (int)((double)h * ratio_1);
            c_h = Math.max(c_h, 0);
            comp1.setBounds(x, y, w, c_h);
        }
    }

    private void layoutHorizontal(Container parent, Component comp1, Component comp2) {
        Insets margin = parent.getInsets();
        int minW = Math.max(this.getMinWidth(), 0);
        int minH = Math.max(this.getMinHeight(), 0);
        int pw = Math.max(parent.getWidth(), minW);
        int ph = Math.max(parent.getHeight(), minH);
        int x = margin.left;
        int y = margin.top;
        int w = pw - (margin.left + margin.right);
        int h = ph - (margin.top + margin.bottom);
        double full_ratio = 1.0;
        double weight_fill = Math.max(this.getWeightFill(), 0.0);
        if (weight_fill <= 0.0) {
            weight_fill = 0.5;
        } else if (weight_fill > 1.0) {
            weight_fill = full_ratio;
        }
        double ratio_1 = weight_fill;
        double ratio_2 = full_ratio - ratio_1;
        if (comp2 != null) {
            int spacing = Math.max(this.getSpacing(), 0);
            int c_w = (int)((double)w * ratio_2);
            c_w = Math.max(c_w - spacing, 0);
            x = Math.max(pw - margin.right - c_w, 0);
            comp2.setBounds(x, y, c_w, h);
            x = margin.left;
        } else {
            ratio_1 = full_ratio;
        }
        if (comp1 != null) {
            int c_w = (int)((double)w * ratio_1);
            c_w = Math.max(c_w, 0);
            comp1.setBounds(x, y, c_w, h);
        }
    }
}

