/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.control.image;

import com.rameses.rcp.control.image.ThumbnailItem;
import com.rameses.util.Base64Cipher;
import java.awt.Image;
import java.net.URL;
import java.util.ArrayList;
import java.util.Map;
import javax.swing.AbstractListModel;
import javax.swing.ImageIcon;

public class ThumbnailListModel
extends AbstractListModel {
    private final Object LOCKED = new Object();
    private ArrayList<ThumbnailItem> list = new ArrayList();
    private Base64Cipher base64;

    @Override
    public int getSize() {
        return this.list.size();
    }

    @Override
    public Object getElementAt(int index) {
        try {
            return this.list.get(index);
        }
        catch (Throwable t) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.LOCKED;
        synchronized (object) {
            int lastIndex = this.list.size() - 1;
            this.list.clear();
            if (lastIndex >= 0) {
                this.fireIntervalRemoved(this, 0, lastIndex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Map data) {
        Object object = this.LOCKED;
        synchronized (object) {
            if (data == null) {
                return;
            }
            Object caption = data.get("caption");
            Object image = data.get("image");
            ThumbnailItem item = new ThumbnailItem();
            item.setCaption(caption == null ? "" : caption.toString());
            item.setIcon(this.resolveImage(image));
            item.setData(data);
            int index = this.list.size();
            this.list.add(item);
            this.fireIntervalAdded(this, index, index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(int index) {
        Object object = this.LOCKED;
        synchronized (object) {
            try {
                this.list.remove(index);
                this.fireIntervalRemoved(this, index, index);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public void fireRemoveItemEvent(int index0, int index1) {
        this.fireIntervalRemoved(this, index0, index1);
    }

    public void fireAddItemEvent(int index0, int index1) {
        this.fireIntervalAdded(this, index0, index1);
    }

    private Base64Cipher getBase64Cipher() {
        if (this.base64 == null) {
            this.base64 = new Base64Cipher();
        }
        return this.base64;
    }

    private ImageIcon resolveImage(Object value) {
        if (value instanceof URL) {
            return new ImageIcon((URL)value);
        }
        if (value instanceof Image) {
            return new ImageIcon((Image)value);
        }
        if (value instanceof byte[]) {
            return new ImageIcon((byte[])value);
        }
        if (value instanceof String && this.getBase64Cipher().isEncoded(value.toString())) {
            Object o = this.getBase64Cipher().decode(value.toString(), false);
            return this.resolveImage(o);
        }
        return null;
    }
}

