/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.control.image;

import com.rameses.rcp.control.image.ImageView;
import com.rameses.rcp.control.image.ImageViewToolbar;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.LayoutManager2;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class ImageViewPanel
extends JPanel {
    private ImageView imageView;
    private ImageViewToolbar toolbar;
    private String text;

    public ImageViewPanel() {
        this.initComponent();
    }

    private void initComponent() {
        super.setLayout(new DefaultLayout());
        this.setPreferredSize(new Dimension(120, 100));
        this.setOpaque(false);
        this.toolbar = new ImageViewToolbar(this);
        this.toolbar.setVisible(false);
        this.add(this.toolbar);
        this.imageView = new ImageView();
        this.imageView.addMouseListener(new MouseAdapterImpl());
        this.imageView.addHandler(this.toolbar.getImageViewHandler());
        this.add(this.imageView);
    }

    @Override
    public void setLayout(LayoutManager layoutManager) {
    }

    public ImageIcon getValue() {
        return this.imageView.getValue();
    }

    public void setValue(ImageIcon value) {
        this.imageView.setValue(value);
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
        if (this.imageView != null) {
            this.imageView.setText(text);
        }
    }

    public Color getNoImageBackground() {
        return this.imageView == null ? null : this.imageView.getNoImageBackground();
    }

    public void setNoImageBackground(Color color) {
        if (this.imageView != null) {
            this.imageView.setNoImageBackground(color);
        }
    }

    public Color getNoImageForeground() {
        return this.imageView == null ? null : this.imageView.getNoImageForeground();
    }

    public void setNoImageForeground(Color color) {
        if (this.imageView != null) {
            this.imageView.setNoImageForeground(color);
        }
    }

    public final void refreshCanvas() {
        if (this.imageView != null) {
            this.imageView.refreshCanvas();
        }
    }

    private void showToolbar() {
        ImageIcon iicon;
        ImageIcon imageIcon = iicon = this.imageView == null ? null : this.imageView.getValue();
        if (iicon == null) {
            this.toolbar.setVisible(false);
            this.toolbar.setEnabled(false);
        } else {
            this.toolbar.setVisible(true);
        }
        this.revalidate();
        this.repaint();
    }

    private void hideToolbar() {
        this.toolbar.setVisible(false);
        this.revalidate();
        this.repaint();
    }

    private class MouseAdapterImpl
    implements MouseListener {
        ImageViewPanel root;

        private MouseAdapterImpl() {
            this.root = ImageViewPanel.this;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            this.root.showToolbar();
        }

        @Override
        public void mouseExited(MouseEvent e) {
            Rectangle bounds = this.root.getBounds();
            if (bounds.contains(e.getPoint())) {
                return;
            }
            this.root.hideToolbar();
        }
    }

    private class DefaultLayout
    implements LayoutManager,
    LayoutManager2 {
        ImageViewPanel root;

        private DefaultLayout() {
            this.root = ImageViewPanel.this;
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return this.layoutSize(parent);
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return this.layoutSize(parent);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Dimension layoutSize(Container parent) {
            Object object = parent.getTreeLock();
            synchronized (object) {
                Insets margin = parent.getInsets();
                int width = margin.left + margin.right;
                int height = margin.top + margin.bottom;
                return new Dimension(width + 120, height + 100);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void layoutContainer(Container parent) {
            Object object = parent.getTreeLock();
            synchronized (object) {
                Insets margin = parent.getInsets();
                int pw = parent.getWidth();
                int ph = parent.getHeight();
                int x = margin.left;
                int y = margin.top;
                int w = pw - (margin.left + margin.right);
                int h = ph - (margin.top + margin.bottom);
                JComponent c = this.root.imageView;
                if (c != null && c.isVisible()) {
                    c.setBounds(x, y, w, h);
                }
                if ((c = this.root.toolbar) != null && c.isVisible()) {
                    Dimension dim = ((Component)c).getPreferredSize();
                    x = Math.max(pw - margin.right - dim.width - 2, 2);
                    y = Math.max(ph - margin.bottom - dim.height - 2, 2);
                    c.setBounds(x, y, dim.width, dim.height);
                }
            }
        }

        @Override
        public void addLayoutComponent(Component comp, Object constraints) {
        }

        @Override
        public Dimension maximumLayoutSize(Container target) {
            return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
        }

        @Override
        public float getLayoutAlignmentX(Container target) {
            return 0.5f;
        }

        @Override
        public float getLayoutAlignmentY(Container target) {
            return 0.5f;
        }

        @Override
        public void invalidateLayout(Container target) {
            this.layoutContainer(target);
        }
    }
}

