/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.control.image;

import com.rameses.rcp.framework.Binding;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.AffineTransform;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JLabel;

public class ImageView
extends JLabel {
    private Binding binding;
    private String[] depends;
    private int index;
    private ImageIcon iicon;
    private NoImageCanvas noImageCanvas;
    private ImageCanvas imageCanvas;
    private Color noImageBackground;
    private Color noImageForeground;
    private double ZOOM_FACTOR = 0.1;
    private Dimension fitSize;
    private Rectangle image_rect;
    private Rectangle drag_rect;
    private boolean zoom_mode;
    private Vector<Handler> handlers;
    private AffineTransform tx = new AffineTransform();
    private boolean customize_mode;

    public ImageView() {
        this((ImageIcon)null);
    }

    public ImageView(ImageIcon iicon) {
        this.iicon = iicon;
        this.handlers = new Vector();
        this.initComponent();
    }

    private void initComponent() {
        super.setLayout(new DefaultLayout());
        this.setOpaque(false);
        this.setPreferredSize(new Dimension(120, 100));
        this.setNoImageBackground(Color.BLACK);
        this.setNoImageForeground(Color.WHITE);
        this.noImageCanvas = new NoImageCanvas();
        this.imageCanvas = new ImageCanvas();
        Font oldFont = this.getFont();
        if (oldFont != null) {
            this.setFont(oldFont.deriveFont(1, 14.0f));
        }
        this.addComponentListener(new ComponentListenerImpl());
        MouseAdapterImpl mouseAdapter = new MouseAdapterImpl();
        this.addMouseListener(mouseAdapter);
        this.addMouseWheelListener(mouseAdapter);
        this.addMouseMotionListener(mouseAdapter);
    }

    @Override
    public void setLayout(LayoutManager mgr) {
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        if (this.noImageCanvas != null) {
            this.noImageCanvas.setFont(font);
        }
    }

    public Color getNoImageBackground() {
        return this.noImageBackground;
    }

    public void setNoImageBackground(Color noImageBackground) {
        this.noImageBackground = noImageBackground;
    }

    public Color getNoImageForeground() {
        return this.noImageForeground;
    }

    public void setNoImageForeground(Color noImageForeground) {
        this.noImageForeground = noImageForeground;
    }

    public ImageIcon getValue() {
        return this.iicon;
    }

    public void setValue(ImageIcon iicon) {
        this.iicon = iicon;
        this.image_rect = null;
        this.zoom_mode = false;
    }

    public void removeHandler(Handler handler) {
        if (handler != null) {
            this.handlers.remove(handler);
        }
    }

    public void addHandler(Handler handler) {
        if (handler == null) {
            return;
        }
        if (!this.handlers.contains(handler)) {
            this.handlers.addElement(handler);
        }
    }

    public final double getMinScale() {
        double scaleX;
        ImageIcon iicon = this.getValue();
        if (iicon == null) {
            return 0.0;
        }
        int iw = iicon.getIconWidth();
        int ih = iicon.getIconHeight();
        int width = this.getWidth();
        int height = this.getHeight();
        double scaleY = (double)height / (double)ih;
        return scaleY > (scaleX = (double)width / (double)iw) ? scaleX : scaleY;
    }

    public final double getCurrentScale() {
        ImageIcon iicon = this.getValue();
        if (iicon == null) {
            return 0.0;
        }
        Rectangle rect = this.cloneImageRect();
        if (rect == null) {
            return 0.0;
        }
        double iw = iicon.getIconWidth();
        double rw = rect.width;
        double scale = rw / iw;
        return scale;
    }

    public final double getNextScale() {
        return 0.0;
    }

    protected void paintNoImage(Graphics2D g2, int width, int height) {
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setBackground(Color.BLACK);
        g2.fillRect(0, 0, width, height);
        g2.setColor(Color.DARK_GRAY);
        g2.setStroke(new BasicStroke(3.0f));
        g2.drawLine(0, 0, width - 1, height - 1);
        g2.drawLine(0, height - 1, width - 1, 0);
        String str = "No Available";
        FontMetrics metrics = g2.getFontMetrics(this.getFont());
        int fw = metrics.stringWidth(str);
        int fh = metrics.getHeight();
        int x = Math.max((width - fw) / 2, 0);
        int y = Math.max(height / 2 - fh / 2, 0) + 4;
        g2.setFont(this.getFont());
        g2.setColor(Color.WHITE);
        g2.drawString(str, x, y);
        str = "Photo";
        fw = metrics.stringWidth(str);
        fh = metrics.getHeight();
        x = Math.max((width - fw) / 2, 0);
        y = Math.max(height / 2 + fh / 2, 0) + 4;
        g2.drawString(str, x, y);
    }

    protected void paintImage(Graphics2D g2, int width, int height, ImageIcon anIcon) {
        g2.setBackground(this.getBackground());
        g2.clearRect(0, 0, width, height);
        g2.setBackground(Color.YELLOW);
        g2.fillRect(0, 0, width, height);
        g2.drawImage(anIcon.getImage(), 0, 0, null);
    }

    private Rectangle getFitViewRect() {
        double scaleX;
        ImageIcon iicon = this.getValue();
        if (iicon == null) {
            return null;
        }
        int iw = iicon.getIconWidth();
        int ih = iicon.getIconHeight();
        int width = this.getWidth();
        int height = this.getHeight();
        double scaleY = (double)height / (double)ih;
        double scale = scaleY > (scaleX = (double)width / (double)iw) ? scaleX : scaleY;
        int nw = (int)((double)iw * scale);
        int nh = (int)((double)ih * scale);
        int nx = (width - nw) / 2;
        int ny = (height - nh) / 2;
        return new Rectangle(nx, ny, nw, nh);
    }

    private Rectangle cloneImageRect() {
        return this.cloneRect(this.image_rect);
    }

    private Rectangle cloneRect(Rectangle source) {
        if (source == null) {
            return null;
        }
        return new Rectangle(source.x, source.y, source.width, source.height);
    }

    private boolean matchSize(Rectangle rect1, Rectangle rect2) {
        if (rect1.width != rect2.width) {
            return false;
        }
        return rect1.height == rect2.height;
    }

    private boolean overlap(Rectangle outr, Rectangle inr) {
        boolean xb = inr.x >= outr.x && inr.x + inr.width <= outr.width;
        boolean yb = inr.y >= outr.y && inr.y + inr.height <= outr.height;
        return xb && yb;
    }

    private Rectangle computeDelta(Rectangle inr, int width, int height) {
        int n;
        Rectangle rect = new Rectangle(0, 0, 0, 0);
        if (inr.x < 0) {
            rect.x = Math.abs(inr.x);
            n = rect.x + width - inr.width;
            if (n < 0) {
                rect.width = Math.abs(n);
            }
        } else {
            n = inr.x + inr.width - width;
            if (n > 0) {
                rect.width = n;
            }
        }
        if (inr.y < 0) {
            rect.y = Math.abs(inr.y);
            n = rect.y + height - inr.height;
            if (n < 0) {
                rect.height = Math.abs(n);
            }
        } else {
            n = inr.y + inr.height - height;
            if (n > 0) {
                rect.height = n;
            }
        }
        return rect;
    }

    private Rectangle computeInnerDelta(Rectangle inr, int width, int height) {
        Rectangle rect = new Rectangle(0, 0, 0, 0);
        if (inr.x < 0) {
            int lx = Math.abs(inr.x);
            int rx = inr.width - lx - width;
            if (rx < 0) {
                rect.width = Math.abs(rx);
            }
        } else {
            rect.x = inr.x;
            int rx = inr.x + inr.width - width;
            if (rx < 0) {
                rect.width = Math.abs(rx);
            }
        }
        if (inr.y < 0) {
            int ty = Math.abs(inr.y);
            int by = inr.height - ty - height;
            if (by < 0) {
                rect.height = Math.abs(by);
            }
        } else {
            rect.y = inr.y;
            int by = inr.y + inr.height - height;
            if (by < 0) {
                rect.height = Math.abs(by);
            }
        }
        return rect;
    }

    private void computeCenter(Rectangle inr, int width, int height) {
        inr.x = (width - inr.width) / 2;
        inr.y = (height - inr.height) / 2;
    }

    private void notifyRefresh() {
        ImageIcon iicon = this.getValue();
        if (iicon == null) {
            return;
        }
        for (Handler handler : this.handlers) {
            handler.refresh(this);
        }
    }

    public final void fitToWindow() {
        Rectangle rect;
        this.image_rect = rect = this.getFitViewRect();
        this.zoom_mode = false;
        this.refreshCanvas();
    }

    public final void refreshCanvas() {
        this.removeAll();
        this.revalidate();
        this.repaint();
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                ImageView.this.notifyRefresh();
            }
        });
    }

    public final void zoom(int zoomlevel) {
        ImageIcon iicon = this.getValue();
        if (iicon == null) {
            return;
        }
        boolean hasFitScreen = false;
        double scale = (double)zoomlevel / 100.0;
        int iw = (int)((double)iicon.getIconWidth() * scale);
        int ih = (int)((double)iicon.getIconHeight() * scale);
        Rectangle newrect = new Rectangle(0, 0, iw, ih);
        this.computeCenter(newrect, this.getWidth(), this.getHeight());
        this.zoom_mode = true;
        this.image_rect = newrect;
        this.refreshCanvas();
    }

    public static interface Handler {
        public void refresh(ImageView var1);
    }

    private class ComponentListenerImpl
    implements ComponentListener {
        ImageView root;

        private ComponentListenerImpl() {
            this.root = ImageView.this;
        }

        @Override
        public void componentMoved(ComponentEvent e) {
        }

        @Override
        public void componentShown(ComponentEvent e) {
        }

        @Override
        public void componentHidden(ComponentEvent e) {
        }

        public void xcomponentResized(ComponentEvent e) {
            int width = this.root.getWidth();
            int height = this.root.getHeight();
            ImageIcon iicon = this.root.getValue();
            int iw = iicon == null ? 0 : iicon.getIconWidth();
            int ih = iicon == null ? 0 : iicon.getIconHeight();
            double scaleX = (double)width / (double)iw;
            double scaleY = (double)height / (double)ih;
            double scale = scaleY > scaleX ? scaleX : scaleY;
            int nw = (int)((double)iw * scale);
            int nh = (int)((double)ih * scale);
            ImageView.this.fitSize = new Dimension(nw, nh);
            this.root.refreshCanvas();
        }

        @Override
        public void componentResized(ComponentEvent e) {
            ImageIcon iicon = this.root.getValue();
            if (iicon == null) {
                return;
            }
            int width = this.root.getWidth();
            int height = this.root.getHeight();
            int iw = iicon.getIconWidth();
            int ih = iicon.getIconHeight();
            Rectangle fitrect = ImageView.this.getFitViewRect();
            ImageView.this.fitSize = new Dimension(fitrect.width, fitrect.height);
            if (ImageView.this.image_rect == null) {
                ImageView.this.image_rect = fitrect;
            } else if (ImageView.this.zoom_mode) {
                this.adjustOnZoomMode();
            } else {
                ImageView.this.image_rect = fitrect;
            }
            this.root.refreshCanvas();
        }

        private void adjustOnZoomMode() {
            ImageIcon iicon = this.root.getValue();
            if (iicon == null) {
                return;
            }
            int width = this.root.getWidth();
            int height = this.root.getHeight();
            int iw = iicon.getIconWidth();
            int ih = iicon.getIconHeight();
            int nx = 0;
            int ny = 0;
            int nw = 0;
            int nh = 0;
            Rectangle rect = ImageView.this.cloneImageRect();
            Rectangle deltaR = ImageView.this.computeInnerDelta(rect, width, height);
            if (deltaR.x == 0 && deltaR.y == 0 && deltaR.width == 0 && deltaR.height == 0) {
                nx = rect.x;
                ny = rect.y;
                nw = rect.width;
                nh = rect.height;
            } else if (deltaR.x > 0 && deltaR.y > 0 && deltaR.width > 0 && deltaR.height > 0) {
                Rectangle fit_rect = ImageView.this.getFitViewRect();
                nw = fit_rect.width;
                nh = fit_rect.height;
                nx = (width - nw) / 2;
                ny = (height - nh) / 2;
                ImageView.this.zoom_mode = false;
            } else {
                if (deltaR.width > 0) {
                    rect.x += deltaR.width;
                }
                if (rect.x > 0) {
                    rect.x = (width - rect.width) / 2;
                }
                if (deltaR.height > 0) {
                    rect.y += deltaR.height;
                }
                if (rect.y > 0) {
                    rect.y = (height - rect.height) / 2;
                }
                if (rect.x + rect.width < width || rect.y + rect.height < height) {
                    Rectangle fit_rect = ImageView.this.getFitViewRect();
                    nx = fit_rect.x;
                    ny = fit_rect.y;
                    nw = fit_rect.width;
                    nh = fit_rect.height;
                    ImageView.this.zoom_mode = false;
                } else {
                    nx = rect.x;
                    ny = rect.y;
                    nw = rect.width;
                    nh = rect.height;
                }
            }
            ImageView.this.image_rect = new Rectangle(nx, ny, nw, nh);
        }
    }

    private class MouseAdapterImpl
    implements MouseWheelListener,
    MouseListener,
    MouseMotionListener {
        ImageView root;
        boolean start_tracking;
        Point startPoint;
        private Rectangle orig_image_rect;

        private MouseAdapterImpl() {
            this.root = ImageView.this;
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent e) {
            boolean ctrlDown;
            boolean bl = ctrlDown = (e.getModifiers() & 2) == 2;
            if (!ctrlDown) {
                return;
            }
            ImageIcon iicon = this.root.getValue();
            if (iicon == null) {
                return;
            }
            Point pivot = e.getPoint();
            int width = ImageView.this.getWidth();
            int height = ImageView.this.getHeight();
            if (e.getWheelRotation() <= -1) {
                try {
                    int maxWidth = (int)((double)iicon.getIconWidth() * 8.0);
                    int maxHeight = (int)((double)iicon.getIconWidth() * 8.0);
                    Rectangle rect = new Rectangle(((ImageView)ImageView.this).image_rect.x, ((ImageView)ImageView.this).image_rect.y, ((ImageView)ImageView.this).image_rect.width, ((ImageView)ImageView.this).image_rect.height);
                    rect.grow(50, 50);
                    ImageView.this.zoom_mode = true;
                    if (rect.width <= maxWidth && rect.height <= maxHeight) {
                        ImageView.this.image_rect = rect;
                        this.root.refreshCanvas();
                    }
                }
                catch (Throwable maxWidth) {}
            } else {
                try {
                    Rectangle rect = new Rectangle(((ImageView)ImageView.this).image_rect.x, ((ImageView)ImageView.this).image_rect.y, ((ImageView)ImageView.this).image_rect.width, ((ImageView)ImageView.this).image_rect.height);
                    rect.grow(-50, -50);
                    Rectangle fit_rect = ImageView.this.getFitViewRect();
                    if (rect.width < fit_rect.width || rect.height < fit_rect.height) {
                        ImageView.this.image_rect = fit_rect;
                    } else {
                        Rectangle deltaR = ImageView.this.computeInnerDelta(rect, width, height);
                        if (deltaR.width > 0) {
                            rect.x += deltaR.width;
                        }
                        if (rect.x > 0) {
                            ImageView.this.computeCenter(rect, width, height);
                        }
                        if (deltaR.height > 0) {
                            rect.y += deltaR.height;
                        }
                        if (rect.y > 0) {
                            ImageView.this.computeCenter(rect, width, height);
                        }
                        ImageView.this.image_rect = rect;
                    }
                    if (((ImageView)ImageView.this).fitSize.width == ((ImageView)ImageView.this).image_rect.width && ((ImageView)ImageView.this).fitSize.height == ((ImageView)ImageView.this).image_rect.height) {
                        ImageView.this.zoom_mode = false;
                    }
                    this.root.refreshCanvas();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (ImageView.this.image_rect == null) {
                return;
            }
            this.startPoint = e.getPoint();
            if (ImageView.this.image_rect.contains(this.startPoint)) {
                this.orig_image_rect = ImageView.this.cloneImageRect();
                this.start_tracking = true;
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.onstopDragging(e);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            this.onstopDragging(e);
        }

        private void onstopDragging(MouseEvent e) {
            this.start_tracking = false;
            this.orig_image_rect = null;
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (!this.start_tracking) {
                return;
            }
            Point p = e.getPoint();
            int width = ImageView.this.getWidth();
            int height = ImageView.this.getHeight();
            Rectangle rect = this.root.cloneRect(this.orig_image_rect);
            Rectangle deltaR = ImageView.this.computeDelta(rect, width, height);
            int dx = p.x - this.startPoint.x;
            int dy = p.y - this.startPoint.y;
            if (dy != 0) {
                int ady;
                if (dy < 0 && deltaR.height > 0) {
                    ady = Math.abs(dy);
                    rect.y = ady > deltaR.height ? -(deltaR.y + deltaR.height) : -(deltaR.y + ady);
                } else if (dy > 0 && deltaR.y > 0) {
                    ady = Math.abs(dy);
                    rect.y = ady > deltaR.y ? (rect.y += deltaR.y) : (rect.y += ady);
                }
            }
            if (dx != 0) {
                int adx;
                if (dx < 0 && deltaR.width > 0) {
                    adx = Math.abs(dx);
                    rect.x = adx > deltaR.width ? -(deltaR.x + deltaR.width) : -(deltaR.x + adx);
                } else if (dx > 0 && deltaR.x > 0) {
                    adx = Math.abs(dx);
                    rect.x = adx > deltaR.x ? (rect.x += deltaR.x) : (rect.x += adx);
                }
            }
            ImageView.this.image_rect = rect;
            this.root.refreshCanvas();
        }
    }

    private class DefaultLayout
    implements LayoutManager {
        ImageView root;

        private DefaultLayout() {
            this.root = ImageView.this;
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return this.layoutSize(parent);
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return this.layoutSize(parent);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Dimension layoutSize(Container parent) {
            Object object = parent.getTreeLock();
            synchronized (object) {
                Insets margin = parent.getInsets();
                int width = margin.left + margin.right;
                int height = margin.top + margin.bottom;
                return new Dimension(width, height);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void layoutContainer(Container parent) {
            Object object = parent.getTreeLock();
            synchronized (object) {
                Insets margin = parent.getInsets();
                int pw = parent.getWidth();
                int ph = parent.getHeight();
                int x = margin.left;
                int y = margin.top;
                int w = pw - (margin.left + margin.right);
                int h = ph - (margin.top + margin.bottom);
                JLabel c = null;
                ImageIcon iicon = this.root.getValue();
                c = iicon == null ? ImageView.this.noImageCanvas : ImageView.this.imageCanvas;
                if (c.getParent() == null) {
                    parent.add(c);
                }
                c.setBounds(x, y, w, h);
            }
        }
    }

    private class ImageCanvas
    extends JLabel {
        ImageView root;

        ImageCanvas() {
            this.root = ImageView.this;
            this.setHorizontalAlignment(0);
            this.setOpaque(true);
        }

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            ImageIcon iicon = this.root.getValue();
            if (iicon == null) {
                return;
            }
            Rectangle fitrect = ImageView.this.getFitViewRect();
            int nx = ImageView.this.image_rect == null ? fitrect.x : ((ImageView)ImageView.this).image_rect.x;
            int ny = ImageView.this.image_rect == null ? fitrect.y : ((ImageView)ImageView.this).image_rect.y;
            int nw = ImageView.this.image_rect == null ? fitrect.width : ((ImageView)ImageView.this).image_rect.width;
            int nh = ImageView.this.image_rect == null ? fitrect.height : ((ImageView)ImageView.this).image_rect.height;
            Graphics2D g2 = (Graphics2D)g.create();
            g2.drawImage(iicon.getImage(), nx, ny, nw, nh, null);
            g2.dispose();
        }
    }

    private class NoImageCanvas
    extends JLabel {
        ImageView root;

        private NoImageCanvas() {
            this.root = ImageView.this;
        }

        @Override
        public void paint(Graphics g) {
            int width = this.getWidth();
            int height = this.getHeight();
            Color bgcolor = this.root.getNoImageBackground();
            Color fgcolor = this.root.getNoImageForeground();
            if (bgcolor == null) {
                bgcolor = Color.decode("#a0a0a0");
            }
            if (fgcolor == null) {
                fgcolor = Color.WHITE;
            }
            Graphics2D g2 = (Graphics2D)g.create();
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setBackground(bgcolor);
            g2.fillRect(0, 0, width, height);
            String str = "No Available";
            FontMetrics metrics = g2.getFontMetrics(this.getFont());
            int fw = metrics.stringWidth(str);
            int fh = metrics.getHeight();
            int x = Math.max((width - fw) / 2, 0);
            int y = Math.max(height / 2 - fh / 2, 0) + 4;
            g2.setFont(this.getFont());
            g2.setColor(fgcolor);
            g2.drawString(str, x, y);
            str = "Image";
            fw = metrics.stringWidth(str);
            fh = metrics.getHeight();
            x = Math.max((width - fw) / 2, 0);
            y = Math.max(height / 2 + fh / 2, 0) + 4;
            g2.drawString(str, x, y);
        }
    }
}

