/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.control.image;

import com.rameses.rcp.support.ImageIconSupport;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.LayoutManager2;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;

class ImageCropToolbar
extends JPanel {
    public static final String ACTION_ZOOM_IN = "zoom-in";
    public static final String ACTION_ZOOM_OUT = "zoom-out";
    public static final String ACTION_FIT_SCREEN = "fit-screen";
    private static final String IMG_ZOOM_IN = "com/rameses/rcp/icons/zoom-in-16.png";
    private static final String IMG_ZOOM_OUT = "com/rameses/rcp/icons/zoom-out-16.png";
    private static final String IMG_FIT_SCREEN = "com/rameses/rcp/icons/fit-to-screen.png";
    private JButton btnFitWindow;
    private JButton btnZoomIn;
    private JButton btnZoomOut;

    ImageCropToolbar() {
        this.initComponent();
    }

    private void initComponent() {
        super.setLayout(new DefaultLayout());
        this.setOpaque(false);
        this.btnZoomIn = this.createButton("Zoom In", IMG_ZOOM_IN);
        this.btnZoomOut = this.createButton("Zoom Out", IMG_ZOOM_OUT);
        this.btnFitWindow = this.createButton("Fit to window", IMG_FIT_SCREEN);
        this.add(this.btnZoomIn);
        this.add(this.btnFitWindow);
        this.add(this.btnZoomOut);
    }

    private JButton createButton(String tooltiptext, String iconpath) {
        JButton btn = new JButton();
        btn.setOpaque(false);
        btn.setFocusable(false);
        btn.setBorderPainted(false);
        btn.setMargin(new Insets(2, 4, 2, 4));
        if (tooltiptext != null) {
            btn.setToolTipText(tooltiptext);
        }
        try {
            btn.setIcon(this.getIcon(iconpath));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return btn;
    }

    public void setAction(String name, ActionListener handler) {
        if (name == null || handler == null) {
            return;
        }
        JButton btn = null;
        if (ACTION_ZOOM_IN.equals(name)) {
            btn = this.btnZoomIn;
        } else if (ACTION_ZOOM_OUT.equals(name)) {
            btn = this.btnZoomOut;
        } else if (ACTION_FIT_SCREEN.equals(name)) {
            btn = this.btnFitWindow;
        }
        if (btn == null) {
            return;
        }
        ActionListener[] items = btn.getActionListeners();
        if (items == null) {
            items = new ActionListener[]{};
        }
        for (ActionListener o : items) {
            btn.removeActionListener(o);
        }
        btn.addActionListener(handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics g2 = null;
        try {
            AlphaComposite alpha = AlphaComposite.getInstance(3, 0.1f);
            g2 = (Graphics2D)g.create();
            g2.setColor(Color.WHITE);
            ((Graphics2D)g2).setComposite(alpha);
            g2.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
        catch (Throwable throwable) {
        }
        finally {
            try {
                g2.dispose();
            }
            catch (Throwable throwable) {}
        }
    }

    private ImageIcon getIcon(String name) {
        return ImageIconSupport.getInstance().getIcon(name);
    }

    private class DefaultLayout
    implements LayoutManager,
    LayoutManager2 {
        private Insets DEFAULT_PADDING = new Insets(3, 5, 3, 5);

        private DefaultLayout() {
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return this.layoutSize(parent);
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return this.layoutSize(parent);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Dimension layoutSize(Container parent) {
            Object object = parent.getTreeLock();
            synchronized (object) {
                int width = 0;
                int height = 0;
                int count = 0;
                Component[] comps = parent.getComponents();
                for (int i = 0; i < comps.length; ++i) {
                    Component c = comps[i];
                    if (!c.isVisible()) continue;
                    Dimension dim = c.getPreferredSize();
                    width += dim.width;
                    height = Math.max(dim.height, height);
                    ++count;
                }
                Insets margin = this.DEFAULT_PADDING;
                return new Dimension(width += margin.left + margin.right + count * 2, height += margin.top + margin.bottom);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void layoutContainer(Container parent) {
            Object object = parent.getTreeLock();
            synchronized (object) {
                Insets margin = this.DEFAULT_PADDING;
                int pw = parent.getWidth();
                int ph = parent.getHeight();
                int x = margin.left;
                int y = margin.top;
                int w = pw - (margin.left + margin.right);
                int h = ph - (margin.top + margin.bottom);
                Component[] comps = parent.getComponents();
                for (int i = 0; i < comps.length; ++i) {
                    Component c = comps[i];
                    if (!c.isVisible()) continue;
                    Dimension dim = c.getPreferredSize();
                    c.setBounds(x, y, dim.width, h);
                    x += dim.width + 2;
                }
            }
        }

        @Override
        public void addLayoutComponent(Component comp, Object constraints) {
        }

        @Override
        public Dimension maximumLayoutSize(Container target) {
            return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
        }

        @Override
        public float getLayoutAlignmentX(Container target) {
            return 0.5f;
        }

        @Override
        public float getLayoutAlignmentY(Container target) {
            return 0.5f;
        }

        @Override
        public void invalidateLayout(Container target) {
            this.layoutContainer(target);
        }
    }
}

