/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.control.image;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.text.DecimalFormat;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;

class ImageCropItem
extends JPanel {
    private static final int DEFAULT_BOX_WIDTH = 200;
    private static final int DEFAULT_BOX_HEIGHT = 200;
    private static final int DEFAULT_ZOOM_VALUE = 25;
    private Meta meta;
    private ImageIcon value;
    private ImageCanvas imageCanvas;
    private BufferedImage cropImage;
    private Dimension boxdim;
    private Rectangle scaleRect;
    private DecimalFormat decformatter = new DecimalFormat("0");

    public ImageCropItem() {
        this.initComponent();
    }

    private void initComponent() {
        super.setLayout(new DefaultLayout());
        this.setPreferredSize(new Dimension(120, 100));
        this.setOpaque(false);
        this.boxdim = new Dimension(200, 200);
        this.imageCanvas = new ImageCanvas();
        this.add(this.imageCanvas);
        MouseAdapterImpl mouseAdapter = new MouseAdapterImpl();
        this.addMouseMotionListener(mouseAdapter);
        this.addMouseWheelListener(mouseAdapter);
        this.addMouseListener(mouseAdapter);
    }

    @Override
    public void setLayout(LayoutManager mgr) {
    }

    public ImageIcon getValue() {
        return this.value;
    }

    public void setValue(ImageIcon value) {
        this.value = value;
        this.cropImage = null;
        this.meta = new Meta(value);
    }

    public int getBoxWidth() {
        return this.boxdim == null ? 200 : this.boxdim.width;
    }

    public void setBoxWidth(int width) {
        this.boxdim.width = width;
    }

    public int getBoxHeight() {
        return this.boxdim == null ? 200 : this.boxdim.height;
    }

    public void setBoxHeight(int height) {
        this.boxdim.height = height;
    }

    public final void fit() {
        this.scaleRect = this.getFitRect();
        this.repaint();
    }

    private Rectangle getFitRect() {
        return this.scaleTo(this.getWidth(), this.getHeight());
    }

    private Rectangle scaleTo(int width, int height) {
        double scaleX;
        ImageIcon iicon = this.getValue();
        if (iicon == null) {
            return null;
        }
        Dimension dim = new Dimension(this.getBoxWidth(), this.getBoxHeight());
        int iw = iicon.getIconWidth();
        int ih = iicon.getIconHeight();
        int cw = Math.max(width, dim.width);
        int ch = Math.max(height, dim.height);
        double scaleY = (double)ch / (double)ih;
        double scale = scaleY > (scaleX = (double)cw / (double)iw) ? scaleX : scaleY;
        int nw = (int)((double)iw * scale);
        int nh = (int)((double)ih * scale);
        int nx = cw / 2 - nw / 2;
        int ny = ch / 2 - nh / 2;
        return new FitRect(nx, ny, nw, nh);
    }

    public void zoomIn() {
        this.zoom(25);
    }

    public void zoomOut() {
        this.zoom(-25);
    }

    private void zoom(int value) {
        ImageIcon iicon = this.getValue();
        if (iicon == null || this.scaleRect == null) {
            return;
        }
        Rectangle oldrect = this.scaleRect;
        Rectangle newrect = this.scaleTo(oldrect.width + value, oldrect.height + value);
        if (oldrect instanceof DragRect) {
            DragRect dr = (DragRect)oldrect;
            dr.width = newrect.width;
            dr.height = newrect.height;
        } else {
            this.scaleRect = newrect;
        }
        this.repaint();
    }

    private int toInt(double value) {
        String str = this.decformatter.format(value);
        return new Integer(str);
    }

    Rectangle copy(Rectangle2D rect) {
        int x = (int)rect.getX();
        int y = (int)rect.getY();
        int w = (int)rect.getWidth();
        int h = (int)rect.getHeight();
        return new Rectangle(x, y, w, h);
    }

    public BufferedImage getCropImage() {
        if (this.meta.icon == null) {
            return null;
        }
        int iw = this.meta.icon.getIconWidth();
        int ih = this.meta.icon.getIconHeight();
        Dimension dim = new Dimension(iw, ih);
        Dimension canvasdim = new Dimension(this.getWidth(), this.getHeight());
        double vscaleX = canvasdim.getWidth() / dim.getWidth();
        double vscaleY = canvasdim.getHeight() / dim.getHeight();
        double vscale = vscaleY > vscaleX ? vscaleX : vscaleY;
        Dimension scaledim = new Dimension(0, 0);
        scaledim.width = this.toInt(dim.getWidth() * vscale);
        scaledim.height = this.toInt(dim.getHeight() * vscale);
        Rectangle boxrect = this.copy(this.meta.boxRect);
        Rectangle imagerect = this.copy(this.meta.imageRect);
        boxrect.x = imagerect.x > 0 ? (boxrect.x -= imagerect.x) : (boxrect.x += Math.abs(imagerect.x));
        boxrect.y = imagerect.y > 0 ? (boxrect.y -= imagerect.y) : (boxrect.y += Math.abs(imagerect.y));
        imagerect.x = 0;
        imagerect.y = 0;
        boxrect = this.copy(imagerect.createIntersection(boxrect));
        if (!imagerect.contains(boxrect.x, boxrect.y, boxrect.width, boxrect.height)) {
            return null;
        }
        Rectangle nimagerect = this.copy(imagerect);
        nimagerect.x = this.toInt(imagerect.getX() / scaledim.getWidth() * dim.getWidth());
        nimagerect.y = this.toInt(imagerect.getY() / scaledim.getHeight() * dim.getHeight());
        nimagerect.width = this.toInt(imagerect.getWidth() / scaledim.getWidth() * dim.getWidth());
        nimagerect.height = this.toInt(imagerect.getHeight() / scaledim.getHeight() * dim.getHeight());
        double scaleL = boxrect.getX() / imagerect.getWidth();
        double scaleT = boxrect.getY() / imagerect.getHeight();
        double scaleR = (imagerect.getWidth() - (boxrect.getX() + boxrect.getWidth())) / imagerect.getWidth();
        double scaleB = (imagerect.getHeight() - (boxrect.getY() + boxrect.getHeight())) / imagerect.getHeight();
        Rectangle nboxrect = new Rectangle(0, 0, 0, 0);
        nboxrect.x = this.toInt(nimagerect.getWidth() * scaleL);
        nboxrect.y = this.toInt(nimagerect.getHeight() * scaleT);
        nboxrect.width = nimagerect.width - this.toInt(nimagerect.getWidth() * scaleR) - nboxrect.x;
        nboxrect.height = nimagerect.height - this.toInt(nimagerect.getHeight() * scaleB) - nboxrect.y;
        nboxrect = this.copy(nimagerect.createIntersection(nboxrect));
        double scaleW = imagerect.getWidth() / scaledim.getWidth();
        double scaleH = imagerect.getHeight() / scaledim.getHeight();
        if (scaleW < 1.0) {
            scaleW = 1.0;
        }
        if (scaleH < 1.0) {
            scaleH = 1.0;
        }
        int ndimwidth = this.toInt(dim.getWidth() * scaleW);
        int ndimheight = this.toInt(dim.getHeight() * scaleH);
        BufferedImage bi = new BufferedImage(ndimwidth, ndimheight, 2);
        Graphics2D g2 = bi.createGraphics();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.drawImage(this.meta.icon.getImage(), nimagerect.x, nimagerect.y, nimagerect.width, nimagerect.height, null);
        g2.dispose();
        return bi.getSubimage(nboxrect.x, nboxrect.y, nboxrect.width, nboxrect.height);
    }

    private class Meta {
        private Rectangle imageRect = new Rectangle(0, 0, 0, 0);
        private Rectangle viewRect = new Rectangle(0, 0, 0, 0);
        private Rectangle boxRect = new Rectangle(0, 0, 0, 0);
        private ImageIcon icon;

        Meta(ImageIcon icon) {
            this.icon = icon;
        }

        ImageIcon getIcon() {
            return this.icon;
        }

        Rectangle getBoxRect() {
            return this.boxRect;
        }

        Rectangle getViewRect() {
            return this.viewRect;
        }

        Rectangle getImageRect() {
            return this.imageRect;
        }

        void setViewSize(int width, int height) {
            this.viewRect.width = width;
            this.viewRect.height = height;
        }

        void setBoxRect(int x, int y, int w, int h) {
            this.boxRect.x = x;
            this.boxRect.y = y;
            this.boxRect.width = w;
            this.boxRect.height = h;
        }

        void setImageRect(int x, int y, int w, int h) {
            this.imageRect.x = x;
            this.imageRect.y = y;
            this.imageRect.width = w;
            this.imageRect.height = h;
        }
    }

    private class MouseAdapterImpl
    implements MouseWheelListener,
    MouseListener,
    MouseMotionListener {
        ImageCropItem root;
        private boolean start_tracking;
        private Rectangle dragRect;
        private Point startPoint;
        private Cursor oldCursor;

        private MouseAdapterImpl() {
            this.root = ImageCropItem.this;
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent e) {
            boolean ctrlDown;
            boolean bl = ctrlDown = (e.getModifiers() & 2) == 2;
            if (!ctrlDown) {
                return;
            }
            int rotation = e.getWheelRotation();
            if (rotation < 0) {
                this.root.zoomIn();
            } else if (rotation > 0) {
                this.root.zoomOut();
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.dragRect = new DragRect(this.root.scaleRect);
            this.startPoint = e.getPoint();
            this.start_tracking = true;
            this.oldCursor = this.root.getCursor();
            this.root.setCursor(new Cursor(12));
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.start_tracking = false;
            this.root.setCursor(this.oldCursor);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            this.start_tracking = false;
            this.root.setCursor(this.oldCursor);
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (!this.start_tracking) {
                return;
            }
            int ax = this.startPoint.x;
            int ay = this.startPoint.y;
            int bx = e.getPoint().x;
            int by = e.getPoint().y;
            int nx = this.dragRect.x;
            int ny = this.dragRect.y;
            nx = bx < ax ? (nx -= ax - bx) : (nx += bx - ax);
            ny = by < ay ? (ny -= ay - by) : (ny += by - ay);
            this.root.scaleRect = new DragRect(nx, ny, this.dragRect.width, this.dragRect.height);
            this.root.repaint();
        }
    }

    private class DefaultLayout
    implements LayoutManager {
        ImageCropItem root;

        private DefaultLayout() {
            this.root = ImageCropItem.this;
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return this.layoutSize(parent);
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return this.layoutSize(parent);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Dimension layoutSize(Container parent) {
            Object object = parent.getTreeLock();
            synchronized (object) {
                Dimension dim = new Dimension(this.root.getBoxWidth(), this.root.getBoxHeight());
                System.out.println("layout size " + dim);
                return new Dimension(dim.width, dim.height);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void layoutContainer(Container parent) {
            Object object = parent.getTreeLock();
            synchronized (object) {
                Insets margin = parent.getInsets();
                int pw = parent.getWidth();
                int ph = parent.getHeight();
                int x = margin.left;
                int y = margin.top;
                int w = pw - (margin.left + margin.right);
                int h = ph - (margin.top + margin.bottom);
                ImageIcon iicon = this.root.getValue();
                if (iicon == null) {
                    return;
                }
                ImageCanvas c0 = this.root.imageCanvas;
                if (c0 == null) {
                    return;
                }
                c0.setBounds(x, y, w, h);
            }
        }
    }

    private class ImageCanvas
    extends JLabel {
        ImageCropItem root;

        ImageCanvas() {
            this.root = ImageCropItem.this;
            this.setHorizontalAlignment(0);
            this.setOpaque(true);
        }

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            ImageCropItem.this.cropImage = null;
            ImageIcon iicon = this.root.getValue();
            if (iicon == null) {
                return;
            }
            Rectangle rect = this.root.scaleRect;
            if (rect == null) {
                rect = ImageCropItem.this.getFitRect();
                this.root.scaleRect = rect;
            }
            int nw = rect.width;
            int nh = rect.height;
            int pw = this.root.getWidth();
            int ph = this.root.getHeight();
            Rectangle box = new Rectangle(0, 0, this.root.getBoxWidth(), this.root.getBoxHeight());
            box.x = Math.max(pw / 2 - box.width / 2, 0);
            box.y = Math.max(ph / 2 - box.height / 2, 0);
            Dimension canvasdim = new Dimension(pw, ph);
            canvasdim.width = Math.max(canvasdim.width, box.width);
            canvasdim.height = Math.max(canvasdim.height, box.height);
            this.root.meta.setViewSize(canvasdim.width, canvasdim.height);
            BufferedImage bi = new BufferedImage(canvasdim.width, canvasdim.height, 2);
            Graphics2D big2 = bi.createGraphics();
            int nx = canvasdim.width / 2 - nw / 2;
            int ny = canvasdim.height / 2 - nh / 2;
            if (rect instanceof DragRect) {
                DragRect dr = (DragRect)rect;
                nx = dr.x;
                ny = dr.y;
            } else {
                rect.x = nx;
                rect.y = ny;
            }
            big2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            big2.drawImage(iicon.getImage(), nx, ny, nw, nh, null);
            this.root.meta.setImageRect(nx, ny, nw, nh);
            try {
                ImageCropItem.this.cropImage = bi.getSubimage(box.x, box.y, box.width, box.height);
            }
            catch (Throwable dr) {
                // empty catch block
            }
            Graphics2D g2 = (Graphics2D)g.create();
            g2.drawImage((Image)bi, 0, 0, null);
            g2.dispose();
            big2.dispose();
            AlphaComposite alpha = null;
            try {
                alpha = AlphaComposite.getInstance(3, 0.3f);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (alpha != null) {
                g2 = (Graphics2D)g.create();
                g2.setComposite(alpha);
                g2.setBackground(Color.BLACK);
                g2.fillRect(0, 0, this.getWidth(), this.getHeight());
                g2.dispose();
            }
            if (ImageCropItem.this.cropImage != null) {
                g2 = (Graphics2D)g.create();
                g2.setColor(Color.WHITE);
                g2.drawImage((Image)ImageCropItem.this.cropImage, box.x, box.y, null);
                g2.drawRect(box.x, box.y, box.width, box.height);
                g2.dispose();
                this.root.meta.setBoxRect(box.x, box.y, box.width, box.height);
            }
        }
    }

    private class DragRect
    extends Rectangle {
        DragRect(Rectangle rect) {
            this(rect.x, rect.y, rect.width, rect.height);
        }

        DragRect(int x, int y, int w, int h) {
            super(x, y, w, h);
        }
    }

    private class ZoomRect
    extends Rectangle {
        ZoomRect(Rectangle rect) {
            this(rect.x, rect.y, rect.width, rect.height);
        }

        ZoomRect(int x, int y, int w, int h) {
            super(x, y, w, h);
        }
    }

    private class FitRect
    extends Rectangle {
        FitRect(Rectangle rect) {
            this(rect.x, rect.y, rect.width, rect.height);
        }

        FitRect(int x, int y, int w, int h) {
            super(x, y, w, h);
        }
    }
}

